/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.Props;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.Logging;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.japi.Util$;
import org.apache.pekko.remote.artery.ArterySettings;
import org.apache.pekko.remote.artery.ArterySettings$;
import org.apache.pekko.util.Helpers;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import org.apache.pekko.util.ccompat.package;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class RemoteSettings {
    private final Config config;
    private final ArterySettings Artery;
    private final boolean WarnAboutDirectUse;
    private final boolean LogReceive;
    private final boolean LogSend;
    private final Option LogFrameSizeExceeding;
    private final boolean UntrustedMode;
    private final Set TrustedSelectionPaths;
    private final int RemoteLifecycleEventsLogLevel;
    private final String Dispatcher;
    private final Timeout ShutdownTimeout;
    private final FiniteDuration FlushWait;
    private final Timeout StartupTimeout;
    private final FiniteDuration RetryGateClosedFor;
    private final boolean UsePassiveConnections;
    private final FiniteDuration BackoffPeriod;
    private final int LogBufferSizeExceeding;
    private final FiniteDuration SysMsgAckTimeout;
    private final FiniteDuration SysResendTimeout;
    private final int SysResendLimit;
    private final int SysMsgBufferSize;
    private final FiniteDuration InitialSysMsgDeliveryTimeout;
    private final FiniteDuration QuarantineSilentSystemTimeout;
    private final FiniteDuration QuarantineDuration;
    private final Timeout CommandAckTimeout;
    private final boolean UseUnsafeRemoteFeaturesWithoutCluster;
    private final boolean WarnUnsafeWatchWithoutCluster;
    private final Config WatchFailureDetectorConfig;
    private final String WatchFailureDetectorImplementationClass;
    private final FiniteDuration WatchHeartBeatInterval;
    private final FiniteDuration WatchUnreachableReaperInterval;
    private final FiniteDuration WatchHeartbeatExpectedResponseAfter;
    private final Seq Transports;
    private final Map Adapters;

    public RemoteSettings(Config config) {
        FiniteDuration finiteDuration;
        int n;
        this.config = config;
        this.Artery = ArterySettings$.MODULE$.apply(config.getConfig("pekko.remote.artery"));
        this.WarnAboutDirectUse = config.getBoolean("pekko.remote.warn-about-direct-use");
        this.LogReceive = config.getBoolean("pekko.remote.classic.log-received-messages");
        this.LogSend = config.getBoolean("pekko.remote.classic.log-sent-messages");
        String string = config.getString("pekko.remote.classic.log-frame-size-exceeding").toLowerCase();
        String string2 = "off";
        this.LogFrameSizeExceeding = !(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)Predef$.MODULE$.Long2long(config.getBytes("pekko.remote.classic.log-frame-size-exceeding")))));
        this.UntrustedMode = config.getBoolean("pekko.remote.classic.untrusted-mode");
        this.TrustedSelectionPaths = Util$.MODULE$.immutableSeq((Iterable)config.getStringList("pekko.remote.classic.trusted-selection-paths")).toSet();
        String string3 = Helpers$.MODULE$.toRootLowerCase(config.getString("pekko.remote.classic.log-remote-lifecycle-events"));
        if ("on".equals(string3)) {
            n = Logging$.MODULE$.DebugLevel();
        } else {
            String other = string3;
            Option option = Logging$.MODULE$.levelFor(other);
            if (option instanceof Some) {
                int level;
                Object object = ((Some)option).value();
                n = level = object == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)object).asInt();
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new ConfigurationException("Logging level must be one of (on, off, debug, info, warning, error)");
                }
                throw new MatchError((Object)option);
            }
        }
        this.RemoteLifecycleEventsLogLevel = n;
        this.Dispatcher = config.getString("pekko.remote.classic.use-dispatcher");
        Timeout timeout = (Timeout)Helpers$.MODULE$.Requiring((Object)Timeout$.MODULE$.apply(Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.remote.classic.shutdown-timeout")));
        this.ShutdownTimeout = (Timeout)Helpers.Requiring$.MODULE$.requiring$extension((Object)timeout, (Function1 & Serializable)_$1 -> _$1.duration().$greater((Object)Duration$.MODULE$.Zero()), RemoteSettings::$init$$$anonfun$2);
        FiniteDuration finiteDuration2 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.remote.classic.flush-wait-on-shutdown"));
        this.FlushWait = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration2, (Function1 & Serializable)_$2 -> _$2.$greater((Object)Duration$.MODULE$.Zero()), RemoteSettings::$init$$$anonfun$4);
        Timeout timeout2 = (Timeout)Helpers$.MODULE$.Requiring((Object)Timeout$.MODULE$.apply(Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.remote.classic.startup-timeout")));
        this.StartupTimeout = (Timeout)Helpers.Requiring$.MODULE$.requiring$extension((Object)timeout2, (Function1 & Serializable)_$3 -> _$3.duration().$greater((Object)Duration$.MODULE$.Zero()), RemoteSettings::$init$$$anonfun$6);
        FiniteDuration finiteDuration3 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.remote.classic.retry-gate-closed-for"));
        this.RetryGateClosedFor = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration3, (Function1 & Serializable)_$4 -> _$4.$greater$eq((Object)Duration$.MODULE$.Zero()), RemoteSettings::$init$$$anonfun$8);
        this.UsePassiveConnections = config.getBoolean("pekko.remote.classic.use-passive-connections");
        FiniteDuration finiteDuration4 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.remote.classic.backoff-interval"));
        this.BackoffPeriod = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration4, (Function1 & Serializable)_$5 -> _$5.$greater((Object)Duration$.MODULE$.Zero()), RemoteSettings::$init$$$anonfun$10);
        String key = "pekko.remote.classic.log-buffer-size-exceeding";
        String string4 = config.getString(key).toLowerCase();
        this.LogBufferSizeExceeding = "off".equals(string4) || "false".equals(string4) ? Integer.MAX_VALUE : config.getInt(key);
        FiniteDuration finiteDuration5 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.remote.classic.system-message-ack-piggyback-timeout"));
        this.SysMsgAckTimeout = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration5, (Function1 & Serializable)_$6 -> _$6.$greater((Object)Duration$.MODULE$.Zero()), RemoteSettings::$init$$$anonfun$12);
        FiniteDuration finiteDuration6 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.remote.classic.resend-interval"));
        this.SysResendTimeout = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration6, (Function1 & Serializable)_$7 -> _$7.$greater((Object)Duration$.MODULE$.Zero()), RemoteSettings::$init$$$anonfun$14);
        Integer n2 = (Integer)Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToInteger((int)config.getInt("pekko.remote.classic.resend-limit")));
        this.SysResendLimit = BoxesRunTime.unboxToInt((Object)Helpers.Requiring$.MODULE$.requiring$extension((Object)n2, (Function1)(JFunction1.mcZI.sp & Serializable)_$8 -> _$8 > 0, RemoteSettings::$init$$$anonfun$16));
        Integer n3 = (Integer)Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToInteger((int)config.getInt("pekko.remote.classic.system-message-buffer-size")));
        this.SysMsgBufferSize = BoxesRunTime.unboxToInt((Object)Helpers.Requiring$.MODULE$.requiring$extension((Object)n3, (Function1)(JFunction1.mcZI.sp & Serializable)_$9 -> _$9 > 0, RemoteSettings::$init$$$anonfun$18));
        FiniteDuration finiteDuration7 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.remote.classic.initial-system-message-delivery-timeout"));
        this.InitialSysMsgDeliveryTimeout = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration7, (Function1 & Serializable)_$10 -> _$10.$greater((Object)Duration$.MODULE$.Zero()), RemoteSettings::$init$$$anonfun$20);
        String key2 = "pekko.remote.classic.quarantine-after-silence";
        String string5 = config.getString(key2).toLowerCase();
        if ("off".equals(string5) || "false".equals(string5)) {
            finiteDuration = Duration$.MODULE$.Zero();
        } else {
            FiniteDuration finiteDuration8 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), key2));
            finiteDuration = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration8, (Function1 & Serializable)_$11 -> _$11.$greater((Object)Duration$.MODULE$.Zero()), RemoteSettings::$init$$$anonfun$22);
        }
        this.QuarantineSilentSystemTimeout = finiteDuration;
        FiniteDuration finiteDuration9 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.remote.classic.prune-quarantine-marker-after"));
        this.QuarantineDuration = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration9, (Function1 & Serializable)_$12 -> _$12.$greater((Object)Duration$.MODULE$.Zero()), RemoteSettings::$init$$$anonfun$24);
        Timeout timeout3 = (Timeout)Helpers$.MODULE$.Requiring((Object)Timeout$.MODULE$.apply(Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.remote.classic.command-ack-timeout")));
        this.CommandAckTimeout = (Timeout)Helpers.Requiring$.MODULE$.requiring$extension((Object)timeout3, (Function1 & Serializable)_$13 -> _$13.duration().$greater((Object)Duration$.MODULE$.Zero()), RemoteSettings::$init$$$anonfun$26);
        this.UseUnsafeRemoteFeaturesWithoutCluster = config.getBoolean("pekko.remote.use-unsafe-remote-features-outside-cluster");
        this.WarnUnsafeWatchWithoutCluster = config.getBoolean("pekko.remote.warn-unsafe-watch-outside-cluster");
        this.WatchFailureDetectorConfig = config.getConfig("pekko.remote.watch-failure-detector");
        this.WatchFailureDetectorImplementationClass = this.WatchFailureDetectorConfig().getString("implementation-class");
        FiniteDuration finiteDuration10 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.WatchFailureDetectorConfig()), "heartbeat-interval"));
        this.WatchHeartBeatInterval = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration10, (Function1 & Serializable)_$14 -> _$14.$greater((Object)Duration$.MODULE$.Zero()), RemoteSettings::$init$$$anonfun$28);
        FiniteDuration finiteDuration11 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.WatchFailureDetectorConfig()), "unreachable-nodes-reaper-interval"));
        this.WatchUnreachableReaperInterval = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration11, (Function1 & Serializable)_$15 -> _$15.$greater((Object)Duration$.MODULE$.Zero()), RemoteSettings::$init$$$anonfun$30);
        FiniteDuration finiteDuration12 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.WatchFailureDetectorConfig()), "expected-response-after"));
        this.WatchHeartbeatExpectedResponseAfter = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration12, (Function1 & Serializable)_$16 -> _$16.$greater((Object)Duration$.MODULE$.Zero()), RemoteSettings::$init$$$anonfun$32);
        this.Transports = (Seq)this.transportNames().map((Function1 & Serializable)name -> {
            Config transportConfig = this.transportConfigFor((String)name);
            return Tuple3$.MODULE$.apply((Object)transportConfig.getString("transport-class"), Util$.MODULE$.immutableSeq((Iterable)transportConfig.getStringList("applied-adapters")).reverse(), (Object)transportConfig);
        });
        this.Adapters = this.configToMap(config.getConfig("pekko.remote.classic.adapters"));
    }

    public Config config() {
        return this.config;
    }

    public ArterySettings Artery() {
        return this.Artery;
    }

    public boolean WarnAboutDirectUse() {
        return this.WarnAboutDirectUse;
    }

    public boolean LogReceive() {
        return this.LogReceive;
    }

    public boolean LogSend() {
        return this.LogSend;
    }

    public Option<Object> LogFrameSizeExceeding() {
        return this.LogFrameSizeExceeding;
    }

    public boolean UntrustedMode() {
        return this.UntrustedMode;
    }

    @InternalApi
    public boolean untrustedMode() {
        if (this.Artery().Enabled()) {
            return this.Artery().UntrustedMode();
        }
        return this.UntrustedMode();
    }

    public Set<String> TrustedSelectionPaths() {
        return this.TrustedSelectionPaths;
    }

    public int RemoteLifecycleEventsLogLevel() {
        return this.RemoteLifecycleEventsLogLevel;
    }

    public String Dispatcher() {
        return this.Dispatcher;
    }

    public Props configureDispatcher(Props props) {
        if (this.Artery().Enabled()) {
            if (this.Artery().Advanced().Dispatcher().isEmpty()) {
                return props;
            }
            return props.withDispatcher(this.Artery().Advanced().Dispatcher());
        }
        if (this.Dispatcher().isEmpty()) {
            return props;
        }
        return props.withDispatcher(this.Dispatcher());
    }

    public Timeout ShutdownTimeout() {
        return this.ShutdownTimeout;
    }

    public FiniteDuration FlushWait() {
        return this.FlushWait;
    }

    public Timeout StartupTimeout() {
        return this.StartupTimeout;
    }

    public FiniteDuration RetryGateClosedFor() {
        return this.RetryGateClosedFor;
    }

    public boolean UsePassiveConnections() {
        return this.UsePassiveConnections;
    }

    public FiniteDuration BackoffPeriod() {
        return this.BackoffPeriod;
    }

    public int LogBufferSizeExceeding() {
        return this.LogBufferSizeExceeding;
    }

    public FiniteDuration SysMsgAckTimeout() {
        return this.SysMsgAckTimeout;
    }

    public FiniteDuration SysResendTimeout() {
        return this.SysResendTimeout;
    }

    public int SysResendLimit() {
        return this.SysResendLimit;
    }

    public int SysMsgBufferSize() {
        return this.SysMsgBufferSize;
    }

    public FiniteDuration InitialSysMsgDeliveryTimeout() {
        return this.InitialSysMsgDeliveryTimeout;
    }

    public FiniteDuration QuarantineSilentSystemTimeout() {
        return this.QuarantineSilentSystemTimeout;
    }

    public FiniteDuration QuarantineDuration() {
        return this.QuarantineDuration;
    }

    public Timeout CommandAckTimeout() {
        return this.CommandAckTimeout;
    }

    public boolean UseUnsafeRemoteFeaturesWithoutCluster() {
        return this.UseUnsafeRemoteFeaturesWithoutCluster;
    }

    public boolean WarnUnsafeWatchWithoutCluster() {
        return this.WarnUnsafeWatchWithoutCluster;
    }

    public Config WatchFailureDetectorConfig() {
        return this.WatchFailureDetectorConfig;
    }

    public String WatchFailureDetectorImplementationClass() {
        return this.WatchFailureDetectorImplementationClass;
    }

    public FiniteDuration WatchHeartBeatInterval() {
        return this.WatchHeartBeatInterval;
    }

    public FiniteDuration WatchUnreachableReaperInterval() {
        return this.WatchUnreachableReaperInterval;
    }

    public FiniteDuration WatchHeartbeatExpectedResponseAfter() {
        return this.WatchHeartbeatExpectedResponseAfter;
    }

    public Seq<Tuple3<String, Seq<String>, Config>> Transports() {
        return this.Transports;
    }

    public Map<String, String> Adapters() {
        return this.Adapters;
    }

    private Seq<String> transportNames() {
        return Util$.MODULE$.immutableSeq((Iterable)this.config().getStringList("pekko.remote.classic.enabled-transports"));
    }

    private Config transportConfigFor(String transportName) {
        return this.config().getConfig(transportName);
    }

    private Map<String, String> configToMap(Config cfg) {
        return (Map)package.JavaConverters$.MODULE$.MapHasAsScala(cfg.root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                return Tuple2$.MODULE$.apply((Object)k, (Object)v.toString());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final Object $init$$$anonfun$2() {
        return "shutdown-timeout must be > 0";
    }

    private static final Object $init$$$anonfun$4() {
        return "flush-wait-on-shutdown must be > 0";
    }

    private static final Object $init$$$anonfun$6() {
        return "startup-timeout must be > 0";
    }

    private static final Object $init$$$anonfun$8() {
        return "retry-gate-closed-for must be >= 0";
    }

    private static final Object $init$$$anonfun$10() {
        return "backoff-interval must be > 0";
    }

    private static final Object $init$$$anonfun$12() {
        return "system-message-ack-piggyback-timeout must be > 0";
    }

    private static final Object $init$$$anonfun$14() {
        return "resend-interval must be > 0";
    }

    private static final Object $init$$$anonfun$16() {
        return "resend-limit must be > 0";
    }

    private static final Object $init$$$anonfun$18() {
        return "system-message-buffer-size must be > 0";
    }

    private static final Object $init$$$anonfun$20() {
        return "initial-system-message-delivery-timeout must be > 0";
    }

    private static final Object $init$$$anonfun$22() {
        return "quarantine-after-silence must be > 0";
    }

    private static final Object $init$$$anonfun$24() {
        return "prune-quarantine-marker-after must be > 0 ms";
    }

    private static final Object $init$$$anonfun$26() {
        return "command-ack-timeout must be > 0";
    }

    private static final Object $init$$$anonfun$28() {
        return "watch-failure-detector.heartbeat-interval must be > 0";
    }

    private static final Object $init$$$anonfun$30() {
        return "watch-failure-detector.unreachable-nodes-reaper-interval must be > 0";
    }

    private static final Object $init$$$anonfun$32() {
        return "watch-failure-detector.expected-response-after > 0";
    }
}

