/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.Actor$;
import org.apache.pekko.actor.ActorCell$;
import org.apache.pekko.actor.ActorIdentity$;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorPathExtractor$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefScope;
import org.apache.pekko.actor.ActorRefWithCell;
import org.apache.pekko.actor.ActorSelectionMessage;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystemImpl;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.AddressTerminated;
import org.apache.pekko.actor.AddressTerminated$;
import org.apache.pekko.actor.Deploy;
import org.apache.pekko.actor.EmptyLocalActorRef;
import org.apache.pekko.actor.Identify;
import org.apache.pekko.actor.Identify$;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.MinimalActorRef;
import org.apache.pekko.actor.Nobody$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.SelectChildName;
import org.apache.pekko.actor.SelectChildName$;
import org.apache.pekko.actor.SelectChildPattern;
import org.apache.pekko.actor.SelectParent$;
import org.apache.pekko.actor.SelectionPathElement;
import org.apache.pekko.actor.SystemGuardian;
import org.apache.pekko.actor.VirtualPathContainer;
import org.apache.pekko.dispatch.sysmsg.DeathWatchNotification;
import org.apache.pekko.dispatch.sysmsg.DeathWatchNotification$;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.dispatch.sysmsg.Unwatch$;
import org.apache.pekko.dispatch.sysmsg.Watch$;
import org.apache.pekko.event.AddressTerminatedTopic;
import org.apache.pekko.event.AddressTerminatedTopic$;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.DaemonMsg;
import org.apache.pekko.remote.DaemonMsgCreate;
import org.apache.pekko.remote.DaemonMsgCreate$;
import org.apache.pekko.remote.NotAllowedClassRemoteDeploymentAttemptException;
import org.apache.pekko.util.Switch;
import org.apache.pekko.util.ccompat.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public class RemoteSystemDaemon
extends VirtualPathContainer
implements MinimalActorRef {
    private final ActorSystemImpl system;
    private final ActorRef terminator;
    private final boolean untrustedMode;
    private final Switch terminating;
    private final ConcurrentHashMap<ActorRef, Set<ActorRef>> parent2children;
    private final boolean allowListEnabled;
    private final Set<String> remoteDeploymentAllowList;

    public RemoteSystemDaemon(ActorSystemImpl system, ActorPath _path, InternalActorRef _parent, ActorRef terminator, MarkerLoggingAdapter _log, boolean untrustedMode) {
        this.system = system;
        this.terminator = terminator;
        this.untrustedMode = untrustedMode;
        super(system.provider(), _path, _parent, _log);
        this.terminating = new Switch(false);
        ((AddressTerminatedTopic)AddressTerminatedTopic$.MODULE$.apply((ActorSystem)system)).subscribe((ActorRef)this);
        this.parent2children = new ConcurrentHashMap();
        this.allowListEnabled = system.settings().config().getBoolean("pekko.remote.deployment.enable-allow-list");
        this.remoteDeploymentAllowList = this.allowListEnabled ? package.JavaConverters$.MODULE$.ListHasAsScala(system.settings().config().getStringList("pekko.remote.deployment.allowed-actor-classes")).asScala().toSet() : Predef$.MODULE$.Set().empty();
    }

    public boolean untrustedMode() {
        return this.untrustedMode;
    }

    private boolean addChildParentNeedsWatch(ActorRef parent, ActorRef child) {
        while (true) {
            Set<ActorRef> set;
            if ((set = this.parent2children.get(parent)) == null) {
                if (this.parent2children.putIfAbsent(parent, (Set<ActorRef>)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ActorRef[]{child}))) != null) continue;
                return true;
            }
            Set<ActorRef> children = set;
            if (this.parent2children.replace(parent, children, (Set<ActorRef>)children.$plus((Object)child))) break;
        }
        return false;
    }

    private boolean removeChildParentNeedsUnwatch(ActorRef parent, ActorRef child) {
        while (true) {
            Set<ActorRef> set;
            if ((set = this.parent2children.get(parent)) == null) {
                return false;
            }
            Set<ActorRef> children = set;
            Set next = (Set)children.$minus((Object)child);
            if (next.isEmpty()) {
                if (!this.parent2children.remove(parent, children)) continue;
                return true;
            }
            if (this.parent2children.replace(parent, children, (Set<ActorRef>)next)) break;
        }
        return false;
    }

    public InternalActorRef getChild(Iterator<String> names) {
        Vector full = (Vector)((IterableOps)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))).$plus$plus(names);
        Tuple2 tuple2 = this.rec$1(full.mkString("/"), 0);
        if (tuple2 != null) {
            InternalActorRef internalActorRef = (InternalActorRef)tuple2._1();
            int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
            if (Nobody$.MODULE$.equals(internalActorRef)) {
                return Nobody$.MODULE$;
            }
            InternalActorRef ref = internalActorRef;
            if (0 == n) {
                return ref;
            }
            InternalActorRef ref2 = internalActorRef;
            int n2 = n;
            return ref2.getChild(full.takeRight(n2).iterator());
        }
        throw new MatchError((Object)tuple2);
    }

    public void sendSystemMessage(SystemMessage message) {
        SystemMessage systemMessage = message;
        if (systemMessage instanceof DeathWatchNotification) {
            ActorRef parent;
            ActorRefWithCell child;
            DeathWatchNotification deathWatchNotification = DeathWatchNotification$.MODULE$.unapply((DeathWatchNotification)systemMessage);
            ActorRef actorRef = deathWatchNotification._1();
            boolean bl = deathWatchNotification._2();
            boolean bl2 = deathWatchNotification._3();
            if (actorRef instanceof ActorRefWithCell && actorRef instanceof ActorRefScope && ((ActorRefScope)(child = (ActorRefWithCell)actorRef)).isLocal()) {
                this.terminating.locked((Function0 & Serializable)() -> {
                    this.sendSystemMessage$$anonfun$1(child);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (actorRef != null && actorRef instanceof ActorRefScope && !((ActorRefScope)(parent = actorRef)).isLocal()) {
                this.terminating.locked((Function0 & Serializable)() -> {
                    this.sendSystemMessage$$anonfun$2(parent);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        MinimalActorRef.sendSystemMessage$((MinimalActorRef)this, (SystemMessage)message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void $bang(Object msg, ActorRef sender) {
        try {
            Object object = msg;
            if (object instanceof DaemonMsg) {
                DaemonMsg message = (DaemonMsg)object;
                this.log().debug("Received command [{}] to RemoteSystemDaemon on [{}]", (Object)message, (Object)this.path().address());
                DaemonMsg daemonMsg = message;
                if (!(daemonMsg instanceof DaemonMsgCreate)) throw new MatchError((Object)daemonMsg);
                DaemonMsgCreate daemonMsgCreate = DaemonMsgCreate$.MODULE$.unapply((DaemonMsgCreate)daemonMsg);
                Props props = daemonMsgCreate._1();
                Deploy deploy = daemonMsgCreate._2();
                String string = daemonMsgCreate._3();
                ActorRef actorRef = daemonMsgCreate._4();
                String path = string;
                if (this.untrustedMode()) {
                    this.log().debug("does not accept deployments (untrusted) for [{}]", (Object)path);
                    return;
                } else {
                    Props props2 = props;
                    Deploy deploy2 = deploy;
                    String path2 = string;
                    ActorRef supervisor = actorRef;
                    if (this.allowListEnabled) {
                        String name = props2.clazz().getCanonicalName();
                        if (this.remoteDeploymentAllowList.contains((Object)name)) {
                            this.doCreateActor(message, props2, deploy2, path2, supervisor);
                            return;
                        } else {
                            NotAllowedClassRemoteDeploymentAttemptException ex = new NotAllowedClassRemoteDeploymentAttemptException(props2.actorClass(), this.remoteDeploymentAllowList);
                            this.log().error(LogMarker$.MODULE$.Security(), (Throwable)ex, "Received command to create remote Actor, but class [{}] is not white-listed! Target path: [{}]", (Object)props2.actorClass(), (Object)path2);
                        }
                        return;
                    } else {
                        Props props3 = props;
                        Deploy deploy3 = deploy;
                        String path3 = string;
                        ActorRef supervisor2 = actorRef;
                        this.doCreateActor(message, props3, deploy3, path3, supervisor2);
                    }
                }
                return;
            } else if (object instanceof ActorSelectionMessage) {
                ActorSelectionMessage sel = (ActorSelectionMessage)object;
                Iterator iter = sel.elements().iterator();
                Tuple2 tuple2 = RemoteSystemDaemon.rec$2(sel, iter, (List)package$.MODULE$.Nil());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List concatenatedChildNames = (List)tuple2._1();
                Object m = tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)concatenatedChildNames, m);
                List concatenatedChildNames2 = (List)tuple22._1();
                Object m2 = tuple22._2();
                InternalActorRef internalActorRef = this.getChild((Iterator<String>)concatenatedChildNames2.iterator());
                if (Nobody$.MODULE$.equals(internalActorRef)) {
                    EmptyLocalActorRef emptyRef = new EmptyLocalActorRef(this.system.provider(), this.path().$div((Iterable)sel.elements().map((Function1 & Serializable)_$1 -> _$1.toString())), this.system.eventStream());
                    emptyRef.tell((Object)sel, sender);
                    return;
                } else {
                    InternalActorRef child = internalActorRef;
                    child.tell(m2, sender);
                }
                return;
            } else if (object instanceof Identify) {
                Object object2;
                Identify identify = Identify$.MODULE$.unapply((Identify)object);
                Object messageId = object2 = identify._1();
                sender.$bang((Object)ActorIdentity$.MODULE$.apply(messageId, (Option)Some$.MODULE$.apply((Object)this)), sender);
                return;
            } else if (SystemGuardian.TerminationHook$.MODULE$.equals(object)) {
                this.terminating.switchOn((Function0 & Serializable)() -> {
                    this.$bang$$anonfun$1();
                    return BoxedUnit.UNIT;
                });
                return;
            } else if (object instanceof AddressTerminated) {
                Address address;
                AddressTerminated addressTerminated = AddressTerminated$.MODULE$.unapply((AddressTerminated)object);
                Address address2 = address = addressTerminated._1();
                this.foreachChild((Function1)(JProcedure1 & Serializable)x$1 -> {
                    ActorRef actorRef = x$1;
                    if (actorRef instanceof InternalActorRef) {
                        InternalActorRef a = (InternalActorRef)actorRef;
                        Address address = a.getParent().path().address();
                        Address address2 = address2;
                        if (!(address != null ? !address.equals(address2) : address2 != null)) {
                            this.system.stop((ActorRef)a);
                            return;
                        }
                    }
                });
                return;
            } else {
                Object unknown = object;
                this.log().warning(LogMarker$.MODULE$.Security(), "Unknown message [{}] received by [{}]", unknown, (Object)this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Option option;
            Throwable throwable3 = throwable;
            if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) throw throwable;
            Throwable e = throwable2 = (Throwable)option.get();
            this.log().error(e, "exception while processing remote command [{}] from [{}]", msg, (Object)sender);
            return;
        }
    }

    public ActorRef $bang$default$2(Object msg) {
        return Actor$.MODULE$.noSender();
    }

    private void doCreateActor(DaemonMsg message, Props props, Deploy deploy, String path, ActorRef supervisor) {
        Tuple2 tuple2;
        scala.collection.immutable.Iterable elems;
        Option option;
        String string = path;
        if (string != null && !(option = ActorPathExtractor$.MODULE$.unapply(string)).isEmpty() && (elems = (scala.collection.immutable.Iterable)(tuple2 = (Tuple2)option.get())._2()).nonEmpty()) {
            Object object = elems.head();
            String string2 = "remote";
            if (!(object != null ? !object.equals(string2) : string2 != null)) {
                boolean isTerminating;
                scala.collection.immutable.Iterable subpath = (scala.collection.immutable.Iterable)elems.drop(1);
                ActorPath p = this.path().$div((Iterable)subpath);
                String s = subpath.mkString("/");
                int i = s.indexOf(35);
                String childName = i < 0 ? s : s.substring(0, i);
                boolean bl = isTerminating = !this.terminating.whileOff((Function0 & Serializable)() -> {
                    this.$anonfun$2(props, deploy, supervisor, p, childName);
                    return BoxedUnit.UNIT;
                });
                if (isTerminating) {
                    this.log().error("Skipping [{}] to RemoteSystemDaemon on [{}] while terminating", (Object)message, (Object)p.address());
                    return;
                }
                return;
            }
        }
        this.log().debug("remote path does not match path from message [{}]", (Object)message);
    }

    public void terminationHookDoneWhenNoChildren() {
        this.terminating.whileOn((Function0 & Serializable)() -> {
            this.terminationHookDoneWhenNoChildren$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    private final Tuple2 rec$1(String s, int n) {
        InternalActorRef internalActorRef;
        int uid;
        while (true) {
            Tuple2 tuple2;
            if ((tuple2 = ActorCell$.MODULE$.splitNameAndUid(s)) == null) {
                throw new MatchError((Object)tuple2);
            }
            String childName = (String)tuple2._1();
            int uid2 = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)childName, (Object)BoxesRunTime.boxToInteger((int)uid2));
            String childName2 = (String)tuple22._1();
            uid = BoxesRunTime.unboxToInt((Object)tuple22._2());
            internalActorRef = this.getChild(childName2);
            if (internalActorRef != null) break;
            int last = s.lastIndexOf(47);
            if (last == -1) {
                return Tuple2$.MODULE$.apply((Object)Nobody$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)n));
            }
            String string = s.substring(0, last);
            int n2 = n + 1;
            s = string;
            n = n2;
        }
        InternalActorRef ref = internalActorRef;
        if (uid != 0 && uid != ref.path().uid()) {
            return Tuple2$.MODULE$.apply((Object)Nobody$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)n));
        }
        InternalActorRef ref2 = internalActorRef;
        return Tuple2$.MODULE$.apply((Object)ref2, (Object)BoxesRunTime.boxToInteger((int)n));
    }

    private final void sendSystemMessage$$anonfun$1(ActorRefWithCell child$1) {
        this.removeChild(((IterableOnceOps)child$1.path().elements().drop(1)).mkString("/"), (ActorRef)child$1);
        InternalActorRef parent = child$1.getParent();
        if (this.removeChildParentNeedsUnwatch((ActorRef)parent, (ActorRef)child$1)) {
            parent.sendSystemMessage((SystemMessage)Unwatch$.MODULE$.apply((ActorRef)parent, (ActorRef)this));
        }
        this.terminationHookDoneWhenNoChildren();
    }

    private final void sendSystemMessage$$anonfun$2(ActorRef parent$1) {
        Set<ActorRef> set = this.parent2children.remove(parent$1);
        if (set == null) {
            return;
        }
        Set<ActorRef> children = set;
        children.foreach((Function1)(JProcedure1 & Serializable)c -> {
            this.system.stop(c);
            this.removeChild(((IterableOnceOps)c.path().elements().drop(1)).mkString("/"), (ActorRef)c);
        });
        this.terminationHookDoneWhenNoChildren();
    }

    private static final Tuple2 rec$2(ActorSelectionMessage sel$1, Iterator iter$1, List acc) {
        SelectionPathElement selectionPathElement;
        while (true) {
            if (iter$1.isEmpty()) {
                return Tuple2$.MODULE$.apply((Object)acc.reverse(), sel$1.msg());
            }
            selectionPathElement = (SelectionPathElement)iter$1.next();
            if (selectionPathElement instanceof SelectChildName) {
                String string;
                SelectChildName selectChildName = SelectChildName$.MODULE$.unapply((SelectChildName)selectionPathElement);
                String name = string = selectChildName._1();
                acc = acc.$colon$colon((Object)name);
                continue;
            }
            if (!SelectParent$.MODULE$.equals(selectionPathElement)) break;
            if (acc.isEmpty()) continue;
            acc = (List)acc.tail();
        }
        if (selectionPathElement instanceof SelectChildPattern) {
            SelectChildPattern pat = (SelectChildPattern)selectionPathElement;
            Vector vector = (Vector)iter$1.toVector().$plus$colon((Object)pat);
            Object object = sel$1.copy$default$1();
            boolean bl = sel$1.copy$default$3();
            return Tuple2$.MODULE$.apply((Object)acc.reverse(), (Object)sel$1.copy(object, (scala.collection.immutable.Iterable)vector, bl));
        }
        throw new MatchError((Object)selectionPathElement);
    }

    private final void $bang$$anonfun$1() {
        this.terminationHookDoneWhenNoChildren();
        this.foreachChild((Function1)(JProcedure1 & Serializable)actor -> this.system.stop(actor));
    }

    private final void $anonfun$2(Props props$1, Deploy deploy$1, ActorRef supervisor$1, ActorPath p$1, String childName$1) {
        InternalActorRef parent = (InternalActorRef)supervisor$1;
        InternalActorRef actor = this.system.provider().actorOf(this.system, props$1, parent, p$1, false, (Option)Some$.MODULE$.apply((Object)deploy$1), true, false);
        this.addChild(childName$1, actor);
        actor.sendSystemMessage((SystemMessage)Watch$.MODULE$.apply(actor, (InternalActorRef)this));
        actor.start();
        if (this.addChildParentNeedsWatch((ActorRef)parent, (ActorRef)actor)) {
            parent.sendSystemMessage((SystemMessage)Watch$.MODULE$.apply(parent, (InternalActorRef)this));
            return;
        }
    }

    private final void terminationHookDoneWhenNoChildren$$anonfun$1() {
        if (!this.hasChildren()) {
            this.terminator.tell((Object)SystemGuardian.TerminationHookDone$.MODULE$, (ActorRef)this);
            return;
        }
    }
}

