/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.Address;
import org.apache.pekko.remote.UniqueAddress;
import org.apache.pekko.remote.artery.Association;
import org.apache.pekko.remote.artery.AssociationState;
import org.apache.pekko.remote.artery.AssociationState$UidKnown$;
import org.apache.pekko.remote.artery.AssociationState$UidQuarantined$;
import org.apache.pekko.remote.artery.AssociationState$UidUnknown$;
import org.apache.pekko.remote.artery.ImmutableLongMap;
import org.apache.pekko.remote.artery.ImmutableLongMap$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class AssociationRegistry {
    private final Function1<Address, Association> createAssociation;
    private final AtomicReference<Map<Address, Association>> associationsByAddress;
    private final AtomicReference<ImmutableLongMap<Association>> associationsByUid;

    public AssociationRegistry(Function1<Address, Association> createAssociation) {
        this.createAssociation = createAssociation;
        this.associationsByAddress = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        this.associationsByUid = new AtomicReference(ImmutableLongMap$.MODULE$.empty(ClassTag$.MODULE$.apply(Association.class)));
    }

    public final Association association(Address remoteAddress) {
        Option option;
        block2: {
            Association newAssociation;
            Map newMap;
            Map<Address, Association> currentMap;
            do {
                if ((option = (currentMap = this.associationsByAddress.get()).get((Object)remoteAddress)) instanceof Some) {
                    Association existing = (Association)((Some)option).value();
                    return existing;
                }
                if (!None$.MODULE$.equals(option)) break block2;
            } while (!this.associationsByAddress.compareAndSet(currentMap, (Map<Address, Association>)(newMap = (Map)currentMap.updated((Object)remoteAddress, (Object)(newAssociation = (Association)this.createAssociation.apply((Object)remoteAddress))))));
            newAssociation.associate();
            return newAssociation;
        }
        throw new MatchError((Object)option);
    }

    public Association association(long uid) {
        return (Association)this.associationsByUid.get().get(uid);
    }

    public final Association setUID(UniqueAddress peer) {
        Association a;
        ImmutableLongMap<Association> newMap;
        ImmutableLongMap<Association> currentMap;
        do {
            a = this.association(peer.address());
            currentMap = this.associationsByUid.get();
            Association association = (Association)currentMap.get(peer.uid());
            Association association2 = (Association)OptionVal.Some$.MODULE$.unapply((Object)association);
            if (OptionVal$.MODULE$.isEmpty$extension((Object)association2)) continue;
            Association association3 = (Association)OptionVal$.MODULE$.get$extension((Object)association2);
            Association previous = association3;
            if (previous == a) {
                return a;
            }
            throw new IllegalArgumentException(new StringBuilder(27).append("UID collision old [").append(previous).append("] new [").append(a).append("]").toString());
        } while (!this.associationsByUid.compareAndSet(currentMap, newMap = currentMap.updated(peer.uid(), a)));
        return a;
    }

    public Set<Association> allAssociations() {
        return ((MapOps)this.associationsByAddress.get()).values().toSet();
    }

    public void removeUnusedQuarantined(FiniteDuration after) {
        this.removeUnusedQuarantinedByAddress(after);
        this.removeUnusedQuarantinedByUid(after);
    }

    private void removeUnusedQuarantinedByAddress(FiniteDuration after) {
        block1: {
            Map remove;
            Map newMap;
            Map<Address, Association> currentMap;
            do {
                long now = System.nanoTime();
                long afterNanos = after.toNanos();
                currentMap = this.associationsByAddress.get();
                remove = (Map)currentMap.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        Map acc = (Map)tuple2._1();
                        if (tuple22 != null) {
                            Address address = (Address)tuple22._1();
                            Association association = (Association)tuple22._2();
                            AssociationState state = association.associationState();
                            if (now - state.lastUsedTimestamp().get() >= afterNanos) {
                                AssociationState.UniqueRemoteAddressState uniqueRemoteAddressState = state.uniqueRemoteAddressState();
                                if (AssociationState$UidQuarantined$.MODULE$.equals(uniqueRemoteAddressState) || AssociationState$UidUnknown$.MODULE$.equals(uniqueRemoteAddressState)) {
                                    return (Map)acc.updated((Object)address, (Object)association);
                                }
                                if (AssociationState$UidKnown$.MODULE$.equals(uniqueRemoteAddressState)) {
                                    return acc;
                                }
                                throw new MatchError((Object)uniqueRemoteAddressState);
                            }
                            return acc;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
                if (!remove.nonEmpty()) break block1;
            } while (!this.associationsByAddress.compareAndSet(currentMap, (Map<Address, Association>)(newMap = (Map)currentMap.$minus$minus((IterableOnce)remove.keysIterator()))));
            remove.valuesIterator().foreach((Function1)(JProcedure1 & Serializable)_$15 -> _$15.removedAfterQuarantined());
            return;
        }
    }

    private void removeUnusedQuarantinedByUid(FiniteDuration after) {
        block1: {
            Map remove;
            ImmutableLongMap newMap;
            ImmutableLongMap<Association> currentMap;
            do {
                long now = System.nanoTime();
                long afterNanos = after.toNanos();
                currentMap = this.associationsByUid.get();
                remove = (Map)currentMap.keysIterator().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x$1, x$2) -> AssociationRegistry.$anonfun$15(now, afterNanos, currentMap, (Map)x$1, BoxesRunTime.unboxToLong((Object)x$2)));
                if (!remove.nonEmpty()) break block1;
            } while (!this.associationsByUid.compareAndSet(currentMap, newMap = (ImmutableLongMap)remove.keysIterator().foldLeft(currentMap, (Function2 & Serializable)(acc, uid) -> ((ImmutableLongMap)acc).remove(BoxesRunTime.unboxToLong((Object)uid)))));
            remove.valuesIterator().foreach((Function1)(JProcedure1 & Serializable)_$16 -> _$16.removedAfterQuarantined());
            return;
        }
    }

    private static final /* synthetic */ Map $anonfun$15(long now$2, long afterNanos$2, ImmutableLongMap currentMap$1, Map x$1, long x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToLong((long)x$2));
        if (tuple2 != null) {
            Map acc = (Map)tuple2._1();
            long uid = BoxesRunTime.unboxToLong((Object)tuple2._2());
            Association association = (Association)currentMap$1.get(uid);
            Association association2 = (Association)OptionVal$.MODULE$.get$extension((Object)association);
            AssociationState state = association2.associationState();
            if (now$2 - state.lastUsedTimestamp().get() >= afterNanos$2) {
                AssociationState.UniqueRemoteAddressState uniqueRemoteAddressState = state.uniqueRemoteAddressState();
                if (AssociationState$UidQuarantined$.MODULE$.equals(uniqueRemoteAddressState) || AssociationState$UidUnknown$.MODULE$.equals(uniqueRemoteAddressState)) {
                    return (Map)acc.updated((Object)BoxesRunTime.boxToLong((long)uid), (Object)association2);
                }
                if (AssociationState$UidKnown$.MODULE$.equals(uniqueRemoteAddressState)) {
                    return acc;
                }
                throw new MatchError((Object)uniqueRemoteAddressState);
            }
            return acc;
        }
        throw new MatchError((Object)tuple2);
    }
}

