/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.remote.artery.RestartCounter$State$;
import scala.Product;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class RestartCounter {
    private final int maxRestarts;
    private final FiniteDuration restartTimeout;
    private final AtomicReference<State> state;

    public RestartCounter(int maxRestarts, FiniteDuration restartTimeout) {
        this.maxRestarts = maxRestarts;
        this.restartTimeout = restartTimeout;
        this.state = new AtomicReference<State>(RestartCounter$State$.MODULE$.apply(0, Deadline$.MODULE$.now().$plus(restartTimeout)));
    }

    public int count() {
        return this.state.get().count();
    }

    public final boolean restart() {
        State newState;
        State s;
        while (!this.state.compareAndSet(s, newState = (s = this.state.get()).deadline().hasTimeLeft() ? s.copy(s.count() + 1, s.copy$default$2()) : RestartCounter$State$.MODULE$.apply(1, Deadline$.MODULE$.now().$plus(this.restartTimeout)))) {
        }
        return newState.count() <= this.maxRestarts;
    }

    public static final class State
    implements Product,
    Serializable {
        private final int count;
        private final Deadline deadline;

        public static State apply(int n, Deadline deadline) {
            return RestartCounter$State$.MODULE$.apply(n, deadline);
        }

        public static State fromProduct(Product product) {
            return RestartCounter$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return RestartCounter$State$.MODULE$.unapply(state);
        }

        public State(int count, Deadline deadline) {
            this.count = count;
            this.deadline = deadline;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.count());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.deadline()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.count() != state.count()) return false;
            Deadline deadline = this.deadline();
            Deadline deadline2 = state.deadline();
            if (deadline != null) {
                if (!deadline.equals(deadline2)) return false;
                return true;
            }
            if (deadline2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "count";
            }
            if (1 == n2) {
                return "deadline";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int count() {
            return this.count;
        }

        public Deadline deadline() {
            return this.deadline;
        }

        public State copy(int count, Deadline deadline) {
            return new State(count, deadline);
        }

        public int copy$default$1() {
            return this.count();
        }

        public Deadline copy$default$2() {
            return this.deadline();
        }

        public int _1() {
            return this.count();
        }

        public Deadline _2() {
            return this.deadline();
        }
    }
}

