/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.aeron;

import io.aeron.Aeron;
import io.aeron.AvailableImageHandler;
import io.aeron.CommonContext;
import io.aeron.Image;
import io.aeron.UnavailableImageHandler;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.CountersReader;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.RemoteTransportException;
import org.apache.pekko.remote.artery.ArteryTransport;
import org.apache.pekko.remote.artery.ArteryTransport$;
import org.apache.pekko.remote.artery.ArteryTransport$InboundStreamMatValues$;
import org.apache.pekko.remote.artery.ArteryTransport$ShuttingDown$;
import org.apache.pekko.remote.artery.Decoder;
import org.apache.pekko.remote.artery.DuplicateFlush;
import org.apache.pekko.remote.artery.DuplicateHandshakeReq;
import org.apache.pekko.remote.artery.EnvelopeBuffer;
import org.apache.pekko.remote.artery.EnvelopeBufferPool;
import org.apache.pekko.remote.artery.FixedSizePartitionHub;
import org.apache.pekko.remote.artery.InboundControlJunction;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.aeron.AeronErrorLog;
import org.apache.pekko.remote.artery.aeron.AeronSink;
import org.apache.pekko.remote.artery.aeron.AeronSource;
import org.apache.pekko.remote.artery.aeron.TaskRunner;
import org.apache.pekko.remote.artery.aeron.TaskRunner$;
import org.apache.pekko.remote.artery.compress.NoInboundCompressions$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.KillSwitches$;
import org.apache.pekko.stream.SharedKillSwitch;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Sink;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.BuildFrom$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public class ArteryAeronUdpTransport
extends ArteryTransport {
    private final AtomicReference<Option<MediaDriver>> mediaDriver = new AtomicReference<None$>(None$.MODULE$);
    public volatile Aeron org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron;
    public volatile Cancellable org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask;
    public volatile Cancellable org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask;
    private volatile AeronErrorLog aeronErrorLog;
    public final TaskRunner org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner = new TaskRunner(this.system(), this.settings().Advanced().Aeron().IdleCpuLevel());

    public ArteryAeronUdpTransport(ExtendedActorSystem _system, RemoteActorRefProvider _provider) {
        super(_system, _provider);
    }

    private String outboundChannel(Address a) {
        return new StringBuilder(20).append("aeron:udp?endpoint=").append(a.host().get()).append(":").append(a.port().get()).toString();
    }

    @Override
    public void startTransport() {
        this.startMediaDriver();
        this.startAeron();
        this.startAeronErrorLog();
        this.flightRecorder().transportAeronErrorLogStarted();
        if (this.settings().Advanced().Aeron().LogAeronCounters()) {
            this.startAeronCounterLog();
        }
        this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner.start();
        this.flightRecorder().transportTaskRunnerStarted();
    }

    private void startMediaDriver() {
        if (this.settings().Advanced().Aeron().EmbeddedMediaDriver()) {
            MediaDriver.Context context;
            MediaDriver.Context driverContext = new MediaDriver.Context();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.settings().Advanced().Aeron().AeronDirectoryName()))) {
                context = driverContext.aeronDirectoryName(this.settings().Advanced().Aeron().AeronDirectoryName());
            } else {
                String uniquePart = UUID.randomUUID().toString();
                String randomName = new StringBuilder(1).append(CommonContext.getAeronDirectoryName()).append(File.separator).append(this.system().name()).append("-").append(uniquePart).toString();
                context = driverContext.aeronDirectoryName(randomName);
            }
            driverContext.clientLivenessTimeoutNs(this.settings().Advanced().Aeron().ClientLivenessTimeout().toNanos());
            driverContext.publicationUnblockTimeoutNs(this.settings().Advanced().Aeron().PublicationUnblockTimeout().toNanos());
            driverContext.imageLivenessTimeoutNs(this.settings().Advanced().Aeron().ImageLivenessTimeout().toNanos());
            driverContext.driverTimeoutMs(this.settings().Advanced().Aeron().DriverTimeout().toMillis());
            int idleCpuLevel = this.settings().Advanced().Aeron().IdleCpuLevel();
            MediaDriver.Context context2 = idleCpuLevel == 10 ? driverContext.threadingMode(ThreadingMode.DEDICATED).conductorIdleStrategy((IdleStrategy)new BackoffIdleStrategy(1L, 1L, 1L, 1L)).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).conductorThreadFactory(this.system().threadFactory()).receiverThreadFactory(this.system().threadFactory()).senderThreadFactory(this.system().threadFactory()) : (idleCpuLevel == 1 ? driverContext.threadingMode(ThreadingMode.SHARED).sharedIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).sharedThreadFactory(this.system().threadFactory()) : (idleCpuLevel <= 7 ? driverContext.threadingMode(ThreadingMode.SHARED_NETWORK).sharedNetworkIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).sharedNetworkThreadFactory(this.system().threadFactory()).conductorThreadFactory(this.system().threadFactory()) : driverContext.threadingMode(ThreadingMode.DEDICATED).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).receiverThreadFactory(this.system().threadFactory()).senderThreadFactory(this.system().threadFactory()).conductorThreadFactory(this.system().threadFactory())));
            MediaDriver driver = MediaDriver.launchEmbedded((MediaDriver.Context)driverContext);
            this.log().info("Started embedded media driver in directory [{}]", (Object)driver.aeronDirectoryName());
            this.flightRecorder().transportMediaDriverStarted(driver.aeronDirectoryName());
            if (!this.mediaDriver.compareAndSet((Option<MediaDriver>)None$.MODULE$, (Option<MediaDriver>)Some$.MODULE$.apply((Object)driver))) {
                throw new IllegalStateException("media driver started more than once");
            }
            return;
        }
    }

    private String aeronDir() {
        Option<MediaDriver> option = this.mediaDriver.get();
        if (option instanceof Some) {
            MediaDriver driver = (MediaDriver)((Some)option).value();
            return driver.aeronDirectoryName();
        }
        if (None$.MODULE$.equals(option)) {
            return this.settings().Advanced().Aeron().AeronDirectoryName();
        }
        throw new MatchError(option);
    }

    private void stopMediaDriver() {
        Option<MediaDriver> maybeDriver = this.mediaDriver.getAndSet((Option<MediaDriver>)None$.MODULE$);
        maybeDriver.foreach((Function1)(JProcedure1 & Serializable)driver -> {
            this.log().info("Stopping embedded media driver in directory [{}]", (Object)driver.aeronDirectoryName());
            try {
                driver.close();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    this.log().warning("Couldn't close Aeron embedded media driver due to [{}]", (Object)e);
                }
                throw throwable;
            }
            try {
                if (this.settings().Advanced().Aeron().DeleteAeronDirectory()) {
                    IoUtil.delete((File)new File(driver.aeronDirectoryName()), (boolean)false);
                    this.flightRecorder().transportMediaFileDeleted();
                }
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable4 = throwable;
                if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                    Throwable throwable5;
                    Throwable e = throwable5 = (Throwable)option.get();
                    this.log().warning("Couldn't delete Aeron embedded media driver files in [{}] due to [{}]", (Object)driver.aeronDirectoryName(), (Object)e);
                }
                throw throwable;
            }
        });
    }

    private void startAeron() {
        Aeron.Context ctx = new Aeron.Context();
        ctx.driverTimeoutMs(this.settings().Advanced().Aeron().DriverTimeout().toMillis());
        ctx.threadFactory(this.system().threadFactory());
        ctx.availableImageHandler(new AvailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onAvailableImage(Image img) {
                if (this.$outer.log().isDebugEnabled()) {
                    this.$outer.log().debug(new StringBuilder(31).append("onAvailableImage from ").append(img.sourceIdentity()).append(" session ").append(img.sessionId()).toString());
                    return;
                }
            }
        });
        ctx.unavailableImageHandler(new UnavailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onUnavailableImage(Image img) {
                if (this.$outer.log().isDebugEnabled()) {
                    this.$outer.log().debug(new StringBuilder(33).append("onUnavailableImage from ").append(img.sourceIdentity()).append(" session ").append(img.sessionId()).toString());
                }
                ((MapOps)this.$outer.streamMatValues().get()).valuesIterator().foreach((Function1)((JProcedure1 & Serializable)arg_0 -> ArteryAeronUdpTransport.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$anon$2$$_$onUnavailableImage$$anonfun$1(img, arg_0)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$anon$2$$_$onUnavailableImage$$anonfun$1(io.aeron.Image org.apache.pekko.remote.artery.ArteryTransport$InboundStreamMatValues )}, serializedLambda);
            }
        });
        ctx.errorHandler(new ErrorHandler(this){
            private final AtomicBoolean fatalErrorOccured;
            private final /* synthetic */ ArteryAeronUdpTransport $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fatalErrorOccured = new AtomicBoolean();
            }

            public void onError(Throwable cause) {
                Throwable throwable = cause;
                if (throwable instanceof ConductorServiceTimeoutException) {
                    ConductorServiceTimeoutException e = (ConductorServiceTimeoutException)throwable;
                    this.handleFatalError((Throwable)e);
                    return;
                }
                if (throwable instanceof DriverTimeoutException) {
                    DriverTimeoutException e = (DriverTimeoutException)throwable;
                    this.handleFatalError(e);
                    return;
                }
                if (throwable instanceof ArteryTransport.AeronTerminated) {
                    return;
                }
                this.$outer.log().error(cause, new StringBuilder(13).append("Aeron error, ").append(cause).toString());
            }

            private void handleFatalError(Throwable cause) {
                if (this.fatalErrorOccured.compareAndSet(false, true)) {
                    if (!this.$outer.isShutdown()) {
                        this.$outer.log().error(cause, "Fatal Aeron error {}. Have to terminate ActorSystem because it lost contact with the {} Aeron media driver. Possible configuration properties to mitigate the problem are 'client-liveness-timeout' or 'driver-timeout'. {}", (Object)Logging$.MODULE$.simpleName((Object)cause), (Object)(this.$outer.settings().Advanced().Aeron().EmbeddedMediaDriver() ? "embedded" : "external"), (Object)cause);
                        this.$outer.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner.stop();
                        this.$outer.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                        if (this.$outer.settings().Advanced().Aeron().LogAeronCounters()) {
                            this.$outer.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask.cancel();
                        }
                        this.$outer.system().terminate();
                        throw new ArteryTransport.AeronTerminated(cause);
                    }
                    return;
                }
                throw new ArteryTransport.AeronTerminated(cause);
            }
        });
        ctx.aeronDirectoryName(this.aeronDir());
        this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron = Aeron.connect((Aeron.Context)ctx);
    }

    private void blockUntilChannelActive() {
        AeronSource.AeronLifecycle aeronLifecyle = (AeronSource.AeronLifecycle)((ArteryTransport.InboundStreamMatValues)((MapOps)this.streamMatValues().get()).apply((Object)BoxesRunTime.boxToInteger((int)ArteryTransport$.MODULE$.ControlStreamId()))).lifeCycle();
        int waitInterval = 200;
        long retries = package$.MODULE$.max(1L, this.settings().Bind().BindTimeout().toMillis() / (long)waitInterval);
        this.retry$1(aeronLifecyle, waitInterval, retries);
    }

    private void startAeronErrorLog() {
        this.aeronErrorLog = new AeronErrorLog(new File(this.aeronDir(), "cnc.dat"), (LoggingAdapter)this.log());
        AtomicLong lastTimestamp = new AtomicLong(0L);
        MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
        this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask = this.system().scheduler().scheduleWithFixedDelay(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), () -> {
            if (!this.isShutdown()) {
                long newLastTimestamp = this.aeronErrorLog.logErrors((LoggingAdapter)this.log(), lastTimestamp.get());
                lastTimestamp.set(newLastTimestamp + 1L);
                return;
            }
        }, (ExecutionContext)ec);
    }

    private void startAeronCounterLog() {
        MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
        this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask = this.system().scheduler().scheduleWithFixedDelay(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), () -> {
            if (!this.isShutdown() && this.log().isDebugEnabled()) {
                this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().forEach(new CountersReader.MetaData(this){
                    private final /* synthetic */ ArteryAeronUdpTransport $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void accept(int counterId, int typeId, DirectBuffer keyBuffer, String label) {
                        long value = this.$outer.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().getCounterValue(counterId);
                        this.$outer.log().debug("Aeron Counter {}: {} {}]", (Object)BoxesRunTime.boxToInteger((int)counterId), (Object)BoxesRunTime.boxToLong((long)value), (Object)label);
                    }
                });
                return;
            }
        }, (ExecutionContext)ec);
    }

    @Override
    public Sink<EnvelopeBuffer, Future<Done>> outboundTransportSink(OutboundContext outboundContext, int streamId, EnvelopeBufferPool bufferPool) {
        FiniteDuration giveUpAfter = streamId == ArteryTransport$.MODULE$.ControlStreamId() ? this.settings().Advanced().GiveUpSystemMessageAfter() : this.settings().Advanced().Aeron().GiveUpMessageAfter();
        return Sink$.MODULE$.fromGraph((Graph)new AeronSink(this.outboundChannel(outboundContext.remoteAddress()), streamId, this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner, bufferPool, (Duration)giveUpAfter, this.flightRecorder()));
    }

    private Source<EnvelopeBuffer, AeronSource.AeronLifecycle> aeronSource(int streamId, EnvelopeBufferPool pool, String inboundChannel) {
        return Source$.MODULE$.fromGraph((Graph)new AeronSource(inboundChannel, streamId, this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner, pool, this.flightRecorder(), this.aeronSourceSpinningStrategy()));
    }

    private int aeronSourceSpinningStrategy() {
        if (this.settings().Advanced().InboundLanes() > 1 || this.settings().Advanced().Aeron().IdleCpuLevel() < 5) {
            return 0;
        }
        return 50 * this.settings().Advanced().Aeron().IdleCpuLevel() - 240;
    }

    @Override
    public Tuple2<Object, Object> bindInboundStreams() {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.settings().Canonical().Port()), (Object)BoxesRunTime.boxToInteger((int)this.settings().Bind().Port()));
        if (tuple2 != null) {
            int n = tuple2._2$mcI$sp();
            if (0 == tuple2._1$mcI$sp()) {
                if (0 == n) {
                    int p = this.autoSelectPort(this.settings().Bind().Hostname());
                    return new Tuple2.mcII.sp(p, p);
                }
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.settings().Bind().Port()), (Object)BoxesRunTime.boxToInteger((int)this.settings().Bind().Port()));
            }
            if (0 == n) {
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.settings().Canonical().Port()), (Object)BoxesRunTime.boxToInteger((int)this.autoSelectPort(this.settings().Bind().Hostname())));
            }
        }
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.settings().Canonical().Port()), (Object)BoxesRunTime.boxToInteger((int)this.settings().Bind().Port()));
    }

    @Override
    public void runInboundStreams(int port, int bindPort) {
        String inboundChannel = new StringBuilder(20).append("aeron:udp?endpoint=").append(this.settings().Bind().Hostname()).append(":").append(bindPort).toString();
        this.runInboundControlStream(inboundChannel);
        this.runInboundOrdinaryMessagesStream(inboundChannel);
        if (this.largeMessageChannelEnabled()) {
            this.runInboundLargeMessagesStream(inboundChannel);
        }
        this.blockUntilChannelActive();
    }

    private void runInboundControlStream(String inboundChannel) {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Tuple3 tuple3 = (Tuple3)this.aeronSource(ArteryTransport$.MODULE$.ControlStreamId(), this.envelopeBufferPool(), inboundChannel).via(this.inboundFlow(this.settings(), NoInboundCompressions$.MODULE$)).toMat(this.inboundControlSink(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)tuple2._1();
                if (tuple22 != null) {
                    InboundControlJunction.ControlMessageSubject c = (InboundControlJunction.ControlMessageSubject)tuple22._1();
                    Future d = (Future)tuple22._2();
                    return Tuple3$.MODULE$.apply((Object)a, (Object)c, (Object)d);
                }
            }
            throw new MatchError((Object)tuple2);
        }).run(this.controlMaterializer());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple3._1();
        InboundControlJunction.ControlMessageSubject ctrl = (InboundControlJunction.ControlMessageSubject)tuple3._2();
        Future completed = (Future)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)resourceLife, (Object)ctrl, (Object)completed);
        AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple32._1();
        InboundControlJunction.ControlMessageSubject ctrl2 = (InboundControlJunction.ControlMessageSubject)tuple32._2();
        Future completed2 = (Future)tuple32._3();
        this.attachControlMessageObserver(ctrl2);
        this.updateStreamMatValues(ArteryTransport$.MODULE$.ControlStreamId(), resourceLife2, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound control stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.runInboundControlStream(inboundChannel));
    }

    private void runInboundOrdinaryMessagesStream(String inboundChannel) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        if (this.inboundLanes() == 1) {
            tuple32 = (Tuple3)this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool(), inboundChannel).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).toMat(this.inboundSink(this.envelopeBufferPool()), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)tuple2._1();
                    Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple2._2();
                    Future c = (Future)tuple22._2();
                    return Tuple3$.MODULE$.apply((Object)a, (Object)b, (Object)c);
                }
                throw new MatchError((Object)tuple22);
            }).run(this.materializer());
        } else {
            SharedKillSwitch laneKillSwitch = KillSwitches$.MODULE$.shared("laneKillSwitch");
            Source laneSource = this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool(), inboundChannel).via(laneKillSwitch.flow()).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).via((Graph)Flow$.MODULE$.fromGraph((Graph)new DuplicateHandshakeReq(this.inboundLanes(), this, this.system(), this.envelopeBufferPool()))).via((Graph)Flow$.MODULE$.fromGraph((Graph)new DuplicateFlush(this.inboundLanes(), this.system(), this.envelopeBufferPool())));
            Tuple3 tuple33 = (Tuple3)laneSource.toMat((Graph)Sink$.MODULE$.fromGraph(new FixedSizePartitionHub<InboundEnvelope>(this.inboundLanePartitioner(), this.inboundLanes(), this.settings().Advanced().InboundHubBufferSize())), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)tuple2._1();
                    Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple2._2();
                    Source c = (Source)tuple22._2();
                    return Tuple3$.MODULE$.apply((Object)a, (Object)b, (Object)c);
                }
                throw new MatchError((Object)tuple22);
            }).run(this.materializer());
            if (tuple33 == null) {
                throw new MatchError((Object)tuple33);
            }
            AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple33._1();
            Decoder.InboundCompressionAccess compressionAccess = (Decoder.InboundCompressionAccess)tuple33._2();
            Source laneHub = (Source)tuple33._3();
            Tuple3 tuple34 = Tuple3$.MODULE$.apply((Object)resourceLife, (Object)compressionAccess, (Object)laneHub);
            AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple34._1();
            Decoder.InboundCompressionAccess compressionAccess2 = (Decoder.InboundCompressionAccess)tuple34._2();
            Source laneHub2 = (Source)tuple34._3();
            Sink<InboundEnvelope, Future<Done>> lane = this.inboundSink(this.envelopeBufferPool());
            Vector completedValues = (Vector)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.inboundLanes()).iterator().map((Function1 & Serializable)_$5 -> this.$anonfun$4(laneHub2, lane, BoxesRunTime.unboxToInt((Object)_$5))).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Vector$.MODULE$));
            MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
            Future$.MODULE$.firstCompletedOf((IterableOnce)completedValues, (ExecutionContext)ec).failed().foreach((Function1)(JProcedure1 & Serializable)reason -> laneKillSwitch.abort(reason), (ExecutionContext)ec);
            Future allCompleted = Future$.MODULE$.sequence((IterableOnce)completedValues, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)ec).map((Function1 & Serializable)_$6 -> Done$.MODULE$, (ExecutionContext)ec);
            tuple32 = tuple3 = Tuple3$.MODULE$.apply((Object)resourceLife2, (Object)compressionAccess2, (Object)allCompleted);
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple3._1();
        Decoder.InboundCompressionAccess inboundCompressionAccess = (Decoder.InboundCompressionAccess)tuple3._2();
        Future completed = (Future)tuple3._3();
        Tuple3 tuple35 = Tuple3$.MODULE$.apply((Object)resourceLife, (Object)inboundCompressionAccess, (Object)completed);
        AeronSource.AeronLifecycle resourceLife3 = (AeronSource.AeronLifecycle)tuple35._1();
        Decoder.InboundCompressionAccess inboundCompressionAccess2 = (Decoder.InboundCompressionAccess)tuple35._2();
        Future completed2 = (Future)tuple35._3();
        this.setInboundCompressionAccess(inboundCompressionAccess2);
        this.updateStreamMatValues(ArteryTransport$.MODULE$.OrdinaryStreamId(), resourceLife3, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound message stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.runInboundOrdinaryMessagesStream(inboundChannel));
    }

    private void runInboundLargeMessagesStream(String inboundChannel) {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Tuple2 tuple2 = (Tuple2)this.aeronSource(ArteryTransport$.MODULE$.LargeStreamId(), this.largeEnvelopeBufferPool(), inboundChannel).via(this.inboundLargeFlow(this.settings())).toMat(this.inboundSink(this.largeEnvelopeBufferPool()), Keep$.MODULE$.both()).run(this.materializer());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple2._1();
        Future completed = (Future)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)resourceLife, (Object)completed);
        AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple22._1();
        Future completed2 = (Future)tuple22._2();
        this.updateStreamMatValues(ArteryTransport$.MODULE$.LargeStreamId(), resourceLife2, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound large message stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.runInboundLargeMessagesStream(inboundChannel));
    }

    private void updateStreamMatValues(int streamId, AeronSource.AeronLifecycle aeronSourceLifecycle, Future<Done> completed) {
        ExecutionContextExecutor ec = this.materializer().executionContext();
        this.updateStreamMatValues(streamId, ArteryTransport$InboundStreamMatValues$.MODULE$.apply(aeronSourceLifecycle, (Future<Done>)completed.recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return Done$.MODULE$;
            }
        }, (ExecutionContext)ec)));
    }

    @Override
    public Future<Done> shutdownTransport() {
        return this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner.stop().map((Function1 & Serializable)_$7 -> {
            this.flightRecorder().transportStopped();
            if (this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask != null) {
                this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                this.flightRecorder().transportAeronErrorLogTaskStopped();
            }
            if (this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron != null) {
                this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.close();
            }
            if (this.aeronErrorLog != null) {
                this.aeronErrorLog.close();
            }
            if (this.mediaDriver.get().isDefined()) {
                this.stopMediaDriver();
            }
            return Done$.MODULE$;
        }, (ExecutionContext)this.system().dispatchers().internalDispatcher());
    }

    public int autoSelectPort(String hostname) {
        DatagramSocket socket = DatagramChannel.open().socket();
        socket.bind(new InetSocketAddress(hostname, 0));
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    public static final /* synthetic */ void org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$anon$2$$_$onUnavailableImage$$anonfun$1(Image img$1, ArteryTransport.InboundStreamMatValues x$1) {
        ArteryTransport.InboundStreamMatValues inboundStreamMatValues = x$1;
        if (inboundStreamMatValues != null) {
            ArteryTransport.InboundStreamMatValues inboundStreamMatValues2 = ArteryTransport$InboundStreamMatValues$.MODULE$.unapply(inboundStreamMatValues);
            AeronSource.AeronLifecycle aeronLifecycle = (AeronSource.AeronLifecycle)inboundStreamMatValues2._1();
            Future<Done> future = inboundStreamMatValues2._2();
            AeronSource.AeronLifecycle resourceLife = aeronLifecycle;
            resourceLife.onUnavailableImage(img$1.sessionId());
            return;
        }
        throw new MatchError((Object)inboundStreamMatValues);
    }

    private final void retry$1(AeronSource.AeronLifecycle aeronLifecyle$1, int waitInterval$1, long retries) {
        while (true) {
            long status;
            if ((status = BoxesRunTime.unboxToLong((Object)Await$.MODULE$.result(aeronLifecyle$1.channelEndpointStatus(), (Duration)this.settings().Bind().BindTimeout()))) == 1L) {
                this.log().debug("Inbound channel is now active");
                return;
            }
            if (status == -1L) {
                this.aeronErrorLog.logErrors((LoggingAdapter)this.log(), 0L);
                this.stopMediaDriver();
                throw new RemoteTransportException("Inbound Aeron channel is in errored state. See Aeron logs for details.");
            }
            if (status != 0L || retries <= 0L) break;
            Thread.sleep(Int$.MODULE$.int2long(waitInterval$1));
            --retries;
        }
        this.aeronErrorLog.logErrors((LoggingAdapter)this.log(), 0L);
        this.stopMediaDriver();
        throw new RemoteTransportException("Timed out waiting for Aeron transport to bind. See Aeoron logs.");
    }

    private final /* synthetic */ Future $anonfun$4(Source laneHub$1, Sink lane$1, int _$5) {
        return (Future)laneHub$1.toMat((Graph)lane$1, Keep$.MODULE$.right()).run(this.materializer());
    }
}

