/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.aeron;

import java.io.Serializable;
import java.util.concurrent.ThreadFactory;
import org.agrona.concurrent.IdleStrategy;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.dispatch.AbstractNodeQueue;
import org.apache.pekko.dispatch.MonitorableThreadFactory;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.artery.aeron.TaskRunner$;
import org.apache.pekko.remote.artery.aeron.TaskRunner$Add$;
import org.apache.pekko.remote.artery.aeron.TaskRunner$Remove$;
import org.apache.pekko.remote.artery.aeron.TaskRunner$Shutdown$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public class TaskRunner
implements Runnable {
    private final ExtendedActorSystem system;
    private final int idleCpuLevel;
    private final LoggingAdapter log;
    private boolean running;
    private final CommandQueue cmdQueue;
    private final ArrayBag<Function0<Object>> tasks;
    private final Promise<Done> shutdown;
    private final IdleStrategy idleStrategy;
    private boolean reset;

    public static IdleStrategy createIdleStrategy(int n) {
        return TaskRunner$.MODULE$.createIdleStrategy(n);
    }

    public TaskRunner(ExtendedActorSystem system, int idleCpuLevel) {
        this.system = system;
        this.idleCpuLevel = idleCpuLevel;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, TaskRunner.class, LogSource$.MODULE$.fromAnyClass());
        this.running = false;
        this.cmdQueue = new CommandQueue();
        this.tasks = new ArrayBag(ClassTag$.MODULE$.apply(Function0.class));
        this.shutdown = Promise$.MODULE$.apply();
        this.idleStrategy = TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel);
        this.reset = false;
    }

    public int idleCpuLevel() {
        return this.idleCpuLevel;
    }

    public void start() {
        ThreadFactory threadFactory;
        ThreadFactory threadFactory2 = this.system.threadFactory();
        if (threadFactory2 instanceof MonitorableThreadFactory) {
            MonitorableThreadFactory m = (MonitorableThreadFactory)threadFactory2;
            threadFactory = m.withName(new StringBuilder(11).append(m.name()).append("-taskrunner").toString());
        } else {
            ThreadFactory other;
            threadFactory = other = threadFactory2;
        }
        ThreadFactory tf = threadFactory;
        Thread thread = tf.newThread(this);
        thread.start();
    }

    public Future<Done> stop() {
        this.command(TaskRunner$Shutdown$.MODULE$);
        return this.shutdown.future();
    }

    public void command(Command cmd) {
        this.cmdQueue.add(cmd);
    }

    @Override
    public void run() {
        try {
            this.running = true;
            while (this.running) {
                this.processCommand((Command)this.cmdQueue.poll());
                if (!this.running) continue;
                this.executeTasks();
                if (this.reset) {
                    this.reset = false;
                    this.idleStrategy.reset();
                }
                this.idleStrategy.idle();
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.log.error(e, e.getMessage());
            }
            throw throwable;
        }
    }

    private void executeTasks() {
        for (Function0<Object> task : this.tasks.all()) {
            if (task == null) continue;
            try {
                if (!task.apply$mcZ$sp()) continue;
                this.tasks.remove(task);
                this.reset = true;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    this.log.error(e, "Task failed");
                    this.tasks.remove(task);
                    continue;
                }
                throw throwable;
            }
        }
    }

    private void processCommand(Command cmd) {
        Command command = cmd;
        if (command == null) {
            return;
        }
        if (command instanceof Add) {
            Function0<Object> function0;
            Add add = TaskRunner$Add$.MODULE$.unapply((Add)command);
            Function0<Object> task = function0 = add._1();
            this.tasks.add(task);
            return;
        }
        if (command instanceof Remove) {
            Function0<Object> function0;
            Remove remove = TaskRunner$Remove$.MODULE$.unapply((Remove)command);
            Function0<Object> task = function0 = remove._1();
            this.tasks.remove(task);
            return;
        }
        if (TaskRunner$Shutdown$.MODULE$.equals(command)) {
            this.running = false;
            this.tasks.removeAll();
            while (this.cmdQueue.poll() != null) {
            }
            this.shutdown.trySuccess((Object)Done$.MODULE$);
            return;
        }
        throw new MatchError((Object)command);
    }

    public static final class Add
    implements Command,
    Product,
    Serializable {
        private final Function0 task;

        public static Add apply(Function0<Object> function0) {
            return TaskRunner$Add$.MODULE$.apply(function0);
        }

        public static Add fromProduct(Product product) {
            return TaskRunner$Add$.MODULE$.fromProduct(product);
        }

        public static Add unapply(Add add) {
            return TaskRunner$Add$.MODULE$.unapply(add);
        }

        public Add(Function0<Object> task) {
            this.task = task;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Add)) return false;
            Add add = (Add)object;
            Function0<Object> function0 = this.task();
            Function0<Object> function02 = add.task();
            if (function0 != null) {
                if (!function0.equals(function02)) return false;
                return true;
            }
            if (function02 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Add;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Add";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "task";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function0<Object> task() {
            return this.task;
        }

        public Add copy(Function0<Object> task) {
            return new Add(task);
        }

        public Function0<Object> copy$default$1() {
            return this.task();
        }

        public Function0<Object> _1() {
            return this.task();
        }
    }

    public static final class ArrayBag<T> {
        private final ClassTag<T> evidence$1;
        private T[] elements;

        public ArrayBag(ClassTag<T> evidence$1) {
            this.evidence$1 = evidence$1;
            this.elements = (Object[])Array$.MODULE$.ofDim(16, evidence$1);
        }

        public void add(T e) {
            int size = this.elements.length;
            this.tryAdd$1(e, size, 0);
        }

        public void remove(T e) {
            int size = this.elements.length;
            this.tryRemove$1(e, size, 0);
        }

        public void removeAll() {
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i] = null;
            }
        }

        public T[] all() {
            return this.elements;
        }

        private void doubleCapacity() {
            int newCapacity = this.elements.length << 1;
            if (newCapacity < 0) {
                throw new IllegalStateException("Sorry, too big");
            }
            Object[] a = (Object[])Array$.MODULE$.ofDim(newCapacity, this.evidence$1);
            System.arraycopy(this.elements, 0, a, 0, this.elements.length);
            this.elements = a;
        }

        public String toString() {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.elements);
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filterNot$extension(object, (Function1 & Serializable)_$1 -> _$1 == null)).mkString("[", ",", "]");
        }

        private final void tryAdd$1(Object e$1, int size$1, int i) {
            while (true) {
                if (i == size$1) {
                    this.doubleCapacity();
                    this.elements[i] = e$1;
                    return;
                }
                if (this.elements[i] == null) {
                    this.elements[i] = e$1;
                    return;
                }
                ++i;
            }
        }

        private final void tryRemove$1(Object e$2, int size$2, int i) {
            while (i != size$2) {
                if (BoxesRunTime.equals(this.elements[i], (Object)e$2)) {
                    this.elements[i] = null;
                    return;
                }
                ++i;
            }
            return;
        }
    }

    public static interface Command {
    }

    public static final class CommandQueue
    extends AbstractNodeQueue<Command> {
    }

    public static final class Remove
    implements Command,
    Product,
    Serializable {
        private final Function0 task;

        public static Remove apply(Function0<Object> function0) {
            return TaskRunner$Remove$.MODULE$.apply(function0);
        }

        public static Remove fromProduct(Product product) {
            return TaskRunner$Remove$.MODULE$.fromProduct(product);
        }

        public static Remove unapply(Remove remove) {
            return TaskRunner$Remove$.MODULE$.unapply(remove);
        }

        public Remove(Function0<Object> task) {
            this.task = task;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Remove)) return false;
            Remove remove = (Remove)object;
            Function0<Object> function0 = this.task();
            Function0<Object> function02 = remove.task();
            if (function0 != null) {
                if (!function0.equals(function02)) return false;
                return true;
            }
            if (function02 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Remove;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Remove";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "task";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function0<Object> task() {
            return this.task;
        }

        public Remove copy(Function0<Object> task) {
            return new Remove(task);
        }

        public Function0<Object> copy$default$1() {
            return this.task();
        }

        public Function0<Object> _1() {
            return this.task();
        }
    }
}

