/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.serialization;

import java.io.Serializable;
import org.apache.pekko.actor.ActorSelectionMessage;
import org.apache.pekko.actor.ActorSelectionMessage$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.SelectChildName;
import org.apache.pekko.actor.SelectChildName$;
import org.apache.pekko.actor.SelectChildPattern;
import org.apache.pekko.actor.SelectChildPattern$;
import org.apache.pekko.actor.SelectParent$;
import org.apache.pekko.actor.SelectionPathElement;
import org.apache.pekko.protobufv3.internal.ByteString;
import org.apache.pekko.remote.ByteStringUtils$;
import org.apache.pekko.remote.ContainerFormats;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;

public class MessageContainerSerializer
implements Serializer,
BaseSerializer {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MessageContainerSerializer.class.getDeclaredField("serialization$lzy1"));
    private int identifier;
    private final ExtendedActorSystem system;
    private volatile Object serialization$lzy1;

    public MessageContainerSerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$((BaseSerializer)this);
        Statics.releaseFence();
    }

    public int identifier() {
        return this.identifier;
    }

    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$0) {
        this.identifier = x$0;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization() {
        Object object = this.serialization$lzy1;
        if (object instanceof Serialization) {
            return (Serialization)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Serialization)this.serialization$lzyINIT1();
    }

    private Object serialization$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.serialization$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Serialization serialization = null;
                    try {
                        serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                        object2 = serialization == null ? LazyVals.NullValue$.MODULE$ : serialization;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.serialization$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serialization;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean includeManifest() {
        return false;
    }

    public byte[] toBinary(Object obj) {
        Object object = obj;
        if (object instanceof ActorSelectionMessage) {
            ActorSelectionMessage sel = (ActorSelectionMessage)object;
            return this.serializeSelection(sel);
        }
        throw new IllegalArgumentException(new StringBuilder(34).append("Cannot serialize object of type [").append(obj.getClass().getName()).append("]").toString());
    }

    private byte[] serializeSelection(ActorSelectionMessage sel) {
        ContainerFormats.SelectionEnvelope.Builder builder = ContainerFormats.SelectionEnvelope.newBuilder();
        Object message = sel.msg();
        Serializer serializer = this.serialization().findSerializerFor(message);
        builder.setEnclosedMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(serializer.toBinary(message))).setSerializerId(serializer.identifier()).setWildcardFanOut(sel.wildcardFanOut());
        String ms = Serializers$.MODULE$.manifestFor(serializer, message);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ms))) {
            builder.setMessageManifest(ByteString.copyFromUtf8((String)ms));
        }
        sel.elements().foreach((Function1 & Serializable)x$1 -> {
            SelectionPathElement selectionPathElement = x$1;
            if (selectionPathElement instanceof SelectChildName) {
                String string;
                SelectChildName selectChildName = SelectChildName$.MODULE$.unapply((SelectChildName)selectionPathElement);
                String name = string = selectChildName._1();
                return builder.addPattern(this.buildPattern((Option<String>)Some$.MODULE$.apply((Object)name), ContainerFormats.PatternType.CHILD_NAME));
            }
            if (selectionPathElement instanceof SelectChildPattern) {
                String string;
                SelectChildPattern selectChildPattern = SelectChildPattern$.MODULE$.unapply((SelectChildPattern)selectionPathElement);
                String patternStr = string = selectChildPattern._1();
                return builder.addPattern(this.buildPattern((Option<String>)Some$.MODULE$.apply((Object)patternStr), ContainerFormats.PatternType.CHILD_PATTERN));
            }
            if (SelectParent$.MODULE$.equals(selectionPathElement)) {
                return builder.addPattern(this.buildPattern((Option<String>)None$.MODULE$, ContainerFormats.PatternType.PARENT));
            }
            throw new MatchError((Object)selectionPathElement);
        });
        return builder.build().toByteArray();
    }

    private ContainerFormats.Selection.Builder buildPattern(Option<String> matcher, ContainerFormats.PatternType tpe) {
        ContainerFormats.Selection.Builder builder = ContainerFormats.Selection.newBuilder().setType(tpe);
        matcher.foreach((Function1 & Serializable)value -> builder.setMatcher((String)value));
        return builder;
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        ContainerFormats.SelectionEnvelope selectionEnvelope = ContainerFormats.SelectionEnvelope.parseFrom(bytes);
        String manifest2 = selectionEnvelope.hasMessageManifest() ? selectionEnvelope.getMessageManifest().toStringUtf8() : "";
        Object msg = this.serialization().deserialize(selectionEnvelope.getEnclosedMessage().toByteArray(), selectionEnvelope.getSerializerId(), manifest2).get();
        Iterable elements = (Iterable)package.JavaConverters$.MODULE$.ListHasAsScala(selectionEnvelope.getPatternList()).asScala().iterator().map((Function1 & Serializable)x -> {
            SelectChildName selectChildName;
            ContainerFormats.PatternType patternType = x.getType();
            ContainerFormats.PatternType patternType2 = ContainerFormats.PatternType.CHILD_NAME;
            ContainerFormats.PatternType patternType3 = patternType;
            if (!(patternType2 != null ? !((Object)((Object)patternType2)).equals((Object)patternType3) : patternType3 != null)) {
                selectChildName = SelectChildName$.MODULE$.apply(x.getMatcher());
            } else {
                ContainerFormats.PatternType patternType4 = ContainerFormats.PatternType.CHILD_PATTERN;
                ContainerFormats.PatternType patternType5 = patternType;
                if (!(patternType4 != null ? !((Object)((Object)patternType4)).equals((Object)patternType5) : patternType5 != null)) {
                    selectChildName = SelectChildPattern$.MODULE$.apply(x.getMatcher());
                } else {
                    ContainerFormats.PatternType patternType6 = ContainerFormats.PatternType.PARENT;
                    ContainerFormats.PatternType patternType7 = patternType;
                    if (!(patternType6 != null ? !((Object)((Object)patternType6)).equals((Object)patternType7) : patternType7 != null)) {
                        selectChildName = SelectParent$.MODULE$;
                    } else {
                        throw new MatchError((Object)patternType);
                    }
                }
            }
            return (SelectionPathElement)selectChildName;
        }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$));
        boolean wildcardFanOut = selectionEnvelope.hasWildcardFanOut() ? selectionEnvelope.getWildcardFanOut() : false;
        return ActorSelectionMessage$.MODULE$.apply(msg, elements, wildcardFanOut);
    }
}

