/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.dispatch.Dispatchers;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.Transport;
import org.apache.pekko.remote.transport.netty.ClientHandler;
import org.apache.pekko.remote.transport.netty.NettyFutureBridge$;
import org.apache.pekko.remote.transport.netty.NettySSLSupport$;
import org.apache.pekko.remote.transport.netty.NettyTransport$;
import org.apache.pekko.remote.transport.netty.NettyTransportException;
import org.apache.pekko.remote.transport.netty.NettyTransportExceptionNoStack;
import org.apache.pekko.remote.transport.netty.NettyTransportSettings;
import org.apache.pekko.remote.transport.netty.SSLEngineProvider;
import org.apache.pekko.remote.transport.netty.TcpClientHandler;
import org.apache.pekko.remote.transport.netty.TcpServerHandler;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public class NettyTransport
implements Transport {
    private final NettyTransportSettings settings;
    private final ExtendedActorSystem system;
    private final ExecutionContext executionContext;
    private final String schemeIdentifier;
    private volatile Address boundTo;
    private volatile Channel serverChannel;
    public final MarkerLoggingAdapter org$apache$pekko$remote$transport$netty$NettyTransport$$log;
    private final ConcurrentHashMap udpConnectionTable;
    private final DefaultChannelGroup channelGroup;
    private final ChannelFactory clientChannelFactory;
    private final ChannelFactory serverChannelFactory;
    public final Promise<Transport.AssociationEventListener> org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise;
    private final SSLEngineProvider sslEngineProvider;
    private final Bootstrap inboundBootstrap;

    public static int FrameLengthFieldLength() {
        return NettyTransport$.MODULE$.FrameLengthFieldLength();
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option);
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option, Option<Object> option2) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option, option2);
    }

    public static void gracefulClose(Channel channel, ExecutionContext executionContext) {
        NettyTransport$.MODULE$.gracefulClose(channel, executionContext);
    }

    public static AtomicInteger uniqueIdCounter() {
        return NettyTransport$.MODULE$.uniqueIdCounter();
    }

    public NettyTransport(NettyTransportSettings settings, ExtendedActorSystem system) {
        SSLEngineProvider sSLEngineProvider;
        this.settings = settings;
        this.system = system;
        Dispatchers dispatchers = system.dispatchers();
        this.executionContext = (ExecutionContext)settings.UseDispatcherForIo().orElse(() -> NettyTransport.$init$$$anonfun$3(system)).map((Function1 & Serializable)id -> dispatchers.lookup(id)).getOrElse(() -> NettyTransport.$init$$$anonfun$5(system));
        this.schemeIdentifier = new StringBuilder(3).append(settings.EnableSsl() ? "ssl." : "").append("tcp").toString();
        this.org$apache$pekko$remote$transport$netty$NettyTransport$$log = Logging$.MODULE$.withMarker((ActorSystem)system, NettyTransport.class, LogSource$.MODULE$.fromAnyClass());
        this.udpConnectionTable = new ConcurrentHashMap();
        this.channelGroup = new DefaultChannelGroup(new StringBuilder(42).append("pekko-netty-transport-driver-channelgroup-").append(NettyTransport$.MODULE$.uniqueIdCounter().getAndIncrement()).toString());
        Executor boss = this.createExecutorService();
        Executor worker = this.createExecutorService();
        this.clientChannelFactory = new NioClientSocketChannelFactory(boss, 1, (WorkerPool)new NioWorkerPool(worker, settings.ClientSocketWorkerPoolSize()), (Timer)new HashedWheelTimer(system.threadFactory()));
        Executor boss2 = this.createExecutorService();
        Executor worker2 = this.createExecutorService();
        this.serverChannelFactory = new NioServerSocketChannelFactory(boss2, worker2, settings.ServerSocketWorkerPoolSize());
        this.org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise = Promise$.MODULE$.apply();
        if (settings.EnableSsl()) {
            sSLEngineProvider = (SSLEngineProvider)OptionVal.Some$.MODULE$.apply(system.dynamicAccess().createInstanceFor(settings.SSLEngineProviderClassName(), (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply(ActorSystem.class, (Object)system)})), ClassTag$.MODULE$.apply(SSLEngineProvider.class)).recover((PartialFunction)new Serializable(this){
                private final /* synthetic */ NettyTransport $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    throw new ConfigurationException(new StringBuilder(37).append("Could not create SSLEngineProvider [").append(this.$outer.settings().SSLEngineProviderClassName()).append("]").toString(), e);
                }
            }).get());
        } else {
            OptionVal$.MODULE$.None();
            sSLEngineProvider = null;
        }
        this.sslEngineProvider = sSLEngineProvider;
        ChannelPipelineFactory serverPipelineFactory = new ChannelPipelineFactory(this){
            private final /* synthetic */ NettyTransport $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public ChannelPipeline getPipeline() {
                DefaultChannelPipeline pipeline = this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", (ChannelHandler)this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$sslHandler(false));
                }
                TcpServerHandler handler = new TcpServerHandler(this.$outer, (Future<Transport.AssociationEventListener>)this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise.future(), (LoggingAdapter)this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$log);
                pipeline.addLast("ServerHandler", (ChannelHandler)handler);
                return pipeline;
            }
        };
        this.inboundBootstrap = this.setupBootstrap(new ServerBootstrap(this.serverChannelFactory), serverPipelineFactory);
    }

    public NettyTransportSettings settings() {
        return this.settings;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public NettyTransport(ExtendedActorSystem system, Config conf) {
        this(new NettyTransportSettings(conf), system);
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String schemeIdentifier() {
        return this.schemeIdentifier;
    }

    @Override
    public int maximumPayloadBytes() {
        return this.settings().MaxFrameSize();
    }

    public final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable() {
        return this.udpConnectionTable;
    }

    private Executor createExecutorService() {
        Dispatchers dispatchers = this.system().dispatchers();
        return (Executor)this.settings().UseDispatcherForIo().map((Function1 & Serializable)id -> dispatchers.lookup(id)).getOrElse(this::createExecutorService$$anonfun$2);
    }

    public DefaultChannelGroup channelGroup() {
        return this.channelGroup;
    }

    public DefaultChannelPipeline org$apache$pekko$remote$transport$netty$NettyTransport$$newPipeline() {
        DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
        pipeline.addLast("FrameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.maximumPayloadBytes(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), true));
        pipeline.addLast("FrameEncoder", (ChannelHandler)new LengthFieldPrepender(NettyTransport$.MODULE$.FrameLengthFieldLength()));
        return pipeline;
    }

    public SslHandler org$apache$pekko$remote$transport$netty$NettyTransport$$sslHandler(boolean isClient) {
        SSLEngineProvider sSLEngineProvider = this.sslEngineProvider;
        SSLEngineProvider sSLEngineProvider2 = (SSLEngineProvider)OptionVal.Some$.MODULE$.unapply((Object)sSLEngineProvider);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)sSLEngineProvider2)) {
            SSLEngineProvider sSLEngineProvider3;
            SSLEngineProvider sslProvider = sSLEngineProvider3 = (SSLEngineProvider)OptionVal$.MODULE$.get$extension((Object)sSLEngineProvider2);
            SslHandler handler = NettySSLSupport$.MODULE$.apply(sslProvider, isClient);
            handler.setCloseOnSSLException(true);
            return handler;
        }
        throw new IllegalStateException("Expected enable-ssl=on");
    }

    private ChannelPipelineFactory clientPipelineFactory(Address remoteAddress) {
        return new ChannelPipelineFactory(remoteAddress, this){
            private final Address remoteAddress$1;
            private final /* synthetic */ NettyTransport $outer;
            {
                this.remoteAddress$1 = remoteAddress$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public ChannelPipeline getPipeline() {
                DefaultChannelPipeline pipeline = this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", (ChannelHandler)this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$sslHandler(true));
                }
                TcpClientHandler handler = new TcpClientHandler(this.$outer, this.remoteAddress$1, (LoggingAdapter)this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$log);
                pipeline.addLast("clienthandler", (ChannelHandler)handler);
                return pipeline;
            }
        };
    }

    private <B extends Bootstrap> B setupBootstrap(B bootstrap, ChannelPipelineFactory pipelineFactory) {
        bootstrap.setPipelineFactory(pipelineFactory);
        bootstrap.setOption("backlog", (Object)BoxesRunTime.boxToInteger((int)this.settings().Backlog()));
        bootstrap.setOption("child.tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpNodelay()));
        bootstrap.setOption("child.keepAlive", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpKeepalive()));
        bootstrap.setOption("reuseAddress", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpReuseAddr()));
        this.settings().ReceiveBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("receiveBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().SendBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("sendBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferHighWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferLowWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        return bootstrap;
    }

    private ClientBootstrap outboundBootstrap(Address remoteAddress) {
        ClientBootstrap bootstrap = this.setupBootstrap(new ClientBootstrap(this.clientChannelFactory), this.clientPipelineFactory(remoteAddress));
        bootstrap.setOption("connectTimeoutMillis", (Object)BoxesRunTime.boxToLong((long)this.settings().ConnectionTimeout().toMillis()));
        bootstrap.setOption("tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpNodelay()));
        bootstrap.setOption("keepAlive", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpKeepalive()));
        this.settings().ReceiveBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("receiveBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().SendBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("sendBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferHighWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferLowWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        return bootstrap;
    }

    @Override
    public boolean isResponsibleFor(Address address) {
        return true;
    }

    public Future<InetSocketAddress> addressToSocketAddress(Address addr) {
        Address address = addr;
        if (address != null) {
            Address address2 = Address$.MODULE$.unapply(address);
            String string = address2._1();
            String string2 = address2._2();
            Option option = address2._3();
            Option option2 = address2._4();
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return Future$.MODULE$.apply(() -> NettyTransport.addressToSocketAddress$$anonfun$1(host, port), this.executionContext());
                }
            }
        }
        return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(53).append("Address [").append(addr).append("] does not contain host or port information.").toString()));
    }

    @Override
    public Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> listen() {
        int bindPort = this.settings().BindPortSelector();
        return this.addressToSocketAddress(Address$.MODULE$.apply("", "", this.settings().BindHostname(), bindPort)).map((Function1 & Serializable)address -> {
            Tuple2 tuple2;
            try {
                Address address2;
                Channel channel;
                Bootstrap bootstrap = this.inboundBootstrap;
                if (bootstrap instanceof ServerBootstrap) {
                    ServerBootstrap b = (ServerBootstrap)bootstrap;
                    channel = b.bind((SocketAddress)address);
                } else if (bootstrap instanceof ConnectionlessBootstrap) {
                    ConnectionlessBootstrap b = (ConnectionlessBootstrap)bootstrap;
                    channel = b.bind((SocketAddress)address);
                } else {
                    throw new IllegalStateException();
                }
                Channel newServerChannel = channel;
                newServerChannel.setReadable(false);
                this.channelGroup().add(newServerChannel);
                this.serverChannel = newServerChannel;
                None$ port = this.settings().PortSelector() == 0 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.settings().PortSelector()));
                Option<Address> option = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)Some$.MODULE$.apply((Object)this.settings().Hostname()), (Option<Object>)port);
                if (option instanceof Some) {
                    Address address3;
                    address2 = (Address)((Some)option).value();
                    Option<Address> option2 = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    if (!(option2 instanceof Some)) {
                        if (None$.MODULE$.equals(option2)) {
                            throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.getLocalAddress().getClass().getName()).append("]").toString());
                        }
                        throw new MatchError(option2);
                    }
                    this.boundTo = address3 = (Address)((Some)option2).value();
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.getLocalAddress().getClass().getName()).append("]").toString());
                    }
                    throw new MatchError(option);
                }
                this.org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise.future().foreach((Function1 & Serializable)_$4 -> newServerChannel.setReadable(true), this.executionContext());
                tuple2 = Tuple2$.MODULE$.apply((Object)address2, this.org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    this.org$apache$pekko$remote$transport$netty$NettyTransport$$log.error("failed to bind to {}, shutting down Netty transport", address);
                    try {
                        boxedUnit = this.shutdown();
                    }
                    catch (Throwable throwable4) {
                        Option option3;
                        Throwable throwable5 = throwable4;
                        if (throwable5 == null || (option3 = NonFatal$.MODULE$.unapply(throwable5)).isEmpty()) {
                            throw throwable4;
                        }
                        Throwable throwable6 = (Throwable)option3.get();
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw e;
                }
                throw throwable;
            }
            return tuple2;
        }, this.executionContext());
    }

    public Address boundAddress() {
        return this.boundTo;
    }

    @Override
    public Future<AssociationHandle> associate(Address remoteAddress) {
        if (!this.serverChannel.isBound()) {
            return Future$.MODULE$.failed((Throwable)new NettyTransportException("Transport is not bound"));
        }
        ClientBootstrap bootstrap = this.outboundBootstrap(remoteAddress);
        return this.addressToSocketAddress(remoteAddress).flatMap((Function1 & Serializable)socketAddress -> NettyFutureBridge$.MODULE$.apply(bootstrap.connect((SocketAddress)socketAddress)).map((Function1 & Serializable)channel -> {
            if (this.settings().EnableSsl()) {
                scala.concurrent.package$.MODULE$.blocking(() -> NettyTransport.associate$$anonfun$1$$anonfun$1$$anonfun$1(channel));
            }
            channel.setReadable(false);
            return channel;
        }, this.executionContext()).flatMap((Function1 & Serializable)readyChannel -> ((ClientHandler)readyChannel.getPipeline().get(ClientHandler.class)).statusFuture().map((Function1 & Serializable)handle -> handle, this.executionContext()), this.executionContext()), this.executionContext()).recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof CancellationException) {
                    return true;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable t = throwable2 = (Throwable)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof CancellationException) {
                    throw new NettyTransportExceptionNoStack("Connection was cancelled");
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2 = (Throwable)option.get();
                    Throwable t = throwable2;
                    String msg = t.getCause() == null ? t.getMessage() : (t.getCause().getCause() == null ? new StringBuilder(13).append(t.getMessage()).append(", caused by: ").append(t.getCause()).toString() : new StringBuilder(26).append(t.getMessage()).append(", caused by: ").append(t.getCause()).append(", caused by: ").append(t.getCause().getCause()).toString());
                    throw new NettyTransportExceptionNoStack(new StringBuilder(2).append(t.getClass().getName()).append(": ").append(msg).toString(), t.getCause());
                }
                return function1.apply((Object)x);
            }
        }, this.executionContext());
    }

    @Override
    public Future<Object> shutdown() {
        return this.always$1(this.channelGroup().unbind()).flatMap((Function1 & Serializable)unbindStatus -> this.shutdown$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)unbindStatus)), this.executionContext());
    }

    private static final Option $init$$$anonfun$3(ExtendedActorSystem system$1) {
        String string = ((RARP)RARP$.MODULE$.apply((ActorSystem)system$1)).provider().remoteSettings().Dispatcher();
        if ("".equals(string)) {
            return None$.MODULE$;
        }
        String dispatcherName = string;
        return Some$.MODULE$.apply((Object)dispatcherName);
    }

    private static final ExecutionContextExecutor $init$$$anonfun$5(ExtendedActorSystem system$2) {
        return system$2.dispatcher();
    }

    private final Executor createExecutorService$$anonfun$2() {
        return Executors.newCachedThreadPool(this.system().threadFactory());
    }

    private static final InetSocketAddress addressToSocketAddress$$anonfun$1$$anonfun$1(String host$2, int port$2) {
        return new InetSocketAddress(InetAddress.getByName(host$2), port$2);
    }

    private static final InetSocketAddress addressToSocketAddress$$anonfun$1(String host$1, int port$1) {
        return (InetSocketAddress)scala.concurrent.package$.MODULE$.blocking(() -> NettyTransport.addressToSocketAddress$$anonfun$1$$anonfun$1(host$1, port$1));
    }

    private static final ChannelFuture associate$$anonfun$1$$anonfun$1$$anonfun$1(Channel channel$3) {
        return ((SslHandler)channel$3.getPipeline().get(SslHandler.class)).handshake().awaitUninterruptibly();
    }

    private final Future always$1(ChannelGroupFuture c) {
        return NettyFutureBridge$.MODULE$.apply(c).map((Function1 & Serializable)_$5 -> true, this.executionContext()).recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return BoxesRunTime.boxToBoolean((boolean)false);
            }
        }, this.executionContext());
    }

    private final /* synthetic */ boolean shutdown$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(boolean unbindStatus$2, boolean lastWriteStatus$2, boolean disconnectStatus$1, boolean closeStatus) {
        if (this.settings().UseDispatcherForIo().isDefined()) {
            this.clientChannelFactory.shutdown();
            this.serverChannelFactory.shutdown();
        } else {
            this.clientChannelFactory.releaseExternalResources();
            this.serverChannelFactory.releaseExternalResources();
        }
        return lastWriteStatus$2 && unbindStatus$2 && disconnectStatus$1 && closeStatus;
    }

    private final /* synthetic */ Future shutdown$$anonfun$1$$anonfun$1$$anonfun$1(boolean unbindStatus$1, boolean lastWriteStatus$1, boolean disconnectStatus) {
        return this.always$1(this.channelGroup().close()).map((Function1 & Serializable)closeStatus -> this.shutdown$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(unbindStatus$1, lastWriteStatus$1, disconnectStatus, BoxesRunTime.unboxToBoolean((Object)closeStatus)), this.executionContext());
    }

    private final /* synthetic */ Future shutdown$$anonfun$1$$anonfun$1(boolean unbindStatus$3, boolean lastWriteStatus) {
        return this.always$1(this.channelGroup().disconnect()).flatMap((Function1 & Serializable)disconnectStatus -> this.shutdown$$anonfun$1$$anonfun$1$$anonfun$1(unbindStatus$3, lastWriteStatus, BoxesRunTime.unboxToBoolean((Object)disconnectStatus)), this.executionContext());
    }

    private final /* synthetic */ Future shutdown$$anonfun$1(boolean unbindStatus) {
        return this.always$1(this.channelGroup().write((Object)ChannelBuffers.buffer((int)0))).flatMap((Function1 & Serializable)lastWriteStatus -> this.shutdown$$anonfun$1$$anonfun$1(unbindStatus, BoxesRunTime.unboxToBoolean((Object)lastWriteStatus)), this.executionContext());
    }
}

