/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import java.io.Serializable;
import org.apache.pekko.remote.Ack;
import org.apache.pekko.remote.AckedSendBuffer$;
import org.apache.pekko.remote.HasSequenceNumber;
import org.apache.pekko.remote.ResendBufferCapacityReachedException;
import org.apache.pekko.remote.ResendUnfulfillableException;
import org.apache.pekko.remote.SeqNo;
import scala.Function1;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class AckedSendBuffer<T extends HasSequenceNumber>
implements Product,
Serializable {
    private final int capacity;
    private final IndexedSeq nonAcked;
    private final IndexedSeq nacked;
    private final SeqNo maxSeq;

    public static <T extends HasSequenceNumber> AckedSendBuffer<T> apply(int n, IndexedSeq<T> indexedSeq, IndexedSeq<T> indexedSeq2, SeqNo seqNo) {
        return AckedSendBuffer$.MODULE$.apply(n, indexedSeq, indexedSeq2, seqNo);
    }

    public static AckedSendBuffer<?> fromProduct(Product product) {
        return AckedSendBuffer$.MODULE$.fromProduct(product);
    }

    public static <T extends HasSequenceNumber> AckedSendBuffer<T> unapply(AckedSendBuffer<T> ackedSendBuffer) {
        return AckedSendBuffer$.MODULE$.unapply(ackedSendBuffer);
    }

    public static <T extends HasSequenceNumber> Vector<T> $lessinit$greater$default$2() {
        return AckedSendBuffer$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T extends HasSequenceNumber> Vector<T> $lessinit$greater$default$3() {
        return AckedSendBuffer$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T extends HasSequenceNumber> SeqNo $lessinit$greater$default$4() {
        return AckedSendBuffer$.MODULE$.$lessinit$greater$default$4();
    }

    public AckedSendBuffer(int capacity, IndexedSeq<T> nonAcked, IndexedSeq<T> nacked, SeqNo maxSeq) {
        this.capacity = capacity;
        this.nonAcked = nonAcked;
        this.nacked = nacked;
        this.maxSeq = maxSeq;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.capacity());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.nonAcked()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.nacked()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.maxSeq()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof AckedSendBuffer)) return false;
        AckedSendBuffer ackedSendBuffer = (AckedSendBuffer)object;
        if (this.capacity() != ackedSendBuffer.capacity()) return false;
        IndexedSeq<T> indexedSeq = this.nonAcked();
        IndexedSeq<T> indexedSeq2 = ackedSendBuffer.nonAcked();
        if (indexedSeq == null) {
            if (indexedSeq2 != null) {
                return false;
            }
        } else if (!indexedSeq.equals(indexedSeq2)) return false;
        IndexedSeq<T> indexedSeq3 = this.nacked();
        IndexedSeq<T> indexedSeq4 = ackedSendBuffer.nacked();
        if (indexedSeq3 == null) {
            if (indexedSeq4 != null) {
                return false;
            }
        } else if (!indexedSeq3.equals(indexedSeq4)) return false;
        SeqNo seqNo = this.maxSeq();
        SeqNo seqNo2 = ackedSendBuffer.maxSeq();
        if (seqNo == null) {
            if (seqNo2 == null) return true;
            return false;
        } else {
            if (!((Object)seqNo).equals(seqNo2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof AckedSendBuffer;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "AckedSendBuffer";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "capacity";
            }
            case 1: {
                return "nonAcked";
            }
            case 2: {
                return "nacked";
            }
            case 3: {
                return "maxSeq";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public int capacity() {
        return this.capacity;
    }

    public IndexedSeq<T> nonAcked() {
        return this.nonAcked;
    }

    public IndexedSeq<T> nacked() {
        return this.nacked;
    }

    public SeqNo maxSeq() {
        return this.maxSeq;
    }

    public AckedSendBuffer<T> acknowledge(Ack ack) {
        Vector newNacked;
        if (ack.cumulativeAck().$greater(this.maxSeq())) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Highest SEQ so far was ").append(this.maxSeq()).append(" but cumulative ACK is ").append(ack.cumulativeAck()).toString());
        }
        Object object = newNacked = ack.nacks().isEmpty() ? Vector$.MODULE$.empty() : (IndexedSeq)((IterableOps)this.nacked().$plus$plus(this.nonAcked())).filter((Function1 & Serializable)m -> ack.nacks().apply((Object)m.seq()));
        if (newNacked.size() < ack.nacks().size()) {
            throw new ResendUnfulfillableException();
        }
        IndexedSeq indexedSeq = (IndexedSeq)this.nonAcked().filter((Function1 & Serializable)m -> m.seq().$greater(ack.cumulativeAck()));
        int n = this.copy$default$1();
        SeqNo seqNo = this.copy$default$4();
        return this.copy(n, (IndexedSeq<T>)indexedSeq, (IndexedSeq<T>)newNacked, seqNo);
    }

    public AckedSendBuffer<T> buffer(T msg) {
        if (msg.seq().$less$eq(this.maxSeq())) {
            throw new IllegalArgumentException(new StringBuilder(47).append("Sequence number must be monotonic. Received [").append(msg.seq()).append("] ").append(new StringBuilder(24).append("which is smaller than [").append(this.maxSeq()).append("]").toString()).toString());
        }
        if (this.nonAcked().size() == this.capacity()) {
            throw new ResendBufferCapacityReachedException(this.capacity());
        }
        IndexedSeq indexedSeq = (IndexedSeq)this.nonAcked().$colon$plus(msg);
        SeqNo seqNo = msg.seq();
        int n = this.copy$default$1();
        IndexedSeq<T> indexedSeq2 = this.copy$default$3();
        return this.copy(n, indexedSeq, indexedSeq2, seqNo);
    }

    public String toString() {
        return new StringBuilder(3).append("[").append(this.maxSeq()).append(" ").append(((IterableOnceOps)this.nonAcked().map((Function1 & Serializable)_$1 -> _$1.seq())).mkString("{", ", ", "}")).append("]").toString();
    }

    public <T extends HasSequenceNumber> AckedSendBuffer<T> copy(int capacity, IndexedSeq<T> nonAcked, IndexedSeq<T> nacked, SeqNo maxSeq) {
        return new AckedSendBuffer<T>(capacity, nonAcked, nacked, maxSeq);
    }

    public int copy$default$1() {
        return this.capacity();
    }

    public <T extends HasSequenceNumber> IndexedSeq<T> copy$default$2() {
        return this.nonAcked();
    }

    public <T extends HasSequenceNumber> IndexedSeq<T> copy$default$3() {
        return this.nacked();
    }

    public <T extends HasSequenceNumber> SeqNo copy$default$4() {
        return this.maxSeq();
    }

    public int _1() {
        return this.capacity();
    }

    public IndexedSeq<T> _2() {
        return this.nonAcked();
    }

    public IndexedSeq<T> _3() {
        return this.nacked();
    }

    public SeqNo _4() {
        return this.maxSeq();
    }
}

