/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import com.typesafe.config.Config;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.remote.FailureDetector;
import org.apache.pekko.remote.FailureDetector$;
import org.apache.pekko.util.Helpers;
import org.apache.pekko.util.Helpers$;
import scala.Predef$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;

public class DeadlineFailureDetector
implements FailureDetector {
    private final FiniteDuration acceptableHeartbeatPause;
    private final FiniteDuration heartbeatInterval;
    private final FailureDetector.Clock clock;
    private final long deadlineMillis;
    private volatile long heartbeatTimestamp;
    private volatile boolean active;

    public DeadlineFailureDetector(FiniteDuration acceptableHeartbeatPause, FiniteDuration heartbeatInterval, FailureDetector.Clock clock) {
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.heartbeatInterval = heartbeatInterval;
        this.clock = clock;
        Predef$.MODULE$.require(acceptableHeartbeatPause.$greater$eq((Object)Duration$.MODULE$.Zero()), DeadlineFailureDetector::$init$$$anonfun$1);
        Predef$.MODULE$.require(heartbeatInterval.$greater((Object)Duration$.MODULE$.Zero()), DeadlineFailureDetector::$init$$$anonfun$2);
        this.deadlineMillis = acceptableHeartbeatPause.toMillis() + heartbeatInterval.toMillis();
        this.heartbeatTimestamp = 0L;
        this.active = false;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public FiniteDuration heartbeatInterval() {
        return this.heartbeatInterval;
    }

    public DeadlineFailureDetector(Config config, EventStream ev) {
        this(Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "acceptable-heartbeat-pause"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "heartbeat-interval"), FailureDetector$.MODULE$.defaultClock());
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable(this.clock.apply$mcJ$sp());
    }

    private boolean isAvailable(long timestamp) {
        if (this.active) {
            return this.heartbeatTimestamp + this.deadlineMillis > timestamp;
        }
        return true;
    }

    @Override
    public boolean isMonitoring() {
        return this.active;
    }

    @Override
    public final void heartbeat() {
        this.heartbeatTimestamp = this.clock.apply$mcJ$sp();
        this.active = true;
    }

    private static final Object $init$$$anonfun$1() {
        return "failure-detector.acceptable-heartbeat-pause must be >= 0 s";
    }

    private static final Object $init$$$anonfun$2() {
        return "failure-detector.heartbeat-interval must be > 0 s";
    }
}

