/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRef$;
import org.apache.pekko.actor.ActorSelectionMessage;
import org.apache.pekko.actor.ActorSelectionMessage$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.Dropped;
import org.apache.pekko.actor.Dropped$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.OneForOneStrategy$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Status;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.DiagnosticMarkerBusLoggingAdapter;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.Ack;
import org.apache.pekko.remote.AddressUrlEncoder$;
import org.apache.pekko.remote.AssociatedEvent$;
import org.apache.pekko.remote.DefaultMessageDispatcher;
import org.apache.pekko.remote.DisassociatedEvent$;
import org.apache.pekko.remote.EndpointActor;
import org.apache.pekko.remote.EndpointAssociationException;
import org.apache.pekko.remote.EndpointDisassociatedException;
import org.apache.pekko.remote.EndpointException;
import org.apache.pekko.remote.EndpointManager;
import org.apache.pekko.remote.EndpointManager$Send$;
import org.apache.pekko.remote.EndpointReader$;
import org.apache.pekko.remote.EndpointWriter$;
import org.apache.pekko.remote.EndpointWriter$AckIdleCheckTimer$;
import org.apache.pekko.remote.EndpointWriter$BackoffTimer$;
import org.apache.pekko.remote.EndpointWriter$FlushAndStop$;
import org.apache.pekko.remote.EndpointWriter$FlushAndStopTimeout$;
import org.apache.pekko.remote.EndpointWriter$Handle$;
import org.apache.pekko.remote.EndpointWriter$OutboundAck$;
import org.apache.pekko.remote.EndpointWriter$StopReading$;
import org.apache.pekko.remote.EndpointWriter$StoppedReading$;
import org.apache.pekko.remote.EndpointWriter$TakeOver$;
import org.apache.pekko.remote.EndpointWriter$TookOver$;
import org.apache.pekko.remote.InvalidAssociation;
import org.apache.pekko.remote.InvalidAssociation$;
import org.apache.pekko.remote.MessageSerializer;
import org.apache.pekko.remote.MessageSerializer$;
import org.apache.pekko.remote.OversizedPayloadException;
import org.apache.pekko.remote.PriorityMessage;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.ReliableDeliverySupervisor$GotUid$;
import org.apache.pekko.remote.RemoteActorRef;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.RemoteMetrics;
import org.apache.pekko.remote.RemoteMetricsExtension$;
import org.apache.pekko.remote.RemoteSettings;
import org.apache.pekko.remote.SeqNo;
import org.apache.pekko.remote.ShutDownAssociation;
import org.apache.pekko.remote.WireFormats;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.AssociationHandle$ActorHandleEventListener$;
import org.apache.pekko.remote.transport.AssociationHandle$Shutdown$;
import org.apache.pekko.remote.transport.AssociationHandle$Unknown$;
import org.apache.pekko.remote.transport.PekkoPduCodec;
import org.apache.pekko.remote.transport.PekkoProtocolHandle;
import org.apache.pekko.remote.transport.PekkoProtocolTransport;
import org.apache.pekko.remote.transport.Transport;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public class EndpointWriter
extends EndpointActor
implements Actor {
    private final Option<Object> refuseUid;
    private final ConcurrentHashMap receiveBuffers;
    private final Option reliableDeliverySupervisor;
    private final ExtendedActorSystem extendedSystem;
    private final RemoteMetrics remoteMetrics;
    private final MessageDispatcher backoffDispatcher;
    private Option reader;
    private Option handle;
    private final Iterator readerId;
    private Deadline ackDeadline;
    private Option lastAck;
    private final SupervisorStrategy supervisorStrategy;
    private final RemoteActorRefProvider provider;
    private final DefaultMessageDispatcher msgDispatch;
    private final boolean inbound;
    private AssociationHandle.DisassociateInfo stopReason;
    private final LinkedList buffer;
    private final LinkedList prioBuffer;
    private long largeBufferLogTimestamp;
    private final Cancellable ackIdleTimer;
    private final PartialFunction buffering;
    private int writeCount;
    private int maxWriteCount;
    private long adaptiveBackoffNanos;
    private boolean fullBackoff;
    private int fullBackoffCount;
    private int smallBackoffCount;
    private int noBackoffCount;
    private final PartialFunction writing;

    public static Props props(Option<PekkoProtocolHandle> option, Address address, Address address2, Option<Object> option2, PekkoProtocolTransport pekkoProtocolTransport, RemoteSettings remoteSettings, PekkoPduCodec pekkoPduCodec, ConcurrentHashMap<EndpointManager.Link, EndpointManager.ResendState> concurrentHashMap, Option<ActorRef> option3) {
        return EndpointWriter$.MODULE$.props(option, address, address2, option2, pekkoProtocolTransport, remoteSettings, pekkoPduCodec, concurrentHashMap, option3);
    }

    public EndpointWriter(Option<PekkoProtocolHandle> handleOrActive, Address localAddress, Address remoteAddress, Option<Object> refuseUid, PekkoProtocolTransport transport, RemoteSettings settings, PekkoPduCodec codec, ConcurrentHashMap<EndpointManager.Link, EndpointManager.ResendState> receiveBuffers, Option<ActorRef> reliableDeliverySupervisor) {
        this.refuseUid = refuseUid;
        this.receiveBuffers = receiveBuffers;
        this.reliableDeliverySupervisor = reliableDeliverySupervisor;
        super(localAddress, remoteAddress, transport, settings, codec);
        DiagnosticMarkerBusLoggingAdapter markLog = Logging$.MODULE$.withMarker((Actor)this);
        this.extendedSystem = (ExtendedActorSystem)this.context().system();
        this.remoteMetrics = (RemoteMetrics)RemoteMetricsExtension$.MODULE$.apply((ActorSystem)this.extendedSystem());
        this.backoffDispatcher = this.context().system().dispatchers().lookup("pekko.remote.classic.backoff-remote-dispatcher");
        this.reader = None$.MODULE$;
        this.handle = handleOrActive;
        this.readerId = scala.package$.MODULE$.Iterator().from(0);
        this.ackDeadline = this.newAckDeadline();
        this.lastAck = None$.MODULE$;
        this.supervisorStrategy = OneForOneStrategy$.MODULE$.apply(OneForOneStrategy$.MODULE$.$lessinit$greater$default$1(), OneForOneStrategy$.MODULE$.$lessinit$greater$default$2(), false, (PartialFunction)new Serializable(this){
            private final /* synthetic */ EndpointWriter $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof ShutDownAssociation) {
                    ShutDownAssociation e = (ShutDownAssociation)((Object)throwable);
                    return true;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = (Throwable)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof ShutDownAssociation) {
                    ShutDownAssociation e = (ShutDownAssociation)((Object)throwable);
                    throw this.$outer.org$apache$pekko$remote$EndpointWriter$$publishAndThrow((Throwable)((Object)e), Logging$.MODULE$.InfoLevel());
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = (Throwable)option.get();
                    throw this.$outer.org$apache$pekko$remote$EndpointWriter$$publishAndThrow(e, Logging$.MODULE$.ErrorLevel());
                }
                return function1.apply((Object)x);
            }
        });
        this.provider = ((RARP)RARP$.MODULE$.apply((ActorSystem)this.extendedSystem())).provider();
        this.msgDispatch = new DefaultMessageDispatcher(this.extendedSystem(), this.provider(), (MarkerLoggingAdapter)markLog);
        this.inbound = this.handle().isDefined();
        this.stopReason = AssociationHandle$Unknown$.MODULE$;
        this.buffer = new LinkedList();
        this.prioBuffer = new LinkedList();
        this.largeBufferLogTimestamp = System.nanoTime();
        FiniteDuration interval = settings.SysMsgAckTimeout().$div(2L);
        this.ackIdleTimer = this.context().system().scheduler().scheduleWithFixedDelay(interval, interval, this.self(), (Object)EndpointWriter$AckIdleCheckTimer$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.buffering = new Serializable(this){
            private final /* synthetic */ EndpointWriter $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof EndpointManager.Send) {
                    EndpointManager.Send s = (EndpointManager.Send)object;
                    return true;
                }
                if (EndpointWriter$BackoffTimer$.MODULE$.equals(object)) {
                    return true;
                }
                if (EndpointWriter$FlushAndStop$.MODULE$.equals(object)) {
                    return true;
                }
                return EndpointWriter$FlushAndStopTimeout$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof EndpointManager.Send) {
                    EndpointManager.Send s = (EndpointManager.Send)object;
                    this.$outer.enqueueInBuffer(s);
                    return BoxedUnit.UNIT;
                }
                if (EndpointWriter$BackoffTimer$.MODULE$.equals(object)) {
                    this.$outer.sendBufferedMessages();
                    return BoxedUnit.UNIT;
                }
                if (EndpointWriter$FlushAndStop$.MODULE$.equals(object)) {
                    this.$outer.buffer().offer(EndpointWriter$FlushAndStop$.MODULE$);
                    this.$outer.context().system().scheduler().scheduleOnce(this.$outer.org$apache$pekko$remote$EndpointWriter$$settings$accessor().FlushWait(), this.$outer.self(), (Object)EndpointWriter$FlushAndStopTimeout$.MODULE$, (ExecutionContext)this.$outer.context().dispatcher(), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (EndpointWriter$FlushAndStopTimeout$.MODULE$.equals(object)) {
                    this.$outer.flushAndStop();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
        this.writeCount = 0;
        this.maxWriteCount = EndpointWriter$.org$apache$pekko$remote$EndpointWriter$$$MaxWriteCount;
        this.adaptiveBackoffNanos = 1000000L;
        this.fullBackoff = false;
        this.fullBackoffCount = 1;
        this.smallBackoffCount = 0;
        this.noBackoffCount = 0;
        this.writing = new Serializable(this){
            private final /* synthetic */ EndpointWriter $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof EndpointManager.Send) {
                    EndpointManager.Send s = (EndpointManager.Send)object;
                    return true;
                }
                if (EndpointWriter$FlushAndStop$.MODULE$.equals(object)) {
                    return true;
                }
                return EndpointWriter$AckIdleCheckTimer$.MODULE$.equals(object) && this.$outer.ackDeadline().isOverdue();
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof EndpointManager.Send) {
                    EndpointManager.Send s = (EndpointManager.Send)object;
                    if (!this.$outer.writeSend(s)) {
                        this.$outer.enqueueInBuffer(s);
                        this.$outer.scheduleBackoffTimer();
                        this.$outer.context().become(this.$outer.buffering());
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (EndpointWriter$FlushAndStop$.MODULE$.equals(object)) {
                    this.$outer.flushAndStop();
                    return BoxedUnit.UNIT;
                }
                if (EndpointWriter$AckIdleCheckTimer$.MODULE$.equals(object) && this.$outer.ackDeadline().isOverdue()) {
                    this.$outer.org$apache$pekko$remote$EndpointWriter$$trySendPureAck();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public Address org$apache$pekko$remote$EndpointWriter$$localAddress$accessor() {
        return super.localAddress();
    }

    public Address org$apache$pekko$remote$EndpointWriter$$remoteAddress$accessor() {
        return super.remoteAddress();
    }

    private PekkoProtocolTransport transport$accessor() {
        return (PekkoProtocolTransport)super.transport();
    }

    public RemoteSettings org$apache$pekko$remote$EndpointWriter$$settings$accessor() {
        return super.settings();
    }

    private PekkoPduCodec codec$accessor() {
        return super.codec();
    }

    public ConcurrentHashMap<EndpointManager.Link, EndpointManager.ResendState> receiveBuffers() {
        return this.receiveBuffers;
    }

    public Option<ActorRef> reliableDeliverySupervisor() {
        return this.reliableDeliverySupervisor;
    }

    public ExtendedActorSystem extendedSystem() {
        return this.extendedSystem;
    }

    public RemoteMetrics remoteMetrics() {
        return this.remoteMetrics;
    }

    public MessageDispatcher backoffDispatcher() {
        return this.backoffDispatcher;
    }

    public Option<ActorRef> reader() {
        return this.reader;
    }

    public void reader_$eq(Option<ActorRef> x$1) {
        this.reader = x$1;
    }

    public Option<PekkoProtocolHandle> handle() {
        return this.handle;
    }

    public void handle_$eq(Option<PekkoProtocolHandle> x$1) {
        this.handle = x$1;
    }

    public Iterator<Object> readerId() {
        return this.readerId;
    }

    public Deadline newAckDeadline() {
        return Deadline$.MODULE$.now().$plus(this.org$apache$pekko$remote$EndpointWriter$$settings$accessor().SysMsgAckTimeout());
    }

    public Deadline ackDeadline() {
        return this.ackDeadline;
    }

    public void ackDeadline_$eq(Deadline x$1) {
        this.ackDeadline = x$1;
    }

    public Option<Ack> lastAck() {
        return this.lastAck;
    }

    public void lastAck_$eq(Option<Ack> x$1) {
        this.lastAck = x$1;
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    public RemoteActorRefProvider provider() {
        return this.provider;
    }

    public DefaultMessageDispatcher msgDispatch() {
        return this.msgDispatch;
    }

    @Override
    public boolean inbound() {
        return this.inbound;
    }

    public AssociationHandle.DisassociateInfo stopReason() {
        return this.stopReason;
    }

    public void stopReason_$eq(AssociationHandle.DisassociateInfo x$1) {
        this.stopReason = x$1;
    }

    public LinkedList<Object> buffer() {
        return this.buffer;
    }

    public LinkedList<EndpointManager.Send> prioBuffer() {
        return this.prioBuffer;
    }

    public long largeBufferLogTimestamp() {
        return this.largeBufferLogTimestamp;
    }

    public void largeBufferLogTimestamp_$eq(long x$1) {
        this.largeBufferLogTimestamp = x$1;
    }

    public Nothing$ org$apache$pekko$remote$EndpointWriter$$publishAndThrow(Throwable reason, int logLevel) {
        Throwable throwable = reason;
        if (throwable instanceof EndpointDisassociatedException) {
            this.publishDisassociated();
        } else {
            this.publishError(reason, logLevel);
        }
        throw reason;
    }

    public Cancellable ackIdleTimer() {
        return this.ackIdleTimer;
    }

    @Override
    public void preStart() {
        Option<PekkoProtocolHandle> option = this.handle();
        if (option instanceof Some) {
            PekkoProtocolHandle h = (PekkoProtocolHandle)((Some)option).value();
            this.reader_$eq((Option<ActorRef>)this.org$apache$pekko$remote$EndpointWriter$$startReadEndpoint(h));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.apache.pekko.pattern.package$.MODULE$.pipe(this.transport$accessor().associate(this.org$apache$pekko$remote$EndpointWriter$$remoteAddress$accessor(), this.refuseUid).map((Function1 & Serializable)_$10 -> EndpointWriter$Handle$.MODULE$.apply((PekkoProtocolHandle)_$10), (ExecutionContext)this.context().dispatcher()), (ExecutionContext)this.context().dispatcher()).pipeTo(this.self(), this.self());
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void postRestart(Throwable reason) {
        throw new IllegalStateException("EndpointWriter must not be restarted");
    }

    @Override
    public void postStop() {
        this.ackIdleTimer().cancel();
        while (!this.prioBuffer().isEmpty()) {
            this.extendedSystem().deadLetters().$bang((Object)this.prioBuffer().poll(), this.self());
        }
        while (!this.buffer().isEmpty()) {
            this.extendedSystem().deadLetters().$bang(this.buffer().poll(), this.self());
        }
        this.handle().foreach((Function1)(JProcedure1 & Serializable)_$11 -> _$11.disassociate(this.stopReason()));
        this.eventPublisher().notifyListeners(DisassociatedEvent$.MODULE$.apply(this.org$apache$pekko$remote$EndpointWriter$$localAddress$accessor(), this.org$apache$pekko$remote$EndpointWriter$$remoteAddress$accessor(), this.inbound()));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        if (this.handle().isEmpty()) {
            return this.initializing();
        }
        return this.writing();
    }

    public PartialFunction<Object, BoxedUnit> initializing() {
        return new Serializable(this){
            private final /* synthetic */ EndpointWriter $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof EndpointManager.Send) {
                    EndpointManager.Send s = (EndpointManager.Send)object;
                    return true;
                }
                if (object instanceof Status.Failure) {
                    Status.Failure failure = Status.Failure$.MODULE$.unapply((Status.Failure)object);
                    Throwable throwable = failure._1();
                    if (throwable instanceof Transport.InvalidAssociationException) {
                        Transport.InvalidAssociationException e = (Transport.InvalidAssociationException)((Object)throwable);
                        return true;
                    }
                    Throwable e = throwable;
                    return true;
                }
                if (object instanceof Handle) {
                    PekkoProtocolHandle pekkoProtocolHandle;
                    Handle handle = EndpointWriter$Handle$.MODULE$.unapply((Handle)object);
                    PekkoProtocolHandle inboundHandle = pekkoProtocolHandle = handle._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof EndpointManager.Send) {
                    EndpointManager.Send s = (EndpointManager.Send)object;
                    this.$outer.enqueueInBuffer(s);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Status.Failure) {
                    Status.Failure failure = Status.Failure$.MODULE$.unapply((Status.Failure)object);
                    Throwable throwable = failure._1();
                    if (throwable instanceof Transport.InvalidAssociationException) {
                        Transport.InvalidAssociationException e = (Transport.InvalidAssociationException)((Object)throwable);
                        throw this.$outer.org$apache$pekko$remote$EndpointWriter$$publishAndThrow((Throwable)((Object)new InvalidAssociation(this.$outer.org$apache$pekko$remote$EndpointWriter$$localAddress$accessor(), this.$outer.org$apache$pekko$remote$EndpointWriter$$remoteAddress$accessor(), (Throwable)((Object)e), InvalidAssociation$.MODULE$.$lessinit$greater$default$4())), Logging$.MODULE$.WarningLevel());
                    }
                    Throwable e = throwable;
                    throw this.$outer.org$apache$pekko$remote$EndpointWriter$$publishAndThrow((Throwable)((Object)new EndpointAssociationException(new StringBuilder(26).append("Association failed with [").append(this.$outer.org$apache$pekko$remote$EndpointWriter$$remoteAddress$accessor()).append("]").toString(), e)), Logging$.MODULE$.DebugLevel());
                }
                if (object instanceof Handle) {
                    PekkoProtocolHandle pekkoProtocolHandle;
                    Handle handle = EndpointWriter$Handle$.MODULE$.unapply((Handle)object);
                    PekkoProtocolHandle inboundHandle = pekkoProtocolHandle = handle._1();
                    this.$outer.context().parent().$bang((Object)ReliableDeliverySupervisor$GotUid$.MODULE$.apply(inboundHandle.handshakeInfo().uid(), this.$outer.org$apache$pekko$remote$EndpointWriter$$remoteAddress$accessor()), this.$outer.self());
                    this.$outer.handle_$eq((Option<PekkoProtocolHandle>)Some$.MODULE$.apply((Object)inboundHandle));
                    this.$outer.reader_$eq((Option<ActorRef>)this.$outer.org$apache$pekko$remote$EndpointWriter$$startReadEndpoint(inboundHandle));
                    this.$outer.eventPublisher().notifyListeners(AssociatedEvent$.MODULE$.apply(this.$outer.org$apache$pekko$remote$EndpointWriter$$localAddress$accessor(), this.$outer.org$apache$pekko$remote$EndpointWriter$$remoteAddress$accessor(), this.$outer.inbound()));
                    this.$outer.becomeWritingOrSendBufferedMessages();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public void enqueueInBuffer(Object msg) {
        Object object = msg;
        if (object instanceof EndpointManager.Send) {
            EndpointManager.Send send = (EndpointManager.Send)object;
            EndpointManager.Send send2 = EndpointManager$Send$.MODULE$.unapply(send);
            Object object2 = send2._1();
            ActorRef actorRef = send2._2();
            RemoteActorRef remoteActorRef = send2._3();
            Option<SeqNo> option = send2._4();
            if (object2 instanceof PriorityMessage) {
                EndpointManager.Send s = send;
                this.prioBuffer().offer(s);
                return;
            }
            if (object2 instanceof ActorSelectionMessage) {
                ActorSelectionMessage actorSelectionMessage = ActorSelectionMessage$.MODULE$.unapply((ActorSelectionMessage)object2);
                Object object3 = actorSelectionMessage._1();
                Iterable iterable = actorSelectionMessage._2();
                boolean bl = actorSelectionMessage._3();
                if (object3 instanceof PriorityMessage) {
                    EndpointManager.Send s = send;
                    this.prioBuffer().offer(s);
                    return;
                }
            }
        }
        this.buffer().offer(msg);
    }

    public PartialFunction<Object, BoxedUnit> buffering() {
        return this.buffering;
    }

    public void becomeWritingOrSendBufferedMessages() {
        if (this.buffer().isEmpty()) {
            this.context().become(this.writing());
            return;
        }
        this.context().become(this.buffering());
        this.sendBufferedMessages();
    }

    public int writeCount() {
        return this.writeCount;
    }

    public void writeCount_$eq(int x$1) {
        this.writeCount = x$1;
    }

    public int maxWriteCount() {
        return this.maxWriteCount;
    }

    public void maxWriteCount_$eq(int x$1) {
        this.maxWriteCount = x$1;
    }

    public long adaptiveBackoffNanos() {
        return this.adaptiveBackoffNanos;
    }

    public void adaptiveBackoffNanos_$eq(long x$1) {
        this.adaptiveBackoffNanos = x$1;
    }

    public boolean fullBackoff() {
        return this.fullBackoff;
    }

    public void fullBackoff_$eq(boolean x$1) {
        this.fullBackoff = x$1;
    }

    public int fullBackoffCount() {
        return this.fullBackoffCount;
    }

    public void fullBackoffCount_$eq(int x$1) {
        this.fullBackoffCount = x$1;
    }

    public int smallBackoffCount() {
        return this.smallBackoffCount;
    }

    public void smallBackoffCount_$eq(int x$1) {
        this.smallBackoffCount = x$1;
    }

    public int noBackoffCount() {
        return this.noBackoffCount;
    }

    public void noBackoffCount_$eq(int x$1) {
        this.noBackoffCount = x$1;
    }

    public void adjustAdaptiveBackup() {
        this.maxWriteCount_$eq(package$.MODULE$.max(this.writeCount(), this.maxWriteCount()));
        if (this.writeCount() <= EndpointWriter$.org$apache$pekko$remote$EndpointWriter$$$SendBufferBatchSize) {
            this.fullBackoff_$eq(true);
            this.adaptiveBackoffNanos_$eq(package$.MODULE$.min((long)((double)this.adaptiveBackoffNanos() * 1.2), EndpointWriter$.org$apache$pekko$remote$EndpointWriter$$$MaxAdaptiveBackoffNanos));
        } else if ((double)this.writeCount() >= (double)this.maxWriteCount() * 0.6) {
            this.adaptiveBackoffNanos_$eq(package$.MODULE$.max((long)((double)this.adaptiveBackoffNanos() * 0.9), EndpointWriter$.org$apache$pekko$remote$EndpointWriter$$$MinAdaptiveBackoffNanos));
        } else if ((double)this.writeCount() <= (double)this.maxWriteCount() * 0.2) {
            this.adaptiveBackoffNanos_$eq(package$.MODULE$.min((long)((double)this.adaptiveBackoffNanos() * 1.1), EndpointWriter$.org$apache$pekko$remote$EndpointWriter$$$MaxAdaptiveBackoffNanos));
        }
        this.writeCount_$eq(0);
    }

    public void sendBufferedMessages() {
        long now;
        boolean ok;
        int size = this.buffer().size();
        boolean bl = ok = this.writePrioLoop$1() && this.writeLoop$1(EndpointWriter$.org$apache$pekko$remote$EndpointWriter$$$SendBufferBatchSize);
        if (this.buffer().isEmpty() && this.prioBuffer().isEmpty()) {
            if (this.log().isDebugEnabled()) {
                this.log().debug(new StringBuilder(55).append("Drained buffer with maxWriteCount: ").append(this.maxWriteCount()).append(", fullBackoffCount: ").append(this.fullBackoffCount()).append(new StringBuilder(40).append(", smallBackoffCount: ").append(this.smallBackoffCount()).append(", noBackoffCount: ").append(this.noBackoffCount()).append(" ").toString()).append(new StringBuilder(19).append(", adaptiveBackoff: ").append(this.adaptiveBackoffNanos() / 1000L).toString()).toString());
            }
            this.fullBackoffCount_$eq(1);
            this.smallBackoffCount_$eq(0);
            this.noBackoffCount_$eq(0);
            this.writeCount_$eq(0);
            this.maxWriteCount_$eq(EndpointWriter$.org$apache$pekko$remote$EndpointWriter$$$MaxWriteCount);
            this.context().become(this.writing());
            return;
        }
        if (ok) {
            this.noBackoffCount_$eq(this.noBackoffCount() + 1);
            this.self().$bang((Object)EndpointWriter$BackoffTimer$.MODULE$, this.self());
            return;
        }
        if (size > this.org$apache$pekko$remote$EndpointWriter$$settings$accessor().LogBufferSizeExceeding() && (now = System.nanoTime()) - this.largeBufferLogTimestamp() >= EndpointWriter$.org$apache$pekko$remote$EndpointWriter$$$LogBufferSizeInterval) {
            this.log().warning("[{}] buffered messages in EndpointWriter for [{}]. You should probably implement flow control to avoid flooding the remote connection.", (Object)BoxesRunTime.boxToInteger((int)size), (Object)this.org$apache$pekko$remote$EndpointWriter$$remoteAddress$accessor());
            this.largeBufferLogTimestamp_$eq(now);
        }
        this.adjustAdaptiveBackup();
        this.scheduleBackoffTimer();
    }

    public void scheduleBackoffTimer() {
        if (this.fullBackoff()) {
            this.fullBackoffCount_$eq(this.fullBackoffCount() + 1);
            this.fullBackoff_$eq(false);
            this.context().system().scheduler().scheduleOnce(this.org$apache$pekko$remote$EndpointWriter$$settings$accessor().BackoffPeriod(), this.self(), (Object)EndpointWriter$BackoffTimer$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
            return;
        }
        this.smallBackoffCount_$eq(this.smallBackoffCount() + 1);
        ActorRef s = this.self();
        long backoffDeadlinelineNanoTime = System.nanoTime() + this.adaptiveBackoffNanos();
        Future$.MODULE$.apply((Function0 & Serializable)() -> {
            EndpointWriter.scheduleBackoffTimer$$anonfun$1(s, backoffDeadlinelineNanoTime);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.backoffDispatcher());
    }

    public PartialFunction<Object, BoxedUnit> writing() {
        return this.writing;
    }

    public boolean writeSend(EndpointManager.Send s) {
        boolean bl;
        block15: {
            try {
                Option<PekkoProtocolHandle> option = this.handle();
                if (option instanceof Some) {
                    PekkoProtocolHandle h = (PekkoProtocolHandle)((Some)option).value();
                    if (this.provider().remoteSettings().LogSend() && this.log().isDebugEnabled()) {
                        this.log().debug("sending message {}", (Object)this.msgLog$1(s));
                    }
                    ByteString pdu = this.codec$accessor().constructMessage(s.recipient().localAddressToUse(), (ActorRef)s.recipient(), this.serializeMessage(s.message()), s.senderOption(), s.seqOpt(), this.lastAck());
                    int pduSize = pdu.size();
                    this.remoteMetrics().logPayloadBytes(s.message(), pduSize);
                    if (pduSize > this.transport$accessor().maximumPayloadBytes()) {
                        Dropped dropped;
                        String reasonText = new StringBuilder(99).append("Discarding oversized payload sent to ").append(s.recipient()).append(": max allowed size ").append(this.transport$accessor().maximumPayloadBytes()).append(" bytes, actual size of encoded ").append(s.message().getClass()).append(" was ").append(pdu.size()).append(" bytes.").toString();
                        this.log().error((Throwable)((Object)new OversizedPayloadException(reasonText)), "Transient association error (association remains live)");
                        EventStream eventStream = this.extendedSystem().eventStream();
                        ActorRef actorRef = s.senderOption();
                        ActorRef actorRef2 = (ActorRef)OptionVal.Some$.MODULE$.unapply((Object)actorRef);
                        if (!OptionVal$.MODULE$.isEmpty$extension((Object)actorRef2)) {
                            ActorRef actorRef3;
                            ActorRef msgSender = actorRef3 = (ActorRef)OptionVal$.MODULE$.get$extension((Object)actorRef2);
                            dropped = Dropped$.MODULE$.apply(s.message(), reasonText, msgSender, (ActorRef)s.recipient());
                        } else {
                            dropped = Dropped$.MODULE$.apply(s.message(), reasonText, (ActorRef)s.recipient());
                        }
                        eventStream.publish((Object)dropped);
                        bl = true;
                    } else {
                        boolean ok = h.write(pdu);
                        if (ok) {
                            this.ackDeadline_$eq(this.newAckDeadline());
                            this.lastAck_$eq((Option<Ack>)None$.MODULE$);
                        }
                        bl = ok;
                    }
                    break block15;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new EndpointException("Internal error: Endpoint is in state Writing, but no association handle is present.");
                }
                throw new MatchError(option);
            }
            catch (NotSerializableException e) {
                this.log().error((Throwable)e, "Serializer not defined for message type [{}]. Transient association error (association remains live)", s.message().getClass());
                bl = true;
            }
            catch (IllegalArgumentException e) {
                this.log().error((Throwable)e, "Serializer not defined for message type [{}]. Transient association error (association remains live)", s.message().getClass());
                bl = true;
            }
            catch (MessageSerializer.SerializationException e) {
                this.log().error((Throwable)e, "{} Transient association error (association remains live)", (Object)e.getMessage());
                bl = true;
            }
            catch (EndpointException e) {
                throw this.org$apache$pekko$remote$EndpointWriter$$publishAndThrow((Throwable)((Object)e), Logging$.MODULE$.ErrorLevel());
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Option option;
                Throwable throwable3 = throwable;
                if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                    throw throwable;
                }
                Throwable e = throwable2 = (Throwable)option.get();
                throw this.org$apache$pekko$remote$EndpointWriter$$publishAndThrow((Throwable)((Object)new EndpointException("Failed to write message to the transport", e)), Logging$.MODULE$.ErrorLevel());
            }
        }
        return bl;
    }

    public PartialFunction<Object, BoxedUnit> handoff() {
        return new Serializable(this){
            private final /* synthetic */ EndpointWriter $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    return true;
                }
                if (object instanceof EndpointManager.Send) {
                    EndpointManager.Send s = (EndpointManager.Send)object;
                    return true;
                }
                if (object instanceof OutboundAck) {
                    OutboundAck outboundAck = EndpointWriter$OutboundAck$.MODULE$.unapply((OutboundAck)object);
                    Ack ack = outboundAck._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    this.$outer.reader_$eq((Option<ActorRef>)this.$outer.org$apache$pekko$remote$EndpointWriter$$startReadEndpoint((PekkoProtocolHandle)this.$outer.handle().get()));
                    this.$outer.becomeWritingOrSendBufferedMessages();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof EndpointManager.Send) {
                    EndpointManager.Send s = (EndpointManager.Send)object;
                    this.$outer.enqueueInBuffer(s);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof OutboundAck) {
                    OutboundAck outboundAck = EndpointWriter$OutboundAck$.MODULE$.unapply((OutboundAck)object);
                    Ack ack = outboundAck._1();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    @Override
    public void unhandled(Object message) {
        Object object = message;
        if (object instanceof Terminated) {
            ActorRef actorRef;
            ActorRef r;
            Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
            ActorRef actorRef2 = r = (actorRef = terminated._1());
            Object object2 = this.reader().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (!(actorRef2 != null ? !actorRef2.equals(object2) : object2 != null)) {
                throw this.org$apache$pekko$remote$EndpointWriter$$publishAndThrow((Throwable)((Object)new EndpointDisassociatedException("Disassociated")), Logging$.MODULE$.DebugLevel());
            }
        }
        if (object instanceof StopReading) {
            ActorRef actorRef;
            StopReading stopReading = (StopReading)object;
            StopReading stopReading2 = EndpointWriter$StopReading$.MODULE$.unapply(stopReading);
            ActorRef actorRef3 = stopReading2._1();
            ActorRef replyTo = actorRef = stopReading2._2();
            StopReading s = stopReading;
            Option<ActorRef> option = this.reader();
            if (option instanceof Some) {
                ActorRef r = (ActorRef)((Some)option).value();
                r.tell((Object)s, replyTo);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.enqueueInBuffer(s);
                return;
            }
            throw new MatchError(option);
        }
        if (object instanceof TakeOver) {
            TakeOver takeOver = EndpointWriter$TakeOver$.MODULE$.unapply((TakeOver)object);
            PekkoProtocolHandle pekkoProtocolHandle = takeOver._1();
            ActorRef actorRef = takeOver._2();
            PekkoProtocolHandle newHandle = pekkoProtocolHandle;
            ActorRef replyTo = actorRef;
            this.handle().foreach((Function1)(JProcedure1 & Serializable)_$13 -> _$13.disassociate("the association was replaced by a new one", this.log()));
            this.handle_$eq((Option<PekkoProtocolHandle>)Some$.MODULE$.apply((Object)newHandle));
            replyTo.$bang((Object)EndpointWriter$TookOver$.MODULE$.apply(this.self(), newHandle), this.self());
            this.context().become(this.handoff());
            return;
        }
        if (EndpointWriter$FlushAndStop$.MODULE$.equals(object)) {
            this.stopReason_$eq(AssociationHandle$Shutdown$.MODULE$);
            this.context().stop(this.self());
            return;
        }
        if (object instanceof OutboundAck) {
            Ack ack;
            OutboundAck outboundAck = EndpointWriter$OutboundAck$.MODULE$.unapply((OutboundAck)object);
            Ack ack2 = ack = outboundAck._1();
            this.lastAck_$eq((Option<Ack>)Some$.MODULE$.apply((Object)ack2));
            if (this.ackDeadline().isOverdue()) {
                this.org$apache$pekko$remote$EndpointWriter$$trySendPureAck();
                return;
            }
            return;
        }
        if (EndpointWriter$AckIdleCheckTimer$.MODULE$.equals(object)) {
            return;
        }
        if (EndpointWriter$FlushAndStopTimeout$.MODULE$.equals(object)) {
            return;
        }
        if (EndpointWriter$BackoffTimer$.MODULE$.equals(object)) {
            return;
        }
        Object other = object;
        Actor.unhandled$((Actor)this, (Object)other);
    }

    public void flushAndStop() {
        this.org$apache$pekko$remote$EndpointWriter$$trySendPureAck();
        this.stopReason_$eq(AssociationHandle$Shutdown$.MODULE$);
        this.context().stop(this.self());
    }

    public void org$apache$pekko$remote$EndpointWriter$$trySendPureAck() {
        this.handle().foreach((Function1)(JProcedure1 & Serializable)h -> this.lastAck().foreach((Function1)(JProcedure1 & Serializable)ack -> {
            if (h.write(this.codec$accessor().constructPureAck((Ack)ack))) {
                this.ackDeadline_$eq(this.newAckDeadline());
                this.lastAck_$eq((Option<Ack>)None$.MODULE$);
                return;
            }
        }));
    }

    public Some<ActorRef> org$apache$pekko$remote$EndpointWriter$$startReadEndpoint(PekkoProtocolHandle handle) {
        ActorRef newReader = this.context().watch(this.context().actorOf(((RARP)RARP$.MODULE$.apply(this.context().system())).configureDispatcher(EndpointReader$.MODULE$.props(this.org$apache$pekko$remote$EndpointWriter$$localAddress$accessor(), this.org$apache$pekko$remote$EndpointWriter$$remoteAddress$accessor(), this.transport$accessor(), this.org$apache$pekko$remote$EndpointWriter$$settings$accessor(), this.codec$accessor(), this.msgDispatch(), this.inbound(), handle.handshakeInfo().uid(), this.reliableDeliverySupervisor(), this.receiveBuffers())).withDeploy(Deploy$.MODULE$.local()), new StringBuilder(16).append("endpointReader-").append(AddressUrlEncoder$.MODULE$.apply(this.org$apache$pekko$remote$EndpointWriter$$remoteAddress$accessor())).append("-").append(this.readerId().next()).toString()));
        handle.readHandlerPromise().success((Object)AssociationHandle$ActorHandleEventListener$.MODULE$.apply(newReader));
        return Some$.MODULE$.apply((Object)newReader);
    }

    private WireFormats.SerializedMessage serializeMessage(Object msg) {
        Option<PekkoProtocolHandle> option = this.handle();
        if (option instanceof Some) {
            PekkoProtocolHandle h = (PekkoProtocolHandle)((Some)option).value();
            return (WireFormats.SerializedMessage)Serialization$.MODULE$.currentTransportInformation().withValue((Object)Serialization.Information$.MODULE$.apply(h.localAddress(), (ActorSystem)this.extendedSystem()), () -> this.serializeMessage$$anonfun$1(msg));
        }
        if (None$.MODULE$.equals(option)) {
            throw new EndpointException("Internal error: No handle was present during serialization of outbound message.");
        }
        throw new MatchError(option);
    }

    private final boolean delegate$1(Object msg) {
        Object object = msg;
        if (object instanceof EndpointManager.Send) {
            EndpointManager.Send s = (EndpointManager.Send)object;
            return this.writeSend(s);
        }
        if (EndpointWriter$FlushAndStop$.MODULE$.equals(object)) {
            this.flushAndStop();
            return false;
        }
        if (object instanceof StopReading) {
            ActorRef actorRef;
            StopReading stopReading = (StopReading)object;
            StopReading stopReading2 = EndpointWriter$StopReading$.MODULE$.unapply(stopReading);
            ActorRef actorRef2 = stopReading2._1();
            ActorRef replyTo = actorRef = stopReading2._2();
            StopReading s = stopReading;
            this.reader().foreach((Function1)(JProcedure1 & Serializable)_$12 -> _$12.tell((Object)s, replyTo));
            return true;
        }
        Object unexpected = object;
        throw new IllegalArgumentException(new StringBuilder(25).append("Unexpected message type: ").append(unexpected.getClass()).toString());
    }

    private final boolean writeLoop$1(int count) {
        while (count > 0 && !this.buffer().isEmpty()) {
            if (this.delegate$1(this.buffer().peek())) {
                this.buffer().removeFirst();
                this.writeCount_$eq(this.writeCount() + 1);
                --count;
                continue;
            }
            return false;
        }
        return true;
    }

    private final boolean writePrioLoop$1() {
        while (true) {
            if (this.prioBuffer().isEmpty()) {
                return true;
            }
            if (!this.writeSend(this.prioBuffer().peek())) break;
            this.prioBuffer().removeFirst();
        }
        return false;
    }

    private static final void backoff$1(long backoffDeadlinelineNanoTime$2) {
        long backoffNanos;
        while ((backoffNanos = backoffDeadlinelineNanoTime$2 - System.nanoTime()) > 0L) {
            LockSupport.parkNanos(backoffNanos);
        }
    }

    private static final void scheduleBackoffTimer$$anonfun$1(ActorRef s$2, long backoffDeadlinelineNanoTime$1) {
        EndpointWriter.backoff$1(backoffDeadlinelineNanoTime$1);
        s$2.tell((Object)EndpointWriter$BackoffTimer$.MODULE$, ActorRef$.MODULE$.noSender());
    }

    private final String msgLog$1(EndpointManager.Send s$3) {
        return new StringBuilder(35).append("RemoteMessage: [").append(s$3.message()).append("] to [").append(s$3.recipient()).append("]<+[").append(s$3.recipient().path()).append("] from [").append(OptionVal$.MODULE$.getOrElse$extension((Object)s$3.senderOption(), (Object)this.extendedSystem().deadLetters())).append("]").toString();
    }

    private final WireFormats.SerializedMessage serializeMessage$$anonfun$1(Object msg$1) {
        return MessageSerializer$.MODULE$.serialize(this.extendedSystem(), msg$1);
    }

    public static final class Handle
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final PekkoProtocolHandle handle;

        public static Handle apply(PekkoProtocolHandle pekkoProtocolHandle) {
            return EndpointWriter$Handle$.MODULE$.apply(pekkoProtocolHandle);
        }

        public static Handle fromProduct(Product product) {
            return EndpointWriter$Handle$.MODULE$.fromProduct(product);
        }

        public static Handle unapply(Handle handle) {
            return EndpointWriter$Handle$.MODULE$.unapply(handle);
        }

        public Handle(PekkoProtocolHandle handle) {
            this.handle = handle;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Handle)) return false;
            Handle handle = (Handle)object;
            PekkoProtocolHandle pekkoProtocolHandle = this.handle();
            PekkoProtocolHandle pekkoProtocolHandle2 = handle.handle();
            if (pekkoProtocolHandle != null) {
                if (!pekkoProtocolHandle.equals(pekkoProtocolHandle2)) return false;
                return true;
            }
            if (pekkoProtocolHandle2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Handle;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Handle";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "handle";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public PekkoProtocolHandle handle() {
            return this.handle;
        }

        public Handle copy(PekkoProtocolHandle handle) {
            return new Handle(handle);
        }

        public PekkoProtocolHandle copy$default$1() {
            return this.handle();
        }

        public PekkoProtocolHandle _1() {
            return this.handle();
        }
    }

    public static final class OutboundAck
    implements Product,
    Serializable {
        private final Ack ack;

        public static OutboundAck apply(Ack ack) {
            return EndpointWriter$OutboundAck$.MODULE$.apply(ack);
        }

        public static OutboundAck fromProduct(Product product) {
            return EndpointWriter$OutboundAck$.MODULE$.fromProduct(product);
        }

        public static OutboundAck unapply(OutboundAck outboundAck) {
            return EndpointWriter$OutboundAck$.MODULE$.unapply(outboundAck);
        }

        public OutboundAck(Ack ack) {
            this.ack = ack;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OutboundAck)) return false;
            OutboundAck outboundAck = (OutboundAck)object;
            Ack ack = this.ack();
            Ack ack2 = outboundAck.ack();
            if (ack != null) {
                if (!((Object)ack).equals(ack2)) return false;
                return true;
            }
            if (ack2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OutboundAck;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "OutboundAck";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ack";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Ack ack() {
            return this.ack;
        }

        public OutboundAck copy(Ack ack) {
            return new OutboundAck(ack);
        }

        public Ack copy$default$1() {
            return this.ack();
        }

        public Ack _1() {
            return this.ack();
        }
    }

    public static final class StopReading
    implements Product,
    Serializable {
        private final ActorRef writer;
        private final ActorRef replyTo;

        public static StopReading apply(ActorRef actorRef, ActorRef actorRef2) {
            return EndpointWriter$StopReading$.MODULE$.apply(actorRef, actorRef2);
        }

        public static StopReading fromProduct(Product product) {
            return EndpointWriter$StopReading$.MODULE$.fromProduct(product);
        }

        public static StopReading unapply(StopReading stopReading) {
            return EndpointWriter$StopReading$.MODULE$.unapply(stopReading);
        }

        public StopReading(ActorRef writer, ActorRef replyTo) {
            this.writer = writer;
            this.replyTo = replyTo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StopReading)) return false;
            StopReading stopReading = (StopReading)object;
            ActorRef actorRef = this.writer();
            ActorRef actorRef2 = stopReading.writer();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            ActorRef actorRef3 = this.replyTo();
            ActorRef actorRef4 = stopReading.replyTo();
            if (actorRef3 == null) {
                if (actorRef4 == null) return true;
                return false;
            } else {
                if (!actorRef3.equals(actorRef4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StopReading;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StopReading";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "writer";
            }
            if (1 == n2) {
                return "replyTo";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef writer() {
            return this.writer;
        }

        public ActorRef replyTo() {
            return this.replyTo;
        }

        public StopReading copy(ActorRef writer, ActorRef replyTo) {
            return new StopReading(writer, replyTo);
        }

        public ActorRef copy$default$1() {
            return this.writer();
        }

        public ActorRef copy$default$2() {
            return this.replyTo();
        }

        public ActorRef _1() {
            return this.writer();
        }

        public ActorRef _2() {
            return this.replyTo();
        }
    }

    public static final class StoppedReading
    implements Product,
    Serializable {
        private final ActorRef writer;

        public static StoppedReading apply(ActorRef actorRef) {
            return EndpointWriter$StoppedReading$.MODULE$.apply(actorRef);
        }

        public static StoppedReading fromProduct(Product product) {
            return EndpointWriter$StoppedReading$.MODULE$.fromProduct(product);
        }

        public static StoppedReading unapply(StoppedReading stoppedReading) {
            return EndpointWriter$StoppedReading$.MODULE$.unapply(stoppedReading);
        }

        public StoppedReading(ActorRef writer) {
            this.writer = writer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoppedReading)) return false;
            StoppedReading stoppedReading = (StoppedReading)object;
            ActorRef actorRef = this.writer();
            ActorRef actorRef2 = stoppedReading.writer();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StoppedReading;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "StoppedReading";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "writer";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef writer() {
            return this.writer;
        }

        public StoppedReading copy(ActorRef writer) {
            return new StoppedReading(writer);
        }

        public ActorRef copy$default$1() {
            return this.writer();
        }

        public ActorRef _1() {
            return this.writer();
        }
    }

    public static final class TakeOver
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final PekkoProtocolHandle handle;
        private final ActorRef replyTo;

        public static TakeOver apply(PekkoProtocolHandle pekkoProtocolHandle, ActorRef actorRef) {
            return EndpointWriter$TakeOver$.MODULE$.apply(pekkoProtocolHandle, actorRef);
        }

        public static TakeOver fromProduct(Product product) {
            return EndpointWriter$TakeOver$.MODULE$.fromProduct(product);
        }

        public static TakeOver unapply(TakeOver takeOver) {
            return EndpointWriter$TakeOver$.MODULE$.unapply(takeOver);
        }

        public TakeOver(PekkoProtocolHandle handle, ActorRef replyTo) {
            this.handle = handle;
            this.replyTo = replyTo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TakeOver)) return false;
            TakeOver takeOver = (TakeOver)object;
            PekkoProtocolHandle pekkoProtocolHandle = this.handle();
            PekkoProtocolHandle pekkoProtocolHandle2 = takeOver.handle();
            if (pekkoProtocolHandle == null) {
                if (pekkoProtocolHandle2 != null) {
                    return false;
                }
            } else if (!pekkoProtocolHandle.equals(pekkoProtocolHandle2)) return false;
            ActorRef actorRef = this.replyTo();
            ActorRef actorRef2 = takeOver.replyTo();
            if (actorRef == null) {
                if (actorRef2 == null) return true;
                return false;
            } else {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TakeOver;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "TakeOver";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "handle";
            }
            if (1 == n2) {
                return "replyTo";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public PekkoProtocolHandle handle() {
            return this.handle;
        }

        public ActorRef replyTo() {
            return this.replyTo;
        }

        public TakeOver copy(PekkoProtocolHandle handle, ActorRef replyTo) {
            return new TakeOver(handle, replyTo);
        }

        public PekkoProtocolHandle copy$default$1() {
            return this.handle();
        }

        public ActorRef copy$default$2() {
            return this.replyTo();
        }

        public PekkoProtocolHandle _1() {
            return this.handle();
        }

        public ActorRef _2() {
            return this.replyTo();
        }
    }

    public static final class TookOver
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final ActorRef writer;
        private final PekkoProtocolHandle handle;

        public static TookOver apply(ActorRef actorRef, PekkoProtocolHandle pekkoProtocolHandle) {
            return EndpointWriter$TookOver$.MODULE$.apply(actorRef, pekkoProtocolHandle);
        }

        public static TookOver fromProduct(Product product) {
            return EndpointWriter$TookOver$.MODULE$.fromProduct(product);
        }

        public static TookOver unapply(TookOver tookOver) {
            return EndpointWriter$TookOver$.MODULE$.unapply(tookOver);
        }

        public TookOver(ActorRef writer, PekkoProtocolHandle handle) {
            this.writer = writer;
            this.handle = handle;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TookOver)) return false;
            TookOver tookOver = (TookOver)object;
            ActorRef actorRef = this.writer();
            ActorRef actorRef2 = tookOver.writer();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            PekkoProtocolHandle pekkoProtocolHandle = this.handle();
            PekkoProtocolHandle pekkoProtocolHandle2 = tookOver.handle();
            if (pekkoProtocolHandle == null) {
                if (pekkoProtocolHandle2 == null) return true;
                return false;
            } else {
                if (!pekkoProtocolHandle.equals(pekkoProtocolHandle2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TookOver;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "TookOver";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "writer";
            }
            if (1 == n2) {
                return "handle";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef writer() {
            return this.writer;
        }

        public PekkoProtocolHandle handle() {
            return this.handle;
        }

        public TookOver copy(ActorRef writer, PekkoProtocolHandle handle) {
            return new TookOver(writer, handle);
        }

        public ActorRef copy$default$1() {
            return this.writer();
        }

        public PekkoProtocolHandle copy$default$2() {
            return this.handle();
        }

        public ActorRef _1() {
            return this.writer();
        }

        public PekkoProtocolHandle _2() {
            return this.handle();
        }
    }
}

