/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import java.io.Serializable;
import org.apache.pekko.remote.HeartbeatHistory$;
import scala.Product;
import scala.collection.immutable.IndexedSeq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class HeartbeatHistory
implements Product,
Serializable {
    private final int maxSampleSize;
    private final IndexedSeq intervals;
    private final long intervalSum;
    private final long squaredIntervalSum;

    public static HeartbeatHistory apply(int n) {
        return HeartbeatHistory$.MODULE$.apply(n);
    }

    public static HeartbeatHistory fromProduct(Product product) {
        return HeartbeatHistory$.MODULE$.fromProduct(product);
    }

    public static HeartbeatHistory unapply(HeartbeatHistory heartbeatHistory) {
        return HeartbeatHistory$.MODULE$.unapply(heartbeatHistory);
    }

    public HeartbeatHistory(int maxSampleSize, IndexedSeq<Object> intervals, long intervalSum, long squaredIntervalSum) {
        this.maxSampleSize = maxSampleSize;
        this.intervals = intervals;
        this.intervalSum = intervalSum;
        this.squaredIntervalSum = squaredIntervalSum;
        if (maxSampleSize < 1) {
            throw new IllegalArgumentException(new StringBuilder(34).append("maxSampleSize must be >= 1, got [").append(maxSampleSize).append("]").toString());
        }
        if (intervalSum < 0L) {
            throw new IllegalArgumentException(new StringBuilder(32).append("intervalSum must be >= 0, got [").append(intervalSum).append("]").toString());
        }
        if (squaredIntervalSum < 0L) {
            throw new IllegalArgumentException(new StringBuilder(39).append("squaredIntervalSum must be >= 0, got [").append(squaredIntervalSum).append("]").toString());
        }
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.maxSampleSize());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.intervals()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.intervalSum()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.squaredIntervalSum()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof HeartbeatHistory)) return false;
        HeartbeatHistory heartbeatHistory = (HeartbeatHistory)object;
        if (this.maxSampleSize() != heartbeatHistory.maxSampleSize()) return false;
        if (this.intervalSum() != heartbeatHistory.intervalSum()) return false;
        if (this.squaredIntervalSum() != heartbeatHistory.squaredIntervalSum()) return false;
        IndexedSeq<Object> indexedSeq = this.intervals();
        IndexedSeq<Object> indexedSeq2 = heartbeatHistory.intervals();
        if (indexedSeq != null) {
            if (!indexedSeq.equals(indexedSeq2)) return false;
            return true;
        }
        if (indexedSeq2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof HeartbeatHistory;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "HeartbeatHistory";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return BoxesRunTime.boxToLong((long)this._3());
            }
            case 3: {
                return BoxesRunTime.boxToLong((long)this._4());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "maxSampleSize";
            }
            case 1: {
                return "intervals";
            }
            case 2: {
                return "intervalSum";
            }
            case 3: {
                return "squaredIntervalSum";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public int maxSampleSize() {
        return this.maxSampleSize;
    }

    public IndexedSeq<Object> intervals() {
        return this.intervals;
    }

    public long intervalSum() {
        return this.intervalSum;
    }

    public long squaredIntervalSum() {
        return this.squaredIntervalSum;
    }

    public double mean() {
        return (double)this.intervalSum() / (double)this.intervals().size();
    }

    public double variance() {
        return (double)this.squaredIntervalSum() / (double)this.intervals().size() - this.mean() * this.mean();
    }

    public double stdDeviation() {
        return package$.MODULE$.sqrt(this.variance());
    }

    public final HeartbeatHistory $colon$plus(long interval) {
        while (this_.intervals().size() >= this_.maxSampleSize()) {
            HeartbeatHistory this_ = this_.dropOldest();
        }
        return HeartbeatHistory$.MODULE$.org$apache$pekko$remote$HeartbeatHistory$$$apply(this_.maxSampleSize(), (IndexedSeq<Object>)((IndexedSeq)this_.intervals().$colon$plus((Object)BoxesRunTime.boxToLong((long)interval))), this_.intervalSum() + interval, this_.squaredIntervalSum() + this_.pow2(interval));
    }

    private HeartbeatHistory dropOldest() {
        return HeartbeatHistory$.MODULE$.org$apache$pekko$remote$HeartbeatHistory$$$apply(this.maxSampleSize(), (IndexedSeq<Object>)((IndexedSeq)this.intervals().drop(1)), this.intervalSum() - BoxesRunTime.unboxToLong((Object)this.intervals().head()), this.squaredIntervalSum() - this.pow2(BoxesRunTime.unboxToLong((Object)this.intervals().head())));
    }

    private long pow2(long x) {
        return x * x;
    }

    private HeartbeatHistory copy(int maxSampleSize, IndexedSeq<Object> intervals, long intervalSum, long squaredIntervalSum) {
        return new HeartbeatHistory(maxSampleSize, intervals, intervalSum, squaredIntervalSum);
    }

    private int copy$default$1() {
        return this.maxSampleSize();
    }

    private IndexedSeq<Object> copy$default$2() {
        return this.intervals();
    }

    private long copy$default$3() {
        return this.intervalSum();
    }

    private long copy$default$4() {
        return this.squaredIntervalSum();
    }

    public int _1() {
        return this.maxSampleSize();
    }

    public IndexedSeq<Object> _2() {
        return this.intervals();
    }

    public long _3() {
        return this.intervalSum();
    }

    public long _4() {
        return this.squaredIntervalSum();
    }
}

