/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.pekko.actor.Actor$;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Deploy;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.InvalidMessageException$;
import org.apache.pekko.actor.Nobody$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.SerializedActorRef$;
import org.apache.pekko.dispatch.sysmsg.Recreate$;
import org.apache.pekko.dispatch.sysmsg.Resume$;
import org.apache.pekko.dispatch.sysmsg.Suspend$;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.dispatch.sysmsg.Terminate$;
import org.apache.pekko.dispatch.sysmsg.Unwatch;
import org.apache.pekko.dispatch.sysmsg.Unwatch$;
import org.apache.pekko.dispatch.sysmsg.Watch;
import org.apache.pekko.dispatch.sysmsg.Watch$;
import org.apache.pekko.event.Logging;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.RemoteRef;
import org.apache.pekko.remote.RemoteTransport;
import org.apache.pekko.remote.RemoteWatcher;
import org.apache.pekko.remote.RemoteWatcher$UnwatchRemote$;
import org.apache.pekko.remote.RemoteWatcher$WatchRemote$;
import org.apache.pekko.remote.artery.ArteryTransport;
import org.apache.pekko.remote.artery.Association;
import org.apache.pekko.util.OptionVal$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Stream;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public class RemoteActorRef
extends InternalActorRef
implements RemoteRef {
    public final RemoteTransport org$apache$pekko$remote$RemoteActorRef$$remote;
    private final Address localAddressToUse;
    private final ActorPath path;
    private final InternalActorRef getParent;
    private final Option<Props> props;
    private final Option<Deploy> deploy;
    private volatile Association cachedAssociation;
    private volatile int cachedSendQueueIndex;

    public RemoteActorRef(RemoteTransport remote, Address localAddressToUse, ActorPath path, InternalActorRef getParent, Option<Props> props, Option<Deploy> deploy) {
        this.org$apache$pekko$remote$RemoteActorRef$$remote = remote;
        this.localAddressToUse = localAddressToUse;
        this.path = path;
        this.getParent = getParent;
        this.props = props;
        this.deploy = deploy;
        if (path.address().hasLocalScope()) {
            throw new IllegalArgumentException(new StringBuilder(45).append("Unexpected local address in RemoteActorRef [").append(this).append("]").toString());
        }
        RemoteTransport remoteTransport = remote;
        if (remoteTransport instanceof ArteryTransport) {
            ArteryTransport t = (ArteryTransport)remoteTransport;
            String string = path.address().protocol();
            String string2 = t.localAddress().address().protocol();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new IllegalArgumentException(new StringBuilder(33).append("Wrong protocol of [").append(path).append("], expected [").append(t.localAddress().address().protocol()).append("]").toString());
            }
        }
        this.cachedAssociation = null;
        this.cachedSendQueueIndex = -1;
    }

    public Address localAddressToUse() {
        return this.localAddressToUse;
    }

    public ActorPath path() {
        return this.path;
    }

    public InternalActorRef getParent() {
        return this.getParent;
    }

    public Association cachedAssociation() {
        return this.cachedAssociation;
    }

    public void cachedAssociation_$eq(Association x$1) {
        this.cachedAssociation = x$1;
    }

    public int cachedSendQueueIndex() {
        return this.cachedSendQueueIndex;
    }

    public void cachedSendQueueIndex_$eq(int x$1) {
        this.cachedSendQueueIndex = x$1;
    }

    public InternalActorRef getChild(Iterator<String> name) {
        Stream s = name.toStream();
        Option option = s.headOption();
        if (None$.MODULE$.equals(option)) {
            return this;
        }
        if (option instanceof Some && "..".equals(((Some)option).value())) {
            return this.getParent().getChild(name);
        }
        return new RemoteActorRef(this.org$apache$pekko$remote$RemoteActorRef$$remote, this.localAddressToUse(), this.path().$div((Iterable)s), (InternalActorRef)Nobody$.MODULE$, (Option<Props>)None$.MODULE$, (Option<Deploy>)None$.MODULE$);
    }

    public boolean isTerminated() {
        return false;
    }

    private PartialFunction<Throwable, BoxedUnit> handleException(Object message, ActorRef sender) {
        return new Serializable(message, sender, this){
            private final Object message$5;
            private final ActorRef sender$1;
            private final /* synthetic */ RemoteActorRef $outer;
            {
                this.message$5 = message$6;
                this.sender$1 = sender$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof InterruptedException) {
                    InterruptedException e = (InterruptedException)throwable;
                    return true;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = (Throwable)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof InterruptedException) {
                    InterruptedException e = (InterruptedException)throwable;
                    this.$outer.org$apache$pekko$remote$RemoteActorRef$$remote.system().eventStream().publish((Object)Logging.Error$.MODULE$.apply((Throwable)e, this.$outer.path().toString(), this.$outer.getClass(), (Object)"interrupted during message send"));
                    this.$outer.org$apache$pekko$remote$RemoteActorRef$$remote.system().deadLetters().tell(this.message$5, this.sender$1);
                    Thread.currentThread().interrupt();
                    return BoxedUnit.UNIT;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = (Throwable)option.get();
                    this.$outer.org$apache$pekko$remote$RemoteActorRef$$remote.system().eventStream().publish((Object)Logging.Error$.MODULE$.apply(e, this.$outer.path().toString(), this.$outer.getClass(), (Object)"swallowing exception during message send"));
                    this.$outer.org$apache$pekko$remote$RemoteActorRef$$remote.system().deadLetters().tell(this.message$5, this.sender$1);
                    return BoxedUnit.UNIT;
                }
                return function1.apply((Object)x);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isWatchIntercepted(ActorRef watchee, ActorRef watcher) {
        if (!this.provider().remoteWatcher().exists((Function1 & Serializable)remoteWatcher -> {
            ActorRef actorRef = watcher;
            ActorRef actorRef2 = remoteWatcher;
            return actorRef == null ? actorRef2 != null : !actorRef.equals(actorRef2);
        })) return false;
        ActorRef actorRef = watchee;
        RemoteActorRef remoteActorRef = this;
        if (actorRef != null) {
            if (!actorRef.equals(remoteActorRef)) return false;
            return true;
        }
        if (remoteActorRef == null) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendSystemMessage(SystemMessage message) {
        try {
            SystemMessage systemMessage = message;
            if (systemMessage instanceof Watch) {
                InternalActorRef internalActorRef;
                InternalActorRef watcher;
                Watch watch = Watch$.MODULE$.unapply((Watch)systemMessage);
                InternalActorRef internalActorRef2 = watch._1();
                InternalActorRef watchee = internalActorRef2;
                if (this.isWatchIntercepted((ActorRef)watchee, (ActorRef)(watcher = (internalActorRef = watch._2())))) {
                    this.provider().remoteWatcher().foreach((Function1)(JProcedure1 & Serializable)_$4 -> {
                        RemoteWatcher.WatchRemote watchRemote = RemoteWatcher$WatchRemote$.MODULE$.apply(watchee, watcher);
                        _$4.$bang((Object)watchRemote, _$4.$bang$default$2((Object)watchRemote));
                    });
                    return;
                }
                if (this.provider().remoteWatcher().isDefined()) {
                    OptionVal$.MODULE$.None();
                    this.org$apache$pekko$remote$RemoteActorRef$$remote.send(message, null, this);
                    return;
                }
                this.provider().warnIfUnsafeDeathwatchWithoutCluster((ActorRef)watchee, (ActorRef)watcher, "Watch");
                return;
            }
            if (systemMessage instanceof Unwatch) {
                Unwatch unwatch = Unwatch$.MODULE$.unapply((Unwatch)systemMessage);
                ActorRef actorRef = unwatch._1();
                ActorRef actorRef2 = unwatch._2();
                if (actorRef instanceof InternalActorRef) {
                    InternalActorRef watchee = (InternalActorRef)actorRef;
                    if (actorRef2 instanceof InternalActorRef) {
                        InternalActorRef watcher = (InternalActorRef)actorRef2;
                        if (this.isWatchIntercepted((ActorRef)watchee, (ActorRef)watcher)) {
                            this.provider().remoteWatcher().foreach((Function1)(JProcedure1 & Serializable)_$5 -> {
                                RemoteWatcher.UnwatchRemote unwatchRemote = RemoteWatcher$UnwatchRemote$.MODULE$.apply(watchee, watcher);
                                _$5.$bang((Object)unwatchRemote, _$5.$bang$default$2((Object)unwatchRemote));
                            });
                            return;
                        }
                        if (!this.provider().remoteWatcher().isDefined()) return;
                        OptionVal$.MODULE$.None();
                        this.org$apache$pekko$remote$RemoteActorRef$$remote.send(message, null, this);
                        return;
                    }
                }
            }
            OptionVal$.MODULE$.None();
            this.org$apache$pekko$remote$RemoteActorRef$$remote.send(message, null, this);
            return;
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $3$ = this.handleException(message, Actor$.MODULE$.noSender());
            if (!$3$.isDefinedAt((Object)ex$)) throw ex$;
            $3$.apply((Object)ex$);
            return;
        }
    }

    public void $bang(Object message, ActorRef sender) {
        if (message == null) {
            throw InvalidMessageException$.MODULE$.apply("Message is null");
        }
        try {
            this.org$apache$pekko$remote$RemoteActorRef$$remote.send(message, (ActorRef)OptionVal$.MODULE$.apply((Object)sender), this);
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $4$ = this.handleException(message, sender);
            if ($4$.isDefinedAt((Object)ex$)) {
                $4$.apply((Object)ex$);
            }
            throw ex$;
        }
    }

    public ActorRef $bang$default$2(Object message) {
        return Actor$.MODULE$.noSender();
    }

    public RemoteActorRefProvider provider() {
        return this.org$apache$pekko$remote$RemoteActorRef$$remote.provider();
    }

    public void start() {
        if (this.props.isDefined() && this.deploy.isDefined()) {
            this.org$apache$pekko$remote$RemoteActorRef$$remote.provider().useActorOnNode((ActorRef)this, (Props)this.props.get(), (Deploy)this.deploy.get(), (ActorRef)this.getParent());
            return;
        }
    }

    public void suspend() {
        this.sendSystemMessage((SystemMessage)Suspend$.MODULE$.apply());
    }

    public void resume(Throwable causedByFailure) {
        this.sendSystemMessage((SystemMessage)Resume$.MODULE$.apply(causedByFailure));
    }

    public void stop() {
        this.sendSystemMessage((SystemMessage)Terminate$.MODULE$.apply());
    }

    public void restart(Throwable cause) {
        this.sendSystemMessage((SystemMessage)Recreate$.MODULE$.apply(cause));
    }

    private Object writeReplace() throws ObjectStreamException {
        return SerializedActorRef$.MODULE$.apply((ActorRef)this);
    }
}

