/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.concurrent.ManyToManyConcurrentArrayQueue;
import org.apache.pekko.remote.artery.EnvelopeBuffer;

public class EnvelopeBufferPool {
    private final int maximumPayload;
    private final ManyToManyConcurrentArrayQueue<EnvelopeBuffer> availableBuffers;

    public EnvelopeBufferPool(int maximumPayload, int maximumBuffers) {
        this.maximumPayload = maximumPayload;
        this.availableBuffers = new ManyToManyConcurrentArrayQueue(maximumBuffers);
    }

    public EnvelopeBuffer acquire() {
        EnvelopeBuffer buf = (EnvelopeBuffer)this.availableBuffers.poll();
        if (buf != null) {
            buf.byteBuffer().clear();
            return buf;
        }
        EnvelopeBuffer newBuf = new EnvelopeBuffer(ByteBuffer.allocateDirect(this.maximumPayload));
        newBuf.byteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        return newBuf;
    }

    public void release(EnvelopeBuffer buffer) {
        if (buffer.byteBuffer().isDirect() && !this.availableBuffers.offer((Object)buffer)) {
            buffer.tryCleanDirectByteBuffer();
            return;
        }
    }
}

