/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.remote.artery.ByteFlag$;
import org.apache.pekko.remote.artery.HeaderBuilder;
import org.apache.pekko.remote.artery.RemoteInstruments;
import org.apache.pekko.remote.artery.SerializationFormatCache;
import org.apache.pekko.remote.artery.compress.CompressionTable;
import org.apache.pekko.remote.artery.compress.InboundCompressions;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;

public final class HeaderBuilderImpl
implements HeaderBuilder {
    private final InboundCompressions inboundCompression;
    private CompressionTable _outboundActorRefCompression;
    private CompressionTable _outboundClassManifestCompression;
    private final SerializationFormatCache toSerializationFormat;
    private byte _version;
    private byte _flags;
    private long _uid;
    private byte _inboundActorRefCompressionTableVersion;
    private byte _inboundClassManifestCompressionTableVersion;
    private boolean _useOutboundCompression;
    private String _senderActorRef;
    private int _senderActorRefIdx;
    private String _recipientActorRef;
    private int _recipientActorRefIdx;
    private int _serializer;
    private String _manifest;
    private int _manifestIdx;
    private RemoteInstruments _remoteInstruments;

    public HeaderBuilderImpl(InboundCompressions inboundCompression, CompressionTable<ActorRef> _outboundActorRefCompression, CompressionTable<String> _outboundClassManifestCompression) {
        this.inboundCompression = inboundCompression;
        this._outboundActorRefCompression = _outboundActorRefCompression;
        this._outboundClassManifestCompression = _outboundClassManifestCompression;
        this.toSerializationFormat = new SerializationFormatCache();
        this._version = 0;
        this._flags = 0;
        this._uid = 0L;
        this._inboundActorRefCompressionTableVersion = 0;
        this._inboundClassManifestCompressionTableVersion = 0;
        this._useOutboundCompression = true;
        this._senderActorRef = null;
        this._senderActorRefIdx = -1;
        this._recipientActorRef = null;
        this._recipientActorRefIdx = -1;
        this._serializer = 0;
        this._manifest = null;
        this._manifestIdx = -1;
        OptionVal$.MODULE$.None();
        this._remoteInstruments = null;
    }

    public CompressionTable<ActorRef> _outboundActorRefCompression() {
        return this._outboundActorRefCompression;
    }

    public void _outboundActorRefCompression_$eq(CompressionTable<ActorRef> x$1) {
        this._outboundActorRefCompression = x$1;
    }

    public CompressionTable<String> _outboundClassManifestCompression() {
        return this._outboundClassManifestCompression;
    }

    public void _outboundClassManifestCompression_$eq(CompressionTable<String> x$1) {
        this._outboundClassManifestCompression = x$1;
    }

    public byte _version() {
        return this._version;
    }

    public void _version_$eq(byte x$1) {
        this._version = x$1;
    }

    public byte _flags() {
        return this._flags;
    }

    public void _flags_$eq(byte x$1) {
        this._flags = x$1;
    }

    public long _uid() {
        return this._uid;
    }

    public void _uid_$eq(long x$1) {
        this._uid = x$1;
    }

    public byte _inboundActorRefCompressionTableVersion() {
        return this._inboundActorRefCompressionTableVersion;
    }

    public void _inboundActorRefCompressionTableVersion_$eq(byte x$1) {
        this._inboundActorRefCompressionTableVersion = x$1;
    }

    public byte _inboundClassManifestCompressionTableVersion() {
        return this._inboundClassManifestCompressionTableVersion;
    }

    public void _inboundClassManifestCompressionTableVersion_$eq(byte x$1) {
        this._inboundClassManifestCompressionTableVersion = x$1;
    }

    public boolean _useOutboundCompression() {
        return this._useOutboundCompression;
    }

    public void _useOutboundCompression_$eq(boolean x$1) {
        this._useOutboundCompression = x$1;
    }

    public String _senderActorRef() {
        return this._senderActorRef;
    }

    public void _senderActorRef_$eq(String x$1) {
        this._senderActorRef = x$1;
    }

    public int _senderActorRefIdx() {
        return this._senderActorRefIdx;
    }

    public void _senderActorRefIdx_$eq(int x$1) {
        this._senderActorRefIdx = x$1;
    }

    public String _recipientActorRef() {
        return this._recipientActorRef;
    }

    public void _recipientActorRef_$eq(String x$1) {
        this._recipientActorRef = x$1;
    }

    public int _recipientActorRefIdx() {
        return this._recipientActorRefIdx;
    }

    public void _recipientActorRefIdx_$eq(int x$1) {
        this._recipientActorRefIdx = x$1;
    }

    public int _serializer() {
        return this._serializer;
    }

    public void _serializer_$eq(int x$1) {
        this._serializer = x$1;
    }

    public String _manifest() {
        return this._manifest;
    }

    public void _manifest_$eq(String x$1) {
        this._manifest = x$1;
    }

    public int _manifestIdx() {
        return this._manifestIdx;
    }

    public void _manifestIdx_$eq(int x$1) {
        this._manifestIdx = x$1;
    }

    public RemoteInstruments _remoteInstruments() {
        return this._remoteInstruments;
    }

    public void _remoteInstruments_$eq(RemoteInstruments x$1) {
        this._remoteInstruments = x$1;
    }

    @Override
    public void resetMessageFields() {
        this._flags_$eq((byte)0);
        this._senderActorRef_$eq(null);
        this._senderActorRefIdx_$eq(-1);
        this._recipientActorRef_$eq(null);
        this._recipientActorRefIdx_$eq(-1);
        this._serializer_$eq(0);
        this._manifest_$eq(null);
        this._manifestIdx_$eq(-1);
        OptionVal$.MODULE$.None();
        this._remoteInstruments_$eq(null);
    }

    @Override
    public void setVersion(byte v) {
        this._version_$eq(v);
    }

    @Override
    public byte version() {
        return this._version();
    }

    @Override
    public void setFlags(byte v) {
        this._flags_$eq(v);
    }

    @Override
    public byte flags() {
        return this._flags();
    }

    @Override
    public boolean flag(byte byteFlag) {
        return (this._flags() & byteFlag) != 0;
    }

    @Override
    public void setFlag(byte byteFlag) {
        this._flags_$eq((byte)(this.flags() | byteFlag));
    }

    @Override
    public void clearFlag(byte byteFlag) {
        this._flags_$eq((byte)(this.flags() & ~byteFlag));
    }

    @Override
    public void setUid(long uid) {
        this._uid_$eq(uid);
    }

    @Override
    public long uid() {
        return this._uid();
    }

    @Override
    public byte inboundActorRefCompressionTableVersion() {
        return this._inboundActorRefCompressionTableVersion();
    }

    @Override
    public byte inboundClassManifestCompressionTableVersion() {
        return this._inboundClassManifestCompressionTableVersion();
    }

    @Override
    public void useOutboundCompression(boolean on) {
        this._useOutboundCompression_$eq(on);
    }

    @Override
    public void setOutboundActorRefCompression(CompressionTable<ActorRef> table) {
        this._outboundActorRefCompression_$eq(table);
    }

    @Override
    public CompressionTable<ActorRef> outboundActorRefCompression() {
        return this._outboundActorRefCompression();
    }

    @Override
    public void setOutboundClassManifestCompression(CompressionTable<String> table) {
        this._outboundClassManifestCompression_$eq(table);
    }

    @Override
    public CompressionTable<String> outboundClassManifestCompression() {
        return this._outboundClassManifestCompression();
    }

    @Override
    public void setSenderActorRef(ActorRef ref) {
        if (this._useOutboundCompression()) {
            this._senderActorRefIdx_$eq(this.outboundActorRefCompression().compress(ref));
            if (this._senderActorRefIdx() == -1) {
                this._senderActorRef_$eq(Serialization$.MODULE$.serializedActorPath(ref));
                return;
            }
            return;
        }
        this._senderActorRef_$eq(Serialization$.MODULE$.serializedActorPath(ref));
    }

    @Override
    public void setNoSender() {
        this._senderActorRef_$eq(null);
        this._senderActorRefIdx_$eq(-1);
    }

    @Override
    public boolean isNoSender() {
        return this._senderActorRef() == null && this._senderActorRefIdx() == -1;
    }

    @Override
    public ActorRef senderActorRef(long originUid) {
        if (this._senderActorRef() == null && !this.isNoSender()) {
            return this.inboundCompression.decompressActorRef(originUid, this.inboundActorRefCompressionTableVersion(), this._senderActorRefIdx());
        }
        OptionVal$.MODULE$.None();
        return null;
    }

    @Override
    public String senderActorRefPath() {
        return (String)OptionVal$.MODULE$.apply((Object)this._senderActorRef());
    }

    @Override
    public void setNoRecipient() {
        this._recipientActorRef_$eq(null);
        this._recipientActorRefIdx_$eq(-1);
    }

    @Override
    public boolean isNoRecipient() {
        return this._recipientActorRef() == null && this._recipientActorRefIdx() == -1;
    }

    @Override
    public void setRecipientActorRef(ActorRef ref) {
        if (this._useOutboundCompression()) {
            this._recipientActorRefIdx_$eq(this.outboundActorRefCompression().compress(ref));
            if (this._recipientActorRefIdx() == -1) {
                this._recipientActorRef_$eq((String)this.toSerializationFormat.getOrCompute(ref));
                return;
            }
            return;
        }
        this._recipientActorRef_$eq((String)this.toSerializationFormat.getOrCompute(ref));
    }

    @Override
    public ActorRef recipientActorRef(long originUid) {
        if (this._recipientActorRef() == null && !this.isNoRecipient()) {
            return this.inboundCompression.decompressActorRef(originUid, this.inboundActorRefCompressionTableVersion(), this._recipientActorRefIdx());
        }
        OptionVal$.MODULE$.None();
        return null;
    }

    @Override
    public String recipientActorRefPath() {
        return (String)OptionVal$.MODULE$.apply((Object)this._recipientActorRef());
    }

    @Override
    public void setSerializer(int serializer) {
        this._serializer_$eq(serializer);
    }

    @Override
    public int serializer() {
        return this._serializer();
    }

    @Override
    public void setManifest(String manifest) {
        if (this._useOutboundCompression()) {
            this._manifestIdx_$eq(this.outboundClassManifestCompression().compress(manifest));
            if (this._manifestIdx() == -1) {
                this._manifest_$eq(manifest);
                return;
            }
            return;
        }
        this._manifest_$eq(manifest);
    }

    @Override
    public String manifest(long originUid) {
        if (this._manifest() != null) {
            return (String)OptionVal.Some$.MODULE$.apply((Object)this._manifest());
        }
        return this.inboundCompression.decompressClassManifest(originUid, this.inboundClassManifestCompressionTableVersion(), this._manifestIdx());
    }

    @Override
    public void setRemoteInstruments(RemoteInstruments instruments) {
        this._remoteInstruments_$eq((RemoteInstruments)OptionVal$.MODULE$.apply((Object)instruments));
    }

    public String toString() {
        return new StringBuilder(166).append("HeaderBuilderImpl(version:").append(this.version()).append(", ").append("flags:").append(ByteFlag$.MODULE$.binaryLeftPad(this.flags())).append(", ").append("UID:").append(this.uid()).append(", ").append("_senderActorRef:").append(this._senderActorRef()).append(", ").append("_senderActorRefIdx:").append(this._senderActorRefIdx()).append(", ").append("_recipientActorRef:").append(this._recipientActorRef()).append(", ").append("_recipientActorRefIdx:").append(this._recipientActorRefIdx()).append(", ").append("_serializer:").append(this._serializer()).append(", ").append("_manifest:").append(this._manifest()).append(", ").append("_manifestIdx:").append(this._manifestIdx()).append(")").toString();
    }
}

