/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import org.apache.pekko.remote.artery.CacheStatistics;
import org.apache.pekko.remote.artery.CacheStatistics$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public abstract class LruBoundedCache<K, V> {
    private final int capacity;
    private final int evictAgeThreshold;
    private final int Mask;
    private int epoch;
    private final K[] keys;
    private final V[] values;
    private final int[] hashes;
    private final int[] epochs;

    public LruBoundedCache(int capacity, int evictAgeThreshold, ClassTag<K> evidence$1, ClassTag<V> evidence$2) {
        this.capacity = capacity;
        this.evictAgeThreshold = evictAgeThreshold;
        Predef$.MODULE$.require(capacity > 0, LruBoundedCache::$init$$$anonfun$1);
        Predef$.MODULE$.require((capacity & capacity - 1) == 0, LruBoundedCache::$init$$$anonfun$2);
        Predef$.MODULE$.require(evictAgeThreshold <= capacity, LruBoundedCache::$init$$$anonfun$3);
        this.Mask = capacity - 1;
        this.epoch = 0x7FFFFFFE;
        this.keys = (Object[])Array$.MODULE$.ofDim(capacity, evidence$1);
        this.values = (Object[])Array$.MODULE$.ofDim(capacity, evidence$2);
        this.hashes = new int[capacity];
        this.epochs = (int[])Array$.MODULE$.fill(capacity, () -> this.$init$$$anonfun$4(evictAgeThreshold), ClassTag$.MODULE$.apply(Integer.TYPE));
    }

    public final Option<V> get(K k) {
        int h = this.hash(k);
        return this.find$1(k, h, h & this.Mask, 0);
    }

    public final CacheStatistics stats() {
        int sum = 0;
        int count = 0;
        int max = 0;
        for (int i = 0; i < this.hashes.length; ++i) {
            if (this.values[i] == null) continue;
            int dist = this.probeDistanceOf(i);
            sum += dist;
            ++count;
            max = package$.MODULE$.max(dist, max);
        }
        return CacheStatistics$.MODULE$.apply(count, max, (double)sum / (double)count);
    }

    public final V getOrCompute(K k) {
        if (!this.isKeyCacheable(k)) {
            return this.compute(k);
        }
        int h = this.hash(k);
        ++this.epoch;
        return (V)this.findOrCalculate$1(k, h, h & this.Mask, 0);
    }

    private void removeAt(int position) {
        while (true) {
            int next;
            if (this.values[next = position + 1 & this.Mask] == null || this.probeDistanceOf(next) == 0) {
                this.values[position] = null;
                return;
            }
            this.keys[position] = this.keys[next];
            this.values[position] = this.values[next];
            this.hashes[position] = this.hashes[next];
            this.epochs[position] = this.epochs[next];
            position = next;
        }
    }

    private int probeDistanceOf(int slot) {
        return this.probeDistanceOf(this.hashes[slot] & this.Mask, slot);
    }

    public int probeDistanceOf(int idealSlot, int actualSlot) {
        return actualSlot - idealSlot + this.capacity & this.Mask;
    }

    private void move(int position, K k, int h, V value, int elemEpoch, int probeDistance) {
        while (true) {
            if (this.values[position] == null) {
                this.keys[position] = k;
                this.values[position] = value;
                this.hashes[position] = h;
                this.epochs[position] = elemEpoch;
                return;
            }
            int otherEpoch = this.epochs[position];
            if (this.epoch - otherEpoch >= this.evictAgeThreshold) {
                this.removeAt(position);
                int n = h & this.Mask;
                int n2 = 0;
                position = n;
                probeDistance = n2;
                continue;
            }
            int otherProbeDistance = this.probeDistanceOf(position);
            int otherEpoch2 = this.epochs[position];
            if (probeDistance > otherProbeDistance) {
                K otherKey = this.keys[position];
                V otherValue = this.values[position];
                int otherHash = this.hashes[position];
                this.keys[position] = k;
                this.values[position] = value;
                this.hashes[position] = h;
                this.epochs[position] = elemEpoch;
                int n = position + 1 & this.Mask;
                K k2 = otherKey;
                int n3 = otherHash;
                V v = otherValue;
                int n4 = otherEpoch2;
                int n5 = otherProbeDistance + 1;
                position = n;
                k = k2;
                h = n3;
                value = v;
                elemEpoch = n4;
                probeDistance = n5;
                continue;
            }
            int n = position + 1 & this.Mask;
            int n6 = probeDistance + 1;
            position = n;
            probeDistance = n6;
        }
    }

    public abstract V compute(K var1);

    public abstract int hash(K var1);

    public abstract boolean isKeyCacheable(K var1);

    public abstract boolean isCacheable(V var1);

    public String toString() {
        Object object = Predef$.MODULE$.intArrayOps(this.hashes);
        Object object2 = Predef$.MODULE$.intArrayOps(this.hashes);
        return new StringBuilder(16).append("LruBoundedCache(").append(new StringBuilder(11).append(" values = ").append(Predef$.MODULE$.wrapRefArray((Object[])this.values).mkString("[", ",", "]")).append(",").toString()).append(new StringBuilder(11).append(" hashes = ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(object, (Function1)(JFunction1.mcII.sp & Serializable)_$1 -> _$1 & this.Mask, ClassTag$.MODULE$.apply(Integer.TYPE))).mkString("[", ",", "]")).append(",").toString()).append(new StringBuilder(11).append(" epochs = ").append(Predef$.MODULE$.wrapIntArray(this.epochs).mkString("[", ",", "]")).append(",").toString()).append(new StringBuilder(14).append(" distances = ").append(ArrayOps$.MODULE$.indices$extension(object2).map((Function1)(JFunction1.mcII.sp & Serializable)slot -> this.probeDistanceOf(slot)).mkString("[", ",", "]")).append(",").toString()).append(new StringBuilder(2).append(" ").append(this.epoch).append(")").toString()).toString();
    }

    private static final Object $init$$$anonfun$1() {
        return "Capacity must be larger than zero";
    }

    private static final Object $init$$$anonfun$2() {
        return "Capacity must be power of two";
    }

    private static final Object $init$$$anonfun$3() {
        return "Age threshold must be less than capacity.";
    }

    private final int $init$$$anonfun$4(int evictAgeThreshold$1) {
        return this.epoch - evictAgeThreshold$1;
    }

    private final Option find$1(Object k$1, int h$1, int position, int probeDistance) {
        while (true) {
            int otherProbeDistance = this.probeDistanceOf(position);
            if (this.values[position] == null) {
                return None$.MODULE$;
            }
            if (probeDistance > otherProbeDistance) {
                return None$.MODULE$;
            }
            if (this.hashes[position] == h$1 && BoxesRunTime.equals((Object)k$1, this.keys[position])) {
                return Some$.MODULE$.apply(this.values[position]);
            }
            int n = position + 1 & this.Mask;
            int n2 = probeDistance + 1;
            position = n;
            probeDistance = n2;
        }
    }

    private final Object findOrCalculate$1(Object k$2, int h$2, int position, int probeDistance) {
        while (true) {
            if (this.values[position] == null) {
                V value = this.compute(k$2);
                if (this.isCacheable(value)) {
                    this.keys[position] = k$2;
                    this.values[position] = value;
                    this.hashes[position] = h$2;
                    this.epochs[position] = this.epoch;
                }
                return value;
            }
            int otherProbeDistance = this.probeDistanceOf(position);
            if (probeDistance > otherProbeDistance) {
                V value = this.compute(k$2);
                if (this.isCacheable(value)) {
                    this.move(position, k$2, h$2, value, this.epoch, probeDistance);
                }
                return value;
            }
            if (this.hashes[position] == h$2 && BoxesRunTime.equals((Object)k$2, this.keys[position])) {
                this.epochs[position] = this.epoch;
                return this.values[position];
            }
            int n = position + 1 & this.Mask;
            int n2 = probeDistance + 1;
            position = n;
            probeDistance = n2;
        }
    }
}

