/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefScope;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.ActorSelectionMessage;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.LocalRef;
import org.apache.pekko.actor.PossiblyHarmful;
import org.apache.pekko.actor.RepointableRef;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.RemoteRef;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;

public class MessageDispatcher {
    private final ExtendedActorSystem system;
    private final RemoteActorRefProvider provider;
    private final InternalActorRef remoteDaemon;
    private final MarkerLoggingAdapter log;
    private final boolean debugLogEnabled;

    public MessageDispatcher(ExtendedActorSystem system, RemoteActorRefProvider provider) {
        this.system = system;
        this.provider = provider;
        this.remoteDaemon = provider.remoteDaemon();
        this.log = Logging$.MODULE$.withMarker((ActorSystem)system, (Object)this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.debugLogEnabled = this.log.isDebugEnabled();
    }

    public void dispatch(InboundEnvelope inboundEnvelope) {
        InternalActorRef internalActorRef;
        ActorRef sender;
        Address originAddress;
        ActorRef senderOption;
        Object message;
        InternalActorRef recipient;
        block18: {
            Object object;
            InternalActorRef l;
            block19: {
                ActorSelectionMessage sel;
                block20: {
                    block21: {
                        Address address;
                        InternalActorRef internalActorRef2 = inboundEnvelope.recipient();
                        recipient = (InternalActorRef)OptionVal$.MODULE$.get$extension((Object)internalActorRef2);
                        message = inboundEnvelope.message();
                        senderOption = inboundEnvelope.sender();
                        OutboundContext outboundContext = inboundEnvelope.association();
                        OutboundContext outboundContext2 = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext);
                        if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundContext2)) {
                            OutboundContext outboundContext3;
                            OutboundContext a = outboundContext3 = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext2);
                            address = (Address)OptionVal.Some$.MODULE$.apply((Object)a.remoteAddress());
                        } else {
                            OptionVal$.MODULE$.None();
                            address = null;
                        }
                        originAddress = address;
                        sender = (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)senderOption, (Object)this.system.deadLetters());
                        internalActorRef = recipient;
                        InternalActorRef internalActorRef3 = this.remoteDaemon;
                        InternalActorRef internalActorRef4 = internalActorRef;
                        if (!(internalActorRef3 != null ? !internalActorRef3.equals(internalActorRef4) : internalActorRef4 != null)) {
                            if (this.provider.remoteSettings().Artery().UntrustedMode()) {
                                if (this.debugLogEnabled) {
                                    this.log.debug(LogMarker$.MODULE$.Security(), "dropping daemon message [{}] in untrusted mode", (Object)Logging$.MODULE$.messageClassName(message));
                                    return;
                                }
                                return;
                            }
                            if (this.provider.remoteSettings().Artery().LogReceive() && this.debugLogEnabled) {
                                this.log.debug("received daemon message [{}] from [{}]", message, OptionVal$.MODULE$.getOrElse$extension((Object)senderOption, OptionVal$.MODULE$.getOrElse$extension((Object)originAddress, (Object)"")));
                            }
                            this.remoteDaemon.$bang(message, this.remoteDaemon.$bang$default$2(message));
                            return;
                        }
                        if (!(internalActorRef instanceof LocalRef) && !(internalActorRef instanceof RepointableRef)) break block18;
                        l = internalActorRef;
                        if (!((ActorRefScope)l).isLocal()) break block18;
                        if (this.provider.remoteSettings().Artery().LogReceive() && this.debugLogEnabled) {
                            this.log.debug("received message [{}] to [{}] from [{}]", message, (Object)recipient, OptionVal$.MODULE$.getOrElse$extension((Object)senderOption, (Object)""));
                        }
                        if (!((object = message) instanceof ActorSelectionMessage)) break block19;
                        sel = (ActorSelectionMessage)object;
                        if (!this.provider.remoteSettings().Artery().UntrustedMode()) break block20;
                        if (!this.provider.remoteSettings().Artery().TrustedSelectionPaths().contains((Object)sel.elements().mkString("/", "/", "")) || sel.msg() instanceof PossiblyHarmful) break block21;
                        InternalActorRef internalActorRef5 = l;
                        InternalActorRef internalActorRef6 = this.provider.rootGuardian();
                        if (!(internalActorRef5 == null ? internalActorRef6 != null : !internalActorRef5.equals(internalActorRef6))) break block20;
                    }
                    if (this.debugLogEnabled) {
                        this.log.debug(LogMarker$.MODULE$.Security(), "operating in UntrustedMode, dropping inbound actor selection to [{}], allow it by adding the path to 'pekko.remote.trusted-selection-paths' configuration", (Object)sel.elements().mkString("/", "/", ""));
                        return;
                    }
                    return;
                }
                ActorSelection$.MODULE$.deliverSelection(l, sender, sel);
                return;
            }
            if (object instanceof PossiblyHarmful) {
                PossiblyHarmful msg = (PossiblyHarmful)object;
                if (this.provider.remoteSettings().Artery().UntrustedMode()) {
                    if (this.debugLogEnabled) {
                        this.log.debug(LogMarker$.MODULE$.Security(), "operating in UntrustedMode, dropping inbound PossiblyHarmful message of type [{}] to [{}] from [{}]", (Object)Logging$.MODULE$.messageClassName((Object)msg), (Object)recipient, OptionVal$.MODULE$.getOrElse$extension((Object)senderOption, OptionVal$.MODULE$.getOrElse$extension((Object)originAddress, (Object)"")));
                        return;
                    }
                    return;
                }
            }
            if (object instanceof SystemMessage) {
                SystemMessage msg = (SystemMessage)object;
                l.sendSystemMessage(msg);
                return;
            }
            Object msg = object;
            l.$bang(msg, sender);
            return;
        }
        if (internalActorRef instanceof RemoteRef || internalActorRef instanceof RepointableRef) {
            InternalActorRef r = internalActorRef;
            if (!((ActorRefScope)r).isLocal() && !this.provider.remoteSettings().Artery().UntrustedMode()) {
                if (this.provider.remoteSettings().Artery().LogReceive() && this.debugLogEnabled) {
                    this.log.debug("received remote-destined message [{}] to [{}] from [{}]", message, (Object)recipient, OptionVal$.MODULE$.getOrElse$extension((Object)senderOption, OptionVal$.MODULE$.getOrElse$extension((Object)originAddress, (Object)"")));
                }
                r.$bang(message, sender);
                return;
            }
        }
        InternalActorRef r = internalActorRef;
        this.log.error("dropping message [{}] for unknown recipient [{}] from [{}]", (Object)Logging$.MODULE$.messageClassName(message), (Object)r, OptionVal$.MODULE$.getOrElse$extension((Object)senderOption, OptionVal$.MODULE$.getOrElse$extension((Object)originAddress, (Object)"")));
    }
}

