/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.compress;

import java.util.Objects;
import org.apache.pekko.remote.artery.compress.TopHeavyHitters$HashCodeVal$;
import scala.Array$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class TopHeavyHitters<T> {
    private final int max;
    private final int adjustedMax;
    private final int capacity;
    private final int mask;
    private final int[] hashes;
    public final Object org$apache$pekko$remote$artery$compress$TopHeavyHitters$$items;
    private final int[] heapIndex;
    private final long[] weights;
    public final int[] org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap;

    public TopHeavyHitters(int max, ClassTag<T> classTag) {
        this.max = max;
        this.adjustedMax = max == 0 ? 1 : max;
        Predef$.MODULE$.require((this.adjustedMax & this.adjustedMax - 1) == 0, TopHeavyHitters::$init$$$anonfun$1);
        this.capacity = this.adjustedMax * 2;
        this.mask = this.capacity() - 1;
        this.hashes = new int[this.capacity()];
        this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$items = Array$.MODULE$.ofDim(this.capacity(), classTag);
        this.heapIndex = (int[])Array$.MODULE$.fill(this.capacity(), TopHeavyHitters::$init$$$anonfun$2, ClassTag$.MODULE$.apply(Integer.TYPE));
        this.weights = new long[this.capacity()];
        this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap = (int[])Array$.MODULE$.fill(this.adjustedMax, TopHeavyHitters::$init$$$anonfun$3, ClassTag$.MODULE$.apply(Integer.TYPE));
    }

    public int max() {
        return this.max;
    }

    public int capacity() {
        return this.capacity;
    }

    public int mask() {
        return this.mask;
    }

    public Iterator<T> iterator() {
        return new Iterator<T>(this){
            private int i;
            private final /* synthetic */ TopHeavyHitters $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.i = 0;
            }

            public int i() {
                return this.i;
            }

            public void i_$eq(int x$1) {
                this.i = x$1;
            }

            public final boolean hasNext() {
                boolean bl;
                block2: {
                    while (this.i() < this.$outer.max()) {
                        if (this.value() == null) {
                            this.next();
                            continue;
                        }
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                return bl;
            }

            public final Object next() {
                Object v = this.value();
                this.i_$eq(this.i() + 1);
                return v;
            }

            private final int index() {
                return this.$outer.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[this.i()];
            }

            private final Object value() {
                int idx = this.index();
                if (idx < 0) {
                    return null;
                }
                return ScalaRunTime$.MODULE$.array_apply(this.$outer.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$items, idx);
            }
        };
    }

    public String toDebugString() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(215).append("TopHeavyHitters(\n        |  max: ").append(this.max()).append(",\n        |  lowestHitterIdx: ").append(this.lowestHitterIndex()).append(" (weight: ").append(this.lowestHitterWeight()).append(")\n        |\n        |  hashes:      ").append(Predef$.MODULE$.wrapIntArray(this.hashes).toList().mkString("[", ", ", "]")).append("\n        |  weights:     ").append(Predef$.MODULE$.wrapLongArray(this.weights).toList().mkString("[", ", ", "]")).append("\n        |  items:       ").append(Predef$.MODULE$.genericWrapArray(this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$items).toList().mkString("[", ", ", "]")).append("\n        |  heapIndex:   ").append(Predef$.MODULE$.wrapIntArray(this.heapIndex).toList().mkString("[", ", ", "]")).append("\n        |  heap:   ").append(Predef$.MODULE$.wrapIntArray(this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap).toList().mkString("[", ", ", "]")).append("\n        |)").toString()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean update(T item, long count) {
        if (!this.isHeavy(count)) return false;
        int hashCode = item.hashCode();
        int startIndex = hashCode & this.mask();
        int candidateIndex = this.findHashIdx(startIndex, hashCode);
        if (candidateIndex == -1) {
            this.insertKnownNewHeavy(hashCode, item, count);
            if (true) return true;
            return false;
        } else {
            int actualIdx = this.findItemIdx(candidateIndex, hashCode, item);
            if (actualIdx == -1) {
                this.insertKnownNewHeavy(hashCode, item, count);
                if (true) return true;
                return false;
            } else {
                this.updateExistingHeavyHitter(actualIdx, count);
                if (!false) return false;
                return true;
            }
        }
    }

    private boolean isHeavy(long count) {
        return count > this.lowestHitterWeight();
    }

    private int findItemIdx(int searchFromIndex, int hashCode, T o) {
        if (searchFromIndex == -1) {
            return -1;
        }
        if (Objects.equals(ScalaRunTime$.MODULE$.array_apply(this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$items, searchFromIndex), o)) {
            return searchFromIndex;
        }
        return this.loop$1(searchFromIndex + 1 & this.mask(), searchFromIndex, hashCode, o);
    }

    private void updateExistingHeavyHitter(int foundHashIndex, long count) {
        if (this.weights[foundHashIndex] > count) {
            throw new IllegalArgumentException(new StringBuilder(67).append("Weights can be only incremented or kept the same, not decremented. ").append(new StringBuilder(53).append("Previous weight was [").append(this.weights[foundHashIndex]).append("], attempted to modify it to [").append(count).append("].").toString()).toString());
        }
        this.weights[foundHashIndex] = count;
        this.fixHeap(this.heapIndex[foundHashIndex]);
    }

    private int findHashIdx(int searchFromIndex, int hashCode) {
        for (int i = 0; i < this.hashes.length; ++i) {
            int index = i + searchFromIndex & this.mask();
            if (this.hashes[index] != hashCode) continue;
            return index;
        }
        return -1;
    }

    private void fixHeap(int index) {
        block8: {
            while (true) {
                int leftIndex = index * 2 + 1;
                int rightIndex = index * 2 + 2;
                long currentWeight = this.weights[this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[index]];
                if (rightIndex < this.adjustedMax) {
                    int leftValueIndex = this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[leftIndex];
                    int rightValueIndex = this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[rightIndex];
                    if (leftValueIndex < 0) {
                        this.swapHeapNode(index, leftIndex);
                        index = leftIndex;
                        continue;
                    }
                    if (rightValueIndex < 0) {
                        this.swapHeapNode(index, rightIndex);
                        index = rightIndex;
                        continue;
                    }
                    long leftWeight = this.weights[leftValueIndex];
                    long rightWeight = this.weights[rightValueIndex];
                    if (leftWeight < rightWeight) {
                        if (currentWeight > leftWeight) {
                            this.swapHeapNode(index, leftIndex);
                            index = leftIndex;
                            continue;
                        }
                        return;
                    }
                    if (currentWeight > rightWeight) {
                        this.swapHeapNode(index, rightIndex);
                        index = rightIndex;
                        continue;
                    }
                    return;
                }
                if (leftIndex >= this.adjustedMax) break block8;
                int leftValueIndex = this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[leftIndex];
                if (leftValueIndex < 0) {
                    this.swapHeapNode(index, leftIndex);
                    index = leftIndex;
                    continue;
                }
                long leftWeights = this.weights[leftValueIndex];
                if (currentWeight <= leftWeights) break;
                this.swapHeapNode(index, leftIndex);
                index = leftIndex;
            }
            return;
        }
    }

    private void swapHeapNode(int a, int b) {
        if (this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[a] >= 0) {
            this.heapIndex[this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[a]] = b;
        }
        if (this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[b] >= 0) {
            this.heapIndex[this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[b]] = a;
        }
        int temp = this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[a];
        this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[a] = this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[b];
        this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[b] = temp;
    }

    private void insertKnownNewHeavy(int hashCode, T item, long count) {
        int hashTableIndex;
        this.removeHash(this.lowestHitterIndex());
        this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[0] = hashTableIndex = this.insert(hashCode, item, count);
        this.heapIndex[hashTableIndex] = 0;
        this.fixHeap(0);
    }

    private void removeHash(int index) {
        if (index >= 0) {
            ScalaRunTime$.MODULE$.array_update(this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$items, index, null);
            this.heapIndex[index] = -1;
            this.hashes[index] = 0;
            this.weights[index] = 0L;
            return;
        }
    }

    private int insert(int hashCode, T item, long count) {
        int index = hashCode & this.mask();
        while (ScalaRunTime$.MODULE$.array_apply(this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$items, index) != null) {
            index = index + 1 & this.mask();
        }
        this.hashes[index] = hashCode;
        ScalaRunTime$.MODULE$.array_update(this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$items, index, item);
        this.weights[index] = count;
        return index;
    }

    public long lowestHitterWeight() {
        int index = this.lowestHitterIndex();
        if (index >= 0) {
            return this.weights[index];
        }
        return 0L;
    }

    private int lowestHitterIndex() {
        return this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$heap[0];
    }

    public String toString() {
        return new StringBuilder(6).append(this.getClass().getSimpleName()).append("(max:").append(this.max()).append(")").toString();
    }

    private static final Object $init$$$anonfun$1() {
        return "Maximum numbers of heavy hitters should be in form of 2^k for any natural k";
    }

    private static final int $init$$$anonfun$2() {
        return -1;
    }

    private static final int $init$$$anonfun$3() {
        return -1;
    }

    private final int loop$1(int index, int start, int hashCodeVal, Object o) {
        while (index != start) {
            if (hashCodeVal == this.hashes[index]) {
                Object item = ScalaRunTime$.MODULE$.array_apply(this.org$apache$pekko$remote$artery$compress$TopHeavyHitters$$items, index);
                if (Objects.equals(item, o)) {
                    return index;
                }
                index = index + 1 & this.mask();
                continue;
            }
            index = index + 1 & this.mask();
        }
        return -1;
    }

    public static final class HashCodeVal {
        private final int get;

        public static boolean equals$extension(int n, Object object) {
            return TopHeavyHitters$HashCodeVal$.MODULE$.equals$extension(n, object);
        }

        public static int hashCode$extension(int n) {
            return TopHeavyHitters$HashCodeVal$.MODULE$.hashCode$extension(n);
        }

        public HashCodeVal(int get) {
            this.get = get;
        }

        public int hashCode() {
            return TopHeavyHitters$HashCodeVal$.MODULE$.hashCode$extension(this.get());
        }

        public boolean equals(Object x$0) {
            return TopHeavyHitters$HashCodeVal$.MODULE$.equals$extension(this.get(), x$0);
        }

        public int get() {
            return this.get;
        }
    }
}

