/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.tcp.ssl;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.remote.artery.tcp.ssl.SessionVerifier;
import org.apache.pekko.remote.artery.tcp.ssl.X509Readers$;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Set;

@InternalApi
public final class PeerSubjectVerifier
implements SessionVerifier {
    private final X509Certificate peerCertificate;

    public PeerSubjectVerifier(X509Certificate peerCertificate) {
        this.peerCertificate = peerCertificate;
    }

    @Override
    public Option<Throwable> verifyClientSession(String hostname, SSLSession session) {
        return this.verifyPeerCertificates(session);
    }

    @Override
    public Option<Throwable> verifyServerSession(String hostname, SSLSession session) {
        return this.verifyPeerCertificates(session);
    }

    private Option<IllegalArgumentException> verifyPeerCertificates(SSLSession session) {
        Certificate certificate;
        Set<String> mySubjectNames = X509Readers$.MODULE$.getAllSubjectNames(this.peerCertificate);
        if (session.getPeerCertificates().length == 0) {
            Some$.MODULE$.apply((Object)new IllegalArgumentException("No peer certificates"));
        }
        if ((certificate = session.getPeerCertificates()[0]) instanceof X509Certificate) {
            X509Certificate x509 = (X509Certificate)certificate;
            Set<String> peerSubjectNames = X509Readers$.MODULE$.getAllSubjectNames(x509);
            if (mySubjectNames.exists(peerSubjectNames)) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply((Object)new IllegalArgumentException(new StringBuilder(60).append("None of the peer subject names ").append(peerSubjectNames).append(" were in local subject names ").append(mySubjectNames).toString()));
        }
        Certificate other = certificate;
        return Some$.MODULE$.apply((Object)new IllegalArgumentException(new StringBuilder(26).append("Unknown certificate type: ").append(other.getClass()).toString()));
    }
}

