/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.tcp.ssl;

import com.typesafe.config.Config;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.japi.Util$;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;

@InternalApi
public class SSLEngineConfig {
    private final String SSLRandomNumberGenerator;
    private final String SSLProtocol;
    private final Set SSLEnabledAlgorithms;
    private final boolean SSLRequireMutualAuthentication;
    private final boolean HostnameVerification;
    private final FiniteDuration SSLContextCacheTime;

    public SSLEngineConfig(Config config) {
        this.SSLRandomNumberGenerator = config.getString("random-number-generator");
        this.SSLProtocol = config.getString("protocol");
        this.SSLEnabledAlgorithms = Util$.MODULE$.immutableSeq((Iterable)config.getStringList("enabled-algorithms")).toSet();
        this.SSLRequireMutualAuthentication = config.hasPath("require-mutual-authentication") ? config.getBoolean("require-mutual-authentication") : false;
        this.HostnameVerification = config.hasPath("hostname-verification") ? config.getBoolean("hostname-verification") : false;
        this.SSLContextCacheTime = config.hasPath("ssl-context-cache-ttl") ? new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("ssl-context-cache-ttl").toMillis())).millis() : new package.DurationInt(package$.MODULE$.DurationInt(1024)).days();
    }

    public String SSLRandomNumberGenerator() {
        return this.SSLRandomNumberGenerator;
    }

    public String SSLProtocol() {
        return this.SSLProtocol;
    }

    public Set<String> SSLEnabledAlgorithms() {
        return this.SSLEnabledAlgorithms;
    }

    public boolean SSLRequireMutualAuthentication() {
        return this.SSLRequireMutualAuthentication;
    }

    public boolean HostnameVerification() {
        return this.HostnameVerification;
    }

    public FiniteDuration SSLContextCacheTime() {
        return this.SSLContextCacheTime;
    }
}

