/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.serialization;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.Done$;
import org.apache.pekko.NotUsed$;
import org.apache.pekko.actor.ActorIdentity;
import org.apache.pekko.actor.ActorIdentity$;
import org.apache.pekko.actor.ActorInitializationException;
import org.apache.pekko.actor.ActorInitializationException$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Identify;
import org.apache.pekko.actor.Identify$;
import org.apache.pekko.actor.Kill$;
import org.apache.pekko.actor.LocalScope$;
import org.apache.pekko.actor.PoisonPill$;
import org.apache.pekko.actor.Status;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.pattern.StatusReply;
import org.apache.pekko.pattern.StatusReply$;
import org.apache.pekko.remote.ArteryControlFormats;
import org.apache.pekko.remote.ContainerFormats;
import org.apache.pekko.remote.RemoteScope;
import org.apache.pekko.remote.RemoteScope$;
import org.apache.pekko.remote.RemoteWatcher;
import org.apache.pekko.remote.RemoteWatcher$Heartbeat$;
import org.apache.pekko.remote.RemoteWatcher$HeartbeatRsp$;
import org.apache.pekko.remote.UniqueAddress;
import org.apache.pekko.remote.UniqueAddress$;
import org.apache.pekko.remote.WireFormats;
import org.apache.pekko.remote.routing.RemoteRouterConfig;
import org.apache.pekko.remote.routing.RemoteRouterConfig$;
import org.apache.pekko.remote.serialization.ThrowableNotSerializableException;
import org.apache.pekko.remote.serialization.ThrowableSupport;
import org.apache.pekko.remote.serialization.WrappedPayloadSupport;
import org.apache.pekko.routing.BalancingPool;
import org.apache.pekko.routing.BalancingPool$;
import org.apache.pekko.routing.BroadcastPool;
import org.apache.pekko.routing.BroadcastPool$;
import org.apache.pekko.routing.DefaultResizer;
import org.apache.pekko.routing.DefaultResizer$;
import org.apache.pekko.routing.FromConfig;
import org.apache.pekko.routing.FromConfig$;
import org.apache.pekko.routing.Pool;
import org.apache.pekko.routing.RandomPool;
import org.apache.pekko.routing.RandomPool$;
import org.apache.pekko.routing.Resizer;
import org.apache.pekko.routing.RoundRobinPool;
import org.apache.pekko.routing.RoundRobinPool$;
import org.apache.pekko.routing.ScatterGatherFirstCompletedPool;
import org.apache.pekko.routing.ScatterGatherFirstCompletedPool$;
import org.apache.pekko.routing.TailChoppingPool;
import org.apache.pekko.routing.TailChoppingPool$;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.util.ccompat.package;
import scala.Array$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class MiscMessageSerializer
extends SerializerWithStringManifest
implements BaseSerializer {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MiscMessageSerializer.class.getDeclaredField("serialization$lzy1"));
    private int identifier;
    private final ExtendedActorSystem system;
    private volatile Object serialization$lzy1;
    private final WrappedPayloadSupport payloadSupport;
    private final ThrowableSupport throwableSupport;
    private final byte[] ParameterlessSerializedMessage;
    private final Config EmptyConfig;
    private final String IdentifyManifest;
    private final String ActorIdentityManifest;
    private final String OptionManifest;
    private final String StatusSuccessManifest;
    private final String StatusFailureManifest;
    private final String ThrowableManifest;
    private final String ActorRefManifest;
    private final String OptionalManifest;
    private final String PoisonPillManifest;
    private final String KillManifest;
    private final String RemoteWatcherHBManifest;
    private final String DoneManifest;
    private final String NotUsedManifest;
    private final String AddressManifest;
    private final String UniqueAddressManifest;
    private final String RemoteWatcherHBRespManifest;
    private final String ActorInitializationExceptionManifest;
    private final String ThrowableNotSerializableExceptionManifest;
    private final String LocalScopeManifest;
    private final String RemoteScopeManifest;
    private final String ConfigManifest;
    private final String FromConfigManifest;
    private final String DefaultResizerManifest;
    private final String BalancingPoolManifest;
    private final String BroadcastPoolManifest;
    private final String RandomPoolManifest;
    private final String RoundRobinPoolManifest;
    private final String ScatterGatherPoolManifest;
    private final String TailChoppingPoolManifest;
    private final String RemoteRouterConfigManifest;
    private final String StatusReplySuccessManifest;
    private final String StatusReplyErrorMessageManifest;
    private final String StatusReplyErrorExceptionManifest;
    private final String StatusReplyAckManifest;
    private final Map<String, Function1<byte[], Object>> fromBinaryMap;

    public MiscMessageSerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$((BaseSerializer)this);
        this.payloadSupport = new WrappedPayloadSupport(system);
        this.throwableSupport = new ThrowableSupport(system);
        this.ParameterlessSerializedMessage = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE));
        this.EmptyConfig = ConfigFactory.empty();
        this.IdentifyManifest = "A";
        this.ActorIdentityManifest = "B";
        this.OptionManifest = "C";
        this.StatusSuccessManifest = "D";
        this.StatusFailureManifest = "E";
        this.ThrowableManifest = "F";
        this.ActorRefManifest = "G";
        this.OptionalManifest = "H";
        this.PoisonPillManifest = "P";
        this.KillManifest = "K";
        this.RemoteWatcherHBManifest = "RWHB";
        this.DoneManifest = "DONE";
        this.NotUsedManifest = "NU";
        this.AddressManifest = "AD";
        this.UniqueAddressManifest = "UD";
        this.RemoteWatcherHBRespManifest = "RWHR";
        this.ActorInitializationExceptionManifest = "AIEX";
        this.ThrowableNotSerializableExceptionManifest = "TNSEX";
        this.LocalScopeManifest = "LS";
        this.RemoteScopeManifest = "RS";
        this.ConfigManifest = "CF";
        this.FromConfigManifest = "FC";
        this.DefaultResizerManifest = "DR";
        this.BalancingPoolManifest = "ROBAP";
        this.BroadcastPoolManifest = "ROBP";
        this.RandomPoolManifest = "RORP";
        this.RoundRobinPoolManifest = "RORRP";
        this.ScatterGatherPoolManifest = "ROSGP";
        this.TailChoppingPoolManifest = "ROTCP";
        this.RemoteRouterConfigManifest = "RORRC";
        this.StatusReplySuccessManifest = "S";
        this.StatusReplyErrorMessageManifest = "SM";
        this.StatusReplyErrorExceptionManifest = "SE";
        this.StatusReplyAckManifest = "SA";
        Object[] objectArray = new Tuple2[34];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.IdentifyManifest);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Function1 & Serializable)bytes -> this.deserializeIdentify((byte[])bytes));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.ActorIdentityManifest);
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Function1 & Serializable)bytes -> this.deserializeActorIdentity((byte[])bytes));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.StatusSuccessManifest);
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Function1 & Serializable)bytes -> this.deserializeStatusSuccess((byte[])bytes));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.StatusFailureManifest);
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Function1 & Serializable)bytes -> this.deserializeStatusFailure((byte[])bytes));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.StatusReplyAckManifest);
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Function1 & Serializable)_$1 -> StatusReply$.MODULE$.Ack());
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.StatusReplySuccessManifest);
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Function1 & Serializable)bytes -> this.deserializeStatusReplySuccess((byte[])bytes));
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.StatusReplyErrorMessageManifest);
        objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Function1 & Serializable)bytes -> this.deserializeStatusReplyErrorMessage((byte[])bytes));
        String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.StatusReplyErrorExceptionManifest);
        objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Function1 & Serializable)bytes -> this.deserializeStatusReplyErrorException((byte[])bytes));
        String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.ThrowableManifest);
        objectArray[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Function1 & Serializable)bytes -> this.throwableSupport.deserializeThrowable((byte[])bytes));
        String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.ActorRefManifest);
        objectArray[9] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (Function1 & Serializable)bytes -> this.deserializeActorRefBytes((byte[])bytes));
        String string11 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.OptionManifest);
        objectArray[10] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string11, (Function1 & Serializable)bytes -> this.deserializeOption((byte[])bytes));
        String string12 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.OptionalManifest);
        objectArray[11] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string12, (Function1 & Serializable)bytes -> this.deserializeOptional((byte[])bytes));
        String string13 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.PoisonPillManifest);
        objectArray[12] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string13, (Function1 & Serializable)_$2 -> PoisonPill$.MODULE$);
        String string14 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.KillManifest);
        objectArray[13] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string14, (Function1 & Serializable)_$3 -> Kill$.MODULE$);
        String string15 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.RemoteWatcherHBManifest);
        objectArray[14] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string15, (Function1 & Serializable)_$4 -> RemoteWatcher$Heartbeat$.MODULE$);
        String string16 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DoneManifest);
        objectArray[15] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string16, (Function1 & Serializable)_$5 -> Done$.MODULE$);
        String string17 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.NotUsedManifest);
        objectArray[16] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string17, (Function1 & Serializable)_$6 -> NotUsed$.MODULE$);
        String string18 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.AddressManifest);
        objectArray[17] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string18, (Function1 & Serializable)bytes -> this.deserializeAddressData((byte[])bytes));
        String string19 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.UniqueAddressManifest);
        objectArray[18] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string19, (Function1 & Serializable)bytes -> this.deserializeUniqueAddress((byte[])bytes));
        String string20 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.RemoteWatcherHBRespManifest);
        objectArray[19] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string20, (Function1 & Serializable)bytes -> this.deserializeHeartbeatRsp((byte[])bytes));
        String string21 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.ActorInitializationExceptionManifest);
        objectArray[20] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string21, (Function1 & Serializable)bytes -> this.deserializeActorInitializationException((byte[])bytes));
        String string22 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.ThrowableNotSerializableExceptionManifest);
        objectArray[21] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string22, (Function1 & Serializable)bytes -> this.deserializeThrowableNotSerializableException((byte[])bytes));
        String string23 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.LocalScopeManifest);
        objectArray[22] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string23, (Function1 & Serializable)_$7 -> LocalScope$.MODULE$);
        String string24 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.RemoteScopeManifest);
        objectArray[23] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string24, (Function1 & Serializable)bytes -> this.deserializeRemoteScope((byte[])bytes));
        String string25 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.ConfigManifest);
        objectArray[24] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string25, (Function1 & Serializable)bytes -> this.deserializeConfig((byte[])bytes));
        String string26 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.FromConfigManifest);
        objectArray[25] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string26, (Function1 & Serializable)bytes -> this.deserializeFromConfig((byte[])bytes));
        String string27 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DefaultResizerManifest);
        objectArray[26] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string27, (Function1 & Serializable)bytes -> this.deserializeDefaultResizer((byte[])bytes));
        String string28 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.BalancingPoolManifest);
        objectArray[27] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string28, (Function1 & Serializable)bytes -> this.deserializeBalancingPool((byte[])bytes));
        String string29 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.BroadcastPoolManifest);
        objectArray[28] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string29, (Function1 & Serializable)bytes -> this.deserializeBroadcastPool((byte[])bytes));
        String string30 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.RandomPoolManifest);
        objectArray[29] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string30, (Function1 & Serializable)bytes -> this.deserializeRandomPool((byte[])bytes));
        String string31 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.RoundRobinPoolManifest);
        objectArray[30] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string31, (Function1 & Serializable)bytes -> this.deserializeRoundRobinPool((byte[])bytes));
        String string32 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.ScatterGatherPoolManifest);
        objectArray[31] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string32, (Function1 & Serializable)bytes -> this.deserializeScatterGatherPool((byte[])bytes));
        String string33 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.TailChoppingPoolManifest);
        objectArray[32] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string33, (Function1 & Serializable)bytes -> this.deserializeTailChoppingPool((byte[])bytes));
        String string34 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.RemoteRouterConfigManifest);
        objectArray[33] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string34, (Function1 & Serializable)bytes -> this.deserializeRemoteRouterConfig((byte[])bytes));
        this.fromBinaryMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Statics.releaseFence();
    }

    public int identifier() {
        return this.identifier;
    }

    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$0) {
        this.identifier = x$0;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization() {
        Object object = this.serialization$lzy1;
        if (object instanceof Serialization) {
            return (Serialization)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Serialization)this.serialization$lzyINIT1();
    }

    private Object serialization$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.serialization$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Serialization serialization = null;
                    try {
                        serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                        object2 = serialization == null ? LazyVals.NullValue$.MODULE$ : serialization;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.serialization$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serialization;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public byte[] toBinary(Object obj) {
        Object object = obj;
        if (object instanceof Identify) {
            Identify identify = (Identify)object;
            return this.serializeIdentify(identify);
        }
        if (object instanceof ActorIdentity) {
            ActorIdentity identity = (ActorIdentity)object;
            return this.serializeActorIdentity(identity);
        }
        if (object instanceof Some) {
            Object value = ((Some)object).value();
            return this.serializeSome(value);
        }
        if (None$.MODULE$.equals(object)) {
            return this.ParameterlessSerializedMessage;
        }
        if (object instanceof Optional) {
            Optional o = (Optional)object;
            return this.serializeOptional(o);
        }
        if (object instanceof ActorRef) {
            ActorRef r = (ActorRef)object;
            return this.serializeActorRef(r);
        }
        if (object instanceof Status.Success) {
            Status.Success s = (Status.Success)object;
            return this.serializeStatusSuccess(s);
        }
        if (object instanceof Status.Failure) {
            Status.Failure f = (Status.Failure)object;
            return this.serializeStatusFailure(f);
        }
        StatusReply statusReply = StatusReply$.MODULE$.Ack();
        Object object2 = object;
        if (!(statusReply != null ? !statusReply.equals(object2) : object2 != null)) {
            return Array$.MODULE$.emptyByteArray();
        }
        if (object instanceof StatusReply) {
            StatusReply statusReply2 = (StatusReply)object;
            Option option = StatusReply.Success$.MODULE$.unapply(statusReply2);
            if (!option.isEmpty()) {
                Object object3 = option.get();
                StatusReply r = statusReply2;
                return this.serializeStatusReplySuccess((StatusReply<Object>)r);
            }
            Option option2 = StatusReply.Error$.MODULE$.unapply(statusReply2);
            if (!option2.isEmpty()) {
                Throwable throwable = (Throwable)option2.get();
                StatusReply r = statusReply2;
                return this.serializeStatusReplyError(r);
            }
        }
        if (object instanceof ActorInitializationException) {
            ActorInitializationException ex = (ActorInitializationException)object;
            return this.serializeActorInitializationException(ex);
        }
        if (object instanceof ThrowableNotSerializableException) {
            ThrowableNotSerializableException ex = (ThrowableNotSerializableException)object;
            return this.serializeThrowableNotSerializableException(ex);
        }
        if (object instanceof Throwable) {
            Throwable t = (Throwable)object;
            return this.throwableSupport.serializeThrowable(t);
        }
        if (PoisonPill$.MODULE$.equals(object)) {
            return this.ParameterlessSerializedMessage;
        }
        if (Kill$.MODULE$.equals(object)) {
            return this.ParameterlessSerializedMessage;
        }
        if (RemoteWatcher$Heartbeat$.MODULE$.equals(object)) {
            return this.ParameterlessSerializedMessage;
        }
        if (Done$.MODULE$.equals(object)) {
            return this.ParameterlessSerializedMessage;
        }
        if (NotUsed$.MODULE$.equals(object)) {
            return this.ParameterlessSerializedMessage;
        }
        if (object instanceof RemoteWatcher.HeartbeatRsp) {
            RemoteWatcher.HeartbeatRsp hbrsp = (RemoteWatcher.HeartbeatRsp)object;
            return this.serializeHeartbeatRsp(hbrsp);
        }
        if (object instanceof RemoteScope) {
            RemoteScope rs = (RemoteScope)object;
            return this.serializeRemoteScope(rs);
        }
        if (LocalScope$.MODULE$.equals(object)) {
            return this.ParameterlessSerializedMessage;
        }
        if (object instanceof Address) {
            Address a = (Address)object;
            return this.serializeAddressData(a);
        }
        if (object instanceof UniqueAddress) {
            UniqueAddress u = (UniqueAddress)object;
            return this.serializeClassicUniqueAddress(u);
        }
        if (object instanceof Config) {
            Config c = (Config)object;
            return this.serializeConfig(c);
        }
        if (object instanceof DefaultResizer) {
            DefaultResizer dr = (DefaultResizer)object;
            return this.serializeDefaultResizer(dr);
        }
        if (object instanceof FromConfig) {
            FromConfig fc = (FromConfig)object;
            return this.serializeFromConfig(fc);
        }
        if (object instanceof BalancingPool) {
            BalancingPool bp = (BalancingPool)object;
            return this.serializeBalancingPool(bp);
        }
        if (object instanceof BroadcastPool) {
            BroadcastPool bp = (BroadcastPool)object;
            return this.serializeBroadcastPool(bp);
        }
        if (object instanceof RandomPool) {
            RandomPool rp = (RandomPool)object;
            return this.serializeRandomPool(rp);
        }
        if (object instanceof RoundRobinPool) {
            RoundRobinPool rrp = (RoundRobinPool)object;
            return this.serializeRoundRobinPool(rrp);
        }
        if (object instanceof ScatterGatherFirstCompletedPool) {
            ScatterGatherFirstCompletedPool sgp = (ScatterGatherFirstCompletedPool)object;
            return this.serializeScatterGatherFirstCompletedPool(sgp);
        }
        if (object instanceof TailChoppingPool) {
            TailChoppingPool tp = (TailChoppingPool)object;
            return this.serializeTailChoppingPool(tp);
        }
        if (object instanceof RemoteRouterConfig) {
            RemoteRouterConfig rrc = (RemoteRouterConfig)object;
            return this.serializeRemoteRouterConfig(rrc);
        }
        throw new IllegalArgumentException(new StringBuilder(34).append("Cannot serialize object of type [").append(obj.getClass().getName()).append("]").toString());
    }

    private byte[] serializeIdentify(Identify identify) {
        return ContainerFormats.Identify.newBuilder().setMessageId(this.payloadSupport.payloadBuilder(identify.messageId())).build().toByteArray();
    }

    private byte[] serializeActorIdentity(ActorIdentity actorIdentity) {
        ContainerFormats.ActorIdentity.Builder builder = ContainerFormats.ActorIdentity.newBuilder().setCorrelationId(this.payloadSupport.payloadBuilder(actorIdentity.correlationId()));
        actorIdentity.ref().foreach((Function1 & Serializable)actorRef -> builder.setRef(this.actorRefBuilder((ActorRef)actorRef)));
        return builder.build().toByteArray();
    }

    private byte[] serializeSome(Object someValue) {
        return ContainerFormats.Option.newBuilder().setValue(this.payloadSupport.payloadBuilder(someValue)).build().toByteArray();
    }

    private byte[] serializeOptional(Optional<?> opt) {
        if (opt.isPresent()) {
            return ContainerFormats.Option.newBuilder().setValue(this.payloadSupport.payloadBuilder(opt.get())).build().toByteArray();
        }
        return this.ParameterlessSerializedMessage;
    }

    private byte[] serializeActorRef(ActorRef ref) {
        return this.actorRefBuilder(ref).build().toByteArray();
    }

    private byte[] serializeHeartbeatRsp(RemoteWatcher.HeartbeatRsp hbrsp) {
        return ContainerFormats.WatcherHeartbeatResponse.newBuilder().setUid(Int$.MODULE$.int2long(hbrsp.addressUid())).build().toByteArray();
    }

    private byte[] serializeRemoteScope(RemoteScope rs) {
        WireFormats.RemoteScope.Builder builder = WireFormats.RemoteScope.newBuilder();
        builder.setNode(this.buildAddressData(rs.node()));
        return builder.build().toByteArray();
    }

    private ContainerFormats.ActorRef.Builder actorRefBuilder(ActorRef actorRef) {
        return ContainerFormats.ActorRef.newBuilder().setPath(Serialization$.MODULE$.serializedActorPath(actorRef));
    }

    private byte[] serializeStatusSuccess(Status.Success success) {
        return this.payloadSupport.payloadBuilder(success.status()).build().toByteArray();
    }

    private byte[] serializeStatusFailure(Status.Failure failure) {
        return this.payloadSupport.payloadBuilder(failure.cause()).build().toByteArray();
    }

    public byte[] serializeStatusReplySuccess(StatusReply<Object> r) {
        return this.payloadSupport.payloadBuilder(r.getValue()).build().toByteArray();
    }

    public byte[] serializeStatusReplyError(StatusReply<?> r) {
        Throwable throwable = r.getError();
        if (throwable instanceof StatusReply.ErrorMessage) {
            StatusReply.ErrorMessage em = (StatusReply.ErrorMessage)throwable;
            return ContainerFormats.StatusReplyErrorMessage.newBuilder().setErrorMessage(em.getMessage()).build().toByteArray();
        }
        if (throwable != null) {
            Throwable ex = throwable;
            return this.payloadSupport.payloadBuilder(ex).build().toByteArray();
        }
        throw new MatchError((Object)throwable);
    }

    private byte[] serializeActorInitializationException(ActorInitializationException ex) {
        ContainerFormats.ActorInitializationException.Builder builder = ContainerFormats.ActorInitializationException.newBuilder();
        if (ex.getActor() != null) {
            builder.setActor(this.actorRefBuilder(ex.getActor()));
        }
        return builder.setMessage(ex.getMessage()).setCause(this.payloadSupport.payloadBuilder(ex.getCause())).build().toByteArray();
    }

    private byte[] serializeThrowableNotSerializableException(ThrowableNotSerializableException ex) {
        ContainerFormats.ThrowableNotSerializable.Builder builder = ContainerFormats.ThrowableNotSerializable.newBuilder();
        builder.setMessage(ex.getMessage());
        ContainerFormats.ThrowableNotSerializable.Builder builder2 = ex.originalMessage() == null ? builder.setOriginalMessage("") : builder.setOriginalMessage(ex.originalMessage());
        builder.setOriginalClassName(ex.originalClassName());
        return builder.build().toByteArray();
    }

    private byte[] serializeConfig(Config c) {
        return c.root().render(ConfigRenderOptions.concise()).getBytes(StandardCharsets.UTF_8);
    }

    private WireFormats.AddressData.Builder protoForAddressData(Address address) {
        Address address2 = address;
        if (address2 != null) {
            Address address3 = Address$.MODULE$.unapply(address2);
            String string = address3._1();
            String string2 = address3._2();
            Option option = address3._3();
            Option option2 = address3._4();
            String protocol = string;
            String actorSystem = string2;
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return WireFormats.AddressData.newBuilder().setSystem(actorSystem).setHostname(host).setPort(port).setProtocol(protocol);
                }
            }
        }
        throw new IllegalArgumentException(new StringBuilder(57).append("Address [").append(address).append("] could not be serialized: host or port missing.").toString());
    }

    private ArteryControlFormats.Address.Builder protoForAddress(Address address) {
        Address address2 = address;
        if (address2 != null) {
            Address address3 = Address$.MODULE$.unapply(address2);
            String string = address3._1();
            String string2 = address3._2();
            Option option = address3._3();
            Option option2 = address3._4();
            String protocol = string;
            String actorSystem = string2;
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return ArteryControlFormats.Address.newBuilder().setSystem(actorSystem).setHostname(host).setPort(port).setProtocol(protocol);
                }
            }
        }
        throw new IllegalArgumentException(new StringBuilder(57).append("Address [").append(address).append("] could not be serialized: host or port missing.").toString());
    }

    private byte[] serializeAddressData(Address address) {
        return this.protoForAddressData(address).build().toByteArray();
    }

    private byte[] serializeClassicUniqueAddress(UniqueAddress uniqueAddress) {
        return ArteryControlFormats.UniqueAddress.newBuilder().setUid(uniqueAddress.uid()).setAddress(this.protoForAddress(uniqueAddress.address())).build().toByteArray();
    }

    private byte[] serializeDefaultResizer(DefaultResizer dr) {
        WireFormats.DefaultResizer.Builder builder = WireFormats.DefaultResizer.newBuilder();
        builder.setBackoffRate(dr.backoffRate());
        builder.setBackoffThreshold(dr.backoffThreshold());
        builder.setLowerBound(dr.lowerBound());
        builder.setMessagesPerResize(dr.messagesPerResize());
        builder.setPressureThreshold(dr.pressureThreshold());
        builder.setRampupRate(dr.rampupRate());
        builder.setUpperBound(dr.upperBound());
        return builder.build().toByteArray();
    }

    private byte[] serializeFromConfig(FromConfig fc) {
        FromConfig fromConfig = fc;
        FromConfig$ fromConfig$ = FromConfig$.MODULE$;
        if (!(fromConfig != null ? !fromConfig.equals(fromConfig$) : fromConfig$ != null)) {
            return this.ParameterlessSerializedMessage;
        }
        WireFormats.FromConfig.Builder builder = WireFormats.FromConfig.newBuilder();
        if (fc.resizer().isDefined()) {
            builder.setResizer(this.payloadSupport.payloadBuilder(fc.resizer().get()));
        }
        String string = fc.routerDispatcher();
        String string2 = "pekko.actor.default-dispatcher";
        if (string == null ? string2 != null : !string.equals(string2)) {
            builder.setRouterDispatcher(fc.routerDispatcher());
        }
        return builder.build().toByteArray();
    }

    private byte[] serializeBalancingPool(BalancingPool bp) {
        return this.buildGenericRoutingPool(bp.nrOfInstances(), bp.routerDispatcher(), bp.usePoolDispatcher(), (Option<Resizer>)bp.resizer()).toByteArray();
    }

    private byte[] serializeBroadcastPool(BroadcastPool bp) {
        return this.buildGenericRoutingPool(bp.nrOfInstances(), bp.routerDispatcher(), bp.usePoolDispatcher(), (Option<Resizer>)bp.resizer()).toByteArray();
    }

    private byte[] serializeRandomPool(RandomPool rp) {
        return this.buildGenericRoutingPool(rp.nrOfInstances(), rp.routerDispatcher(), rp.usePoolDispatcher(), (Option<Resizer>)rp.resizer()).toByteArray();
    }

    private byte[] serializeRoundRobinPool(RoundRobinPool rp) {
        return this.buildGenericRoutingPool(rp.nrOfInstances(), rp.routerDispatcher(), rp.usePoolDispatcher(), (Option<Resizer>)rp.resizer()).toByteArray();
    }

    private byte[] serializeScatterGatherFirstCompletedPool(ScatterGatherFirstCompletedPool sgp) {
        WireFormats.ScatterGatherPool.Builder builder = WireFormats.ScatterGatherPool.newBuilder();
        builder.setGeneric(this.buildGenericRoutingPool(sgp.nrOfInstances(), sgp.routerDispatcher(), sgp.usePoolDispatcher(), (Option<Resizer>)sgp.resizer()));
        builder.setWithin(this.buildFiniteDuration(sgp.within()));
        return builder.build().toByteArray();
    }

    private byte[] serializeTailChoppingPool(TailChoppingPool tp) {
        WireFormats.TailChoppingPool.Builder builder = WireFormats.TailChoppingPool.newBuilder();
        builder.setGeneric(this.buildGenericRoutingPool(tp.nrOfInstances(), tp.routerDispatcher(), tp.usePoolDispatcher(), (Option<Resizer>)tp.resizer()));
        builder.setWithin(this.buildFiniteDuration(tp.within()));
        builder.setInterval(this.buildFiniteDuration(tp.interval()));
        return builder.build().toByteArray();
    }

    private byte[] serializeRemoteRouterConfig(RemoteRouterConfig rrc) {
        WireFormats.RemoteRouterConfig.Builder builder = WireFormats.RemoteRouterConfig.newBuilder();
        builder.setLocal(this.payloadSupport.payloadBuilder(rrc.local()).build());
        builder.addAllNodes(package.JavaConverters$.MODULE$.IterableHasAsJava((Iterable)rrc.nodes().map((Function1 & Serializable)address -> this.buildAddressData((Address)address))).asJava());
        return builder.build().toByteArray();
    }

    private WireFormats.GenericRoutingPool buildGenericRoutingPool(int nrOfInstances, String routerDispatcher, boolean usePoolDispatcher, Option<Resizer> resizer) {
        WireFormats.GenericRoutingPool.Builder builder = WireFormats.GenericRoutingPool.newBuilder();
        builder.setNrOfInstances(nrOfInstances);
        String string = routerDispatcher;
        String string2 = "pekko.actor.default-dispatcher";
        if (string == null ? string2 != null : !string.equals(string2)) {
            builder.setRouterDispatcher(routerDispatcher);
        }
        if (resizer.isDefined()) {
            builder.setResizer(this.payloadSupport.payloadBuilder(resizer.get()));
        }
        builder.setUsePoolDispatcher(usePoolDispatcher);
        return builder.build();
    }

    private WireFormats.TimeUnit timeUnitToWire(TimeUnit unit) {
        TimeUnit timeUnit = unit;
        TimeUnit timeUnit2 = TimeUnit.NANOSECONDS;
        TimeUnit timeUnit3 = timeUnit;
        if (!(timeUnit2 != null ? !((Object)((Object)timeUnit2)).equals((Object)timeUnit3) : timeUnit3 != null)) {
            return WireFormats.TimeUnit.NANOSECONDS;
        }
        TimeUnit timeUnit4 = TimeUnit.MICROSECONDS;
        TimeUnit timeUnit5 = timeUnit;
        if (!(timeUnit4 != null ? !((Object)((Object)timeUnit4)).equals((Object)timeUnit5) : timeUnit5 != null)) {
            return WireFormats.TimeUnit.MICROSECONDS;
        }
        TimeUnit timeUnit6 = TimeUnit.MILLISECONDS;
        TimeUnit timeUnit7 = timeUnit;
        if (!(timeUnit6 != null ? !((Object)((Object)timeUnit6)).equals((Object)timeUnit7) : timeUnit7 != null)) {
            return WireFormats.TimeUnit.MILLISECONDS;
        }
        TimeUnit timeUnit8 = TimeUnit.SECONDS;
        TimeUnit timeUnit9 = timeUnit;
        if (!(timeUnit8 != null ? !((Object)((Object)timeUnit8)).equals((Object)timeUnit9) : timeUnit9 != null)) {
            return WireFormats.TimeUnit.SECONDS;
        }
        TimeUnit timeUnit10 = TimeUnit.MINUTES;
        TimeUnit timeUnit11 = timeUnit;
        if (!(timeUnit10 != null ? !((Object)((Object)timeUnit10)).equals((Object)timeUnit11) : timeUnit11 != null)) {
            return WireFormats.TimeUnit.MINUTES;
        }
        TimeUnit timeUnit12 = TimeUnit.HOURS;
        TimeUnit timeUnit13 = timeUnit;
        if (!(timeUnit12 != null ? !((Object)((Object)timeUnit12)).equals((Object)timeUnit13) : timeUnit13 != null)) {
            return WireFormats.TimeUnit.HOURS;
        }
        TimeUnit timeUnit14 = TimeUnit.DAYS;
        TimeUnit timeUnit15 = timeUnit;
        if (!(timeUnit14 != null ? !((Object)((Object)timeUnit14)).equals((Object)timeUnit15) : timeUnit15 != null)) {
            return WireFormats.TimeUnit.DAYS;
        }
        throw new MatchError((Object)timeUnit);
    }

    private WireFormats.FiniteDuration buildFiniteDuration(FiniteDuration duration) {
        return WireFormats.FiniteDuration.newBuilder().setValue(duration.length()).setUnit(this.timeUnitToWire(duration.unit())).build();
    }

    private WireFormats.AddressData buildAddressData(Address address) {
        WireFormats.AddressData.Builder builder = WireFormats.AddressData.newBuilder();
        Address address2 = address;
        if (address2 != null) {
            Address address3 = Address$.MODULE$.unapply(address2);
            String string = address3._1();
            String string2 = address3._2();
            Option option = address3._3();
            Option option2 = address3._4();
            String protocol = string;
            String system = string2;
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    builder.setProtocol(protocol);
                    builder.setSystem(system);
                    builder.setHostname(host);
                    builder.setPort(port);
                    return builder.build();
                }
            }
        }
        throw new IllegalArgumentException(new StringBuilder(57).append("Address [").append(address).append("] could not be serialized: host or port missing.").toString());
    }

    public String manifest(Object o) {
        Object object = o;
        if (object instanceof Identify) {
            return this.IdentifyManifest;
        }
        if (object instanceof ActorIdentity) {
            return this.ActorIdentityManifest;
        }
        if (object instanceof Option) {
            return this.OptionManifest;
        }
        if (object instanceof Optional) {
            return this.OptionalManifest;
        }
        if (object instanceof ActorRef) {
            return this.ActorRefManifest;
        }
        if (object instanceof Status.Success) {
            return this.StatusSuccessManifest;
        }
        if (object instanceof Status.Failure) {
            return this.StatusFailureManifest;
        }
        StatusReply statusReply = StatusReply$.MODULE$.Ack();
        Object object2 = object;
        if (!(statusReply != null ? !statusReply.equals(object2) : object2 != null)) {
            return this.StatusReplyAckManifest;
        }
        if (object instanceof StatusReply) {
            StatusReply statusReply2 = (StatusReply)object;
            Option option = StatusReply.Success$.MODULE$.unapply(statusReply2);
            if (!option.isEmpty()) {
                Object object3 = option.get();
                return this.StatusReplySuccessManifest;
            }
            Option option2 = StatusReply.Error$.MODULE$.unapply(statusReply2);
            if (!option2.isEmpty()) {
                Throwable throwable = (Throwable)option2.get();
                if (throwable instanceof StatusReply.ErrorMessage) {
                    return this.StatusReplyErrorMessageManifest;
                }
                return this.StatusReplyErrorExceptionManifest;
            }
        }
        if (object instanceof ActorInitializationException) {
            return this.ActorInitializationExceptionManifest;
        }
        if (object instanceof ThrowableNotSerializableException) {
            return this.ThrowableNotSerializableExceptionManifest;
        }
        if (object instanceof Throwable) {
            return this.ThrowableManifest;
        }
        if (PoisonPill$.MODULE$.equals(object)) {
            return this.PoisonPillManifest;
        }
        if (Kill$.MODULE$.equals(object)) {
            return this.KillManifest;
        }
        if (RemoteWatcher$Heartbeat$.MODULE$.equals(object)) {
            return this.RemoteWatcherHBManifest;
        }
        if (Done$.MODULE$.equals(object)) {
            return this.DoneManifest;
        }
        if (NotUsed$.MODULE$.equals(object)) {
            return this.NotUsedManifest;
        }
        if (object instanceof Address) {
            return this.AddressManifest;
        }
        if (object instanceof UniqueAddress) {
            return this.UniqueAddressManifest;
        }
        if (object instanceof RemoteWatcher.HeartbeatRsp) {
            return this.RemoteWatcherHBRespManifest;
        }
        if (LocalScope$.MODULE$.equals(object)) {
            return this.LocalScopeManifest;
        }
        if (object instanceof RemoteScope) {
            return this.RemoteScopeManifest;
        }
        if (object instanceof Config) {
            return this.ConfigManifest;
        }
        if (object instanceof FromConfig) {
            return this.FromConfigManifest;
        }
        if (object instanceof DefaultResizer) {
            return this.DefaultResizerManifest;
        }
        if (object instanceof BalancingPool) {
            return this.BalancingPoolManifest;
        }
        if (object instanceof BroadcastPool) {
            return this.BroadcastPoolManifest;
        }
        if (object instanceof RandomPool) {
            return this.RandomPoolManifest;
        }
        if (object instanceof RoundRobinPool) {
            return this.RoundRobinPoolManifest;
        }
        if (object instanceof ScatterGatherFirstCompletedPool) {
            return this.ScatterGatherPoolManifest;
        }
        if (object instanceof TailChoppingPool) {
            return this.TailChoppingPoolManifest;
        }
        if (object instanceof RemoteRouterConfig) {
            return this.RemoteRouterConfigManifest;
        }
        throw new IllegalArgumentException(new StringBuilder(37).append("Can't serialize object of type ").append(o.getClass()).append(" in [").append(this.getClass().getName()).append("]").toString());
    }

    public Object fromBinary(byte[] bytes, String manifest) {
        Option option = this.fromBinaryMap.get((Object)manifest);
        if (option instanceof Some) {
            Function1 deserializer = (Function1)((Some)option).value();
            return deserializer.apply((Object)bytes);
        }
        if (None$.MODULE$.equals(option)) {
            throw new NotSerializableException(new StringBuilder(63).append("Unimplemented deserialization of message with manifest [").append(manifest).append("] in [").append(this.getClass().getName()).append("]").toString());
        }
        throw new MatchError((Object)option);
    }

    private Identify deserializeIdentify(byte[] bytes) {
        ContainerFormats.Identify identifyProto = ContainerFormats.Identify.parseFrom(bytes);
        Object messageId = this.payloadSupport.deserializePayload(identifyProto.getMessageId());
        return Identify$.MODULE$.apply(messageId);
    }

    private ActorIdentity deserializeActorIdentity(byte[] bytes) {
        ContainerFormats.ActorIdentity actorIdentityProto = ContainerFormats.ActorIdentity.parseFrom(bytes);
        Object correlationId = this.payloadSupport.deserializePayload(actorIdentityProto.getCorrelationId());
        None$ actorRef = actorIdentityProto.hasRef() ? Some$.MODULE$.apply((Object)this.deserializeActorRef(actorIdentityProto.getRef())) : None$.MODULE$;
        return ActorIdentity$.MODULE$.apply(correlationId, (Option)actorRef);
    }

    private ActorRef deserializeActorRefBytes(byte[] bytes) {
        return this.deserializeActorRef(ContainerFormats.ActorRef.parseFrom(bytes));
    }

    private ActorRef deserializeActorRef(ContainerFormats.ActorRef actorRef) {
        return this.serialization().system().provider().resolveActorRef(actorRef.getPath());
    }

    private Option<Object> deserializeOption(byte[] bytes) {
        if (bytes.length == 0) {
            return None$.MODULE$;
        }
        ContainerFormats.Option optionProto = ContainerFormats.Option.parseFrom(bytes);
        return Some$.MODULE$.apply(this.payloadSupport.deserializePayload(optionProto.getValue()));
    }

    private Optional<Object> deserializeOptional(byte[] bytes) {
        if (bytes.length == 0) {
            return Optional.empty();
        }
        ContainerFormats.Option optionProto = ContainerFormats.Option.parseFrom(bytes);
        return Optional.of(this.payloadSupport.deserializePayload(optionProto.getValue()));
    }

    private Status.Success deserializeStatusSuccess(byte[] bytes) {
        return Status.Success$.MODULE$.apply(this.payloadSupport.deserializePayload(ContainerFormats.Payload.parseFrom(bytes)));
    }

    private Status.Failure deserializeStatusFailure(byte[] bytes) {
        return Status.Failure$.MODULE$.apply((Throwable)this.payloadSupport.deserializePayload(ContainerFormats.Payload.parseFrom(bytes)));
    }

    private StatusReply<?> deserializeStatusReplySuccess(byte[] bytes) {
        return StatusReply$.MODULE$.success(this.payloadSupport.deserializePayload(ContainerFormats.Payload.parseFrom(bytes)));
    }

    private StatusReply<?> deserializeStatusReplyErrorMessage(byte[] bytes) {
        return StatusReply$.MODULE$.error(ContainerFormats.StatusReplyErrorMessage.parseFrom(bytes).getErrorMessage());
    }

    private StatusReply<?> deserializeStatusReplyErrorException(byte[] bytes) {
        return StatusReply$.MODULE$.error((Throwable)this.payloadSupport.deserializePayload(ContainerFormats.Payload.parseFrom(bytes)));
    }

    private Address deserializeAddressData(byte[] bytes) {
        return this.addressFromDataProto(WireFormats.AddressData.parseFrom(bytes));
    }

    private Address addressFromDataProto(WireFormats.AddressData a) {
        return Address$.MODULE$.apply(a.getProtocol(), a.getSystem(), (Option)(a.hasHostname() ? Some$.MODULE$.apply((Object)a.getHostname()) : None$.MODULE$), (Option)(a.hasPort() ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)a.getPort())) : None$.MODULE$));
    }

    private Address addressFromProto(ArteryControlFormats.Address a) {
        return Address$.MODULE$.apply(a.getProtocol(), a.getSystem(), (Option)(a.hasHostname() ? Some$.MODULE$.apply((Object)a.getHostname()) : None$.MODULE$), (Option)(a.hasPort() ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)a.getPort())) : None$.MODULE$));
    }

    private UniqueAddress deserializeUniqueAddress(byte[] bytes) {
        ArteryControlFormats.UniqueAddress u = ArteryControlFormats.UniqueAddress.parseFrom(bytes);
        return UniqueAddress$.MODULE$.apply(this.addressFromProto(u.getAddress()), u.getUid());
    }

    private RemoteWatcher.HeartbeatRsp deserializeHeartbeatRsp(byte[] bytes) {
        return RemoteWatcher$HeartbeatRsp$.MODULE$.apply((int)ContainerFormats.WatcherHeartbeatResponse.parseFrom(bytes).getUid());
    }

    private ActorInitializationException deserializeActorInitializationException(byte[] bytes) {
        ContainerFormats.ActorInitializationException serializedEx = ContainerFormats.ActorInitializationException.parseFrom(bytes);
        ActorRef ref = this.deserializeActorRef(serializedEx.getActor());
        String refString = ref.path().toString();
        String message = serializedEx.getMessage();
        String reconstructedMessage = message.startsWith(refString) ? StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(message), refString.length() + 2) : message;
        return ActorInitializationException$.MODULE$.apply((ActorRef)(serializedEx.hasActor() ? ref : null), reconstructedMessage, (Throwable)this.payloadSupport.deserializePayload(serializedEx.getCause()));
    }

    private ThrowableNotSerializableException deserializeThrowableNotSerializableException(byte[] bytes) {
        ContainerFormats.ThrowableNotSerializable serializedEx = ContainerFormats.ThrowableNotSerializable.parseFrom(bytes);
        return new ThrowableNotSerializableException(serializedEx.getOriginalMessage(), serializedEx.getOriginalClassName());
    }

    private RemoteScope deserializeRemoteScope(byte[] bytes) {
        WireFormats.RemoteScope rs = WireFormats.RemoteScope.parseFrom(bytes);
        return RemoteScope$.MODULE$.apply(this.deserializeAddressData(rs.getNode()));
    }

    private Config deserializeConfig(byte[] bytes) {
        Object object = Predef$.MODULE$.byteArrayOps(bytes);
        if (ArrayOps$.MODULE$.isEmpty$extension(object)) {
            return this.EmptyConfig;
        }
        return ConfigFactory.parseString((String)new String(bytes, StandardCharsets.UTF_8));
    }

    private FromConfig deserializeFromConfig(byte[] bytes) {
        Object object = Predef$.MODULE$.byteArrayOps(bytes);
        if (ArrayOps$.MODULE$.isEmpty$extension(object)) {
            return FromConfig$.MODULE$;
        }
        WireFormats.FromConfig fc = WireFormats.FromConfig.parseFrom(bytes);
        None$ none$ = fc.hasResizer() ? Some$.MODULE$.apply((Object)((Resizer)this.payloadSupport.deserializePayload(fc.getResizer()))) : None$.MODULE$;
        String string = fc.hasRouterDispatcher() ? fc.getRouterDispatcher() : "pekko.actor.default-dispatcher";
        SupervisorStrategy supervisorStrategy = FromConfig$.MODULE$.apply$default$2();
        return FromConfig$.MODULE$.apply((Option)none$, supervisorStrategy, string);
    }

    private BalancingPool deserializeBalancingPool(byte[] bytes) {
        WireFormats.GenericRoutingPool bp = WireFormats.GenericRoutingPool.parseFrom(bytes);
        int n = bp.getNrOfInstances();
        String string = bp.hasRouterDispatcher() ? bp.getRouterDispatcher() : "pekko.actor.default-dispatcher";
        SupervisorStrategy supervisorStrategy = BalancingPool$.MODULE$.$lessinit$greater$default$2();
        return BalancingPool$.MODULE$.apply(n, supervisorStrategy, string);
    }

    private BroadcastPool deserializeBroadcastPool(byte[] bytes) {
        WireFormats.GenericRoutingPool bp = WireFormats.GenericRoutingPool.parseFrom(bytes);
        int n = bp.getNrOfInstances();
        None$ none$ = bp.hasResizer() ? Some$.MODULE$.apply((Object)((Resizer)this.payloadSupport.deserializePayload(bp.getResizer()))) : None$.MODULE$;
        String string = bp.hasRouterDispatcher() ? bp.getRouterDispatcher() : "pekko.actor.default-dispatcher";
        boolean bl = bp.getUsePoolDispatcher();
        SupervisorStrategy supervisorStrategy = BroadcastPool$.MODULE$.$lessinit$greater$default$3();
        return BroadcastPool$.MODULE$.apply(n, (Option)none$, supervisorStrategy, string, bl);
    }

    private RandomPool deserializeRandomPool(byte[] bytes) {
        WireFormats.GenericRoutingPool rp = WireFormats.GenericRoutingPool.parseFrom(bytes);
        int n = rp.getNrOfInstances();
        None$ none$ = rp.hasResizer() ? Some$.MODULE$.apply((Object)((Resizer)this.payloadSupport.deserializePayload(rp.getResizer()))) : None$.MODULE$;
        String string = rp.hasRouterDispatcher() ? rp.getRouterDispatcher() : "pekko.actor.default-dispatcher";
        boolean bl = rp.getUsePoolDispatcher();
        SupervisorStrategy supervisorStrategy = RandomPool$.MODULE$.$lessinit$greater$default$3();
        return RandomPool$.MODULE$.apply(n, (Option)none$, supervisorStrategy, string, bl);
    }

    private RoundRobinPool deserializeRoundRobinPool(byte[] bytes) {
        WireFormats.GenericRoutingPool rp = WireFormats.GenericRoutingPool.parseFrom(bytes);
        int n = rp.getNrOfInstances();
        None$ none$ = rp.hasResizer() ? Some$.MODULE$.apply((Object)((Resizer)this.payloadSupport.deserializePayload(rp.getResizer()))) : None$.MODULE$;
        String string = rp.hasRouterDispatcher() ? rp.getRouterDispatcher() : "pekko.actor.default-dispatcher";
        boolean bl = rp.getUsePoolDispatcher();
        SupervisorStrategy supervisorStrategy = RoundRobinPool$.MODULE$.$lessinit$greater$default$3();
        return RoundRobinPool$.MODULE$.apply(n, (Option)none$, supervisorStrategy, string, bl);
    }

    private ScatterGatherFirstCompletedPool deserializeScatterGatherPool(byte[] bytes) {
        WireFormats.ScatterGatherPool sgp = WireFormats.ScatterGatherPool.parseFrom(bytes);
        int n = sgp.getGeneric().getNrOfInstances();
        None$ none$ = sgp.getGeneric().hasResizer() ? Some$.MODULE$.apply((Object)((Resizer)this.payloadSupport.deserializePayload(sgp.getGeneric().getResizer()))) : None$.MODULE$;
        FiniteDuration finiteDuration = this.deserializeFiniteDuration(sgp.getWithin());
        String string = sgp.getGeneric().hasRouterDispatcher() ? sgp.getGeneric().getRouterDispatcher() : "pekko.actor.default-dispatcher";
        SupervisorStrategy supervisorStrategy = ScatterGatherFirstCompletedPool$.MODULE$.$lessinit$greater$default$4();
        boolean bl = ScatterGatherFirstCompletedPool$.MODULE$.$lessinit$greater$default$6();
        return ScatterGatherFirstCompletedPool$.MODULE$.apply(n, (Option)none$, finiteDuration, supervisorStrategy, string, bl);
    }

    private TailChoppingPool deserializeTailChoppingPool(byte[] bytes) {
        WireFormats.TailChoppingPool tcp = WireFormats.TailChoppingPool.parseFrom(bytes);
        int n = tcp.getGeneric().getNrOfInstances();
        None$ none$ = tcp.getGeneric().hasResizer() ? Some$.MODULE$.apply((Object)((Resizer)this.payloadSupport.deserializePayload(tcp.getGeneric().getResizer()))) : None$.MODULE$;
        String string = tcp.getGeneric().hasRouterDispatcher() ? tcp.getGeneric().getRouterDispatcher() : "pekko.actor.default-dispatcher";
        boolean bl = tcp.getGeneric().getUsePoolDispatcher();
        FiniteDuration finiteDuration = this.deserializeFiniteDuration(tcp.getWithin());
        FiniteDuration finiteDuration2 = this.deserializeFiniteDuration(tcp.getInterval());
        SupervisorStrategy supervisorStrategy = TailChoppingPool$.MODULE$.$lessinit$greater$default$5();
        return TailChoppingPool$.MODULE$.apply(n, (Option)none$, finiteDuration, finiteDuration2, supervisorStrategy, string, bl);
    }

    private RemoteRouterConfig deserializeRemoteRouterConfig(byte[] bytes) {
        WireFormats.RemoteRouterConfig rrc = WireFormats.RemoteRouterConfig.parseFrom(bytes);
        return RemoteRouterConfig$.MODULE$.apply((Pool)this.payloadSupport.deserializePayload(rrc.getLocal()), (Iterable<Address>)((Iterable)package.JavaConverters$.MODULE$.ListHasAsScala(rrc.getNodesList()).asScala().map((Function1 & Serializable)address -> this.deserializeAddressData((WireFormats.AddressData)address))));
    }

    private DefaultResizer deserializeDefaultResizer(byte[] bytes) {
        WireFormats.DefaultResizer dr = WireFormats.DefaultResizer.parseFrom(bytes);
        return DefaultResizer$.MODULE$.apply(dr.getLowerBound(), dr.getUpperBound(), dr.getPressureThreshold(), dr.getRampupRate(), dr.getBackoffThreshold(), dr.getBackoffRate(), dr.getMessagesPerResize());
    }

    private TimeUnit deserializeTimeUnit(WireFormats.TimeUnit unit) {
        WireFormats.TimeUnit timeUnit = unit;
        WireFormats.TimeUnit timeUnit2 = WireFormats.TimeUnit.NANOSECONDS;
        WireFormats.TimeUnit timeUnit3 = timeUnit;
        if (!(timeUnit2 != null ? !((Object)((Object)timeUnit2)).equals((Object)timeUnit3) : timeUnit3 != null)) {
            return TimeUnit.NANOSECONDS;
        }
        WireFormats.TimeUnit timeUnit4 = WireFormats.TimeUnit.MICROSECONDS;
        WireFormats.TimeUnit timeUnit5 = timeUnit;
        if (!(timeUnit4 != null ? !((Object)((Object)timeUnit4)).equals((Object)timeUnit5) : timeUnit5 != null)) {
            return TimeUnit.MICROSECONDS;
        }
        WireFormats.TimeUnit timeUnit6 = WireFormats.TimeUnit.MILLISECONDS;
        WireFormats.TimeUnit timeUnit7 = timeUnit;
        if (!(timeUnit6 != null ? !((Object)((Object)timeUnit6)).equals((Object)timeUnit7) : timeUnit7 != null)) {
            return TimeUnit.MILLISECONDS;
        }
        WireFormats.TimeUnit timeUnit8 = WireFormats.TimeUnit.SECONDS;
        WireFormats.TimeUnit timeUnit9 = timeUnit;
        if (!(timeUnit8 != null ? !((Object)((Object)timeUnit8)).equals((Object)timeUnit9) : timeUnit9 != null)) {
            return TimeUnit.SECONDS;
        }
        WireFormats.TimeUnit timeUnit10 = WireFormats.TimeUnit.MINUTES;
        WireFormats.TimeUnit timeUnit11 = timeUnit;
        if (!(timeUnit10 != null ? !((Object)((Object)timeUnit10)).equals((Object)timeUnit11) : timeUnit11 != null)) {
            return TimeUnit.MINUTES;
        }
        WireFormats.TimeUnit timeUnit12 = WireFormats.TimeUnit.HOURS;
        WireFormats.TimeUnit timeUnit13 = timeUnit;
        if (!(timeUnit12 != null ? !((Object)((Object)timeUnit12)).equals((Object)timeUnit13) : timeUnit13 != null)) {
            return TimeUnit.HOURS;
        }
        WireFormats.TimeUnit timeUnit14 = WireFormats.TimeUnit.DAYS;
        WireFormats.TimeUnit timeUnit15 = timeUnit;
        if (!(timeUnit14 != null ? !((Object)((Object)timeUnit14)).equals((Object)timeUnit15) : timeUnit15 != null)) {
            return TimeUnit.DAYS;
        }
        throw new MatchError((Object)timeUnit);
    }

    private FiniteDuration deserializeFiniteDuration(WireFormats.FiniteDuration duration) {
        return FiniteDuration$.MODULE$.apply(duration.getValue(), this.deserializeTimeUnit(duration.getUnit()));
    }

    private Address deserializeAddressData(WireFormats.AddressData address) {
        return Address$.MODULE$.apply(address.getProtocol(), address.getSystem(), address.getHostname(), address.getPort());
    }
}

