/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.serialization;

import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.ContainerFormats;
import org.apache.pekko.remote.serialization.ThrowableNotSerializableException;
import org.apache.pekko.remote.serialization.WrappedPayloadSupport;
import org.apache.pekko.serialization.DisabledJavaSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class ThrowableSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ThrowableSupport.class.getDeclaredField("serialization$lzy1"));
    private final ExtendedActorSystem system;
    private volatile Object serialization$lzy1;
    private final WrappedPayloadSupport payloadSupport;
    private final LoggingAdapter log;

    public ThrowableSupport(ExtendedActorSystem system) {
        this.system = system;
        this.payloadSupport = new WrappedPayloadSupport(system);
        this.log = Logging$.MODULE$.apply((ActorSystem)system, ThrowableSupport.class, LogSource$.MODULE$.fromAnyClass());
    }

    private Serialization serialization() {
        Object object = this.serialization$lzy1;
        if (object instanceof Serialization) {
            return (Serialization)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Serialization)this.serialization$lzyINIT1();
    }

    private Object serialization$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.serialization$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Serialization serialization = null;
                    try {
                        serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system);
                        object2 = serialization == null ? LazyVals.NullValue$.MODULE$ : serialization;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.serialization$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serialization;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public byte[] serializeThrowable(Throwable t) {
        return this.toProtobufThrowable(t).build().toByteArray();
    }

    public ContainerFormats.Throwable.Builder toProtobufThrowable(Throwable t) {
        StackTraceElement[] stackTrace;
        ContainerFormats.Throwable.Builder b = ContainerFormats.Throwable.newBuilder().setClassName(t.getClass().getName());
        if (t.getMessage() != null) {
            b.setMessage(t.getMessage());
        }
        if (t.getCause() != null) {
            b.setCause(this.payloadSupport.payloadBuilder(t.getCause()));
        }
        if ((stackTrace = t.getStackTrace()) != null) {
            for (int i = 0; i < stackTrace.length; ++i) {
                b.addStackTrace(this.stackTraceElementBuilder(stackTrace[i]));
            }
        }
        return b;
    }

    private ContainerFormats.StackTraceElement.Builder stackTraceElementBuilder(StackTraceElement elem) {
        ContainerFormats.StackTraceElement.Builder builder = ContainerFormats.StackTraceElement.newBuilder().setClassName(elem.getClassName()).setMethodName(elem.getMethodName()).setLineNumber(elem.getLineNumber());
        String fileName = elem.getFileName();
        if (fileName != null) {
            return builder.setFileName(fileName);
        }
        return builder.setFileName("");
    }

    public Throwable deserializeThrowable(byte[] bytes) {
        return this.fromProtobufThrowable(ContainerFormats.Throwable.parseFrom(bytes));
    }

    public Throwable fromProtobufThrowable(ContainerFormats.Throwable protoT) {
        Throwable throwable;
        block8: {
            String className = protoT.getClassName();
            try {
                Try try_;
                Try try_2;
                Class clazz = (Class)this.system.dynamicAccess().getClassFor(className, ClassTag$.MODULE$.apply(Throwable.class)).get();
                Serializer serializer = this.serialization().serializerFor(clazz);
                if (serializer instanceof DisabledJavaSerializer) {
                    ThrowableNotSerializableException notSerializableException = new ThrowableNotSerializableException(protoT.getMessage(), "unknown");
                    this.log.debug("Couldn't deserialize [{}] because Java serialization is disabled. Fallback to ThrowableNotSerializableException. {}", (Object)notSerializableException.originalClassName(), (Object)notSerializableException.originalMessage());
                    throwable = notSerializableException;
                    break block8;
                }
                if (protoT.hasCause()) {
                    Throwable cause = (Throwable)this.payloadSupport.deserializePayload(protoT.getCause());
                    Object[] objectArray = new Tuple2[2];
                    Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(String.class);
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)protoT.getMessage());
                    Class clazz3 = (Class)Predef$.MODULE$.ArrowAssoc(Throwable.class);
                    objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz3, (Object)cause);
                    try_2 = this.system.dynamicAccess().createInstanceFor(className, (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), ClassTag$.MODULE$.apply(Throwable.class));
                } else {
                    Object[] objectArray = new Tuple2[1];
                    Class clazz4 = (Class)Predef$.MODULE$.ArrowAssoc(String.class);
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz4, (Object)protoT.getMessage());
                    try_2 = try_ = this.system.dynamicAccess().createInstanceFor(clazz, (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), ClassTag$.MODULE$.apply(Throwable.class));
                }
                if (try_ instanceof Success) {
                    Throwable t = (Throwable)((Success)try_).value();
                    this.fillInStackTrace(protoT, t);
                    throwable = t;
                    break block8;
                }
                if (try_ instanceof Failure) {
                    Throwable e = ((Failure)try_).exception();
                    throwable = new ThrowableNotSerializableException(protoT.getMessage(), className, e);
                    break block8;
                }
                throw new MatchError((Object)try_);
            }
            catch (Throwable throwable2) {
                Option option;
                Throwable throwable3 = throwable2;
                if (throwable3 != null && !(option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                    Throwable throwable4;
                    Throwable e = throwable4 = (Throwable)option.get();
                    throwable = new ThrowableNotSerializableException(protoT.getMessage(), className, e);
                }
                throw throwable2;
            }
        }
        return throwable;
    }

    private void fillInStackTrace(ContainerFormats.Throwable protoT, Throwable t) {
        StackTraceElement[] stackTrace = (StackTraceElement[])((IterableOnceOps)package.JavaConverters$.MODULE$.ListHasAsScala(protoT.getStackTraceList()).asScala().map((Function1 & Serializable)elem -> {
            String fileName = elem.getFileName();
            return new StackTraceElement(elem.getClassName(), elem.getMethodName(), fileName.length() > 0 ? fileName : null, elem.getLineNumber());
        })).toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
        t.setStackTrace(stackTrace);
    }
}

