/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.transport.AbstractTransportAdapter;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.FailureInjectorException;
import org.apache.pekko.remote.transport.FailureInjectorHandle;
import org.apache.pekko.remote.transport.FailureInjectorHandle$;
import org.apache.pekko.remote.transport.FailureInjectorTransportAdapter$;
import org.apache.pekko.remote.transport.FailureInjectorTransportAdapter$All$;
import org.apache.pekko.remote.transport.FailureInjectorTransportAdapter$Drop$;
import org.apache.pekko.remote.transport.FailureInjectorTransportAdapter$One$;
import org.apache.pekko.remote.transport.FailureInjectorTransportAdapter$PassThru$;
import org.apache.pekko.remote.transport.Transport;
import org.apache.pekko.remote.transport.Transport$InboundAssociation$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class FailureInjectorTransportAdapter
extends AbstractTransportAdapter
implements Transport.AssociationEventListener {
    private final Transport wrappedTransport;
    private final ExtendedActorSystem extendedSystem;
    private final LoggingAdapter log;
    private final boolean shouldDebugLog;
    private volatile Option<Transport.AssociationEventListener> upstreamListener;
    private final ConcurrentHashMap addressChaosTable;
    private final String addedSchemeIdentifier;

    public static String FailureInjectorSchemeIdentifier() {
        return FailureInjectorTransportAdapter$.MODULE$.FailureInjectorSchemeIdentifier();
    }

    public FailureInjectorTransportAdapter(Transport wrappedTransport, ExtendedActorSystem extendedSystem) {
        this.wrappedTransport = wrappedTransport;
        this.extendedSystem = extendedSystem;
        super(wrappedTransport, (ExecutionContext)extendedSystem.dispatchers().internalDispatcher());
        this.log = Logging$.MODULE$.apply((ActorSystem)extendedSystem, FailureInjectorTransportAdapter.class, LogSource$.MODULE$.fromAnyClass());
        this.shouldDebugLog = extendedSystem.settings().config().getBoolean("pekko.remote.classic.gremlin.debug");
        this.upstreamListener = None$.MODULE$;
        this.addressChaosTable = new ConcurrentHashMap();
        this.addedSchemeIdentifier = FailureInjectorTransportAdapter$.MODULE$.FailureInjectorSchemeIdentifier();
    }

    public ExtendedActorSystem extendedSystem() {
        return this.extendedSystem;
    }

    private ThreadLocalRandom rng() {
        return ThreadLocalRandom.current();
    }

    public ConcurrentHashMap<Address, GremlinMode> addressChaosTable() {
        return this.addressChaosTable;
    }

    @Override
    public String addedSchemeIdentifier() {
        return this.addedSchemeIdentifier;
    }

    @Override
    public int maximumOverhead() {
        return 0;
    }

    @Override
    public Future<Object> managementCommand(Object cmd) {
        Object object = cmd;
        if (object instanceof All) {
            All all = FailureInjectorTransportAdapter$All$.MODULE$.unapply((All)object);
            GremlinMode gremlinMode = all._1();
            return Future$.MODULE$.failed((Throwable)new IllegalArgumentException("Setting the mode for all addresses at once is not currently implemented"));
        }
        if (object instanceof One) {
            One one = FailureInjectorTransportAdapter$One$.MODULE$.unapply((One)object);
            Address address = one._1();
            GremlinMode gremlinMode = one._2();
            Address address2 = address;
            GremlinMode mode = gremlinMode;
            this.addressChaosTable().put(address2.copy("", "", address2.copy$default$3(), address2.copy$default$4()), mode);
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        return this.wrappedTransport.managementCommand(cmd);
    }

    @Override
    public Future<Transport.AssociationEventListener> interceptListen(Address listenAddress, Future<Transport.AssociationEventListener> listenerFuture) {
        this.log.warning("FailureInjectorTransport is active on this system. Gremlins might munch your packets.");
        listenerFuture.foreach((Function1)(JProcedure1 & Serializable)listener -> {
            this.upstreamListener = Some$.MODULE$.apply(listener);
        }, this.ec());
        return Future$.MODULE$.successful((Object)this);
    }

    @Override
    public void interceptAssociate(Address remoteAddress, Promise<AssociationHandle> statusPromise) {
        if (this.shouldDropInbound(remoteAddress, BoxedUnit.UNIT, "interceptAssociate") || this.shouldDropOutbound(remoteAddress, BoxedUnit.UNIT, "interceptAssociate")) {
            statusPromise.failure((Throwable)((Object)new FailureInjectorException(new StringBuilder(36).append("Simulated failure of association to ").append(remoteAddress).toString())));
            return;
        }
        statusPromise.completeWith(this.wrappedTransport.associate(remoteAddress).map((Function1 & Serializable)handle -> {
            Address address = handle.remoteAddress();
            this.addressChaosTable().putIfAbsent(address.copy("", "", address.copy$default$3(), address.copy$default$4()), FailureInjectorTransportAdapter$PassThru$.MODULE$);
            return new FailureInjectorHandle((AssociationHandle)handle, this);
        }, this.ec()));
    }

    @Override
    public void notify(Transport.AssociationEvent ev) {
        Transport.InboundAssociation inboundAssociation;
        AssociationHandle associationHandle;
        AssociationHandle handle;
        Transport.AssociationEvent associationEvent = ev;
        if (associationEvent instanceof Transport.InboundAssociation && this.shouldDropInbound((handle = (associationHandle = (inboundAssociation = Transport$InboundAssociation$.MODULE$.unapply((Transport.InboundAssociation)associationEvent))._1())).remoteAddress(), ev, "notify")) {
            return;
        }
        Option<Transport.AssociationEventListener> option = this.upstreamListener;
        if (option instanceof Some) {
            Transport.AssociationEventListener listener = (Transport.AssociationEventListener)((Some)option).value();
            listener.notify(this.interceptInboundAssociation(ev));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public Transport.AssociationEvent interceptInboundAssociation(Transport.AssociationEvent ev) {
        Transport.AssociationEvent associationEvent = ev;
        if (associationEvent instanceof Transport.InboundAssociation) {
            AssociationHandle associationHandle;
            Transport.InboundAssociation inboundAssociation = Transport$InboundAssociation$.MODULE$.unapply((Transport.InboundAssociation)associationEvent);
            AssociationHandle handle = associationHandle = inboundAssociation._1();
            return Transport$InboundAssociation$.MODULE$.apply(FailureInjectorHandle$.MODULE$.apply(handle, this));
        }
        return ev;
    }

    public boolean shouldDropInbound(Address remoteAddress, Object instance, String debugMessage) {
        GremlinMode gremlinMode = this.chaosMode(remoteAddress);
        if (FailureInjectorTransportAdapter$PassThru$.MODULE$.equals(gremlinMode)) {
            return false;
        }
        if (gremlinMode instanceof Drop) {
            double d;
            Drop drop = FailureInjectorTransportAdapter$Drop$.MODULE$.unapply((Drop)gremlinMode);
            double d2 = drop._1();
            double inboundDropP = d = drop._2();
            if (this.rng().nextDouble() <= inboundDropP) {
                if (this.shouldDebugLog) {
                    this.log.debug("Dropping inbound [{}] for [{}] {}", instance.getClass(), (Object)remoteAddress, (Object)debugMessage);
                }
                return true;
            }
            return false;
        }
        throw new MatchError((Object)gremlinMode);
    }

    public boolean shouldDropOutbound(Address remoteAddress, Object instance, String debugMessage) {
        GremlinMode gremlinMode = this.chaosMode(remoteAddress);
        if (FailureInjectorTransportAdapter$PassThru$.MODULE$.equals(gremlinMode)) {
            return false;
        }
        if (gremlinMode instanceof Drop) {
            Drop drop = FailureInjectorTransportAdapter$Drop$.MODULE$.unapply((Drop)gremlinMode);
            double d = drop._1();
            double d2 = drop._2();
            double outboundDropP = d;
            if (this.rng().nextDouble() <= outboundDropP) {
                if (this.shouldDebugLog) {
                    this.log.debug("Dropping outbound [{}] for [{}] {}", instance.getClass(), (Object)remoteAddress, (Object)debugMessage);
                }
                return true;
            }
            return false;
        }
        throw new MatchError((Object)gremlinMode);
    }

    public GremlinMode chaosMode(Address remoteAddress) {
        GremlinMode mode = this.addressChaosTable().get(remoteAddress.copy("", "", remoteAddress.copy$default$3(), remoteAddress.copy$default$4()));
        if (mode == null) {
            return FailureInjectorTransportAdapter$PassThru$.MODULE$;
        }
        return mode;
    }

    public static final class All
    implements Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final GremlinMode mode;

        public static All apply(GremlinMode gremlinMode) {
            return FailureInjectorTransportAdapter$All$.MODULE$.apply(gremlinMode);
        }

        public static All fromProduct(Product product) {
            return FailureInjectorTransportAdapter$All$.MODULE$.fromProduct(product);
        }

        public static All unapply(All all) {
            return FailureInjectorTransportAdapter$All$.MODULE$.unapply(all);
        }

        public All(GremlinMode mode) {
            this.mode = mode;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof All)) return false;
            All all = (All)object;
            GremlinMode gremlinMode = this.mode();
            GremlinMode gremlinMode2 = all.mode();
            if (gremlinMode != null) {
                if (!gremlinMode.equals(gremlinMode2)) return false;
                return true;
            }
            if (gremlinMode2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof All;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "All";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "mode";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public GremlinMode mode() {
            return this.mode;
        }

        public All copy(GremlinMode mode) {
            return new All(mode);
        }

        public GremlinMode copy$default$1() {
            return this.mode();
        }

        public GremlinMode _1() {
            return this.mode();
        }
    }

    public static final class Drop
    implements GremlinMode,
    Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final double outboundDropP;
        private final double inboundDropP;

        public static Drop apply(double d, double d2) {
            return FailureInjectorTransportAdapter$Drop$.MODULE$.apply(d, d2);
        }

        public static Drop fromProduct(Product product) {
            return FailureInjectorTransportAdapter$Drop$.MODULE$.fromProduct(product);
        }

        public static Drop unapply(Drop drop) {
            return FailureInjectorTransportAdapter$Drop$.MODULE$.unapply(drop);
        }

        public Drop(double outboundDropP, double inboundDropP) {
            this.outboundDropP = outboundDropP;
            this.inboundDropP = inboundDropP;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.outboundDropP()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.inboundDropP()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Drop)) return false;
            Drop drop = (Drop)object;
            if (this.outboundDropP() != drop.outboundDropP()) return false;
            if (this.inboundDropP() != drop.inboundDropP()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Drop;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Drop";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "outboundDropP";
            }
            if (1 == n2) {
                return "inboundDropP";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double outboundDropP() {
            return this.outboundDropP;
        }

        public double inboundDropP() {
            return this.inboundDropP;
        }

        public Drop copy(double outboundDropP, double inboundDropP) {
            return new Drop(outboundDropP, inboundDropP);
        }

        public double copy$default$1() {
            return this.outboundDropP();
        }

        public double copy$default$2() {
            return this.inboundDropP();
        }

        public double _1() {
            return this.outboundDropP();
        }

        public double _2() {
            return this.inboundDropP();
        }
    }

    public static interface FailureInjectorCommand {
    }

    public static interface GremlinMode {
    }

    public static final class One
    implements Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Address remoteAddress;
        private final GremlinMode mode;

        public static One apply(Address address, GremlinMode gremlinMode) {
            return FailureInjectorTransportAdapter$One$.MODULE$.apply(address, gremlinMode);
        }

        public static One fromProduct(Product product) {
            return FailureInjectorTransportAdapter$One$.MODULE$.fromProduct(product);
        }

        public static One unapply(One one) {
            return FailureInjectorTransportAdapter$One$.MODULE$.unapply(one);
        }

        public One(Address remoteAddress, GremlinMode mode) {
            this.remoteAddress = remoteAddress;
            this.mode = mode;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof One)) return false;
            One one = (One)object;
            Address address = this.remoteAddress();
            Address address2 = one.remoteAddress();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!address.equals(address2)) return false;
            GremlinMode gremlinMode = this.mode();
            GremlinMode gremlinMode2 = one.mode();
            if (gremlinMode == null) {
                if (gremlinMode2 == null) return true;
                return false;
            } else {
                if (!gremlinMode.equals(gremlinMode2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof One;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "One";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "remoteAddress";
            }
            if (1 == n2) {
                return "mode";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address remoteAddress() {
            return this.remoteAddress;
        }

        public GremlinMode mode() {
            return this.mode;
        }

        public One copy(Address remoteAddress, GremlinMode mode) {
            return new One(remoteAddress, mode);
        }

        public Address copy$default$1() {
            return this.remoteAddress();
        }

        public GremlinMode copy$default$2() {
            return this.mode();
        }

        public Address _1() {
            return this.remoteAddress();
        }

        public GremlinMode _2() {
            return this.mode();
        }
    }
}

