/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.remote.transport.ActorTransportAdapter;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.PekkoPduCodec;
import org.apache.pekko.remote.transport.PekkoProtocolHandle;
import org.apache.pekko.remote.transport.PekkoProtocolManager;
import org.apache.pekko.remote.transport.PekkoProtocolSettings;
import org.apache.pekko.remote.transport.PekkoProtocolTransport$;
import org.apache.pekko.remote.transport.PekkoProtocolTransport$AssociateUnderlyingRefuseUid$;
import org.apache.pekko.remote.transport.Transport;
import scala.Option;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class PekkoProtocolTransport
extends ActorTransportAdapter {
    private final Transport wrappedTransport;
    private final ActorSystem system;
    private final PekkoProtocolSettings settings;
    private final PekkoPduCodec codec;
    private final String addedSchemeIdentifier;
    private final int maximumOverhead;

    public static int PekkoOverhead() {
        return PekkoProtocolTransport$.MODULE$.PekkoOverhead();
    }

    public static String PekkoScheme() {
        return PekkoProtocolTransport$.MODULE$.PekkoScheme();
    }

    public static AtomicInteger UniqueId() {
        return PekkoProtocolTransport$.MODULE$.UniqueId();
    }

    public PekkoProtocolTransport(Transport wrappedTransport, ActorSystem system, PekkoProtocolSettings settings, PekkoPduCodec codec) {
        this.wrappedTransport = wrappedTransport;
        this.system = system;
        this.settings = settings;
        this.codec = codec;
        super(wrappedTransport, system);
        this.addedSchemeIdentifier = PekkoProtocolTransport$.MODULE$.PekkoScheme();
        this.maximumOverhead = PekkoProtocolTransport$.MODULE$.PekkoOverhead();
    }

    private ActorSystem system() {
        return this.system;
    }

    private PekkoProtocolSettings settings() {
        return this.settings;
    }

    private PekkoPduCodec codec() {
        return this.codec;
    }

    @Override
    public String addedSchemeIdentifier() {
        return this.addedSchemeIdentifier;
    }

    @Override
    public Future<Object> managementCommand(Object cmd) {
        return this.wrappedTransport.managementCommand(cmd);
    }

    public Future<PekkoProtocolHandle> associate(Address remoteAddress, Option<Object> refuseUid) {
        Promise statusPromise = Promise$.MODULE$.apply();
        ActorRef actorRef = this.manager();
        AssociateUnderlyingRefuseUid associateUnderlyingRefuseUid = PekkoProtocolTransport$AssociateUnderlyingRefuseUid$.MODULE$.apply(this.removeScheme(remoteAddress), (Promise<AssociationHandle>)statusPromise, refuseUid);
        actorRef.$bang((Object)associateUnderlyingRefuseUid, actorRef.$bang$default$2((Object)associateUnderlyingRefuseUid));
        return statusPromise.future().mapTo(ClassTag$.MODULE$.apply(PekkoProtocolHandle.class));
    }

    @Override
    public int maximumOverhead() {
        return this.maximumOverhead;
    }

    @Override
    public String managerName() {
        return new StringBuilder(20).append("akkaprotocolmanager.").append(this.wrappedTransport.schemeIdentifier()).append(PekkoProtocolTransport$.MODULE$.UniqueId().getAndIncrement()).toString();
    }

    @Override
    public Props managerProps() {
        Transport wt = this.wrappedTransport;
        PekkoProtocolSettings s = this.settings();
        return Props$.MODULE$.apply(PekkoProtocolManager.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{wt, s})).withDeploy(Deploy$.MODULE$.local());
    }

    public static final class AssociateUnderlyingRefuseUid
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final Address remoteAddress;
        private final Promise statusPromise;
        private final Option refuseUid;

        public static AssociateUnderlyingRefuseUid apply(Address address, Promise<AssociationHandle> promise, Option<Object> option) {
            return PekkoProtocolTransport$AssociateUnderlyingRefuseUid$.MODULE$.apply(address, promise, option);
        }

        public static AssociateUnderlyingRefuseUid fromProduct(Product product) {
            return PekkoProtocolTransport$AssociateUnderlyingRefuseUid$.MODULE$.fromProduct(product);
        }

        public static AssociateUnderlyingRefuseUid unapply(AssociateUnderlyingRefuseUid associateUnderlyingRefuseUid) {
            return PekkoProtocolTransport$AssociateUnderlyingRefuseUid$.MODULE$.unapply(associateUnderlyingRefuseUid);
        }

        public AssociateUnderlyingRefuseUid(Address remoteAddress, Promise<AssociationHandle> statusPromise, Option<Object> refuseUid) {
            this.remoteAddress = remoteAddress;
            this.statusPromise = statusPromise;
            this.refuseUid = refuseUid;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AssociateUnderlyingRefuseUid)) return false;
            AssociateUnderlyingRefuseUid associateUnderlyingRefuseUid = (AssociateUnderlyingRefuseUid)object;
            Address address = this.remoteAddress();
            Address address2 = associateUnderlyingRefuseUid.remoteAddress();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!address.equals(address2)) return false;
            Promise<AssociationHandle> promise = this.statusPromise();
            Promise<AssociationHandle> promise2 = associateUnderlyingRefuseUid.statusPromise();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            Option<Object> option = this.refuseUid();
            Option<Object> option2 = associateUnderlyingRefuseUid.refuseUid();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AssociateUnderlyingRefuseUid;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "AssociateUnderlyingRefuseUid";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "remoteAddress";
                }
                case 1: {
                    return "statusPromise";
                }
                case 2: {
                    return "refuseUid";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address remoteAddress() {
            return this.remoteAddress;
        }

        public Promise<AssociationHandle> statusPromise() {
            return this.statusPromise;
        }

        public Option<Object> refuseUid() {
            return this.refuseUid;
        }

        public AssociateUnderlyingRefuseUid copy(Address remoteAddress, Promise<AssociationHandle> statusPromise, Option<Object> refuseUid) {
            return new AssociateUnderlyingRefuseUid(remoteAddress, statusPromise, refuseUid);
        }

        public Address copy$default$1() {
            return this.remoteAddress();
        }

        public Promise<AssociationHandle> copy$default$2() {
            return this.statusPromise();
        }

        public Option<Object> copy$default$3() {
            return this.refuseUid();
        }

        public Address _1() {
            return this.remoteAddress();
        }

        public Promise<AssociationHandle> _2() {
            return this.statusPromise();
        }

        public Option<Object> _3() {
            return this.refuseUid();
        }
    }
}

