/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.PoisonPill$;
import org.apache.pekko.remote.transport.AbstractTransportAdapterHandle;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.ThrottledAssociation;
import org.apache.pekko.remote.transport.ThrottledAssociation$FailWith$;
import org.apache.pekko.remote.transport.ThrottlerHandle$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$Blackhole$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$Unthrottled$;
import org.apache.pekko.util.ByteString;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ThrottlerHandle
extends AbstractTransportAdapterHandle
implements Product,
Serializable {
    private final AssociationHandle _wrappedHandle;
    private final ActorRef throttlerActor;
    private final AtomicReference outboundThrottleMode;
    private final Promise readHandlerPromise;

    public static ThrottlerHandle apply(AssociationHandle associationHandle, ActorRef actorRef) {
        return ThrottlerHandle$.MODULE$.apply(associationHandle, actorRef);
    }

    public static ThrottlerHandle fromProduct(Product product) {
        return ThrottlerHandle$.MODULE$.fromProduct(product);
    }

    public static ThrottlerHandle unapply(ThrottlerHandle throttlerHandle) {
        return ThrottlerHandle$.MODULE$.unapply(throttlerHandle);
    }

    public ThrottlerHandle(AssociationHandle _wrappedHandle, ActorRef throttlerActor) {
        this._wrappedHandle = _wrappedHandle;
        this.throttlerActor = throttlerActor;
        super(_wrappedHandle, ThrottlerTransportAdapter$.MODULE$.SchemeIdentifier());
        this.outboundThrottleMode = new AtomicReference<ThrottlerTransportAdapter$Unthrottled$>(ThrottlerTransportAdapter$Unthrottled$.MODULE$);
        this.readHandlerPromise = Promise$.MODULE$.apply();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ThrottlerHandle)) return false;
        ThrottlerHandle throttlerHandle = (ThrottlerHandle)object;
        AssociationHandle associationHandle = this._wrappedHandle();
        AssociationHandle associationHandle2 = throttlerHandle._wrappedHandle();
        if (associationHandle == null) {
            if (associationHandle2 != null) {
                return false;
            }
        } else if (!associationHandle.equals(associationHandle2)) return false;
        ActorRef actorRef = this.throttlerActor();
        ActorRef actorRef2 = throttlerHandle.throttlerActor();
        if (actorRef == null) {
            if (actorRef2 == null) return true;
            return false;
        } else {
            if (!actorRef.equals(actorRef2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ThrottlerHandle;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ThrottlerHandle";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "_wrappedHandle";
        }
        if (1 == n2) {
            return "throttlerActor";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public AssociationHandle _wrappedHandle() {
        return this._wrappedHandle;
    }

    public ActorRef throttlerActor() {
        return this.throttlerActor;
    }

    public AtomicReference<ThrottlerTransportAdapter.ThrottleMode> outboundThrottleMode() {
        return this.outboundThrottleMode;
    }

    @Override
    public Promise<AssociationHandle.HandleEventListener> readHandlerPromise() {
        return this.readHandlerPromise;
    }

    @Override
    public boolean write(ByteString payload) {
        int tokens = payload.length();
        ThrottlerTransportAdapter.ThrottleMode throttleMode = this.outboundThrottleMode().get();
        if (ThrottlerTransportAdapter$Blackhole$.MODULE$.equals(throttleMode)) {
            return true;
        }
        ThrottlerTransportAdapter.ThrottleMode bucket = throttleMode;
        boolean success = this.tryConsume$1(tokens, this.outboundThrottleMode().get());
        if (success) {
            return this.wrappedHandle().write(payload);
        }
        return false;
    }

    @Override
    public void disassociate() {
        this.throttlerActor().$bang((Object)PoisonPill$.MODULE$, this.throttlerActor().$bang$default$2((Object)PoisonPill$.MODULE$));
    }

    public void disassociateWithFailure(AssociationHandle.DisassociateInfo reason) {
        ThrottledAssociation.FailWith failWith = ThrottledAssociation$FailWith$.MODULE$.apply(reason);
        this.throttlerActor().$bang((Object)failWith, this.throttlerActor().$bang$default$2((Object)failWith));
    }

    public ThrottlerHandle copy(AssociationHandle _wrappedHandle, ActorRef throttlerActor) {
        return new ThrottlerHandle(_wrappedHandle, throttlerActor);
    }

    public AssociationHandle copy$default$1() {
        return this._wrappedHandle();
    }

    public ActorRef copy$default$2() {
        return this.throttlerActor();
    }

    public AssociationHandle _1() {
        return this._wrappedHandle();
    }

    public ActorRef _2() {
        return this.throttlerActor();
    }

    private final boolean tryConsume$1(int tokens$1, ThrottlerTransportAdapter.ThrottleMode currentBucket) {
        while (true) {
            long timeOfSend;
            Tuple2<ThrottlerTransportAdapter.ThrottleMode, Object> tuple2;
            if ((tuple2 = currentBucket.tryConsumeTokens(timeOfSend = System.nanoTime(), tokens$1)) == null) {
                throw new MatchError(tuple2);
            }
            ThrottlerTransportAdapter.ThrottleMode newBucket = (ThrottlerTransportAdapter.ThrottleMode)tuple2._1();
            boolean allow = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)newBucket, (Object)BoxesRunTime.boxToBoolean((boolean)allow));
            ThrottlerTransportAdapter.ThrottleMode newBucket2 = (ThrottlerTransportAdapter.ThrottleMode)tuple22._1();
            boolean allow2 = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
            if (!allow2) break;
            if (this.outboundThrottleMode().compareAndSet(currentBucket, newBucket2)) {
                return true;
            }
            currentBucket = this.outboundThrottleMode().get();
        }
        return false;
    }
}

