/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import java.net.InetSocketAddress;
import org.apache.pekko.actor.Address;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.AssociationHandle$Disassociated$;
import org.apache.pekko.remote.transport.AssociationHandle$InboundPayload$;
import org.apache.pekko.remote.transport.AssociationHandle$Unknown$;
import org.apache.pekko.remote.transport.netty.ChannelLocalActor$;
import org.apache.pekko.remote.transport.netty.CommonHandlers;
import org.apache.pekko.remote.transport.netty.TcpAssociationHandle;
import org.apache.pekko.util.ByteString$;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import scala.Some$;

public interface TcpHandlers
extends CommonHandlers {
    public LoggingAdapter log();

    public static void registerListener$(TcpHandlers $this, Channel channel, AssociationHandle.HandleEventListener listener, ChannelBuffer msg, InetSocketAddress remoteSocketAddress) {
        $this.registerListener(channel, listener, msg, remoteSocketAddress);
    }

    @Override
    default public void registerListener(Channel channel, AssociationHandle.HandleEventListener listener, ChannelBuffer msg, InetSocketAddress remoteSocketAddress) {
        ChannelLocalActor$.MODULE$.set(channel, Some$.MODULE$.apply((Object)listener));
    }

    public static AssociationHandle createHandle$(TcpHandlers $this, Channel channel, Address localAddress, Address remoteAddress) {
        return $this.createHandle(channel, localAddress, remoteAddress);
    }

    @Override
    default public AssociationHandle createHandle(Channel channel, Address localAddress, Address remoteAddress) {
        return new TcpAssociationHandle(localAddress, remoteAddress, this.transport(), channel);
    }

    public static void onDisconnect$(TcpHandlers $this, ChannelHandlerContext ctx, ChannelStateEvent e) {
        $this.onDisconnect(ctx, e);
    }

    @Override
    default public void onDisconnect(ChannelHandlerContext ctx, ChannelStateEvent e) {
        ChannelLocalActor$.MODULE$.notifyListener(e.getChannel(), AssociationHandle$Disassociated$.MODULE$.apply(AssociationHandle$Unknown$.MODULE$));
        this.log().debug("Remote connection to [{}] was disconnected because of {}", (Object)e.getChannel().getRemoteAddress(), (Object)e);
    }

    public static void onMessage$(TcpHandlers $this, ChannelHandlerContext ctx, MessageEvent e) {
        $this.onMessage(ctx, e);
    }

    @Override
    default public void onMessage(ChannelHandlerContext ctx, MessageEvent e) {
        byte[] bytes = ((ChannelBuffer)e.getMessage()).array();
        if (bytes.length > 0) {
            ChannelLocalActor$.MODULE$.notifyListener(e.getChannel(), AssociationHandle$InboundPayload$.MODULE$.apply(ByteString$.MODULE$.apply(bytes)));
            return;
        }
    }

    public static void onException$(TcpHandlers $this, ChannelHandlerContext ctx, ExceptionEvent e) {
        $this.onException(ctx, e);
    }

    @Override
    default public void onException(ChannelHandlerContext ctx, ExceptionEvent e) {
        ChannelLocalActor$.MODULE$.notifyListener(e.getChannel(), AssociationHandle$Disassociated$.MODULE$.apply(AssociationHandle$Unknown$.MODULE$));
        this.log().warning("Remote connection to [{}] failed with {}", (Object)e.getChannel().getRemoteAddress(), (Object)e.getCause());
        e.getChannel().close();
    }
}

