/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import java.io.Serializable;
import org.apache.pekko.remote.Ack;
import org.apache.pekko.remote.Ack$;
import org.apache.pekko.remote.AckedReceiveBuffer$;
import org.apache.pekko.remote.HasSequenceNumber;
import org.apache.pekko.remote.SeqNo;
import org.apache.pekko.remote.SeqNo$;
import scala.Function1;
import scala.Product;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class AckedReceiveBuffer<T extends HasSequenceNumber>
implements Product,
Serializable {
    private final SeqNo lastDelivered;
    private final SeqNo cumulativeAck;
    private final SortedSet buf;
    private final Ordering seqOrdering;

    public static <T extends HasSequenceNumber> AckedReceiveBuffer<T> apply(SeqNo seqNo, SeqNo seqNo2, SortedSet<T> sortedSet, Ordering<T> ordering) {
        return AckedReceiveBuffer$.MODULE$.apply(seqNo, seqNo2, sortedSet, ordering);
    }

    public static <T extends HasSequenceNumber> AckedReceiveBuffer<T> unapply(AckedReceiveBuffer<T> ackedReceiveBuffer) {
        return AckedReceiveBuffer$.MODULE$.unapply(ackedReceiveBuffer);
    }

    public static <T extends HasSequenceNumber> SeqNo $lessinit$greater$default$1() {
        return AckedReceiveBuffer$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T extends HasSequenceNumber> SeqNo $lessinit$greater$default$2() {
        return AckedReceiveBuffer$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T extends HasSequenceNumber> TreeSet<T> $lessinit$greater$default$3() {
        return AckedReceiveBuffer$.MODULE$.$lessinit$greater$default$3();
    }

    public AckedReceiveBuffer(SeqNo lastDelivered, SeqNo cumulativeAck, SortedSet<T> buf, Ordering<T> seqOrdering) {
        this.lastDelivered = lastDelivered;
        this.cumulativeAck = cumulativeAck;
        this.buf = buf;
        this.seqOrdering = seqOrdering;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof AckedReceiveBuffer)) return false;
        AckedReceiveBuffer ackedReceiveBuffer = (AckedReceiveBuffer)object;
        SeqNo seqNo = this.lastDelivered();
        SeqNo seqNo2 = ackedReceiveBuffer.lastDelivered();
        if (seqNo == null) {
            if (seqNo2 != null) {
                return false;
            }
        } else if (!((Object)seqNo).equals(seqNo2)) return false;
        SeqNo seqNo3 = this.cumulativeAck();
        SeqNo seqNo4 = ackedReceiveBuffer.cumulativeAck();
        if (seqNo3 == null) {
            if (seqNo4 != null) {
                return false;
            }
        } else if (!((Object)seqNo3).equals(seqNo4)) return false;
        SortedSet<T> sortedSet = this.buf();
        SortedSet<T> sortedSet2 = ackedReceiveBuffer.buf();
        if (sortedSet == null) {
            if (sortedSet2 == null) return true;
            return false;
        } else {
            if (!sortedSet.equals(sortedSet2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof AckedReceiveBuffer;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "AckedReceiveBuffer";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "lastDelivered";
            }
            case 1: {
                return "cumulativeAck";
            }
            case 2: {
                return "buf";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public SeqNo lastDelivered() {
        return this.lastDelivered;
    }

    public SeqNo cumulativeAck() {
        return this.cumulativeAck;
    }

    public SortedSet<T> buf() {
        return this.buf;
    }

    public Ordering<T> seqOrdering() {
        return this.seqOrdering;
    }

    public AckedReceiveBuffer<T> receive(T arrivedMsg) {
        SeqNo seqNo = (SeqNo)SeqNo$.MODULE$.ord().max((Object)arrivedMsg.seq(), (Object)this.cumulativeAck());
        SortedSet sortedSet = arrivedMsg.seq().$greater(this.lastDelivered()) && !this.buf().contains(arrivedMsg) ? (SortedSet)this.buf().$plus(arrivedMsg) : this.buf();
        SeqNo seqNo2 = this.copy$default$1();
        return this.copy(seqNo2, seqNo, sortedSet, this.seqOrdering());
    }

    public Tuple3<AckedReceiveBuffer<T>, Seq<T>, Ack> extractDeliverable() {
        SortedSet sortedSet;
        ObjectRef deliver = ObjectRef.create((Object)Vector$.MODULE$.empty());
        ObjectRef ack = ObjectRef.create((Object)Ack$.MODULE$.apply(this.cumulativeAck(), Ack$.MODULE$.$lessinit$greater$default$2()));
        ObjectRef updatedLastDelivered = ObjectRef.create((Object)this.lastDelivered());
        ObjectRef prev = ObjectRef.create((Object)this.lastDelivered());
        this.buf().foreach((Function1)(JProcedure1 & Serializable)bufferedMsg -> {
            if (bufferedMsg.seq().isSuccessor((SeqNo)updatedLastDelivered$1.elem)) {
                Vector vector = (Vector)((Vector)deliver$1.elem).$colon$plus(bufferedMsg);
                deliver$1.elem = vector;
                vector = null;
                SeqNo seqNo = ((SeqNo)updatedLastDelivered$1.elem).inc();
                updatedLastDelivered$1.elem = seqNo;
                seqNo = null;
            } else if (!bufferedMsg.seq().isSuccessor((SeqNo)prev$1.elem)) {
                Set nacks = Set$.MODULE$.empty();
                for (long diff = bufferedMsg.seq().rawValue() - ((SeqNo)prev$1.elem).rawValue() - 1L; diff > 0L; --diff) {
                    nacks = (Set)nacks.$plus((Object)SeqNo$.MODULE$.apply(((SeqNo)prev$1.elem).rawValue() + diff));
                }
                Ack ack = (Ack)ack$3.elem;
                Set set = (Set)((Ack)ack$3.elem).nacks().$plus$plus((IterableOnce)nacks);
                SeqNo seqNo = ack.copy$default$1();
                Ack ack2 = ack.copy(seqNo, (Set<SeqNo>)set);
                ack$3.elem = ack2;
                ack2 = null;
            }
            SeqNo seqNo = bufferedMsg.seq();
            prev$1.elem = seqNo;
            seqNo = null;
        });
        if (((Vector)deliver.elem).isEmpty()) {
            sortedSet = this.buf();
        } else {
            Vector vector = (Vector)deliver.elem;
            sortedSet = (SortedSet)this.buf().filterNot((Function1 & Serializable)elem -> vector.contains(elem));
        }
        SortedSet newBuf = sortedSet;
        SeqNo seqNo = (SeqNo)updatedLastDelivered.elem;
        SeqNo seqNo2 = this.copy$default$2();
        return Tuple3$.MODULE$.apply(this.copy(seqNo, seqNo2, newBuf, this.seqOrdering()), (Object)((Vector)deliver.elem), (Object)((Ack)ack.elem));
    }

    public AckedReceiveBuffer<T> mergeFrom(AckedReceiveBuffer<T> that) {
        SeqNo mergedLastDelivered = (SeqNo)SeqNo$.MODULE$.ord().max((Object)this.lastDelivered(), (Object)that.lastDelivered());
        return this.copy(mergedLastDelivered, (SeqNo)SeqNo$.MODULE$.ord().max((Object)this.cumulativeAck(), (Object)that.cumulativeAck()), (SortedSet)this.buf().union(that.buf()).filter((Function1 & Serializable)_$2 -> _$2.seq().$greater(mergedLastDelivered)), this.seqOrdering());
    }

    public String toString() {
        return this.buf().map((Function1 & Serializable)_$3 -> _$3.seq(), SeqNo$.MODULE$.ord()).mkString("[", ", ", "]");
    }

    public <T extends HasSequenceNumber> AckedReceiveBuffer<T> copy(SeqNo lastDelivered, SeqNo cumulativeAck, SortedSet<T> buf, Ordering<T> seqOrdering) {
        return new AckedReceiveBuffer<T>(lastDelivered, cumulativeAck, buf, seqOrdering);
    }

    public <T extends HasSequenceNumber> SeqNo copy$default$1() {
        return this.lastDelivered();
    }

    public <T extends HasSequenceNumber> SeqNo copy$default$2() {
        return this.cumulativeAck();
    }

    public <T extends HasSequenceNumber> SortedSet<T> copy$default$3() {
        return this.buf();
    }

    public SeqNo _1() {
        return this.lastDelivered();
    }

    public SeqNo _2() {
        return this.cumulativeAck();
    }

    public SortedSet<T> _3() {
        return this.buf();
    }
}

