/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefScope;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.ActorSelectionMessage;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.LocalRef;
import org.apache.pekko.actor.PossiblyHarmful;
import org.apache.pekko.actor.RepointableRef;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.InboundMessageDispatcher;
import org.apache.pekko.remote.MessageSerializer$;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.RemoteRef;
import org.apache.pekko.remote.WireFormats;
import org.apache.pekko.util.OptionVal$;
import scala.runtime.LazyRef;

public class DefaultMessageDispatcher
implements InboundMessageDispatcher {
    private final ExtendedActorSystem system;
    private final RemoteActorRefProvider provider;
    private final MarkerLoggingAdapter log;
    private final InternalActorRef remoteDaemon;

    public DefaultMessageDispatcher(ExtendedActorSystem system, RemoteActorRefProvider provider, MarkerLoggingAdapter log) {
        this.system = system;
        this.provider = provider;
        this.log = log;
        this.remoteDaemon = provider.remoteDaemon();
    }

    private ExtendedActorSystem system() {
        return this.system;
    }

    private RemoteActorRefProvider provider() {
        return this.provider;
    }

    private MarkerLoggingAdapter log() {
        return this.log;
    }

    @Override
    public void dispatch(InternalActorRef recipient, Address recipientAddress, WireFormats.SerializedMessage serializedMessage, ActorRef senderOption) {
        InternalActorRef internalActorRef;
        ActorPath originalReceiver;
        ActorRef sender;
        LazyRef lazyRef;
        block11: {
            Object object;
            InternalActorRef l;
            block12: {
                ActorSelectionMessage sel;
                block13: {
                    block14: {
                        lazyRef = new LazyRef();
                        sender = (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)senderOption, (Object)this.system().deadLetters());
                        originalReceiver = recipient.path();
                        internalActorRef = recipient;
                        InternalActorRef internalActorRef2 = this.remoteDaemon;
                        InternalActorRef internalActorRef3 = internalActorRef;
                        if (!(internalActorRef2 != null ? !internalActorRef2.equals(internalActorRef3) : internalActorRef3 != null)) {
                            if (this.provider().remoteSettings().UntrustedMode()) {
                                this.log().debug(LogMarker$.MODULE$.Security(), "dropping daemon message in untrusted mode");
                                return;
                            }
                            this.logMessageReceived$1(recipient, originalReceiver, sender, lazyRef, serializedMessage, "daemon message");
                            Object object2 = this.payload$1(lazyRef, serializedMessage);
                            this.remoteDaemon.$bang(object2, this.remoteDaemon.$bang$default$2(object2));
                            return;
                        }
                        if (!(internalActorRef instanceof LocalRef) && !(internalActorRef instanceof RepointableRef)) break block11;
                        l = internalActorRef;
                        if (!((ActorRefScope)l).isLocal()) break block11;
                        this.logMessageReceived$1(recipient, originalReceiver, sender, lazyRef, serializedMessage, "local message");
                        object = this.payload$1(lazyRef, serializedMessage);
                        if (!(object instanceof ActorSelectionMessage)) break block12;
                        sel = (ActorSelectionMessage)object;
                        if (!this.provider().remoteSettings().UntrustedMode()) break block13;
                        if (!this.provider().remoteSettings().TrustedSelectionPaths().contains((Object)sel.elements().mkString("/", "/", "")) || sel.msg() instanceof PossiblyHarmful) break block14;
                        InternalActorRef internalActorRef4 = l;
                        InternalActorRef internalActorRef5 = this.provider().rootGuardian();
                        if (!(internalActorRef4 == null ? internalActorRef5 != null : !internalActorRef4.equals(internalActorRef5))) break block13;
                    }
                    this.log().debug(LogMarker$.MODULE$.Security(), "operating in UntrustedMode, dropping inbound actor selection to [{}], allow it by adding the path to 'pekko.remote.trusted-selection-paths' configuration", (Object)sel.elements().mkString("/", "/", ""));
                    return;
                }
                ActorSelection$.MODULE$.deliverSelection(l, sender, sel);
                return;
            }
            if (object instanceof PossiblyHarmful) {
                PossiblyHarmful msg = (PossiblyHarmful)object;
                if (this.provider().remoteSettings().UntrustedMode()) {
                    this.log().debug(LogMarker$.MODULE$.Security(), "operating in UntrustedMode, dropping inbound PossiblyHarmful message of type [{}]", (Object)msg.getClass().getName());
                    return;
                }
            }
            if (object instanceof SystemMessage) {
                SystemMessage msg = (SystemMessage)object;
                l.sendSystemMessage(msg);
                return;
            }
            Object msg = object;
            l.$bang(msg, sender);
            return;
        }
        if (internalActorRef instanceof RemoteRef || internalActorRef instanceof RepointableRef) {
            InternalActorRef r = internalActorRef;
            if (!((ActorRefScope)r).isLocal() && !this.provider().remoteSettings().UntrustedMode()) {
                this.logMessageReceived$1(recipient, originalReceiver, sender, lazyRef, serializedMessage, "remote-destined message");
                if (this.provider().transport().addresses().apply((Object)recipientAddress)) {
                    r.$bang(this.payload$1(lazyRef, serializedMessage), sender);
                    return;
                }
                this.log().error("dropping message [{}] for non-local recipient [{}] arriving at [{}] inbound addresses are [{}]", (Object)this.payloadClass$1(lazyRef, serializedMessage), (Object)r, (Object)recipientAddress, (Object)this.provider().transport().addresses().mkString(", "));
                return;
            }
        }
        InternalActorRef r = internalActorRef;
        this.log().error("dropping message [{}] for unknown recipient [{}] arriving at [{}] inbound addresses are [{}]", (Object)this.payloadClass$1(lazyRef, serializedMessage), (Object)r, (Object)recipientAddress, (Object)this.provider().transport().addresses().mkString(", "));
    }

    private final Object payload$lzyINIT1$1(LazyRef payload$lzy1$1, WireFormats.SerializedMessage serializedMessage$1) {
        Object object;
        LazyRef lazyRef = payload$lzy1$1;
        synchronized (lazyRef) {
            object = payload$lzy1$1.initialized() ? payload$lzy1$1.value() : payload$lzy1$1.initialize(MessageSerializer$.MODULE$.deserialize(this.system(), serializedMessage$1));
        }
        return object;
    }

    private final Object payload$1(LazyRef payload$lzy1$2, WireFormats.SerializedMessage serializedMessage$2) {
        if (payload$lzy1$2.initialized()) {
            return payload$lzy1$2.value();
        }
        return this.payload$lzyINIT1$1(payload$lzy1$2, serializedMessage$2);
    }

    private final Class payloadClass$1(LazyRef payload$lzy1$4, WireFormats.SerializedMessage serializedMessage$4) {
        if (this.payload$1(payload$lzy1$4, serializedMessage$4) == null) {
            return null;
        }
        return this.payload$1(payload$lzy1$4, serializedMessage$4).getClass();
    }

    private final void logMessageReceived$1(InternalActorRef recipient$4, ActorPath originalReceiver$1, ActorRef sender$1, LazyRef payload$lzy1$3, WireFormats.SerializedMessage serializedMessage$3, String messageType) {
        if (this.provider().remoteSettings().LogReceive() && this.log().isDebugEnabled()) {
            this.log().debug(new StringBuilder(53).append("received ").append(messageType).append(" RemoteMessage: [{}] to [{}]<+[{}] from [{}]").toString(), this.payload$1(payload$lzy1$3, serializedMessage$3), (Object)recipient$4, (Object)originalReceiver$1, (Object)sender$1);
            return;
        }
    }
}

