/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.Logging;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.SubchannelClassification;
import org.apache.pekko.remote.FailureDetector;
import org.apache.pekko.remote.FailureDetector$;
import org.apache.pekko.remote.FailureDetectorWithAddress;
import org.apache.pekko.remote.HeartbeatHistory;
import org.apache.pekko.remote.HeartbeatHistory$;
import org.apache.pekko.remote.PhiAccrualFailureDetector$State$;
import org.apache.pekko.remote.RemoteLogMarker$;
import org.apache.pekko.util.Helpers;
import org.apache.pekko.util.Helpers$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class PhiAccrualFailureDetector
implements FailureDetector,
FailureDetectorWithAddress {
    private final double threshold;
    private final int maxSampleSize;
    private final FiniteDuration minStdDeviation;
    private final FiniteDuration acceptableHeartbeatPause;
    private final FiniteDuration firstHeartbeatEstimate;
    private final Option<EventStream> eventStream;
    private final FailureDetector.Clock clock;
    private final HeartbeatHistory firstHeartbeat;
    private final long acceptableHeartbeatPauseMillis;
    private String address;
    public final PhiAccrualFailureDetector$State$ State$lzy1;
    private final AtomicReference<State> state;
    private final double minStdDeviationMillis;

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, Option<EventStream> eventStream, FailureDetector.Clock clock) {
        this.threshold = threshold;
        this.maxSampleSize = maxSampleSize;
        this.minStdDeviation = minStdDeviation;
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.firstHeartbeatEstimate = firstHeartbeatEstimate;
        this.eventStream = eventStream;
        this.clock = clock;
        this.State$lzy1 = new PhiAccrualFailureDetector$State$(this);
        Predef$.MODULE$.require(threshold > 0.0, PhiAccrualFailureDetector::$init$$$anonfun$1);
        Predef$.MODULE$.require(maxSampleSize > 0, PhiAccrualFailureDetector::$init$$$anonfun$2);
        Predef$.MODULE$.require(minStdDeviation.$greater((Object)Duration$.MODULE$.Zero()), PhiAccrualFailureDetector::$init$$$anonfun$3);
        Predef$.MODULE$.require(acceptableHeartbeatPause.$greater$eq((Object)Duration$.MODULE$.Zero()), PhiAccrualFailureDetector::$init$$$anonfun$4);
        Predef$.MODULE$.require(firstHeartbeatEstimate.$greater((Object)Duration$.MODULE$.Zero()), PhiAccrualFailureDetector::$init$$$anonfun$5);
        long mean = firstHeartbeatEstimate.toMillis();
        long stdDeviation = mean / 4L;
        this.firstHeartbeat = HeartbeatHistory$.MODULE$.apply(maxSampleSize).$colon$plus(mean - stdDeviation).$colon$plus(mean + stdDeviation);
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPause.toMillis();
        this.address = "N/A";
        this.state = new AtomicReference<State>(this.State().apply(this.firstHeartbeat, (Option<Object>)None$.MODULE$));
        this.minStdDeviationMillis = minStdDeviation.toMillis();
    }

    public double threshold() {
        return this.threshold;
    }

    public int maxSampleSize() {
        return this.maxSampleSize;
    }

    public FiniteDuration minStdDeviation() {
        return this.minStdDeviation;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public FiniteDuration firstHeartbeatEstimate() {
        return this.firstHeartbeatEstimate;
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, FailureDetector.Clock clock) {
        this(threshold, maxSampleSize, minStdDeviation, acceptableHeartbeatPause, firstHeartbeatEstimate, (Option<EventStream>)None$.MODULE$, clock);
    }

    public PhiAccrualFailureDetector(Config config, EventStream ev) {
        this(config.getDouble("threshold"), config.getInt("max-sample-size"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "min-std-deviation"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "acceptable-heartbeat-pause"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "heartbeat-interval"), (Option<EventStream>)Some$.MODULE$.apply((Object)ev), FailureDetector$.MODULE$.defaultClock());
    }

    @Override
    public void setAddress(String addr) {
        this.address = addr;
    }

    private final PhiAccrualFailureDetector$State$ State() {
        return this.State$lzy1;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable(this.clock.apply$mcJ$sp());
    }

    private boolean isAvailable(long timestamp) {
        return this.phi(timestamp) < this.threshold();
    }

    @Override
    public boolean isMonitoring() {
        return this.state.get().timestamp().nonEmpty();
    }

    @Override
    public final void heartbeat() {
        State newState;
        State oldState;
        do {
            HeartbeatHistory heartbeatHistory;
            long timestamp = this.clock.apply$mcJ$sp();
            oldState = this.state.get();
            Option<Object> option = oldState.timestamp();
            if (None$.MODULE$.equals(option)) {
                heartbeatHistory = this.firstHeartbeat;
            } else if (option instanceof Some) {
                long latestTimestamp = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                long interval = timestamp - latestTimestamp;
                heartbeatHistory = this.isAvailable(timestamp) ? this.recordInterval(interval) : oldState.history();
            } else {
                throw new MatchError(option);
            }
            HeartbeatHistory newHistory = heartbeatHistory;
            newState = oldState.copy(newHistory, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)timestamp)));
        } while (!this.state.compareAndSet(oldState, newState));
    }

    @InternalApi
    public HeartbeatHistory recordInterval(long interval) {
        if (interval >= this.acceptableHeartbeatPauseMillis / 3L * 2L && this.eventStream.isDefined()) {
            ((SubchannelClassification)this.eventStream.get()).publish((Object)Logging.Warning$.MODULE$.apply(this.toString(), this.getClass(), (Object)new StringBuilder(61).append("heartbeat interval is growing too large for address ").append(this.address).append(": ").append(interval).append(" millis").toString(), Logging$.MODULE$.emptyMDC(), RemoteLogMarker$.MODULE$.failureDetectorGrowing(this.address)));
        }
        return this.state.get().history().$colon$plus(interval);
    }

    public double phi() {
        return this.phi(this.clock.apply$mcJ$sp());
    }

    private double phi(long timestamp) {
        State oldState = this.state.get();
        Option<Object> oldTimestamp = oldState.timestamp();
        if (oldTimestamp.isEmpty()) {
            return 0.0;
        }
        long timeDiff = timestamp - BoxesRunTime.unboxToLong((Object)oldTimestamp.get());
        HeartbeatHistory history = oldState.history();
        double mean = history.mean();
        double stdDeviation = this.ensureValidStdDeviation(history.stdDeviation());
        return this.phi(timeDiff, mean + (double)this.acceptableHeartbeatPauseMillis, stdDeviation);
    }

    public double phi(long timeDiff, double mean, double stdDeviation) {
        double y = ((double)timeDiff - mean) / stdDeviation;
        double e = package$.MODULE$.exp(-y * (1.5976 + 0.070566 * y * y));
        if ((double)timeDiff > mean) {
            return -package$.MODULE$.log10(e / (1.0 + e));
        }
        return -package$.MODULE$.log10(1.0 - 1.0 / (1.0 + e));
    }

    private double ensureValidStdDeviation(double stdDeviation) {
        return package$.MODULE$.max(stdDeviation, this.minStdDeviationMillis);
    }

    private static final Object $init$$$anonfun$1() {
        return "failure-detector.threshold must be > 0";
    }

    private static final Object $init$$$anonfun$2() {
        return "failure-detector.max-sample-size must be > 0";
    }

    private static final Object $init$$$anonfun$3() {
        return "failure-detector.min-std-deviation must be > 0";
    }

    private static final Object $init$$$anonfun$4() {
        return "failure-detector.acceptable-heartbeat-pause must be >= 0";
    }

    private static final Object $init$$$anonfun$5() {
        return "failure-detector.heartbeat-interval must be > 0";
    }

    public class State
    implements Product,
    Serializable {
        private final HeartbeatHistory history;
        private final Option timestamp;
        private final /* synthetic */ PhiAccrualFailureDetector $outer;

        public State(PhiAccrualFailureDetector $outer, HeartbeatHistory history, Option<Object> timestamp) {
            this.history = history;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            if (((State)object).org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer() != this.$outer) return false;
            State state = (State)object;
            HeartbeatHistory heartbeatHistory = this.history();
            HeartbeatHistory heartbeatHistory2 = state.history();
            if (heartbeatHistory == null) {
                if (heartbeatHistory2 != null) {
                    return false;
                }
            } else if (!((Object)heartbeatHistory).equals(heartbeatHistory2)) return false;
            Option<Object> option = this.timestamp();
            Option<Object> option2 = state.timestamp();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "history";
            }
            if (1 == n2) {
                return "timestamp";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public HeartbeatHistory history() {
            return this.history;
        }

        public Option<Object> timestamp() {
            return this.timestamp;
        }

        public State copy(HeartbeatHistory history, Option<Object> timestamp) {
            return new State(this.$outer, history, timestamp);
        }

        public HeartbeatHistory copy$default$1() {
            return this.history();
        }

        public Option<Object> copy$default$2() {
            return this.timestamp();
        }

        public HeartbeatHistory _1() {
            return this.history();
        }

        public Option<Object> _2() {
            return this.timestamp();
        }

        public final /* synthetic */ PhiAccrualFailureDetector org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer() {
            return this.$outer;
        }
    }
}

