/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import java.net.ConnectException;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRef$;
import org.apache.pekko.actor.ActorSelectionMessage;
import org.apache.pekko.actor.ActorSelectionMessage$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.Dropped$;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.dispatch.sysmsg.DeathWatchNotification;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.dispatch.sysmsg.Unwatch;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.DaemonMsgCreate;
import org.apache.pekko.remote.PriorityMessage;
import org.apache.pekko.remote.RemoteActorRef;
import org.apache.pekko.remote.RemoteLogMarker$;
import org.apache.pekko.remote.UniqueAddress;
import org.apache.pekko.remote.UniqueAddress$;
import org.apache.pekko.remote.artery.AbstractAssociation;
import org.apache.pekko.remote.artery.ActorSystemTerminating$;
import org.apache.pekko.remote.artery.ArterySettings;
import org.apache.pekko.remote.artery.ArterySettings$Advanced$;
import org.apache.pekko.remote.artery.ArteryTransport;
import org.apache.pekko.remote.artery.ArteryTransport$ShutdownSignal$;
import org.apache.pekko.remote.artery.ArteryTransport$ShuttingDown$;
import org.apache.pekko.remote.artery.Association$;
import org.apache.pekko.remote.artery.Association$DisabledQueueWrapper$;
import org.apache.pekko.remote.artery.Association$LazyQueueWrapper$;
import org.apache.pekko.remote.artery.Association$OutboundStreamMatValues$;
import org.apache.pekko.remote.artery.Association$OutboundStreamStopIdleSignal$;
import org.apache.pekko.remote.artery.Association$OutboundStreamStopQuarantinedSignal$;
import org.apache.pekko.remote.artery.Association$QueueWrapperImpl$;
import org.apache.pekko.remote.artery.Association$RemovedQueueWrapper$;
import org.apache.pekko.remote.artery.AssociationState;
import org.apache.pekko.remote.artery.AssociationState$;
import org.apache.pekko.remote.artery.AssociationState$UidKnown$;
import org.apache.pekko.remote.artery.AssociationState$UidQuarantined$;
import org.apache.pekko.remote.artery.AssociationState$UidUnknown$;
import org.apache.pekko.remote.artery.ControlMessage;
import org.apache.pekko.remote.artery.Decoder;
import org.apache.pekko.remote.artery.Encoder;
import org.apache.pekko.remote.artery.Flush$;
import org.apache.pekko.remote.artery.FlushBeforeDeathWatchNotification$;
import org.apache.pekko.remote.artery.GracefulShutdownQuarantinedEvent$;
import org.apache.pekko.remote.artery.InboundControlJunction;
import org.apache.pekko.remote.artery.ObjectPool;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.OutboundControlJunction;
import org.apache.pekko.remote.artery.OutboundEnvelope;
import org.apache.pekko.remote.artery.OutboundHandshake;
import org.apache.pekko.remote.artery.Quarantined$;
import org.apache.pekko.remote.artery.QuarantinedEvent$;
import org.apache.pekko.remote.artery.RemotingFlightRecorder;
import org.apache.pekko.remote.artery.RestartCounter;
import org.apache.pekko.remote.artery.ReusableOutboundEnvelope;
import org.apache.pekko.remote.artery.SendQueue;
import org.apache.pekko.remote.artery.SystemMessageDelivery;
import org.apache.pekko.remote.artery.SystemMessageDelivery$ClearSystemMessageDelivery$;
import org.apache.pekko.remote.artery.aeron.AeronSink;
import org.apache.pekko.remote.artery.compress.CompressionTable;
import org.apache.pekko.stream.AbruptTerminationException;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.KillSwitches$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.SharedKillSwitch;
import org.apache.pekko.stream.StreamTcpException;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.MergeHub$;
import org.apache.pekko.stream.scaladsl.Sink;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.PrettyDuration;
import org.apache.pekko.util.PrettyDuration$;
import org.apache.pekko.util.Unsafe;
import org.apache.pekko.util.WildcardIndex;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public class Association
extends AbstractAssociation
implements OutboundContext {
    private final ArteryTransport transport;
    private final Materializer materializer;
    private final Materializer controlMaterializer;
    private final Address remoteAddress;
    private final InboundControlJunction.ControlMessageSubject controlSubject;
    private final WildcardIndex<NotUsed> largeMessageDestinations;
    private final WildcardIndex<NotUsed> priorityMessageDestinations;
    private final ObjectPool<ReusableOutboundEnvelope> outboundEnvelopePool;
    private final MarkerLoggingAdapter log;
    private final boolean deathWatchNotificationFlushEnabled;
    private final RestartCounter restartCounter;
    private final int outboundLanes;
    private final int controlQueueSize;
    private final int queueSize;
    private final int largeQueueSize;
    private final SendQueue.ProducerApi<OutboundEnvelope>[] queues;
    private volatile boolean queuesVisibility;
    private volatile OutboundControlJunction.OutboundControlIngress _outboundControlIngress;
    private volatile CountDownLatch materializing;
    private volatile Vector<Encoder.OutboundCompressionAccess> outboundCompressionAccess;
    private final AtomicReference<Map<Object, OutboundStreamMatValues>> streamMatValues;
    private final AtomicReference<Option<Cancellable>> idleTimer;
    private final AtomicReference<Option<Cancellable>> stopQuarantinedTimer;
    private volatile AssociationState _sharedStateDoNotCallMeDirectly;

    public static int ControlQueueIndex() {
        return Association$.MODULE$.ControlQueueIndex();
    }

    public static int LargeQueueIndex() {
        return Association$.MODULE$.LargeQueueIndex();
    }

    public static int OrdinaryQueueIndex() {
        return Association$.MODULE$.OrdinaryQueueIndex();
    }

    public Association(ArteryTransport transport, Materializer materializer, Materializer controlMaterializer, Address remoteAddress, InboundControlJunction.ControlMessageSubject controlSubject, WildcardIndex<NotUsed> largeMessageDestinations, WildcardIndex<NotUsed> priorityMessageDestinations, ObjectPool<ReusableOutboundEnvelope> outboundEnvelopePool) {
        this.transport = transport;
        this.materializer = materializer;
        this.controlMaterializer = controlMaterializer;
        this.remoteAddress = remoteAddress;
        this.controlSubject = controlSubject;
        this.largeMessageDestinations = largeMessageDestinations;
        this.priorityMessageDestinations = priorityMessageDestinations;
        this.outboundEnvelopePool = outboundEnvelopePool;
        Predef$.MODULE$.require(remoteAddress.port().nonEmpty());
        this.log = Logging$.MODULE$.withMarker((ActorSystem)transport.system(), Association.class, LogSource$.MODULE$.fromAnyClass());
        this.deathWatchNotificationFlushEnabled = this.advancedSettings().DeathWatchNotificationFlushTimeout().$greater((Object)Duration$.MODULE$.Zero()) && transport.provider().settings().HasCluster();
        this.restartCounter = new RestartCounter(this.advancedSettings().OutboundMaxRestarts(), this.advancedSettings().OutboundRestartTimeout());
        this.outboundLanes = this.advancedSettings().OutboundLanes();
        this.controlQueueSize = this.advancedSettings().OutboundControlQueueSize();
        this.queueSize = this.advancedSettings().OutboundMessageQueueSize();
        this.largeQueueSize = this.advancedSettings().OutboundLargeMessageQueueSize();
        this.queues = new SendQueue.ProducerApi[2 + this.outboundLanes];
        this.queues[0] = Association$QueueWrapperImpl$.MODULE$.apply(this.createQueue(this.controlQueueSize, 0));
        this.queues[1] = transport.largeMessageChannelEnabled() ? Association$QueueWrapperImpl$.MODULE$.apply(this.createQueue(this.largeQueueSize, 1)) : Association$DisabledQueueWrapper$.MODULE$;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.outboundLanes).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.queues[2 + i] = Association$QueueWrapperImpl$.MODULE$.apply(this.createQueue(this.queueSize, 2 + i));
        });
        this.queuesVisibility = false;
        OptionVal$.MODULE$.None();
        this._outboundControlIngress = null;
        this.materializing = new CountDownLatch(1);
        this.outboundCompressionAccess = scala.package$.MODULE$.Vector().empty();
        this.streamMatValues = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        this.idleTimer = new AtomicReference<None$>(None$.MODULE$);
        this.stopQuarantinedTimer = new AtomicReference<None$>(None$.MODULE$);
        this._sharedStateDoNotCallMeDirectly = AssociationState$.MODULE$.apply();
    }

    public ArteryTransport transport() {
        return this.transport;
    }

    public Materializer materializer() {
        return this.materializer;
    }

    public Materializer controlMaterializer() {
        return this.controlMaterializer;
    }

    @Override
    public Address remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public InboundControlJunction.ControlMessageSubject controlSubject() {
        return this.controlSubject;
    }

    private RemotingFlightRecorder flightRecorder() {
        return this.transport().flightRecorder();
    }

    @Override
    public ArterySettings settings() {
        return this.transport().settings();
    }

    private ArterySettings$Advanced$ advancedSettings() {
        return this.transport().settings().Advanced();
    }

    public Queue<OutboundEnvelope> createQueue(int capacity, int queueIndex) {
        boolean linked;
        boolean bl = linked = queueIndex == 0 || queueIndex == 1;
        if (linked) {
            return new LinkedBlockingQueue<OutboundEnvelope>(capacity);
        }
        return new ManyToOneConcurrentArrayQueue(capacity);
    }

    private SendQueue.ProducerApi<OutboundEnvelope> controlQueue() {
        return this.queues[0];
    }

    public Future<Done> changeActorRefCompression(CompressionTable<ActorRef> table) {
        return this.updateOutboundCompression((Function1<Encoder.OutboundCompressionAccess, Future<Done>>)(Function1 & Serializable)c -> c.changeActorRefCompression(table));
    }

    public Future<Done> changeClassManifestCompression(CompressionTable<String> table) {
        return this.updateOutboundCompression((Function1<Encoder.OutboundCompressionAccess, Future<Done>>)(Function1 & Serializable)c -> c.changeClassManifestCompression(table));
    }

    private Future<Done> clearOutboundCompression() {
        return this.updateOutboundCompression((Function1<Encoder.OutboundCompressionAccess, Future<Done>>)(Function1 & Serializable)c -> c.clearCompression());
    }

    private Future<Done> updateOutboundCompression(Function1<Encoder.OutboundCompressionAccess, Future<Done>> action) {
        MessageDispatcher ec = this.transport().system().dispatchers().internalDispatcher();
        Vector<Encoder.OutboundCompressionAccess> c = this.outboundCompressionAccess;
        if (c.isEmpty()) {
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        if (c.size() == 1) {
            return (Future)action.apply(c.head());
        }
        return Future$.MODULE$.sequence((IterableOnce)c.map(action), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)ec).map((Function1 & Serializable)_$2 -> Done$.MODULE$, (ExecutionContext)ec);
    }

    private void clearInboundCompression(long originUid) {
        Decoder.InboundCompressionAccess inboundCompressionAccess = this.transport().inboundCompressionAccess();
        Decoder.InboundCompressionAccess inboundCompressionAccess2 = (Decoder.InboundCompressionAccess)OptionVal.Some$.MODULE$.unapply((Object)inboundCompressionAccess);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)inboundCompressionAccess2)) {
            Decoder.InboundCompressionAccess inboundCompressionAccess3;
            Decoder.InboundCompressionAccess access = inboundCompressionAccess3 = (Decoder.InboundCompressionAccess)OptionVal$.MODULE$.get$extension((Object)inboundCompressionAccess2);
            access.closeCompressionFor(originUid);
            return;
        }
    }

    private ActorRef deadletters() {
        return this.transport().system().deadLetters();
    }

    public OutboundControlJunction.OutboundControlIngress outboundControlIngress() {
        OutboundControlJunction.OutboundControlIngress outboundControlIngress = this._outboundControlIngress;
        OutboundControlJunction.OutboundControlIngress outboundControlIngress2 = (OutboundControlJunction.OutboundControlIngress)OptionVal.Some$.MODULE$.unapply((Object)outboundControlIngress);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundControlIngress2)) {
            OutboundControlJunction.OutboundControlIngress outboundControlIngress3;
            OutboundControlJunction.OutboundControlIngress o = outboundControlIngress3 = (OutboundControlJunction.OutboundControlIngress)OptionVal$.MODULE$.get$extension((Object)outboundControlIngress2);
            return o;
        }
        SendQueue.ProducerApi<OutboundEnvelope> producerApi = this.controlQueue();
        if (producerApi instanceof LazyQueueWrapper) {
            LazyQueueWrapper w = (LazyQueueWrapper)producerApi;
            w.runMaterialize();
        }
        this.materializing.await(10L, TimeUnit.SECONDS);
        OutboundControlJunction.OutboundControlIngress outboundControlIngress4 = this._outboundControlIngress;
        OutboundControlJunction.OutboundControlIngress outboundControlIngress5 = (OutboundControlJunction.OutboundControlIngress)OptionVal.Some$.MODULE$.unapply((Object)outboundControlIngress4);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundControlIngress5)) {
            OutboundControlJunction.OutboundControlIngress outboundControlIngress6;
            OutboundControlJunction.OutboundControlIngress o = outboundControlIngress6 = (OutboundControlJunction.OutboundControlIngress)OptionVal$.MODULE$.get$extension((Object)outboundControlIngress5);
            return o;
        }
        if (this.transport().isShutdown() || this.isRemovedAfterQuarantined()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        throw new IllegalStateException(new StringBuilder(49).append("outboundControlIngress for [").append(this.remoteAddress()).append("] not initialized yet").toString());
    }

    @Override
    public UniqueAddress localAddress() {
        return this.transport().localAddress();
    }

    public AssociationState _sharedStateDoNotCallMeDirectly() {
        return this._sharedStateDoNotCallMeDirectly;
    }

    public void _sharedStateDoNotCallMeDirectly_$eq(AssociationState x$1) {
        this._sharedStateDoNotCallMeDirectly = x$1;
    }

    public boolean swapState(AssociationState oldState, AssociationState newState) {
        return Unsafe.instance.compareAndSwapObject(this, AbstractAssociation.sharedStateOffset, oldState, newState);
    }

    @Override
    public AssociationState associationState() {
        return (AssociationState)Unsafe.instance.getObjectVolatile(this, AbstractAssociation.sharedStateOffset);
    }

    public void setControlIdleKillSwitch(SharedKillSwitch killSwitch) {
        AssociationState current = this.associationState();
        this.swapState(current, current.withControlIdleKillSwitch(killSwitch));
    }

    public Future<Done> completeHandshake(UniqueAddress peer) {
        Address address = this.remoteAddress();
        Address address2 = peer.address();
        Predef$.MODULE$.require(!(address != null ? !address.equals(address2) : address2 != null), () -> this.completeHandshake$$anonfun$1(peer));
        AssociationState current = this.associationState();
        Option<UniqueAddress> option = current.uniqueRemoteAddress();
        if (option instanceof Some) {
            UniqueAddress uniqueAddress = peer;
            Object object = ((Some)option).value();
            if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(object) : object != null)) {
                return Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
        }
        MessageDispatcher ec = this.transport().system().dispatchers().internalDispatcher();
        return this.clearOutboundCompression().map((Function1 & Serializable)_$3 -> {
            block8: {
                AssociationState newState;
                block7: {
                    current.completeUniqueRemoteAddress(peer);
                    Option<UniqueAddress> option = current.uniqueRemoteAddress();
                    if (!(option instanceof Some)) break block7;
                    UniqueAddress uniqueAddress = peer;
                    Object object = ((Some)option).value();
                    if (!(uniqueAddress == null ? object != null : !((Object)uniqueAddress).equals(object))) break block8;
                }
                if (this.swapState(current, newState = current.newIncarnation(peer))) {
                    Option<UniqueAddress> option = current.uniqueRemoteAddress();
                    if (option instanceof Some) {
                        UniqueAddress old = (UniqueAddress)((Some)option).value();
                        this.cancelStopQuarantinedTimer();
                        this.log.debug("Incarnation {} of association to [{}] with new UID [{}] (old UID [{}])", (Object)BoxesRunTime.boxToInteger((int)newState.incarnation()), (Object)peer.address(), (Object)BoxesRunTime.boxToLong((long)peer.uid()), (Object)BoxesRunTime.boxToLong((long)old.uid()));
                        this.clearInboundCompression(old.uid());
                    } else if (!None$.MODULE$.equals(option)) {
                        throw new MatchError(option);
                    }
                }
            }
            return Done$.MODULE$;
        }, (ExecutionContext)ec);
    }

    @Override
    public void sendControl(ControlMessage message) {
        block4: {
            try {
                if (!this.transport().isShutdown() && !this.isRemovedAfterQuarantined()) {
                    if (this.associationState().isQuarantined()) {
                        this.log.debug("Send control message [{}] to quarantined [{}]", (Object)Logging$.MODULE$.messageClassName((Object)message), (Object)this.remoteAddress());
                        this.setupStopQuarantinedTimer();
                    }
                    this.outboundControlIngress().sendControlMessage(message);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (ArteryTransport$ShuttingDown$.MODULE$.equals(throwable2)) break block4;
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(Object message, ActorRef sender, RemoteActorRef recipient) {
        boolean unused = this.queuesVisibility;
        AssociationState state = this.associationState();
        boolean quarantined = state.isQuarantined();
        boolean messageIsClearSystemMessageDelivery = message instanceof SystemMessageDelivery.ClearSystemMessageDelivery;
        if (!(message instanceof ActorSelectionMessage) && quarantined && !messageIsClearSystemMessageDelivery) {
            if (!this.log.isDebugEnabled()) return;
            this.log.debug("Dropping message [{}] from [{}] to [{}] due to quarantined system [{}]", (Object)Logging$.MODULE$.messageClassName(message), OptionVal$.MODULE$.getOrElse$extension((Object)sender, (Object)this.deadletters()), OptionVal$.MODULE$.getOrElse$extension((Object)recipient, (Object)new OptionVal((Object)recipient)), (Object)this.remoteAddress());
            return;
        }
        if (quarantined && !messageIsClearSystemMessageDelivery) {
            this.log.debug("Quarantine piercing attempt with message [{}] to [{}]", (Object)Logging$.MODULE$.messageClassName(message), OptionVal$.MODULE$.getOrElse$extension((Object)recipient, (Object)""));
            this.setupStopQuarantinedTimer();
        }
        try {
            Object object;
            OutboundEnvelope outboundEnvelope;
            block13: {
                block12: {
                    block11: {
                        outboundEnvelope = this.createOutboundEnvelope$1(recipient, message, sender);
                        object = message;
                        if (object instanceof DeathWatchNotification) {
                            DeathWatchNotification d = (DeathWatchNotification)object;
                            if (this.deathWatchNotificationFlushEnabled && this.shouldSendDeathWatchNotification$1(d)) {
                                Promise flushingPromise = Promise$.MODULE$.apply();
                                this.log.debug("Delaying death watch notification until flush has been sent. {}", (Object)d);
                                this.transport().system().systemActorOf(FlushBeforeDeathWatchNotification$.MODULE$.props((Promise<Done>)flushingPromise, this.settings().Advanced().DeathWatchNotificationFlushTimeout(), this).withDispatcher("pekko.actor.internal-dispatcher"), FlushBeforeDeathWatchNotification$.MODULE$.nextName());
                                flushingPromise.future().onComplete((Function1)(JProcedure1 & Serializable)_$4 -> {
                                    this.log.debug("Sending death watch notification as flush is complete. {}", (Object)d);
                                    this.sendSystemMessage$1(recipient, message, outboundEnvelope);
                                }, (ExecutionContext)this.materializer().executionContext());
                                return;
                            }
                        }
                        if (object instanceof SystemMessage) {
                            this.sendSystemMessage$1(recipient, message, outboundEnvelope);
                            return;
                        }
                        if (!(object instanceof ActorSelectionMessage)) break block11;
                        ActorSelectionMessage actorSelectionMessage = ActorSelectionMessage$.MODULE$.unapply((ActorSelectionMessage)object);
                        Object object2 = actorSelectionMessage._1();
                        scala.collection.immutable.Iterable iterable = actorSelectionMessage._2();
                        boolean bl = actorSelectionMessage._3();
                        if (object2 instanceof PriorityMessage) break block12;
                    }
                    if (!(object instanceof ControlMessage) && !(object instanceof SystemMessageDelivery.ClearSystemMessageDelivery)) break block13;
                }
                if (this.controlQueue().offer(outboundEnvelope)) return;
                this.dropped$1(recipient, message, 0, this.controlQueueSize, outboundEnvelope);
                return;
            }
            if (object instanceof DaemonMsgCreate) {
                if (this.controlQueue().offer(outboundEnvelope)) return;
                this.dropped$1(recipient, message, 0, this.controlQueueSize, outboundEnvelope);
                return;
            }
            int queueIndex = this.selectQueue(recipient);
            SendQueue.ProducerApi<OutboundEnvelope> queue = this.queues[queueIndex];
            boolean offerOk = queue.offer(outboundEnvelope);
            if (offerOk) return;
            this.dropped$1(recipient, message, queueIndex, this.queueSize, outboundEnvelope);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!ArteryTransport$ShuttingDown$.MODULE$.equals(throwable2)) throw throwable;
            return;
        }
    }

    private int selectQueue(RemoteActorRef recipient) {
        RemoteActorRef remoteActorRef = recipient;
        RemoteActorRef remoteActorRef2 = (RemoteActorRef)OptionVal.Some$.MODULE$.unapply((Object)remoteActorRef);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)remoteActorRef2)) {
            RemoteActorRef remoteActorRef3 = (RemoteActorRef)OptionVal$.MODULE$.get$extension((Object)remoteActorRef2);
            RemoteActorRef r = remoteActorRef3;
            int n = r.cachedSendQueueIndex();
            if (-1 == n) {
                int n2;
                scala.collection.immutable.Iterable elements = r.path().elements();
                if (this.priorityMessageDestinations.find((Iterable)elements).isDefined()) {
                    this.log.debug("Using priority message stream for {}", (Object)r.path());
                    n2 = 0;
                } else if (this.transport().largeMessageChannelEnabled() && this.largeMessageDestinations.find((Iterable)elements).isDefined()) {
                    this.log.debug("Using large message stream for {}", (Object)r.path());
                    n2 = 1;
                } else {
                    n2 = this.outboundLanes == 1 ? 2 : 2 + package$.MODULE$.abs(r.path().uid() % this.outboundLanes);
                }
                int idx = n2;
                r.cachedSendQueueIndex_$eq(idx);
                return idx;
            }
            int idx = n;
            return idx;
        }
        return 2;
    }

    @Override
    public boolean isOrdinaryMessageStreamActive() {
        return this.isStreamActive(2);
    }

    public boolean isStreamActive(int queueIndex) {
        SendQueue.ProducerApi<OutboundEnvelope> producerApi = this.queues[queueIndex];
        if (producerApi instanceof LazyQueueWrapper) {
            return false;
        }
        if (Association$DisabledQueueWrapper$.MODULE$.equals(producerApi)) {
            return false;
        }
        return !Association$RemovedQueueWrapper$.MODULE$.equals(producerApi);
    }

    public int sendTerminationHint(ActorRef replyTo) {
        this.log.debug("Sending ActorSystemTerminating to all queues");
        return this.sendToAllQueues(ActorSystemTerminating$.MODULE$.apply(this.localAddress()), replyTo, false);
    }

    public int sendFlush(ActorRef replyTo, boolean excludeControlQueue) {
        return this.sendToAllQueues(Flush$.MODULE$, replyTo, excludeControlQueue);
    }

    public int sendToAllQueues(ControlMessage msg, ActorRef replyTo, boolean excludeControlQueue) {
        if (!this.associationState().isQuarantined()) {
            Iterator iterator;
            IntRef sent = IntRef.create((int)0);
            if (excludeControlQueue) {
                Object object = Predef$.MODULE$.refArrayOps((Object[])this.queues);
                iterator = ArrayOps$.MODULE$.iterator$extension(object).drop(1);
            } else {
                Object object = Predef$.MODULE$.refArrayOps((Object[])this.queues);
                iterator = ArrayOps$.MODULE$.iterator$extension(object);
            }
            Iterator queuesIter = iterator;
            queuesIter.filter((Function1 & Serializable)q -> q.isEnabled() && !(q instanceof LazyQueueWrapper)).foreach((Function1)(JProcedure1 & Serializable)queue -> {
                block2: {
                    try {
                        int n;
                        OptionVal$.MODULE$.None();
                        OutboundEnvelope envelope = this.outboundEnvelopePool.acquire().init(null, msg, (ActorRef)OptionVal.Some$.MODULE$.apply((Object)replyTo));
                        queue.offer(envelope);
                        sent$1.elem = n = sent$1.elem + 1;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (ArteryTransport$ShuttingDown$.MODULE$.equals(throwable2)) break block2;
                        throw throwable;
                    }
                }
            });
            return sent.elem;
        }
        return 0;
    }

    @Override
    public void quarantine(String reason) {
        Option uid = this.associationState().uniqueRemoteAddress().map((Function1 & Serializable)_$5 -> _$5.uid());
        this.quarantine(reason, (Option<Object>)uid, false);
    }

    public final void quarantine(String reason, Option<Object> uid, boolean harmless) {
        Option<Object> option;
        while ((option = uid) instanceof Some) {
            long u = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            AssociationState current = this.associationState();
            Option<UniqueAddress> option2 = current.uniqueRemoteAddress();
            if (option2 instanceof Some) {
                UniqueAddress uniqueAddress = (UniqueAddress)((Some)option2).value();
                UniqueAddress peer = uniqueAddress;
                if (peer.uid() == u) {
                    if (!current.isQuarantined(u)) {
                        AssociationState newState = current.newQuarantined();
                        if (!this.swapState(current, newState)) continue;
                        if (harmless) {
                            this.log.info("Association to [{}] having UID [{}] has been stopped. All messages to this UID will be delivered to dead letters. Reason: {}", (Object)this.remoteAddress(), (Object)BoxesRunTime.boxToLong((long)u), (Object)reason);
                            this.transport().system().eventStream().publish((Object)GracefulShutdownQuarantinedEvent$.MODULE$.apply(UniqueAddress$.MODULE$.apply(this.remoteAddress(), u), reason));
                        } else {
                            this.log.warning(RemoteLogMarker$.MODULE$.quarantine(this.remoteAddress(), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)u))), "Association to [{}] with UID [{}] is irrecoverably failed. UID is now quarantined and all messages to this UID will be delivered to dead letters. Remote ActorSystem must be restarted to recover from this situation. Reason: {}", (Object)this.remoteAddress(), (Object)BoxesRunTime.boxToLong((long)u), (Object)reason);
                            this.transport().system().eventStream().publish((Object)QuarantinedEvent$.MODULE$.apply(UniqueAddress$.MODULE$.apply(this.remoteAddress(), u)));
                        }
                        this.flightRecorder().transportQuarantined(this.remoteAddress(), u);
                        this.clearOutboundCompression();
                        this.clearInboundCompression(u);
                        SystemMessageDelivery.ClearSystemMessageDelivery clearSystemMessageDelivery = SystemMessageDelivery$ClearSystemMessageDelivery$.MODULE$.apply(current.incarnation());
                        OptionVal$.MODULE$.None();
                        OptionVal$.MODULE$.None();
                        this.send(clearSystemMessageDelivery, null, null);
                        if (!harmless) {
                            this.sendControl(Quarantined$.MODULE$.apply(this.localAddress(), peer));
                        }
                        this.setupStopQuarantinedTimer();
                        return;
                    }
                    return;
                }
                UniqueAddress peer2 = uniqueAddress;
                this.log.info(RemoteLogMarker$.MODULE$.quarantine(this.remoteAddress(), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)u))), "Quarantine of [{}] ignored due to non-matching UID, quarantine requested for [{}] but current is [{}]. Reason: {}", (Object)this.remoteAddress(), (Object)BoxesRunTime.boxToLong((long)u), (Object)BoxesRunTime.boxToLong((long)peer2.uid()), (Object)reason);
                SystemMessageDelivery.ClearSystemMessageDelivery clearSystemMessageDelivery = SystemMessageDelivery$ClearSystemMessageDelivery$.MODULE$.apply(current.incarnation() - 1);
                OptionVal$.MODULE$.None();
                OptionVal$.MODULE$.None();
                this.send(clearSystemMessageDelivery, null, null);
                return;
            }
            if (None$.MODULE$.equals(option2)) {
                this.log.info(RemoteLogMarker$.MODULE$.quarantine(this.remoteAddress(), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)u))), "Quarantine of [{}] ignored because handshake not completed, quarantine request was for old incarnation. Reason: {}", (Object)this.remoteAddress(), (Object)reason);
                return;
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            this.log.warning(RemoteLogMarker$.MODULE$.quarantine(this.remoteAddress(), (Option<Object>)None$.MODULE$), "Quarantine of [{}] ignored because unknown UID. Reason: {}", (Object)this.remoteAddress(), (Object)reason);
            return;
        }
        throw new MatchError(option);
    }

    public void removedAfterQuarantined() {
        if (!this.isRemovedAfterQuarantined()) {
            this.flightRecorder().transportRemoveQuarantined(this.remoteAddress());
            this.queues[0] = Association$RemovedQueueWrapper$.MODULE$;
            if (this.transport().largeMessageChannelEnabled()) {
                this.queues[1] = Association$RemovedQueueWrapper$.MODULE$;
            }
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.outboundLanes).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                this.queues[2 + i] = Association$RemovedQueueWrapper$.MODULE$;
            });
            this.queuesVisibility = true;
            OptionVal$.MODULE$.None();
            this._outboundControlIngress = null;
            this.outboundCompressionAccess = scala.package$.MODULE$.Vector().empty();
            this.cancelAllTimers();
            this.abortQuarantined();
            this.log.info("Unused association to [{}] removed after quarantine", (Object)this.remoteAddress());
            return;
        }
    }

    public boolean isRemovedAfterQuarantined() {
        SendQueue.ProducerApi<OutboundEnvelope> producerApi = this.queues[0];
        Association$RemovedQueueWrapper$ association$RemovedQueueWrapper$ = Association$RemovedQueueWrapper$.MODULE$;
        return !(producerApi != null ? !producerApi.equals(association$RemovedQueueWrapper$) : association$RemovedQueueWrapper$ != null);
    }

    private void cancelStopQuarantinedTimer() {
        Option<Cancellable> current = this.stopQuarantinedTimer.get();
        current.foreach((Function1 & Serializable)_$6 -> _$6.cancel());
        this.stopQuarantinedTimer.compareAndSet(current, (Option<Cancellable>)None$.MODULE$);
    }

    private void setupStopQuarantinedTimer() {
        this.cancelStopQuarantinedTimer();
        this.stopQuarantinedTimer.set((Option<Cancellable>)Some$.MODULE$.apply((Object)this.transport().system().scheduler().scheduleOnce(this.advancedSettings().StopQuarantinedAfterIdle(), (Function0 & Serializable)() -> {
            this.setupStopQuarantinedTimer$$anonfun$1();
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.transport().system().dispatchers().internalDispatcher())));
    }

    private void abortQuarantined() {
        this.cancelIdleTimer();
        ((IterableOnceOps)this.streamMatValues.get()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                OutboundStreamMatValues outboundStreamMatValues = (OutboundStreamMatValues)tuple2._2();
                int queueIndex = BoxesRunTime.unboxToInt((Object)tuple2._1());
                if (outboundStreamMatValues != null) {
                    OutboundStreamMatValues outboundStreamMatValues2 = Association$OutboundStreamMatValues$.MODULE$.unapply(outboundStreamMatValues);
                    SharedKillSwitch sharedKillSwitch = outboundStreamMatValues2._1();
                    Future<Done> future = outboundStreamMatValues2._2();
                    StopSignal stopSignal = outboundStreamMatValues2._3();
                    SharedKillSwitch killSwitch = sharedKillSwitch;
                    SharedKillSwitch sharedKillSwitch2 = killSwitch;
                    SharedKillSwitch sharedKillSwitch3 = (SharedKillSwitch)OptionVal.Some$.MODULE$.unapply((Object)sharedKillSwitch2);
                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)sharedKillSwitch3)) {
                        SharedKillSwitch sharedKillSwitch4;
                        SharedKillSwitch k = sharedKillSwitch4 = (SharedKillSwitch)OptionVal$.MODULE$.get$extension((Object)sharedKillSwitch3);
                        this.setStopReason(queueIndex, Association$OutboundStreamStopQuarantinedSignal$.MODULE$);
                        this.clearStreamKillSwitch(queueIndex, k);
                        k.abort((Throwable)Association$OutboundStreamStopQuarantinedSignal$.MODULE$);
                        return;
                    }
                    return;
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private void cancelIdleTimer() {
        Option<Cancellable> current = this.idleTimer.get();
        current.foreach((Function1 & Serializable)_$7 -> _$7.cancel());
        this.idleTimer.compareAndSet(current, (Option<Cancellable>)None$.MODULE$);
    }

    private void setupIdleTimer() {
        if (this.idleTimer.get().isEmpty()) {
            FiniteDuration StopIdleOutboundAfter = this.settings().Advanced().StopIdleOutboundAfter();
            FiniteDuration QuarantineIdleOutboundAfter = this.settings().Advanced().QuarantineIdleOutboundAfter();
            FiniteDuration interval = StopIdleOutboundAfter.$div(2L);
            FiniteDuration initialDelay = this.settings().Advanced().Tcp().ConnectionTimeout().max(StopIdleOutboundAfter).$plus(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second());
            Cancellable task = this.transport().system().scheduler().scheduleWithFixedDelay(initialDelay, interval, () -> {
                long lastUsedDurationNanos = System.nanoTime() - this.associationState().lastUsedTimestamp().get();
                if (lastUsedDurationNanos >= QuarantineIdleOutboundAfter.toNanos() && !this.associationState().isQuarantined()) {
                    this.quarantine(new StringBuilder(50).append("Idle longer than quarantine-idle-outbound-after [").append(PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)QuarantineIdleOutboundAfter))).append("]").toString());
                    AssociationState.UniqueRemoteAddressState uniqueRemoteAddressState = this.associationState().uniqueRemoteAddressState();
                    if (AssociationState$UidQuarantined$.MODULE$.equals(uniqueRemoteAddressState)) {
                        return;
                    }
                    if (AssociationState$UidKnown$.MODULE$.equals(uniqueRemoteAddressState)) {
                        return;
                    }
                    if (AssociationState$UidUnknown$.MODULE$.equals(uniqueRemoteAddressState)) {
                        long newLastUsedDurationNanos = System.nanoTime() - this.associationState().lastUsedTimestamp().get();
                        if (newLastUsedDurationNanos >= QuarantineIdleOutboundAfter.toNanos()) {
                            this.abortQuarantined();
                            return;
                        }
                        return;
                    }
                    throw new MatchError((Object)uniqueRemoteAddressState);
                }
                if (lastUsedDurationNanos >= StopIdleOutboundAfter.toNanos()) {
                    ((IterableOnceOps)this.streamMatValues.get()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            OutboundStreamMatValues outboundStreamMatValues = (OutboundStreamMatValues)tuple2._2();
                            int queueIndex = BoxesRunTime.unboxToInt((Object)tuple2._1());
                            if (outboundStreamMatValues != null) {
                                OutboundStreamMatValues outboundStreamMatValues2 = Association$OutboundStreamMatValues$.MODULE$.unapply(outboundStreamMatValues);
                                SharedKillSwitch sharedKillSwitch = outboundStreamMatValues2._1();
                                Future<Done> future = outboundStreamMatValues2._2();
                                StopSignal stopSignal = outboundStreamMatValues2._3();
                                SharedKillSwitch streamKillSwitch = sharedKillSwitch;
                                StopSignal stopping = stopSignal;
                                if (this.isStreamActive(queueIndex) && OptionVal$.MODULE$.isEmpty$extension((Object)stopping)) {
                                    if (queueIndex != 0) {
                                        SharedKillSwitch sharedKillSwitch2 = streamKillSwitch;
                                        SharedKillSwitch sharedKillSwitch3 = (SharedKillSwitch)OptionVal.Some$.MODULE$.unapply((Object)sharedKillSwitch2);
                                        if (!OptionVal$.MODULE$.isEmpty$extension((Object)sharedKillSwitch3)) {
                                            SharedKillSwitch sharedKillSwitch4;
                                            SharedKillSwitch k = sharedKillSwitch4 = (SharedKillSwitch)OptionVal$.MODULE$.get$extension((Object)sharedKillSwitch3);
                                            this.log.info("Stopping idle outbound stream [{}] to [{}]", (Object)BoxesRunTime.boxToInteger((int)queueIndex), (Object)this.remoteAddress());
                                            this.flightRecorder().transportStopIdleOutbound(this.remoteAddress(), queueIndex);
                                            this.setStopReason(queueIndex, Association$OutboundStreamStopIdleSignal$.MODULE$);
                                            this.clearStreamKillSwitch(queueIndex, k);
                                            k.abort((Throwable)Association$OutboundStreamStopIdleSignal$.MODULE$);
                                            return;
                                        }
                                        return;
                                    }
                                    SharedKillSwitch sharedKillSwitch5 = this.associationState().controlIdleKillSwitch();
                                    SharedKillSwitch sharedKillSwitch6 = (SharedKillSwitch)OptionVal.Some$.MODULE$.unapply((Object)sharedKillSwitch5);
                                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)sharedKillSwitch6)) {
                                        SharedKillSwitch sharedKillSwitch7;
                                        SharedKillSwitch killSwitch = sharedKillSwitch7 = (SharedKillSwitch)OptionVal$.MODULE$.get$extension((Object)sharedKillSwitch6);
                                        this.log.info("Stopping idle outbound control stream to [{}]", (Object)this.remoteAddress());
                                        this.flightRecorder().transportStopIdleOutbound(this.remoteAddress(), queueIndex);
                                        OptionVal$.MODULE$.None();
                                        this.setControlIdleKillSwitch(null);
                                        killSwitch.abort((Throwable)Association$OutboundStreamStopIdleSignal$.MODULE$);
                                        return;
                                    }
                                    return;
                                }
                                return;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    return;
                }
            }, (ExecutionContext)this.transport().system().dispatcher());
            if (!this.idleTimer.compareAndSet((Option<Cancellable>)None$.MODULE$, (Option<Cancellable>)Some$.MODULE$.apply((Object)task))) {
                task.cancel();
                return;
            }
            return;
        }
    }

    private void cancelAllTimers() {
        this.cancelIdleTimer();
        this.cancelStopQuarantinedTimer();
    }

    private <T> void sendToDeadLetters(Vector<OutboundEnvelope> pending) {
        pending.foreach((Function1)(JProcedure1 & Serializable)_$8 -> {
            ActorRef actorRef = this.transport().system().deadLetters();
            actorRef.$bang(_$8, actorRef.$bang$default$2(_$8));
        });
    }

    public void associate() {
        if (!(this.controlQueue() instanceof QueueWrapper)) {
            throw new IllegalStateException("associate() must only be called once");
        }
        this.runOutboundStreams();
    }

    private void runOutboundStreams() {
        this.runOutboundControlStream();
        this.runOutboundOrdinaryMessagesStream();
        if (this.transport().largeMessageChannelEnabled()) {
            this.runOutboundLargeMessagesStream();
            return;
        }
    }

    private void runOutboundControlStream() {
        SendQueue.QueueValue queueValue;
        Tuple2 tuple2;
        SharedKillSwitch streamKillSwitch;
        QueueWrapper wrapper;
        block5: {
            Tuple2 tuple22;
            block4: {
                if (this.transport().isShutdown()) {
                    throw ArteryTransport$ShuttingDown$.MODULE$;
                }
                this.log.debug("Starting outbound control stream to [{}]", (Object)this.remoteAddress());
                this.queues[0] = wrapper = this.getOrCreateQueueWrapper(0, this.queueSize);
                this.queuesVisibility = true;
                streamKillSwitch = KillSwitches$.MODULE$.shared("outboundControlStreamKillSwitch");
                tuple22 = (Tuple2)Source$.MODULE$.fromGraph(new SendQueue((JProcedure1 & Serializable)pending -> this.sendQueuePostStop$1((Vector)pending))).via(streamKillSwitch.flow()).toMat(this.transport().outboundControl(this), Keep$.MODULE$.both()).run(this.materializer());
                if (tuple22 == null) break block4;
                tuple2 = (Tuple2)tuple22._2();
                queueValue = (SendQueue.QueueValue)tuple22._1();
                if (tuple2 != null) break block5;
            }
            throw new MatchError((Object)tuple22);
        }
        OutboundControlJunction.OutboundControlIngress control = (OutboundControlJunction.OutboundControlIngress)tuple2._1();
        Future completed = (Future)tuple2._2();
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)queueValue, (Object)control, (Object)completed);
        SendQueue.QueueValue queueValue2 = (SendQueue.QueueValue)tuple3._1();
        OutboundControlJunction.OutboundControlIngress control2 = (OutboundControlJunction.OutboundControlIngress)tuple3._2();
        Future completed2 = (Future)tuple3._3();
        queueValue2.inject(wrapper.queue());
        this.queues[0] = queueValue2;
        this.queuesVisibility = true;
        this._outboundControlIngress = (OutboundControlJunction.OutboundControlIngress)OptionVal.Some$.MODULE$.apply((Object)control2);
        this.materializing.countDown();
        this.updateStreamMatValues(0, streamKillSwitch, (Future<Done>)completed2);
        this.setupIdleTimer();
        this.attachOutboundStreamRestart("Outbound control stream", 0, this.controlQueueSize, (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.runOutboundControlStream());
    }

    private QueueWrapper getOrCreateQueueWrapper(int queueIndex, int capacity) {
        boolean unused = this.queuesVisibility;
        SendQueue.ProducerApi<OutboundEnvelope> producerApi = this.queues[queueIndex];
        if (producerApi instanceof QueueWrapper) {
            QueueWrapper existing = (QueueWrapper)producerApi;
            return existing;
        }
        return Association$QueueWrapperImpl$.MODULE$.apply(this.createQueue(capacity, queueIndex));
    }

    private void runOutboundOrdinaryMessagesStream() {
        if (this.transport().isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        SharedKillSwitch streamKillSwitch = KillSwitches$.MODULE$.shared("outboundMessagesKillSwitch");
        if (this.outboundLanes == 1) {
            QueueWrapper wrapper;
            this.log.debug("Starting outbound message stream to [{}]", (Object)this.remoteAddress());
            int queueIndex = 2;
            this.queues[queueIndex] = wrapper = this.getOrCreateQueueWrapper(queueIndex, this.queueSize);
            this.queuesVisibility = true;
            Tuple4 tuple4 = (Tuple4)Source$.MODULE$.fromGraph(new SendQueue((JProcedure1 & Serializable)pending -> this.sendToDeadLetters((Vector<OutboundEnvelope>)pending))).via(streamKillSwitch.flow()).viaMat(this.transport().outboundTestFlow(this), Keep$.MODULE$.both()).toMat(this.transport().outbound(this), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        SendQueue.QueueValue a = (SendQueue.QueueValue)tuple22._1();
                        NotUsed b = (NotUsed)tuple22._2();
                        if (tuple23 != null) {
                            Encoder.OutboundCompressionAccess c = (Encoder.OutboundCompressionAccess)tuple23._1();
                            Future d = (Future)tuple23._2();
                            return Tuple4$.MODULE$.apply((Object)a, (Object)b, (Object)c, (Object)d);
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }).run(this.materializer());
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            SendQueue.QueueValue queueValue = (SendQueue.QueueValue)tuple4._1();
            Encoder.OutboundCompressionAccess changeCompression = (Encoder.OutboundCompressionAccess)tuple4._3();
            Future completed = (Future)tuple4._4();
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)queueValue, (Object)changeCompression, (Object)completed);
            SendQueue.QueueValue queueValue2 = (SendQueue.QueueValue)tuple3._1();
            Encoder.OutboundCompressionAccess changeCompression2 = (Encoder.OutboundCompressionAccess)tuple3._2();
            Future completed2 = (Future)tuple3._3();
            queueValue2.inject(wrapper.queue());
            this.queues[queueIndex] = queueValue2;
            this.queuesVisibility = true;
            this.outboundCompressionAccess = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Encoder.OutboundCompressionAccess[]{changeCompression2}));
            this.updateStreamMatValues(2, streamKillSwitch, (Future<Done>)completed2);
            this.attachOutboundStreamRestart("Outbound message stream", 2, this.queueSize, (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.runOutboundOrdinaryMessagesStream());
            return;
        }
        this.log.debug("Starting outbound message stream to [{}] with [{}] lanes", (Object)this.remoteAddress(), (Object)BoxesRunTime.boxToInteger((int)this.outboundLanes));
        Vector wrappers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.outboundLanes).map((Function1 & Serializable)i -> this.$anonfun$7(BoxesRunTime.unboxToInt((Object)i))).toVector();
        Source lane = ((Source)Source$.MODULE$.fromGraph(new SendQueue((JProcedure1 & Serializable)pending -> this.sendToDeadLetters((Vector<OutboundEnvelope>)pending))).via(streamKillSwitch.flow()).via(this.transport().outboundTestFlow(this)).viaMat(this.transport().outboundLane(this), Keep$.MODULE$.both()).watchTermination(Keep$.MODULE$.both()).recoverWithRetries(-1, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable != null;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    return Source$.MODULE$.empty();
                }
                return function1.apply((Object)x);
            }
        })).mapMaterializedValue((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                SendQueue.QueueValue q = (SendQueue.QueueValue)tuple2._1();
                Encoder.OutboundCompressionAccess c = (Encoder.OutboundCompressionAccess)tuple2._2();
                Future w = (Future)tuple22._2();
                return Tuple3$.MODULE$.apply((Object)q, (Object)c, (Object)w);
            }
            throw new MatchError((Object)tuple22);
        });
        Tuple2 tuple2 = (Tuple2)MergeHub$.MODULE$.source().via(streamKillSwitch.flow()).toMat(this.transport().outboundTransportSink(this), Keep$.MODULE$.both()).run(this.materializer());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Sink mergeHub = (Sink)tuple2._1();
        Future transportSinkCompleted = (Future)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)mergeHub, (Object)transportSinkCompleted);
        Sink mergeHub2 = (Sink)tuple22._1();
        Future transportSinkCompleted2 = (Future)tuple22._2();
        Vector values = (Vector)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.outboundLanes).iterator().map((Function1 & Serializable)_$9 -> this.$anonfun$10(lane, mergeHub2, BoxesRunTime.unboxToInt((Object)_$9))).to(IterableFactory$.MODULE$.toFactory((IterableFactory)scala.package$.MODULE$.Vector()));
        Tuple3 tuple3 = values.unzip3(Predef$.MODULE$.$conforms());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Vector queueValues = (Vector)tuple3._1();
        Vector compressionAccessValues = (Vector)tuple3._2();
        Vector laneCompletedValues = (Vector)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)queueValues, (Object)compressionAccessValues, (Object)laneCompletedValues);
        Vector queueValues2 = (Vector)tuple32._1();
        Vector compressionAccessValues2 = (Vector)tuple32._2();
        Vector laneCompletedValues2 = (Vector)tuple32._3();
        MessageDispatcher ec = this.transport().system().dispatchers().internalDispatcher();
        Future$.MODULE$.firstCompletedOf((IterableOnce)laneCompletedValues2, (ExecutionContext)ec).failed().foreach((Function1)(JProcedure1 & Serializable)reason -> streamKillSwitch.abort(reason), (ExecutionContext)ec);
        ((Vector)laneCompletedValues2.$colon$plus((Object)transportSinkCompleted2)).foreach((Function1)(JProcedure1 & Serializable)_$10 -> _$10.foreach((Function1)(JProcedure1 & Serializable)_$11 -> streamKillSwitch.shutdown(), (ExecutionContext)ec));
        Future allCompleted = Future$.MODULE$.sequence((IterableOnce)laneCompletedValues2, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)ec).flatMap((Function1 & Serializable)_$12 -> transportSinkCompleted2, (ExecutionContext)ec);
        ((Vector)((StrictOptimizedIterableOps)queueValues2.zip((IterableOnce)wrappers)).zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                SendQueue.QueueValue q = (SendQueue.QueueValue)tuple2._1();
                QueueWrapper w = (QueueWrapper)tuple2._2();
                int i = BoxesRunTime.unboxToInt((Object)tuple22._2());
                q.inject(w.queue());
                this.queues[2 + i] = q;
                return;
            }
            throw new MatchError((Object)tuple22);
        });
        this.queuesVisibility = true;
        this.outboundCompressionAccess = compressionAccessValues2;
        this.attachOutboundStreamRestart("Outbound message stream", 2, this.queueSize, (Future<Done>)allCompleted, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.runOutboundOrdinaryMessagesStream());
    }

    private void runOutboundLargeMessagesStream() {
        QueueWrapper wrapper;
        if (this.transport().isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        this.log.debug("Starting outbound large message stream to [{}]", (Object)this.remoteAddress());
        this.queues[1] = wrapper = this.getOrCreateQueueWrapper(1, this.largeQueueSize);
        this.queuesVisibility = true;
        SharedKillSwitch streamKillSwitch = KillSwitches$.MODULE$.shared("outboundLargeMessagesKillSwitch");
        Tuple2 tuple2 = (Tuple2)Source$.MODULE$.fromGraph(new SendQueue((JProcedure1 & Serializable)pending -> this.sendToDeadLetters((Vector<OutboundEnvelope>)pending))).via(streamKillSwitch.flow()).via(this.transport().outboundTestFlow(this)).toMat(this.transport().outboundLarge(this), Keep$.MODULE$.both()).run(this.materializer());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SendQueue.QueueValue queueValue = (SendQueue.QueueValue)tuple2._1();
        Future completed = (Future)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)queueValue, (Object)completed);
        SendQueue.QueueValue queueValue2 = (SendQueue.QueueValue)tuple22._1();
        Future completed2 = (Future)tuple22._2();
        queueValue2.inject(wrapper.queue());
        this.queues[1] = queueValue2;
        this.queuesVisibility = true;
        this.updateStreamMatValues(1, streamKillSwitch, (Future<Done>)completed2);
        this.attachOutboundStreamRestart("Outbound large message stream", 1, this.largeQueueSize, (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.runOutboundLargeMessagesStream());
    }

    private void attachOutboundStreamRestart(String streamName, int queueIndex, int queueCapacity, Future<Done> streamCompleted, Function0<BoxedUnit> restart) {
        ExecutionContextExecutor ec = this.materializer().executionContext();
        streamCompleted.foreach((Function1)(JProcedure1 & Serializable)_$13 -> {
            if (this.transport().isShutdown() || this.isRemovedAfterQuarantined()) {
                this.materializing.countDown();
                return;
            }
            this.log.debug("{} to [{}] was completed. It will be restarted if used again.", (Object)streamName, (Object)this.remoteAddress());
            this.lazyRestart$1(streamName, queueIndex, restart, queueCapacity);
        }, (ExecutionContext)ec);
        streamCompleted.failed().foreach((Function1 & Serializable)x$1 -> {
            Throwable throwable;
            boolean bypassRestartCounter;
            StopSignal stopSignal;
            StopSignal stopSignal2;
            Throwable cause;
            Throwable throwable2 = x$1;
            if (ArteryTransport$ShutdownSignal$.MODULE$.equals(throwable2)) {
                this.cancelAllTimers();
                this.materializing.countDown();
                return BoxedUnit.UNIT;
            }
            Throwable cause2 = throwable2;
            if (this.transport().isShutdown() || this.isRemovedAfterQuarantined()) {
                if (!(cause2 instanceof StreamTcpException)) {
                    this.log.warning("{} to [{}] failed after shutdown. {}: {}", (Object)streamName, (Object)this.remoteAddress(), (Object)cause2.getClass().getName(), (Object)cause2.getMessage());
                }
                this.cancelAllTimers();
                this.materializing.countDown();
                return BoxedUnit.UNIT;
            }
            if (throwable2 instanceof ArteryTransport.AeronTerminated) {
                this.cancelAllTimers();
                return BoxedUnit.UNIT;
            }
            if (throwable2 instanceof AbruptTerminationException) {
                this.cancelAllTimers();
                return BoxedUnit.UNIT;
            }
            Throwable throwable3 = cause = throwable2;
            Association$OutboundStreamStopIdleSignal$ association$OutboundStreamStopIdleSignal$ = Association$OutboundStreamStopIdleSignal$.MODULE$;
            boolean stoppedIdle = !(throwable3 == null ? association$OutboundStreamStopIdleSignal$ != null : !throwable3.equals(association$OutboundStreamStopIdleSignal$)) || OptionVal$.MODULE$.contains$extension((Object)(stopSignal2 = this.getStopReason(queueIndex)), (Object)Association$OutboundStreamStopIdleSignal$.MODULE$);
            Throwable throwable4 = cause;
            Association$OutboundStreamStopQuarantinedSignal$ association$OutboundStreamStopQuarantinedSignal$ = Association$OutboundStreamStopQuarantinedSignal$.MODULE$;
            boolean stoppedQuarantined = !(throwable4 == null ? association$OutboundStreamStopQuarantinedSignal$ != null : !throwable4.equals(association$OutboundStreamStopQuarantinedSignal$)) || OptionVal$.MODULE$.contains$extension((Object)(stopSignal = this.getStopReason(queueIndex)), (Object)Association$OutboundStreamStopQuarantinedSignal$.MODULE$);
            Throwable throwable5 = cause;
            boolean bl = throwable5 instanceof AeronSink.GaveUpMessageException ? true : (bypassRestartCounter = stoppedIdle || stoppedQuarantined);
            if (queueIndex == 0 && !stoppedQuarantined && !((throwable = cause) instanceof OutboundHandshake.HandshakeTimeoutException)) {
                this.quarantine(new StringBuilder(35).append("Outbound control stream restarted. ").append(cause).toString());
            }
            if (stoppedIdle) {
                this.log.debug("{} to [{}] was idle and stopped. It will be restarted if used again.", (Object)streamName, (Object)this.remoteAddress());
                this.lazyRestart$1(streamName, queueIndex, restart, queueCapacity);
                return BoxedUnit.UNIT;
            }
            if (stoppedQuarantined) {
                this.log.debug("{} to [{}] was quarantined and stopped. It will be restarted if used again.", (Object)streamName, (Object)this.remoteAddress());
                this.lazyRestart$1(streamName, queueIndex, restart, queueCapacity);
                return BoxedUnit.UNIT;
            }
            if (bypassRestartCounter || this.restartCounter.restart()) {
                if (Association.isConnectException$1(cause)) {
                    this.log.debug("{} to [{}] failed. Restarting it. {}", (Object)streamName, (Object)this.remoteAddress(), (Object)cause);
                } else {
                    this.log.warning("{} to [{}] failed. Restarting it. {}", (Object)streamName, (Object)this.remoteAddress(), (Object)cause);
                }
                this.lazyRestart$1(streamName, queueIndex, restart, queueCapacity);
                return BoxedUnit.UNIT;
            }
            this.log.error(cause, new StringBuilder(80).append("{} to [{}] failed and restarted {} times within {} seconds. Terminating system. ").append(cause.getMessage()).toString(), (Object)streamName, (Object)this.remoteAddress(), (Object)BoxesRunTime.boxToInteger((int)this.advancedSettings().OutboundMaxRestarts()), (Object)BoxesRunTime.boxToLong((long)this.advancedSettings().OutboundRestartTimeout().toSeconds()));
            this.cancelAllTimers();
            return this.transport().system().terminate();
        }, (ExecutionContext)ec);
    }

    private void updateStreamMatValues(int streamId, SharedKillSwitch streamKillSwitch, Future<Done> completed) {
        ExecutionContextExecutor ec = this.materializer().executionContext();
        SharedKillSwitch sharedKillSwitch = (SharedKillSwitch)OptionVal.Some$.MODULE$.apply((Object)streamKillSwitch);
        Future future = completed.recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return Done$.MODULE$;
            }
        }, (ExecutionContext)ec);
        OptionVal$.MODULE$.None();
        this.updateStreamMatValues(streamId, Association$OutboundStreamMatValues$.MODULE$.apply(sharedKillSwitch, (Future<Done>)future, null));
    }

    private void updateStreamMatValues(int streamId, OutboundStreamMatValues values) {
        Integer n;
        Map<Object, OutboundStreamMatValues> prev;
        while (!this.streamMatValues.compareAndSet(prev = this.streamMatValues.get(), (Map<Object, OutboundStreamMatValues>)prev.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)(n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)streamId))), (Object)values)))) {
        }
    }

    private void setStopReason(int streamId, StopSignal stopSignal) {
        Map<Object, OutboundStreamMatValues> prev;
        Option option;
        while ((option = (prev = this.streamMatValues.get()).get((Object)BoxesRunTime.boxToInteger((int)streamId))) instanceof Some) {
            OutboundStreamMatValues v = (OutboundStreamMatValues)((Some)option).value();
            StopSignal stopSignal2 = (StopSignal)OptionVal.Some$.MODULE$.apply((Object)stopSignal);
            SharedKillSwitch sharedKillSwitch = v.copy$default$1();
            Future<Done> future = v.copy$default$2();
            if (!this.streamMatValues.compareAndSet(prev, (Map<Object, OutboundStreamMatValues>)prev.updated((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)v.copy(sharedKillSwitch, future, stopSignal2)))) continue;
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException(new StringBuilder(31).append("Expected streamMatValues for [").append(streamId).append("]").toString());
        }
        throw new MatchError((Object)option);
    }

    private StopSignal getStopReason(int streamId) {
        OutboundStreamMatValues outboundStreamMatValues;
        Option option = ((MapOps)this.streamMatValues.get()).get((Object)BoxesRunTime.boxToInteger((int)streamId));
        if (option instanceof Some && (outboundStreamMatValues = (OutboundStreamMatValues)((Some)option).value()) != null) {
            StopSignal stopSignal;
            OutboundStreamMatValues outboundStreamMatValues2 = Association$OutboundStreamMatValues$.MODULE$.unapply(outboundStreamMatValues);
            SharedKillSwitch sharedKillSwitch = outboundStreamMatValues2._1();
            Future<Done> future = outboundStreamMatValues2._2();
            StopSignal stopping = stopSignal = outboundStreamMatValues2._3();
            return stopping;
        }
        if (None$.MODULE$.equals(option)) {
            OptionVal$.MODULE$.None();
            return null;
        }
        throw new MatchError((Object)option);
    }

    private void clearStreamKillSwitch(int streamId, SharedKillSwitch old) {
        Map<Object, OutboundStreamMatValues> prev;
        Option option;
        while ((option = (prev = this.streamMatValues.get()).get((Object)BoxesRunTime.boxToInteger((int)streamId))) instanceof Some) {
            OutboundStreamMatValues v = (OutboundStreamMatValues)((Some)option).value();
            if (OptionVal$.MODULE$.isDefined$extension((Object)v.streamKillSwitch()) && (SharedKillSwitch)OptionVal$.MODULE$.get$extension((Object)v.streamKillSwitch()) == old) {
                Integer n = BoxesRunTime.boxToInteger((int)streamId);
                OptionVal$.MODULE$.None();
                if (!this.streamMatValues.compareAndSet(prev, (Map<Object, OutboundStreamMatValues>)prev.updated((Object)n, (Object)v.copy(null, v.copy$default$2(), v.copy$default$3())))) continue;
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException(new StringBuilder(31).append("Expected streamMatValues for [").append(streamId).append("]").toString());
        }
        throw new MatchError((Object)option);
    }

    public Future<Done> streamsCompleted() {
        ExecutionContextExecutor ec = this.materializer().executionContext();
        return Future$.MODULE$.sequence((IterableOnce)((MapOps)this.streamMatValues.get()).values().map((Function1 & Serializable)x$1 -> {
            OutboundStreamMatValues outboundStreamMatValues = x$1;
            if (outboundStreamMatValues != null) {
                OutboundStreamMatValues outboundStreamMatValues2 = Association$OutboundStreamMatValues$.MODULE$.unapply(outboundStreamMatValues);
                SharedKillSwitch sharedKillSwitch = outboundStreamMatValues2._1();
                Future<Done> future = outboundStreamMatValues2._2();
                StopSignal stopSignal = outboundStreamMatValues2._3();
                Future<Done> done = future;
                return done;
            }
            throw new MatchError((Object)outboundStreamMatValues);
        }), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)ec).map((Function1 & Serializable)_$14 -> Done$.MODULE$, (ExecutionContext)ec);
    }

    public String toString() {
        return new StringBuilder(23).append("Association(").append(this.localAddress()).append(" -> ").append(this.remoteAddress()).append(" with ").append(this.associationState()).append(")").toString();
    }

    private final Object completeHandshake$$anonfun$1(UniqueAddress peer$1) {
        return new StringBuilder(58).append("wrong remote address in completeHandshake, got ").append(peer$1.address()).append(", expected ").append(this.remoteAddress()).toString();
    }

    private final OutboundEnvelope createOutboundEnvelope$1(RemoteActorRef recipient$1, Object message$1, ActorRef sender$1) {
        return this.outboundEnvelopePool.acquire().init(recipient$1, message$1, sender$1);
    }

    private final void dropped$1(RemoteActorRef recipient$2, Object message$2, int queueIndex, int qSize, OutboundEnvelope env) {
        RemoteActorRef remoteActorRef;
        RemoteActorRef remoteActorRef2;
        boolean removed = this.isRemovedAfterQuarantined();
        if (removed && !OptionVal$.MODULE$.isEmpty$extension((Object)(remoteActorRef2 = (RemoteActorRef)OptionVal.Some$.MODULE$.unapply((Object)(remoteActorRef = recipient$2))))) {
            RemoteActorRef remoteActorRef3;
            RemoteActorRef ref = remoteActorRef3 = (RemoteActorRef)OptionVal$.MODULE$.get$extension((Object)remoteActorRef2);
            ref.cachedAssociation_$eq(null);
        }
        String reason = removed ? "Due to removed unused quarantined association" : new StringBuilder(38).append("Due to overflow of send queue, size [").append(qSize).append("]").toString();
        ActorRef actorRef = env.sender();
        this.transport().system().eventStream().publish((Object)Dropped$.MODULE$.apply(message$2, reason, (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)actorRef, (Object)ActorRef$.MODULE$.noSender()), (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)recipient$2, (Object)this.deadletters())));
        this.flightRecorder().transportSendQueueOverflow(queueIndex);
        ActorRef actorRef2 = this.deadletters();
        actorRef2.$bang((Object)env, actorRef2.$bang$default$2((Object)env));
    }

    private final boolean shouldSendUnwatch$1() {
        return !this.transport().provider().settings().HasCluster() || !this.transport().system().isTerminating();
    }

    private final boolean shouldSendDeathWatchNotification$1(DeathWatchNotification d) {
        return d.addressTerminated() || !this.transport().provider().settings().HasCluster() || !this.transport().system().isTerminating();
    }

    private final void sendSystemMessage$1(RemoteActorRef recipient$4, Object message$4, OutboundEnvelope outboundEnvelope) {
        DeathWatchNotification d;
        Object object = outboundEnvelope.message();
        if (object instanceof Unwatch) {
            Unwatch u = (Unwatch)object;
            if (this.shouldSendUnwatch$1()) {
                this.log.debug("Not sending Unwatch of {} to {} because it will be notified when this member has been removed from Cluster.", (Object)u.watcher(), (Object)u.watchee());
                return;
            }
        }
        if (object instanceof DeathWatchNotification && !this.shouldSendDeathWatchNotification$1(d = (DeathWatchNotification)object)) {
            RemoteActorRef remoteActorRef = outboundEnvelope.recipient();
            this.log.debug("Not sending DeathWatchNotification of {} to {} because it will be notified when this member has been removed from Cluster.", (Object)d.actor(), OptionVal$.MODULE$.getOrElse$extension((Object)remoteActorRef, (Object)"unknown"));
            return;
        }
        if (!this.controlQueue().offer(outboundEnvelope)) {
            this.quarantine(new StringBuilder(41).append("Due to overflow of control queue, size [").append(this.controlQueueSize).append("]").toString());
            this.dropped$1(recipient$4, message$4, 0, this.controlQueueSize, outboundEnvelope);
            return;
        }
    }

    private final void setupStopQuarantinedTimer$$anonfun$1() {
        if (this.associationState().isQuarantined()) {
            this.abortQuarantined();
            return;
        }
    }

    private final void sendQueuePostStop$1(Vector pending) {
        this.sendToDeadLetters((Vector<OutboundEnvelope>)pending);
        int systemMessagesCount = pending.count((Function1 & Serializable)env -> env.message() instanceof SystemMessage);
        if (systemMessagesCount > 0) {
            this.quarantine(new StringBuilder(50).append("SendQueue stopped with [").append(systemMessagesCount).append("] pending system messages.").toString());
            return;
        }
    }

    private final /* synthetic */ QueueWrapper $anonfun$7(int i) {
        QueueWrapper wrapper;
        this.queues[2 + i] = wrapper = this.getOrCreateQueueWrapper(2 + i, this.queueSize);
        this.queuesVisibility = true;
        return wrapper;
    }

    private final /* synthetic */ Tuple3 $anonfun$10(Source lane$1, Sink mergeHub$1, int _$9) {
        return (Tuple3)lane$1.to((Graph)mergeHub$1).run(this.materializer());
    }

    private final void lazyRestart$1(String streamName$1, int queueIndex$1, Function0 restart$1, int queueCapacity$1) {
        this.flightRecorder().transportRestartOutbound(this.remoteAddress(), streamName$1);
        this.outboundCompressionAccess = scala.package$.MODULE$.Vector().empty();
        if (queueIndex$1 == 0) {
            this.materializing = new CountDownLatch(1);
            OptionVal$.MODULE$.None();
            this._outboundControlIngress = null;
        }
        JFunction0.mcV.sp & Serializable wrappedRestartFun = (JFunction0.mcV.sp & Serializable)() -> restart$1.apply$mcV$sp();
        if (!this.isRemovedAfterQuarantined()) {
            this.queues[queueIndex$1] = Association$LazyQueueWrapper$.MODULE$.apply(this.createQueue(queueCapacity$1, queueIndex$1), (Function0<BoxedUnit>)wrappedRestartFun);
        }
        this.queuesVisibility = true;
    }

    private static final boolean isConnectException$1(Throwable cause$1) {
        return cause$1 instanceof StreamTcpException && cause$1.getCause() != null && cause$1.getCause() instanceof ConnectException;
    }

    public static final class LazyQueueWrapper
    implements QueueWrapper,
    Product,
    Serializable {
        private final Queue queue;
        private final Function0 materialize;
        private final AtomicBoolean onlyOnce;

        public static LazyQueueWrapper apply(Queue<OutboundEnvelope> queue, Function0<BoxedUnit> function0) {
            return Association$LazyQueueWrapper$.MODULE$.apply(queue, function0);
        }

        public static LazyQueueWrapper fromProduct(Product product) {
            return Association$LazyQueueWrapper$.MODULE$.fromProduct(product);
        }

        public static LazyQueueWrapper unapply(LazyQueueWrapper lazyQueueWrapper) {
            return Association$LazyQueueWrapper$.MODULE$.unapply(lazyQueueWrapper);
        }

        public LazyQueueWrapper(Queue<OutboundEnvelope> queue, Function0<BoxedUnit> materialize) {
            this.queue = queue;
            this.materialize = materialize;
            this.onlyOnce = new AtomicBoolean();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LazyQueueWrapper)) return false;
            LazyQueueWrapper lazyQueueWrapper = (LazyQueueWrapper)object;
            Queue<OutboundEnvelope> queue = this.queue();
            Queue<OutboundEnvelope> queue2 = lazyQueueWrapper.queue();
            if (queue == null) {
                if (queue2 != null) {
                    return false;
                }
            } else if (!queue.equals(queue2)) return false;
            Function0<BoxedUnit> function0 = this.materialize();
            Function0<BoxedUnit> function02 = lazyQueueWrapper.materialize();
            if (function0 == null) {
                if (function02 == null) return true;
                return false;
            } else {
                if (!function0.equals(function02)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LazyQueueWrapper;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "LazyQueueWrapper";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "queue";
            }
            if (1 == n2) {
                return "materialize";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Queue<OutboundEnvelope> queue() {
            return this.queue;
        }

        public Function0<BoxedUnit> materialize() {
            return this.materialize;
        }

        public void runMaterialize() {
            if (this.onlyOnce.compareAndSet(false, true)) {
                this.materialize().apply$mcV$sp();
                return;
            }
        }

        @Override
        public boolean offer(OutboundEnvelope message) {
            this.runMaterialize();
            return this.queue().offer(message);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        public LazyQueueWrapper copy(Queue<OutboundEnvelope> queue, Function0<BoxedUnit> materialize) {
            return new LazyQueueWrapper(queue, materialize);
        }

        public Queue<OutboundEnvelope> copy$default$1() {
            return this.queue();
        }

        public Function0<BoxedUnit> copy$default$2() {
            return this.materialize();
        }

        public Queue<OutboundEnvelope> _1() {
            return this.queue();
        }

        public Function0<BoxedUnit> _2() {
            return this.materialize();
        }
    }

    public static final class OutboundStreamMatValues
    implements Product,
    Serializable {
        private final SharedKillSwitch streamKillSwitch;
        private final Future completed;
        private final StopSignal stopping;

        public static OutboundStreamMatValues apply(SharedKillSwitch sharedKillSwitch, Future<Done> future, StopSignal stopSignal) {
            return Association$OutboundStreamMatValues$.MODULE$.apply(sharedKillSwitch, future, stopSignal);
        }

        public static OutboundStreamMatValues fromProduct(Product product) {
            return Association$OutboundStreamMatValues$.MODULE$.fromProduct(product);
        }

        public static OutboundStreamMatValues unapply(OutboundStreamMatValues outboundStreamMatValues) {
            return Association$OutboundStreamMatValues$.MODULE$.unapply(outboundStreamMatValues);
        }

        public OutboundStreamMatValues(SharedKillSwitch streamKillSwitch, Future<Done> completed, StopSignal stopping) {
            this.streamKillSwitch = streamKillSwitch;
            this.completed = completed;
            this.stopping = stopping;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OutboundStreamMatValues)) return false;
            OutboundStreamMatValues outboundStreamMatValues = (OutboundStreamMatValues)object;
            SharedKillSwitch sharedKillSwitch = this.streamKillSwitch();
            SharedKillSwitch sharedKillSwitch2 = outboundStreamMatValues.streamKillSwitch();
            if (sharedKillSwitch == null) {
                if (sharedKillSwitch2 != null) {
                    return false;
                }
            } else if (!sharedKillSwitch.equals(sharedKillSwitch2)) return false;
            Future<Done> future = this.completed();
            Future<Done> future2 = outboundStreamMatValues.completed();
            if (future == null) {
                if (future2 != null) {
                    return false;
                }
            } else if (!future.equals(future2)) return false;
            StopSignal stopSignal = this.stopping();
            StopSignal stopSignal2 = outboundStreamMatValues.stopping();
            if (stopSignal == null) {
                if (stopSignal2 == null) return true;
                return false;
            } else {
                if (!stopSignal.equals(stopSignal2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OutboundStreamMatValues;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "OutboundStreamMatValues";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return new OptionVal((Object)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return new OptionVal((Object)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "streamKillSwitch";
                }
                case 1: {
                    return "completed";
                }
                case 2: {
                    return "stopping";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SharedKillSwitch streamKillSwitch() {
            return this.streamKillSwitch;
        }

        public Future<Done> completed() {
            return this.completed;
        }

        public StopSignal stopping() {
            return this.stopping;
        }

        public OutboundStreamMatValues copy(SharedKillSwitch streamKillSwitch, Future<Done> completed, StopSignal stopping) {
            return new OutboundStreamMatValues(streamKillSwitch, completed, stopping);
        }

        public SharedKillSwitch copy$default$1() {
            return this.streamKillSwitch();
        }

        public Future<Done> copy$default$2() {
            return this.completed();
        }

        public StopSignal copy$default$3() {
            return this.stopping();
        }

        public SharedKillSwitch _1() {
            return this.streamKillSwitch();
        }

        public Future<Done> _2() {
            return this.completed();
        }

        public StopSignal _3() {
            return this.stopping();
        }
    }

    public static interface QueueWrapper
    extends SendQueue.ProducerApi<OutboundEnvelope> {
        public Queue<OutboundEnvelope> queue();
    }

    public static final class QueueWrapperImpl
    implements QueueWrapper,
    Product,
    Serializable {
        private final Queue queue;

        public static QueueWrapperImpl apply(Queue<OutboundEnvelope> queue) {
            return Association$QueueWrapperImpl$.MODULE$.apply(queue);
        }

        public static QueueWrapperImpl fromProduct(Product product) {
            return Association$QueueWrapperImpl$.MODULE$.fromProduct(product);
        }

        public static QueueWrapperImpl unapply(QueueWrapperImpl queueWrapperImpl) {
            return Association$QueueWrapperImpl$.MODULE$.unapply(queueWrapperImpl);
        }

        public QueueWrapperImpl(Queue<OutboundEnvelope> queue) {
            this.queue = queue;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof QueueWrapperImpl)) return false;
            QueueWrapperImpl queueWrapperImpl = (QueueWrapperImpl)object;
            Queue<OutboundEnvelope> queue = this.queue();
            Queue<OutboundEnvelope> queue2 = queueWrapperImpl.queue();
            if (queue != null) {
                if (!queue.equals(queue2)) return false;
                return true;
            }
            if (queue2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof QueueWrapperImpl;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "QueueWrapperImpl";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "queue";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Queue<OutboundEnvelope> queue() {
            return this.queue;
        }

        @Override
        public boolean offer(OutboundEnvelope message) {
            return this.queue().offer(message);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        public QueueWrapperImpl copy(Queue<OutboundEnvelope> queue) {
            return new QueueWrapperImpl(queue);
        }

        public Queue<OutboundEnvelope> copy$default$1() {
            return this.queue();
        }

        public Queue<OutboundEnvelope> _1() {
            return this.queue();
        }
    }

    public static interface StopSignal {
    }
}

