/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.remote.UniqueAddress;
import org.apache.pekko.remote.artery.AssociationState$;
import org.apache.pekko.remote.artery.AssociationState$QuarantinedTimestamp$;
import org.apache.pekko.remote.artery.AssociationState$UidKnown$;
import org.apache.pekko.remote.artery.AssociationState$UidQuarantined$;
import org.apache.pekko.remote.artery.AssociationState$UidUnknown$;
import org.apache.pekko.remote.artery.AssociationState$UniqueRemoteAddressValue$;
import org.apache.pekko.remote.artery.ImmutableLongMap;
import org.apache.pekko.stream.SharedKillSwitch;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class AssociationState {
    private final int incarnation;
    private final AtomicLong lastUsedTimestamp;
    private final SharedKillSwitch controlIdleKillSwitch;
    private final ImmutableLongMap quarantined;
    private final AtomicReference<UniqueRemoteAddressValue> _uniqueRemoteAddress;

    public static AssociationState apply() {
        return AssociationState$.MODULE$.apply();
    }

    public AssociationState(int incarnation, AtomicLong lastUsedTimestamp, SharedKillSwitch controlIdleKillSwitch, ImmutableLongMap<QuarantinedTimestamp> quarantined, AtomicReference<UniqueRemoteAddressValue> _uniqueRemoteAddress) {
        this.incarnation = incarnation;
        this.lastUsedTimestamp = lastUsedTimestamp;
        this.controlIdleKillSwitch = controlIdleKillSwitch;
        this.quarantined = quarantined;
        this._uniqueRemoteAddress = _uniqueRemoteAddress;
    }

    public int incarnation() {
        return this.incarnation;
    }

    public AtomicLong lastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }

    public SharedKillSwitch controlIdleKillSwitch() {
        return this.controlIdleKillSwitch;
    }

    public ImmutableLongMap<QuarantinedTimestamp> quarantined() {
        return this.quarantined;
    }

    public Option<UniqueAddress> uniqueRemoteAddress() {
        return this._uniqueRemoteAddress.get().uniqueRemoteAddress();
    }

    public UniqueRemoteAddressState uniqueRemoteAddressState() {
        Mirror.Singleton singleton;
        Option<UniqueAddress> option = this.uniqueRemoteAddress();
        if (option instanceof Some) {
            UniqueAddress a = (UniqueAddress)((Some)option).value();
            singleton = this.isQuarantined(a.uid()) ? AssociationState$UidQuarantined$.MODULE$ : AssociationState$UidKnown$.MODULE$;
        } else if (None$.MODULE$.equals(option)) {
            singleton = AssociationState$UidUnknown$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return singleton;
    }

    public boolean isQuarantined() {
        Option<UniqueAddress> option = this.uniqueRemoteAddress();
        if (option instanceof Some) {
            UniqueAddress a = (UniqueAddress)((Some)option).value();
            return this.isQuarantined(a.uid());
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    public boolean isQuarantined(long uid) {
        return this.quarantined().contains(uid);
    }

    public void completeUniqueRemoteAddress(UniqueAddress peer) {
        UniqueRemoteAddressValue current;
        while ((current = this._uniqueRemoteAddress.get()).uniqueRemoteAddress().isEmpty()) {
            UniqueRemoteAddressValue newValue = AssociationState$UniqueRemoteAddressValue$.MODULE$.apply((Option<UniqueAddress>)Some$.MODULE$.apply((Object)peer), (List<Function1<UniqueAddress, BoxedUnit>>)package$.MODULE$.Nil());
            if (!this._uniqueRemoteAddress.compareAndSet(current, newValue)) continue;
            current.listeners().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.apply((Object)peer));
            return;
        }
    }

    public void addUniqueRemoteAddressListener(Function1<UniqueAddress, BoxedUnit> callback) {
        Option<UniqueAddress> option;
        block2: {
            UniqueRemoteAddressValue newValue;
            UniqueRemoteAddressValue current;
            do {
                if ((option = (current = this._uniqueRemoteAddress.get()).uniqueRemoteAddress()) instanceof Some) {
                    UniqueAddress peer = (UniqueAddress)((Some)option).value();
                    callback.apply((Object)peer);
                    return;
                }
                if (!None$.MODULE$.equals(option)) break block2;
            } while (!this._uniqueRemoteAddress.compareAndSet(current, newValue = AssociationState$UniqueRemoteAddressValue$.MODULE$.apply((Option<UniqueAddress>)None$.MODULE$, (List<Function1<UniqueAddress, BoxedUnit>>)current.listeners().$colon$colon(callback))));
            return;
        }
        throw new MatchError(option);
    }

    public void removeUniqueRemoteAddressListener(Function1<UniqueAddress, BoxedUnit> callback) {
        UniqueRemoteAddressValue newValue;
        UniqueRemoteAddressValue current;
        while (!this._uniqueRemoteAddress.compareAndSet(current = this._uniqueRemoteAddress.get(), newValue = AssociationState$UniqueRemoteAddressValue$.MODULE$.apply(current.uniqueRemoteAddress(), (List<Function1<UniqueAddress, BoxedUnit>>)current.listeners().filterNot((Function1 & Serializable)_$2 -> {
            Function1 function1 = _$2;
            Function1 function12 = callback;
            return !(function1 != null ? !function1.equals(function12) : function12 != null);
        })))) {
        }
    }

    public AssociationState newIncarnation(UniqueAddress remoteAddress) {
        return new AssociationState(this.incarnation() + 1, new AtomicLong(System.nanoTime()), this.controlIdleKillSwitch(), this.quarantined(), new AtomicReference<UniqueRemoteAddressValue>(AssociationState$UniqueRemoteAddressValue$.MODULE$.apply((Option<UniqueAddress>)Some$.MODULE$.apply((Object)remoteAddress), (List<Function1<UniqueAddress, BoxedUnit>>)package$.MODULE$.Nil())));
    }

    public AssociationState newQuarantined() {
        Option<UniqueAddress> option = this.uniqueRemoteAddress();
        if (option instanceof Some) {
            UniqueAddress a = (UniqueAddress)((Some)option).value();
            return new AssociationState(this.incarnation(), new AtomicLong(System.nanoTime()), this.controlIdleKillSwitch(), this.quarantined().updated(a.uid(), AssociationState$QuarantinedTimestamp$.MODULE$.apply(System.nanoTime())), this._uniqueRemoteAddress);
        }
        if (None$.MODULE$.equals(option)) {
            return this;
        }
        throw new MatchError(option);
    }

    public AssociationState withControlIdleKillSwitch(SharedKillSwitch killSwitch) {
        return new AssociationState(this.incarnation(), this.lastUsedTimestamp(), killSwitch, this.quarantined(), this._uniqueRemoteAddress);
    }

    public String toString() {
        Object object;
        Option<UniqueAddress> option = this.uniqueRemoteAddress();
        if (option instanceof Some) {
            UniqueAddress a = (UniqueAddress)((Some)option).value();
            object = a;
        } else if (None$.MODULE$.equals(option)) {
            object = "unknown";
        } else {
            throw new MatchError(option);
        }
        Object a = object;
        return new StringBuilder(20).append("AssociationState(").append(this.incarnation()).append(", ").append(a).append(")").toString();
    }

    public static final class QuarantinedTimestamp
    implements Product,
    Serializable {
        private final long nanoTime;

        public static QuarantinedTimestamp apply(long l) {
            return AssociationState$QuarantinedTimestamp$.MODULE$.apply(l);
        }

        public static QuarantinedTimestamp fromProduct(Product product) {
            return AssociationState$QuarantinedTimestamp$.MODULE$.fromProduct(product);
        }

        public static QuarantinedTimestamp unapply(QuarantinedTimestamp quarantinedTimestamp) {
            return AssociationState$QuarantinedTimestamp$.MODULE$.unapply(quarantinedTimestamp);
        }

        public QuarantinedTimestamp(long nanoTime) {
            this.nanoTime = nanoTime;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.nanoTime()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof QuarantinedTimestamp)) return false;
            QuarantinedTimestamp quarantinedTimestamp = (QuarantinedTimestamp)object;
            if (this.nanoTime() != quarantinedTimestamp.nanoTime()) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof QuarantinedTimestamp;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "QuarantinedTimestamp";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "nanoTime";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long nanoTime() {
            return this.nanoTime;
        }

        public String toString() {
            return new StringBuilder(24).append("Quarantined ").append(TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.nanoTime())).append(" seconds ago").toString();
        }

        public QuarantinedTimestamp copy(long nanoTime) {
            return new QuarantinedTimestamp(nanoTime);
        }

        public long copy$default$1() {
            return this.nanoTime();
        }

        public long _1() {
            return this.nanoTime();
        }
    }

    public static interface UniqueRemoteAddressState {
    }

    public static final class UniqueRemoteAddressValue
    implements Product,
    Serializable {
        private final Option uniqueRemoteAddress;
        private final List listeners;

        public static UniqueRemoteAddressValue apply(Option<UniqueAddress> option, List<Function1<UniqueAddress, BoxedUnit>> list) {
            return AssociationState$UniqueRemoteAddressValue$.MODULE$.apply(option, list);
        }

        public static UniqueRemoteAddressValue fromProduct(Product product) {
            return AssociationState$UniqueRemoteAddressValue$.MODULE$.fromProduct(product);
        }

        public static UniqueRemoteAddressValue unapply(UniqueRemoteAddressValue uniqueRemoteAddressValue) {
            return AssociationState$UniqueRemoteAddressValue$.MODULE$.unapply(uniqueRemoteAddressValue);
        }

        public UniqueRemoteAddressValue(Option<UniqueAddress> uniqueRemoteAddress, List<Function1<UniqueAddress, BoxedUnit>> listeners) {
            this.uniqueRemoteAddress = uniqueRemoteAddress;
            this.listeners = listeners;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UniqueRemoteAddressValue)) return false;
            UniqueRemoteAddressValue uniqueRemoteAddressValue = (UniqueRemoteAddressValue)object;
            Option<UniqueAddress> option = this.uniqueRemoteAddress();
            Option<UniqueAddress> option2 = uniqueRemoteAddressValue.uniqueRemoteAddress();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            List<Function1<UniqueAddress, BoxedUnit>> list = this.listeners();
            List<Function1<UniqueAddress, BoxedUnit>> list2 = uniqueRemoteAddressValue.listeners();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UniqueRemoteAddressValue;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "UniqueRemoteAddressValue";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "uniqueRemoteAddress";
            }
            if (1 == n2) {
                return "listeners";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<UniqueAddress> uniqueRemoteAddress() {
            return this.uniqueRemoteAddress;
        }

        public List<Function1<UniqueAddress, BoxedUnit>> listeners() {
            return this.listeners;
        }

        public UniqueRemoteAddressValue copy(Option<UniqueAddress> uniqueRemoteAddress, List<Function1<UniqueAddress, BoxedUnit>> listeners) {
            return new UniqueRemoteAddressValue(uniqueRemoteAddress, listeners);
        }

        public Option<UniqueAddress> copy$default$1() {
            return this.uniqueRemoteAddress();
        }

        public List<Function1<UniqueAddress, BoxedUnit>> copy$default$2() {
            return this.listeners();
        }

        public Option<UniqueAddress> _1() {
            return this.uniqueRemoteAddress();
        }

        public List<Function1<UniqueAddress, BoxedUnit>> _2() {
            return this.listeners();
        }
    }
}

