/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.UniqueAddress;
import org.apache.pekko.remote.artery.InboundContext;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.SystemMessageAcker$;
import org.apache.pekko.remote.artery.SystemMessageDelivery;
import org.apache.pekko.remote.artery.SystemMessageDelivery$Ack$;
import org.apache.pekko.remote.artery.SystemMessageDelivery$Nack$;
import org.apache.pekko.remote.artery.SystemMessageDelivery$SystemMessageEnvelope$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.StageLogging;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

@InternalApi
public class SystemMessageAcker
extends GraphStage<FlowShape<InboundEnvelope, InboundEnvelope>> {
    public final InboundContext org$apache$pekko$remote$artery$SystemMessageAcker$$inboundContext;
    private final Inlet in;
    private final Outlet out;
    private final FlowShape shape;

    public static int MaxNegativeAcknowledgementLogging() {
        return SystemMessageAcker$.MODULE$.MaxNegativeAcknowledgementLogging();
    }

    public SystemMessageAcker(InboundContext inboundContext) {
        this.org$apache$pekko$remote$artery$SystemMessageAcker$$inboundContext = inboundContext;
        this.in = Inlet$.MODULE$.apply("SystemMessageAcker.in");
        this.out = Outlet$.MODULE$.apply("SystemMessageAcker.out");
        this.shape = FlowShape$.MODULE$.apply(this.in(), this.out());
    }

    public Inlet<InboundEnvelope> in() {
        return this.in;
    }

    public Outlet<InboundEnvelope> out() {
        return this.out;
    }

    public FlowShape<InboundEnvelope, InboundEnvelope> shape() {
        return this.shape;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log;
            private Map sequenceNumbers;
            private int nackCount;
            private final /* synthetic */ SystemMessageAcker $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                StageLogging.$init$((StageLogging)this);
                this.sequenceNumbers = Predef$.MODULE$.Map().empty();
                this.nackCount = 0;
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            public LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log() {
                return this.org$apache$pekko$stream$stage$StageLogging$$_log;
            }

            public void org$apache$pekko$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
                this.org$apache$pekko$stream$stage$StageLogging$$_log = x$1;
            }

            public Map sequenceNumbers() {
                return this.sequenceNumbers;
            }

            public void sequenceNumbers_$eq(Map x$1) {
                this.sequenceNumbers = x$1;
            }

            public int nackCount() {
                return this.nackCount;
            }

            public void nackCount_$eq(int x$1) {
                this.nackCount = x$1;
            }

            public UniqueAddress localAddress() {
                return this.$outer.org$apache$pekko$remote$artery$SystemMessageAcker$$inboundContext.localAddress();
            }

            public Class logSource() {
                return SystemMessageAcker.class;
            }

            public void onPush() {
                InboundEnvelope env = (InboundEnvelope)this.grab(this.$outer.in());
                Object object = env.message();
                if (object instanceof SystemMessageDelivery.SystemMessageEnvelope) {
                    long l;
                    SystemMessageDelivery.SystemMessageEnvelope systemMessageEnvelope = (SystemMessageDelivery.SystemMessageEnvelope)object;
                    SystemMessageDelivery.SystemMessageEnvelope systemMessageEnvelope2 = SystemMessageDelivery$SystemMessageEnvelope$.MODULE$.unapply(systemMessageEnvelope);
                    Object object2 = systemMessageEnvelope2._1();
                    long l2 = systemMessageEnvelope2._2();
                    UniqueAddress uniqueAddress = systemMessageEnvelope2._3();
                    long n = l2;
                    UniqueAddress ackReplyTo = uniqueAddress;
                    SystemMessageDelivery.SystemMessageEnvelope sysEnv = systemMessageEnvelope;
                    Option option = this.sequenceNumbers().get((Object)ackReplyTo);
                    if (None$.MODULE$.equals(option)) {
                        l = 1L;
                    } else if (option instanceof Some) {
                        long seqNo;
                        l = seqNo = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    } else {
                        throw new MatchError((Object)option);
                    }
                    long expectedSeqNo = l;
                    if (n == expectedSeqNo) {
                        this.$outer.org$apache$pekko$remote$artery$SystemMessageAcker$$inboundContext.sendControl(ackReplyTo.address(), SystemMessageDelivery$Ack$.MODULE$.apply(n, this.localAddress()));
                        this.sequenceNumbers_$eq((Map)this.sequenceNumbers().updated((Object)ackReplyTo, (Object)BoxesRunTime.boxToLong((long)(n + 1L))));
                        InboundEnvelope unwrapped = env.withMessage(sysEnv.message());
                        this.push(this.$outer.out(), unwrapped);
                        return;
                    }
                    if (n < expectedSeqNo) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("Deduplicate system message [{}] from [{}], expected [{}]", (Object)BoxesRunTime.boxToLong((long)n), (Object)SystemMessageAcker.org$apache$pekko$remote$artery$SystemMessageAcker$$anon$2$$_$fromRemoteAddressStr$1(env), (Object)BoxesRunTime.boxToLong((long)expectedSeqNo));
                        }
                        this.$outer.org$apache$pekko$remote$artery$SystemMessageAcker$$inboundContext.sendControl(ackReplyTo.address(), SystemMessageDelivery$Ack$.MODULE$.apply(expectedSeqNo - 1L, this.localAddress()));
                        this.pull(this.$outer.in());
                        return;
                    }
                    if (this.nackCount() < SystemMessageAcker$.MODULE$.MaxNegativeAcknowledgementLogging()) {
                        this.nackCount_$eq(this.nackCount() + 1);
                        String maxNackReached = this.nackCount() == SystemMessageAcker$.MODULE$.MaxNegativeAcknowledgementLogging() ? new StringBuilder(53).append(". This happened [").append(SystemMessageAcker$.MODULE$.MaxNegativeAcknowledgementLogging()).append("] times and will not be logged more.").toString() : "";
                        this.log().warning("Sending negative acknowledgement of system message [{}] from [{}], highest acknowledged [{}]{}", (Object)BoxesRunTime.boxToLong((long)n), (Object)SystemMessageAcker.org$apache$pekko$remote$artery$SystemMessageAcker$$anon$2$$_$fromRemoteAddressStr$1(env), (Object)BoxesRunTime.boxToLong((long)(expectedSeqNo - 1L)), (Object)maxNackReached);
                    }
                    this.$outer.org$apache$pekko$remote$artery$SystemMessageAcker$$inboundContext.sendControl(ackReplyTo.address(), SystemMessageDelivery$Nack$.MODULE$.apply(expectedSeqNo - 1L, this.localAddress()));
                    this.pull(this.$outer.in());
                    return;
                }
                this.push(this.$outer.out(), env);
            }

            public void onPull() {
                this.pull(this.$outer.in());
            }
        };
    }

    public static final String org$apache$pekko$remote$artery$SystemMessageAcker$$anon$2$$_$fromRemoteAddressStr$1(InboundEnvelope env$1) {
        OutboundContext outboundContext = env$1.association();
        OutboundContext outboundContext2 = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundContext2)) {
            OutboundContext outboundContext3;
            OutboundContext a = outboundContext3 = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext2);
            return a.remoteAddress().toString();
        }
        return "N/A";
    }
}

