/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.tcp;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSession;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.NotUsed;
import org.apache.pekko.NotUsed$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.RemoteLogMarker$;
import org.apache.pekko.remote.RemoteTransportException;
import org.apache.pekko.remote.artery.ArteryTransport;
import org.apache.pekko.remote.artery.ArteryTransport$;
import org.apache.pekko.remote.artery.ArteryTransport$InboundStreamMatValues$;
import org.apache.pekko.remote.artery.ArteryTransport$ShutdownSignal$;
import org.apache.pekko.remote.artery.ArteryTransport$ShuttingDown$;
import org.apache.pekko.remote.artery.Association;
import org.apache.pekko.remote.artery.Decoder;
import org.apache.pekko.remote.artery.DuplicateFlush;
import org.apache.pekko.remote.artery.DuplicateHandshakeReq;
import org.apache.pekko.remote.artery.EnvelopeBuffer;
import org.apache.pekko.remote.artery.EnvelopeBufferPool;
import org.apache.pekko.remote.artery.FixedSizePartitionHub;
import org.apache.pekko.remote.artery.InboundControlJunction;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.compress.NoInboundCompressions$;
import org.apache.pekko.remote.artery.tcp.ArteryTcpTransport$;
import org.apache.pekko.remote.artery.tcp.SSLEngineProvider;
import org.apache.pekko.remote.artery.tcp.SSLEngineProviderSetup;
import org.apache.pekko.remote.artery.tcp.TcpFraming;
import org.apache.pekko.remote.artery.tcp.TcpFraming$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.IgnoreComplete$;
import org.apache.pekko.stream.KillSwitches$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.RestartSettings$;
import org.apache.pekko.stream.SharedKillSwitch;
import org.apache.pekko.stream.SinkShape$;
import org.apache.pekko.stream.TLSClosing;
import org.apache.pekko.stream.UniformFanOutShape;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.GraphDSL;
import org.apache.pekko.stream.scaladsl.GraphDSL$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.MergeHub$;
import org.apache.pekko.stream.scaladsl.Partition$;
import org.apache.pekko.stream.scaladsl.RestartFlow$;
import org.apache.pekko.stream.scaladsl.Sink;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.scaladsl.Tcp;
import org.apache.pekko.stream.scaladsl.Tcp$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.BuildFrom$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Try;

public class ArteryTcpTransport
extends ArteryTransport {
    private final boolean tlsEnabled;
    private volatile SharedKillSwitch inboundKillSwitch;
    private volatile Option<Tcp.ServerBinding> serverBinding;
    private final Promise<Flow<ByteString, ByteString, NotUsed>> firstConnectionFlow;
    private volatile Future<Flow<ByteString, ByteString, NotUsed>> inboundConnectionFlow;
    private final SSLEngineProvider sslEngineProvider;

    public static Try<BoxedUnit> optionToTry(Option<Throwable> option) {
        return ArteryTcpTransport$.MODULE$.optionToTry(option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArteryTcpTransport(ExtendedActorSystem _system, RemoteActorRefProvider _provider, boolean tlsEnabled) {
        SSLEngineProvider sSLEngineProvider;
        this.tlsEnabled = tlsEnabled;
        super(_system, _provider);
        this.inboundKillSwitch = KillSwitches$.MODULE$.shared("inboundKillSwitch");
        this.serverBinding = None$.MODULE$;
        this.firstConnectionFlow = Promise$.MODULE$.apply();
        this.inboundConnectionFlow = this.firstConnectionFlow.future();
        if (tlsEnabled) {
            Option option = this.system().settings().setup().get(ClassTag$.MODULE$.apply(SSLEngineProviderSetup.class));
            if (option instanceof Some) {
                SSLEngineProviderSetup p = (SSLEngineProviderSetup)((Object)((Some)option).value());
                sSLEngineProvider = (SSLEngineProvider)OptionVal.Some$.MODULE$.apply(p.sslEngineProvider().apply((Object)this.system()));
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                sSLEngineProvider = (SSLEngineProvider)OptionVal.Some$.MODULE$.apply(this.system().dynamicAccess().createInstanceFor(this.settings().SSLEngineProviderClassName(), (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply(ActorSystem.class, (Object)this.system())})), ClassTag$.MODULE$.apply(SSLEngineProvider.class)).recover((PartialFunction)new Serializable(this){
                    private final /* synthetic */ ArteryTcpTransport $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable;
                        Throwable e = throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable;
                        Throwable e = throwable = x;
                        throw new ConfigurationException(new StringBuilder(37).append("Could not create SSLEngineProvider [").append(this.$outer.settings().SSLEngineProviderClassName()).append("]").toString(), e);
                    }
                }).get());
            }
        } else {
            OptionVal$.MODULE$.None();
            sSLEngineProvider = null;
        }
        this.sslEngineProvider = sSLEngineProvider;
    }

    @Override
    public void startTransport() {
    }

    @Override
    public Sink<EnvelopeBuffer, Future<Done>> outboundTransportSink(OutboundContext outboundContext, int streamId, EnvelopeBufferPool bufferPool) {
        String host = (String)outboundContext.remoteAddress().host().get();
        int port = BoxesRunTime.unboxToInt((Object)outboundContext.remoteAddress().port().get());
        InetSocketAddress remoteAddress = InetSocketAddress.createUnresolved(host, port);
        return ((Flow)((Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)env -> {
            int size = env.byteBuffer().limit();
            this.flightRecorder().tcpOutboundSent(size);
            ByteString bytes = ByteString$.MODULE$.apply(env.byteBuffer());
            bufferPool.release((EnvelopeBuffer)env);
            return TcpFraming$.MODULE$.encodeFrameHeader(size).$plus$plus(bytes);
        })).via((Graph)this.connectionFlowWithRestart$1(outboundContext, streamId, remoteAddress, host, port)).map((Function1 & Serializable)_$3 -> {
            throw new IllegalStateException(new StringBuilder(54).append("Unexpected incoming bytes in outbound connection to [").append(outboundContext.remoteAddress()).append("]").toString());
        })).toMat((Graph)Sink$.MODULE$.ignore(), Keep$.MODULE$.right());
    }

    @Override
    public Tuple2<Object, Object> bindInboundStreams() {
        Tcp.ServerBinding serverBinding;
        Source source;
        ExtendedActorSystem sys = this.system();
        Materializer mat = this.materializer();
        String bindHost = this.settings().Bind().Hostname();
        int bindPort = this.settings().Bind().Port();
        if (this.tlsEnabled) {
            SSLEngineProvider sslProvider = (SSLEngineProvider)OptionVal$.MODULE$.get$extension((Object)this.sslEngineProvider);
            source = ((Tcp)Tcp$.MODULE$.apply((ClassicActorSystemProvider)this.system())).bindWithTls(bindHost, bindPort, (Function0 & Serializable)() -> sslProvider.createServerSSLEngine(bindHost, bindPort), Tcp$.MODULE$.defaultBacklog(), (Seq)package$.MODULE$.Nil(), (Duration)Duration$.MODULE$.Inf(), (Function1 & Serializable)session -> ArteryTcpTransport$.MODULE$.optionToTry(sslProvider.verifyServerSession(bindHost, (SSLSession)session)), (TLSClosing)IgnoreComplete$.MODULE$);
        } else {
            Tcp tcp = (Tcp)Tcp$.MODULE$.apply((ClassicActorSystemProvider)this.system());
            source = tcp.bind(bindHost, bindPort, tcp.bind$default$3(), tcp.bind$default$4(), false, tcp.bind$default$6());
        }
        Source connectionSource = source;
        Option<Tcp.ServerBinding> option = this.serverBinding;
        if (None$.MODULE$.equals(option)) {
            Future binding = ((Future)connectionSource.to((Graph)Sink$.MODULE$.foreach((Function1)((JProcedure1 & Serializable)arg_0 -> this.$anonfun$5(mat, (ActorSystem)sys, arg_0)))).run(mat)).recoverWith((PartialFunction)new Serializable(bindHost, bindPort){
                private final String bindHost$3;
                private final int bindPort$2;
                {
                    this.bindHost$3 = bindHost$4;
                    this.bindPort$2 = bindPort$5;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return Future$.MODULE$.failed((Throwable)((Object)new RemoteTransportException(new StringBuilder(34).append("Failed to bind TCP to [").append(this.bindHost$3).append(":").append(this.bindPort$2).append("] due to: ").append(e.getMessage()).toString(), e)));
                }
            }, ExecutionContexts$.MODULE$.parasitic());
            Tcp.ServerBinding b = (Tcp.ServerBinding)Await$.MODULE$.result((Awaitable)binding, (Duration)this.settings().Bind().BindTimeout());
            this.flightRecorder().tcpInboundBound(bindHost, b.localAddress());
            serverBinding = b;
        } else if (option instanceof Some) {
            Tcp.ServerBinding binding;
            serverBinding = binding = (Tcp.ServerBinding)((Some)option).value();
        } else {
            throw new MatchError(option);
        }
        Tcp.ServerBinding binding = serverBinding;
        this.serverBinding = Some$.MODULE$.apply((Object)binding);
        if (this.settings().Canonical().Port() == 0) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)binding.localAddress().getPort()), (Object)BoxesRunTime.boxToInteger((int)binding.localAddress().getPort()));
        }
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.settings().Canonical().Port()), (Object)BoxesRunTime.boxToInteger((int)binding.localAddress().getPort()));
    }

    @Override
    public void runInboundStreams(int port, int bindPort) {
        Tuple2 tuple2;
        Tuple2<Sink<EnvelopeBuffer, NotUsed>, Future<Done>> tuple22 = this.runInboundControlStream();
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        Sink controlStream = (Sink)tuple22._1();
        Future controlStreamCompleted = (Future)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)controlStream, (Object)controlStreamCompleted);
        Sink controlStream2 = (Sink)tuple23._1();
        Future controlStreamCompleted2 = (Future)tuple23._2();
        Tuple2<Sink<EnvelopeBuffer, NotUsed>, Future<Done>> tuple24 = this.runInboundOrdinaryMessagesStream();
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        Sink ordinaryMessagesStream = (Sink)tuple24._1();
        Future ordinaryMessagesStreamCompleted = (Future)tuple24._2();
        Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)ordinaryMessagesStream, (Object)ordinaryMessagesStreamCompleted);
        Sink ordinaryMessagesStream2 = (Sink)tuple25._1();
        Future ordinaryMessagesStreamCompleted2 = (Future)tuple25._2();
        Tuple2 tuple26 = tuple2 = this.largeMessageChannelEnabled() ? this.runInboundLargeMessagesStream() : Tuple2$.MODULE$.apply((Object)((Flow)Flow$.MODULE$.apply().map((Function1)(JProcedure1 & Serializable)_$5 -> this.log().warning("Dropping large message, missing large-message-destinations configuration."))).to((Graph)Sink$.MODULE$.ignore()), (Object)Promise$.MODULE$.apply().future());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Sink largeMessagesStream = (Sink)tuple2._1();
        Future largeMessagesStreamCompleted = (Future)tuple2._2();
        Tuple2 tuple27 = Tuple2$.MODULE$.apply((Object)largeMessagesStream, (Object)largeMessagesStreamCompleted);
        Sink largeMessagesStream2 = (Sink)tuple27._1();
        Future largeMessagesStreamCompleted2 = (Future)tuple27._2();
        Sink inboundStream = Sink$.MODULE$.fromGraph(GraphDSL$.MODULE$.create((Function1 & Serializable)b -> {
            UniformFanOutShape partition = (UniformFanOutShape)b.add((Graph)Partition$.MODULE$.apply(3, (Function1 & Serializable)env -> {
                int n = env.streamId();
                if (ArteryTransport$.MODULE$.OrdinaryStreamId() == n) {
                    return 1;
                }
                if (ArteryTransport$.MODULE$.ControlStreamId() == n) {
                    return 0;
                }
                if (ArteryTransport$.MODULE$.LargeStreamId() == n) {
                    return 2;
                }
                int other = n;
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected streamId [").append(other).append("]").toString());
            }));
            GraphDSL.Implicits$.MODULE$.port2flow(partition.out(0), b).$tilde$greater((Graph)controlStream2, b);
            GraphDSL.Implicits$.MODULE$.port2flow(partition.out(1), b).$tilde$greater((Graph)ordinaryMessagesStream2, b);
            GraphDSL.Implicits$.MODULE$.port2flow(partition.out(2), b).$tilde$greater((Graph)largeMessagesStream2, b);
            return SinkShape$.MODULE$.apply(partition.in());
        }));
        Flow newInboundConnectionFlow = (Flow)Flow$.MODULE$.apply().via(this.inboundKillSwitch.flow()).via((Graph)new TcpFraming(this.flightRecorder())).alsoTo((Graph)inboundStream).filter((Function1 & Serializable)_$6 -> false).map((Function1 & Serializable)_$7 -> ByteString$.MODULE$.empty());
        this.firstConnectionFlow.trySuccess((Object)newInboundConnectionFlow);
        this.inboundConnectionFlow = Future$.MODULE$.successful((Object)newInboundConnectionFlow);
        ExecutionContextExecutor ec = this.materializer().executionContext();
        Future completed = Future$.MODULE$.firstCompletedOf((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{controlStreamCompleted2, ordinaryMessagesStreamCompleted2, largeMessagesStreamCompleted2})), (ExecutionContext)ec);
        JFunction0.mcV.sp & Serializable restart = () -> this.$anonfun$11(controlStreamCompleted2, (ExecutionContext)ec, ordinaryMessagesStreamCompleted2, largeMessagesStreamCompleted2, port, bindPort);
        this.attachInboundStreamRestart("Inbound streams", (Future<Done>)completed, (Function0<BoxedUnit>)restart);
    }

    private Tuple2<Sink<EnvelopeBuffer, NotUsed>, Future<Done>> runInboundControlStream() {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        int n = Attributes.LogLevels$.MODULE$.Off();
        int n2 = Attributes$.MODULE$.logLevels$default$1();
        int n3 = Attributes$.MODULE$.logLevels$default$2();
        Tuple3 tuple3 = (Tuple3)MergeHub$.MODULE$.source().addAttributes(Attributes$.MODULE$.logLevels(n2, n3, n)).via(this.inboundKillSwitch.flow()).via(this.inboundFlow(this.settings(), NoInboundCompressions$.MODULE$)).toMat(this.inboundControlSink(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Sink a = (Sink)tuple2._1();
                if (tuple22 != null) {
                    InboundControlJunction.ControlMessageSubject c = (InboundControlJunction.ControlMessageSubject)tuple22._1();
                    Future d = (Future)tuple22._2();
                    return Tuple3$.MODULE$.apply((Object)a, (Object)c, (Object)d);
                }
            }
            throw new MatchError((Object)tuple2);
        }).run(this.controlMaterializer());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Sink hub = (Sink)tuple3._1();
        InboundControlJunction.ControlMessageSubject ctrl = (InboundControlJunction.ControlMessageSubject)tuple3._2();
        Future completed = (Future)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)hub, (Object)ctrl, (Object)completed);
        Sink hub2 = (Sink)tuple32._1();
        InboundControlJunction.ControlMessageSubject ctrl2 = (InboundControlJunction.ControlMessageSubject)tuple32._2();
        Future completed2 = (Future)tuple32._3();
        this.attachControlMessageObserver(ctrl2);
        this.updateStreamMatValues((Future<Done>)completed2);
        return Tuple2$.MODULE$.apply((Object)hub2, (Object)completed2);
    }

    private Tuple2<Sink<EnvelopeBuffer, NotUsed>, Future<Done>> runInboundOrdinaryMessagesStream() {
        Sink sink;
        Tuple3 tuple3;
        Tuple3 tuple32;
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        if (this.inboundLanes() == 1) {
            int n = Attributes.LogLevels$.MODULE$.Off();
            int n2 = Attributes$.MODULE$.logLevels$default$1();
            int n3 = Attributes$.MODULE$.logLevels$default$2();
            tuple32 = (Tuple3)MergeHub$.MODULE$.source().addAttributes(Attributes$.MODULE$.logLevels(n2, n3, n)).via(this.inboundKillSwitch.flow()).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).toMat(this.inboundSink(this.envelopeBufferPool()), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    Sink a = (Sink)tuple2._1();
                    Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple2._2();
                    Future c = (Future)tuple22._2();
                    return Tuple3$.MODULE$.apply((Object)a, (Object)b, (Object)c);
                }
                throw new MatchError((Object)tuple22);
            }).run(this.materializer());
        } else {
            SharedKillSwitch laneKillSwitch = KillSwitches$.MODULE$.shared("laneKillSwitch");
            int n = Attributes.LogLevels$.MODULE$.Off();
            int n4 = Attributes$.MODULE$.logLevels$default$1();
            int n5 = Attributes$.MODULE$.logLevels$default$2();
            Source laneSource = MergeHub$.MODULE$.source().addAttributes(Attributes$.MODULE$.logLevels(n4, n5, n)).via(this.inboundKillSwitch.flow()).via(laneKillSwitch.flow()).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).via((Graph)Flow$.MODULE$.fromGraph((Graph)new DuplicateHandshakeReq(this.inboundLanes(), this, this.system(), this.envelopeBufferPool()))).via((Graph)Flow$.MODULE$.fromGraph((Graph)new DuplicateFlush(this.inboundLanes(), this.system(), this.envelopeBufferPool())));
            Tuple3 tuple33 = (Tuple3)laneSource.toMat((Graph)Sink$.MODULE$.fromGraph(new FixedSizePartitionHub<InboundEnvelope>(this.inboundLanePartitioner(), this.inboundLanes(), this.settings().Advanced().InboundHubBufferSize())), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    Sink a = (Sink)tuple2._1();
                    Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple2._2();
                    Source c = (Source)tuple22._2();
                    return Tuple3$.MODULE$.apply((Object)a, (Object)b, (Object)c);
                }
                throw new MatchError((Object)tuple22);
            }).run(this.materializer());
            if (tuple33 == null) {
                throw new MatchError((Object)tuple33);
            }
            Sink inboundHub = (Sink)tuple33._1();
            Decoder.InboundCompressionAccess compressionAccess = (Decoder.InboundCompressionAccess)tuple33._2();
            Source laneHub = (Source)tuple33._3();
            Tuple3 tuple34 = Tuple3$.MODULE$.apply((Object)inboundHub, (Object)compressionAccess, (Object)laneHub);
            Sink inboundHub2 = (Sink)tuple34._1();
            Decoder.InboundCompressionAccess compressionAccess2 = (Decoder.InboundCompressionAccess)tuple34._2();
            Source laneHub2 = (Source)tuple34._3();
            Sink<InboundEnvelope, Future<Done>> lane = this.inboundSink(this.envelopeBufferPool());
            Vector completedValues = (Vector)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.inboundLanes()).iterator().map((Function1 & Serializable)_$9 -> this.$anonfun$16(laneHub2, lane, BoxesRunTime.unboxToInt((Object)_$9))).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Vector$.MODULE$));
            MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
            Future$.MODULE$.firstCompletedOf((IterableOnce)completedValues, (ExecutionContext)ec).failed().foreach((Function1)(JProcedure1 & Serializable)reason -> laneKillSwitch.abort(reason), (ExecutionContext)ec);
            Future allCompleted = Future$.MODULE$.sequence((IterableOnce)completedValues, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)ec).map((Function1 & Serializable)_$10 -> Done$.MODULE$, (ExecutionContext)ec);
            tuple32 = tuple3 = Tuple3$.MODULE$.apply((Object)inboundHub2, (Object)compressionAccess2, (Object)allCompleted);
        }
        if (tuple3 == null || !((sink = (Sink)tuple3._1()) instanceof Sink)) {
            throw new MatchError((Object)tuple3);
        }
        Sink inboundHub = sink;
        Decoder.InboundCompressionAccess inboundCompressionAccess = (Decoder.InboundCompressionAccess)tuple3._2();
        Future completed = (Future)tuple3._3();
        Tuple3 tuple35 = Tuple3$.MODULE$.apply((Object)inboundHub, (Object)inboundCompressionAccess, (Object)completed);
        Sink inboundHub3 = (Sink)tuple35._1();
        Decoder.InboundCompressionAccess inboundCompressionAccess2 = (Decoder.InboundCompressionAccess)tuple35._2();
        Future completed2 = (Future)tuple35._3();
        this.setInboundCompressionAccess(inboundCompressionAccess2);
        this.updateStreamMatValues((Future<Done>)completed2);
        return Tuple2$.MODULE$.apply((Object)inboundHub3, (Object)completed2);
    }

    private Tuple2<Sink<EnvelopeBuffer, NotUsed>, Future<Done>> runInboundLargeMessagesStream() {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        int n = Attributes.LogLevels$.MODULE$.Off();
        int n2 = Attributes$.MODULE$.logLevels$default$1();
        int n3 = Attributes$.MODULE$.logLevels$default$2();
        Tuple2 tuple2 = (Tuple2)MergeHub$.MODULE$.source().addAttributes(Attributes$.MODULE$.logLevels(n2, n3, n)).via(this.inboundKillSwitch.flow()).via(this.inboundLargeFlow(this.settings())).toMat(this.inboundSink(this.largeEnvelopeBufferPool()), Keep$.MODULE$.both()).run(this.materializer());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Sink hub = (Sink)tuple2._1();
        Future completed = (Future)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)hub, (Object)completed);
        Sink hub2 = (Sink)tuple22._1();
        Future completed2 = (Future)tuple22._2();
        this.updateStreamMatValues((Future<Done>)completed2);
        return Tuple2$.MODULE$.apply((Object)hub2, (Object)completed2);
    }

    private void updateStreamMatValues(Future<Done> completed) {
        ExecutionContextExecutor ec = this.materializer().executionContext();
        this.updateStreamMatValues(ArteryTransport$.MODULE$.ControlStreamId(), ArteryTransport$InboundStreamMatValues$.MODULE$.apply(NotUsed$.MODULE$, (Future<Done>)completed.recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return Done$.MODULE$;
            }
        }, (ExecutionContext)ec)));
    }

    @Override
    public Future<Done> shutdownTransport() {
        MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
        this.inboundKillSwitch.shutdown();
        return this.unbind().map((Function1 & Serializable)_$11 -> {
            this.flightRecorder().transportStopped();
            return Done$.MODULE$;
        }, (ExecutionContext)ec);
    }

    private Future<Done> unbind() {
        Option<Tcp.ServerBinding> option = this.serverBinding;
        if (option instanceof Some) {
            Tcp.ServerBinding binding = (Tcp.ServerBinding)((Some)option).value();
            MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
            return binding.unbind().map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                this.flightRecorder().tcpInboundUnbound(this.localAddress());
                return Done$.MODULE$;
            }, (ExecutionContext)ec);
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        throw new MatchError(option);
    }

    private final Flow connectionFlow$1(InetSocketAddress remoteAddress$1, String host$1, int port$1) {
        None$ none$;
        Option<String> option = this.settings().Advanced().Tcp().OutboundClientHostname();
        if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else if (option instanceof Some) {
            String clientHostname = (String)((Some)option).value();
            none$ = Some$.MODULE$.apply((Object)new InetSocketAddress(clientHostname, 0));
        } else {
            throw new MatchError(option);
        }
        None$ localAddress = none$;
        if (this.tlsEnabled) {
            SSLEngineProvider sslProvider = (SSLEngineProvider)OptionVal$.MODULE$.get$extension((Object)this.sslEngineProvider);
            return ((Tcp)Tcp$.MODULE$.apply((ClassicActorSystemProvider)this.system())).outgoingConnectionWithTls(remoteAddress$1, (Function0 & Serializable)() -> sslProvider.createClientSSLEngine(host$1, port$1), (Option)localAddress, (Seq)package$.MODULE$.Nil(), (Duration)this.settings().Advanced().Tcp().ConnectionTimeout(), (Duration)Duration$.MODULE$.Inf(), (Function1 & Serializable)session -> ArteryTcpTransport$.MODULE$.optionToTry(sslProvider.verifyClientSession(host$1, (SSLSession)session)), (TLSClosing)IgnoreComplete$.MODULE$);
        }
        Tcp tcp = (Tcp)Tcp$.MODULE$.apply((ClassicActorSystemProvider)this.system());
        FiniteDuration finiteDuration = this.settings().Advanced().Tcp().ConnectionTimeout();
        Iterable iterable = tcp.outgoingConnection$default$3();
        Duration duration = tcp.outgoingConnection$default$6();
        return tcp.outgoingConnection(remoteAddress$1, (Option)localAddress, iterable, true, (Duration)finiteDuration, duration);
    }

    private final void logConnect$1(OutboundContext outboundContext$2) {
        if (this.log().isDebugEnabled()) {
            this.log().debug(RemoteLogMarker$.MODULE$.connect(outboundContext$2.remoteAddress(), (Option<Object>)outboundContext$2.associationState().uniqueRemoteAddress().map((Function1 & Serializable)_$1 -> _$1.uid())), "Outbound connection opened to [{}]", (Object)outboundContext$2.remoteAddress());
            return;
        }
    }

    public final void org$apache$pekko$remote$artery$tcp$ArteryTcpTransport$$_$logDisconnected$1(OutboundContext outboundContext$3) {
        if (this.log().isDebugEnabled()) {
            this.log().debug(RemoteLogMarker$.MODULE$.disconnected(outboundContext$3.remoteAddress(), (Option<Object>)outboundContext$3.associationState().uniqueRemoteAddress().map((Function1 & Serializable)_$2 -> _$2.uid())), "Outbound connection closed to [{}]", (Object)outboundContext$3.remoteAddress());
            return;
        }
    }

    private final Flow flow$1(OutboundContext outboundContext$5, int streamId$3, int onFailureLogLevel$1, InetSocketAddress remoteAddress$4, String host$6, int port$5, SharedKillSwitch controlIdleKillSwitch) {
        Flow flow = (Flow)Flow$.MODULE$.apply().via((Graph)Flow$.MODULE$.lazyFlow((Function0 & Serializable)() -> {
            this.logConnect$1(outboundContext$5);
            this.flightRecorder().tcpOutboundConnected(outboundContext$5.remoteAddress(), ArteryTransport$.MODULE$.streamName(streamId$3));
            if (OptionVal$.MODULE$.isDefined$extension((Object)controlIdleKillSwitch)) {
                ((Association)outboundContext$5).setControlIdleKillSwitch(controlIdleKillSwitch);
            }
            return ((Flow)Flow$.MODULE$.apply().prepend((Graph)Source$.MODULE$.single((Object)TcpFraming$.MODULE$.encodeConnectionHeader(streamId$3)))).via((Graph)this.connectionFlow$1(remoteAddress$4, host$6, port$5));
        })).mapError((PartialFunction)new Serializable(outboundContext$5, this){
            private final OutboundContext outboundContext$8;
            private final /* synthetic */ ArteryTcpTransport $outer;
            {
                this.outboundContext$8 = outboundContext$9;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (ArteryTransport$ShutdownSignal$.MODULE$.equals(throwable)) {
                    return true;
                }
                Throwable e = throwable;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (ArteryTransport$ShutdownSignal$.MODULE$.equals(throwable)) {
                    return ArteryTransport$ShutdownSignal$.MODULE$;
                }
                Throwable e = throwable;
                this.$outer.org$apache$pekko$remote$artery$tcp$ArteryTcpTransport$$_$logDisconnected$1(this.outboundContext$8);
                return e;
            }
        }).recoverWithRetries(1, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return ArteryTransport$ShutdownSignal$.MODULE$.equals(throwable);
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (ArteryTransport$ShutdownSignal$.MODULE$.equals(throwable)) {
                    return Source$.MODULE$.empty();
                }
                return function1.apply((Object)x);
            }
        });
        String string = new StringBuilder(34).append("outbound connection to [").append(outboundContext$5.remoteAddress()).append("], ").append(ArteryTransport$.MODULE$.streamName(streamId$3)).append(" stream").toString();
        Function1 function1 = flow.log$default$2();
        int n = Attributes.LogLevels$.MODULE$.Off();
        int n2 = Attributes$.MODULE$.logLevels$default$2();
        return ((Flow)flow.log(string, function1, flow.log$default$3(string, function1))).addAttributes(Attributes$.MODULE$.logLevels(n, n2, onFailureLogLevel$1));
    }

    private final Flow connectionFlowWithRestart$1(OutboundContext outboundContext$1, int streamId$1, InetSocketAddress remoteAddress$2, String host$4, int port$3) {
        AtomicInteger restartCount = new AtomicInteger(0);
        Function0 & Serializable flowFactory = (Function0 & Serializable)() -> {
            int onFailureLogLevel;
            int n = onFailureLogLevel = restartCount.incrementAndGet() == 1 ? Logging$.MODULE$.WarningLevel() : Logging$.MODULE$.DebugLevel();
            if (streamId$1 == ArteryTransport$.MODULE$.ControlStreamId()) {
                SharedKillSwitch controlIdleKillSwitch = KillSwitches$.MODULE$.shared("outboundControlStreamIdleKillSwitch");
                return Flow$.MODULE$.apply().via(controlIdleKillSwitch.flow()).via((Graph)this.flow$1(outboundContext$1, streamId$1, onFailureLogLevel, remoteAddress$2, host$4, port$3, (SharedKillSwitch)OptionVal.Some$.MODULE$.apply((Object)controlIdleKillSwitch)));
            }
            OptionVal$.MODULE$.None();
            return this.flow$1(outboundContext$1, streamId$1, onFailureLogLevel, remoteAddress$2, host$4, port$3, null);
        };
        int maxRestarts = streamId$1 == ArteryTransport$.MODULE$.ControlStreamId() ? Integer.MAX_VALUE : 3;
        int n = Attributes.LogLevels$.MODULE$.Off();
        int n2 = Attributes$.MODULE$.logLevels$default$1();
        int n3 = Attributes$.MODULE$.logLevels$default$2();
        return RestartFlow$.MODULE$.withBackoff(RestartSettings$.MODULE$.apply(this.settings().Advanced().OutboundRestartBackoff(), this.settings().Advanced().OutboundRestartBackoff().$times(5L), 0.1).withMaxRestarts(maxRestarts, this.settings().Advanced().OutboundRestartBackoff()), (Function0)flowFactory).addAttributes(Attributes$.MODULE$.logLevels(n2, n3, n));
    }

    private final /* synthetic */ void $anonfun$5(Materializer mat$2, ActorSystem sys$1, Tcp.IncomingConnection connection) {
        this.flightRecorder().tcpInboundConnected(connection.remoteAddress());
        this.inboundConnectionFlow.map((Function1 & Serializable)_$4 -> (NotUsed)connection.handleWith(_$4, mat$2), (ExecutionContext)sys$1.dispatcher());
    }

    private final /* synthetic */ void $anonfun$11(Future controlStreamCompleted$1, ExecutionContext ec$1, Future ordinaryMessagesStreamCompleted$1, Future largeMessagesStreamCompleted$1, int port$7, int bindPort$3) {
        this.inboundKillSwitch.shutdown();
        this.inboundKillSwitch = KillSwitches$.MODULE$.shared("inboundKillSwitch");
        Future allStopped = controlStreamCompleted$1.recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return Done$.MODULE$;
            }
        }, ec$1).flatMap((Function1 & Serializable)x$1 -> {
            Done done = x$1;
            return ordinaryMessagesStreamCompleted$1.recover((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    return Done$.MODULE$;
                }
            }, ec$1).flatMap((Function1 & Serializable)x$12 -> {
                Done done = x$12;
                return (this.largeMessageChannelEnabled() ? largeMessagesStreamCompleted$1.recover((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        return Done$.MODULE$;
                    }
                }, ec$1) : Future$.MODULE$.successful((Object)Done$.MODULE$)).map((Function1 & Serializable)x$1 -> {
                    Done done = x$1;
                    return Done$.MODULE$;
                }, ec$1);
            }, ec$1);
        }, ec$1);
        allStopped.foreach((Function1)(JProcedure1 & Serializable)_$8 -> this.runInboundStreams(port$7, bindPort$3), ec$1);
    }

    private final /* synthetic */ Future $anonfun$16(Source laneHub$1, Sink lane$1, int _$9) {
        return (Future)laneHub$1.toMat((Graph)lane$1, Keep$.MODULE$.right()).run(this.materializer());
    }
}

