/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.serialization;

import org.apache.pekko.actor.ActorInitializationException;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.dispatch.sysmsg.Create;
import org.apache.pekko.dispatch.sysmsg.Create$;
import org.apache.pekko.dispatch.sysmsg.DeathWatchNotification;
import org.apache.pekko.dispatch.sysmsg.DeathWatchNotification$;
import org.apache.pekko.dispatch.sysmsg.Failed;
import org.apache.pekko.dispatch.sysmsg.Failed$;
import org.apache.pekko.dispatch.sysmsg.NoMessage$;
import org.apache.pekko.dispatch.sysmsg.Recreate;
import org.apache.pekko.dispatch.sysmsg.Recreate$;
import org.apache.pekko.dispatch.sysmsg.Resume;
import org.apache.pekko.dispatch.sysmsg.Resume$;
import org.apache.pekko.dispatch.sysmsg.Supervise;
import org.apache.pekko.dispatch.sysmsg.Supervise$;
import org.apache.pekko.dispatch.sysmsg.Suspend;
import org.apache.pekko.dispatch.sysmsg.Suspend$;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.dispatch.sysmsg.Terminate;
import org.apache.pekko.dispatch.sysmsg.Terminate$;
import org.apache.pekko.dispatch.sysmsg.Unwatch;
import org.apache.pekko.dispatch.sysmsg.Unwatch$;
import org.apache.pekko.dispatch.sysmsg.Watch;
import org.apache.pekko.dispatch.sysmsg.Watch$;
import org.apache.pekko.remote.ContainerFormats;
import org.apache.pekko.remote.SystemMessageFormats;
import org.apache.pekko.remote.serialization.WrappedPayloadSupport;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;

public class SystemMessageSerializer
implements Serializer,
BaseSerializer {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SystemMessageSerializer.class.getDeclaredField("serialization$lzy1"));
    private int identifier;
    private final ExtendedActorSystem system;
    private volatile Object serialization$lzy1;
    private final WrappedPayloadSupport payloadSupport;

    public SystemMessageSerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$((BaseSerializer)this);
        this.payloadSupport = new WrappedPayloadSupport(system);
        Statics.releaseFence();
    }

    public int identifier() {
        return this.identifier;
    }

    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$0) {
        this.identifier = x$0;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization() {
        Object object = this.serialization$lzy1;
        if (object instanceof Serialization) {
            return (Serialization)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Serialization)this.serialization$lzyINIT1();
    }

    private Object serialization$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.serialization$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Serialization serialization = null;
                    try {
                        serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                        object2 = serialization == null ? LazyVals.NullValue$.MODULE$ : serialization;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.serialization$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serialization;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean includeManifest() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toBinary(Object o) {
        SystemMessageFormats.SystemMessage.Builder builder;
        SystemMessageFormats.SystemMessage.Builder builder2 = SystemMessageFormats.SystemMessage.newBuilder();
        SystemMessage systemMessage = (SystemMessage)o;
        if (systemMessage instanceof Create) {
            Option option;
            Create create = Create$.MODULE$.unapply((Create)systemMessage);
            Option failure = option = create._1();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.CREATE);
            Option option2 = failure;
            if (option2 instanceof Some) {
                ActorInitializationException throwable = (ActorInitializationException)((Some)option2).value();
                builder = builder2.setCauseData(this.serializeThrowable((Throwable)throwable));
                return builder2.build().toByteArray();
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                builder = BoxedUnit.UNIT;
            }
            return builder2.build().toByteArray();
        } else if (systemMessage instanceof Recreate) {
            Throwable throwable;
            Recreate recreate = Recreate$.MODULE$.unapply((Recreate)systemMessage);
            Throwable cause = throwable = recreate._1();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.RECREATE);
            builder = builder2.setCauseData(this.serializeThrowable(cause));
            return builder2.build().toByteArray();
        } else if (systemMessage instanceof Suspend && Suspend$.MODULE$.unapply((Suspend)systemMessage)) {
            builder = builder2.setType(SystemMessageFormats.SystemMessage.Type.SUSPEND);
            return builder2.build().toByteArray();
        } else if (systemMessage instanceof Resume) {
            Throwable throwable;
            Resume resume = Resume$.MODULE$.unapply((Resume)systemMessage);
            Throwable cause = throwable = resume._1();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.RESUME);
            builder = builder2.setCauseData(this.serializeThrowable(cause));
            return builder2.build().toByteArray();
        } else if (systemMessage instanceof Terminate && Terminate$.MODULE$.unapply((Terminate)systemMessage)) {
            builder = builder2.setType(SystemMessageFormats.SystemMessage.Type.TERMINATE);
            return builder2.build().toByteArray();
        } else if (systemMessage instanceof Supervise) {
            Supervise supervise = Supervise$.MODULE$.unapply((Supervise)systemMessage);
            ActorRef actorRef = supervise._1();
            boolean bl = supervise._2();
            ActorRef child = actorRef;
            boolean async = bl;
            builder2.setType(SystemMessageFormats.SystemMessage.Type.SUPERVISE);
            SystemMessageFormats.SuperviseData.Builder superviseData = SystemMessageFormats.SuperviseData.newBuilder().setChild(this.serializeActorRef(child)).setAsync(async);
            builder = builder2.setSuperviseData(superviseData);
            return builder2.build().toByteArray();
        } else if (systemMessage instanceof Watch) {
            Watch watch = Watch$.MODULE$.unapply((Watch)systemMessage);
            InternalActorRef internalActorRef = watch._1();
            InternalActorRef internalActorRef2 = watch._2();
            InternalActorRef watchee = internalActorRef;
            InternalActorRef watcher = internalActorRef2;
            builder2.setType(SystemMessageFormats.SystemMessage.Type.WATCH);
            SystemMessageFormats.WatchData.Builder watchData = SystemMessageFormats.WatchData.newBuilder().setWatchee(this.serializeActorRef((ActorRef)watchee)).setWatcher(this.serializeActorRef((ActorRef)watcher));
            builder = builder2.setWatchData(watchData);
            return builder2.build().toByteArray();
        } else if (systemMessage instanceof Unwatch) {
            Unwatch unwatch = Unwatch$.MODULE$.unapply((Unwatch)systemMessage);
            ActorRef actorRef = unwatch._1();
            ActorRef actorRef2 = unwatch._2();
            ActorRef watchee = actorRef;
            ActorRef watcher = actorRef2;
            builder2.setType(SystemMessageFormats.SystemMessage.Type.UNWATCH);
            SystemMessageFormats.WatchData.Builder watchData = SystemMessageFormats.WatchData.newBuilder().setWatchee(this.serializeActorRef(watchee)).setWatcher(this.serializeActorRef(watcher));
            builder = builder2.setWatchData(watchData);
            return builder2.build().toByteArray();
        } else if (systemMessage instanceof Failed) {
            Failed failed = Failed$.MODULE$.unapply((Failed)systemMessage);
            ActorRef actorRef = failed._1();
            Throwable throwable = failed._2();
            int n = failed._3();
            ActorRef child = actorRef;
            Throwable cause = throwable;
            int uid = n;
            builder2.setType(SystemMessageFormats.SystemMessage.Type.FAILED);
            SystemMessageFormats.FailedData.Builder failedData = SystemMessageFormats.FailedData.newBuilder().setChild(this.serializeActorRef(child)).setUid(Int$.MODULE$.int2long(uid));
            builder2.setCauseData(this.serializeThrowable(cause));
            builder = builder2.setFailedData(failedData);
            return builder2.build().toByteArray();
        } else if (systemMessage instanceof DeathWatchNotification) {
            DeathWatchNotification deathWatchNotification = DeathWatchNotification$.MODULE$.unapply((DeathWatchNotification)systemMessage);
            ActorRef actorRef = deathWatchNotification._1();
            boolean bl = deathWatchNotification._2();
            boolean bl2 = deathWatchNotification._3();
            ActorRef actor = actorRef;
            boolean existenceConfirmed = bl;
            boolean addressTerminated = bl2;
            builder2.setType(SystemMessageFormats.SystemMessage.Type.DEATHWATCH_NOTIFICATION);
            SystemMessageFormats.DeathWatchNotificationData.Builder deathWatchNotificationData = SystemMessageFormats.DeathWatchNotificationData.newBuilder().setActor(this.serializeActorRef(actor)).setExistenceConfirmed(existenceConfirmed).setAddressTerminated(addressTerminated);
            builder = builder2.setDwNotificationData(deathWatchNotificationData);
            return builder2.build().toByteArray();
        } else {
            if (!NoMessage$.MODULE$.equals(systemMessage)) throw new MatchError((Object)systemMessage);
            throw new IllegalArgumentException("NoMessage should never be serialized or deserialized");
        }
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return this.deserializeSystemMessage(SystemMessageFormats.SystemMessage.parseFrom(bytes));
    }

    private SystemMessage deserializeSystemMessage(SystemMessageFormats.SystemMessage sysmsg) {
        Create create;
        SystemMessageFormats.SystemMessage.Type type = sysmsg.getType();
        SystemMessageFormats.SystemMessage.Type type2 = SystemMessageFormats.SystemMessage.Type.CREATE;
        SystemMessageFormats.SystemMessage.Type type3 = type;
        if (!(type2 != null ? !((Object)((Object)type2)).equals((Object)type3) : type3 != null)) {
            None$ cause = sysmsg.hasCauseData() ? Some$.MODULE$.apply((Object)((ActorInitializationException)this.getCauseThrowable(sysmsg))) : None$.MODULE$;
            create = Create$.MODULE$.apply((Option)cause);
        } else {
            SystemMessageFormats.SystemMessage.Type type4 = SystemMessageFormats.SystemMessage.Type.RECREATE;
            SystemMessageFormats.SystemMessage.Type type5 = type;
            if (!(type4 != null ? !((Object)((Object)type4)).equals((Object)type5) : type5 != null)) {
                create = Recreate$.MODULE$.apply(this.getCauseThrowable(sysmsg));
            } else {
                SystemMessageFormats.SystemMessage.Type type6 = SystemMessageFormats.SystemMessage.Type.SUSPEND;
                SystemMessageFormats.SystemMessage.Type type7 = type;
                if (!(type6 != null ? !((Object)((Object)type6)).equals((Object)type7) : type7 != null)) {
                    create = Suspend$.MODULE$.apply();
                } else {
                    SystemMessageFormats.SystemMessage.Type type8 = SystemMessageFormats.SystemMessage.Type.RESUME;
                    SystemMessageFormats.SystemMessage.Type type9 = type;
                    if (!(type8 != null ? !((Object)((Object)type8)).equals((Object)type9) : type9 != null)) {
                        create = Resume$.MODULE$.apply(this.getCauseThrowable(sysmsg));
                    } else {
                        SystemMessageFormats.SystemMessage.Type type10 = SystemMessageFormats.SystemMessage.Type.TERMINATE;
                        SystemMessageFormats.SystemMessage.Type type11 = type;
                        if (!(type10 != null ? !((Object)((Object)type10)).equals((Object)type11) : type11 != null)) {
                            create = Terminate$.MODULE$.apply();
                        } else {
                            SystemMessageFormats.SystemMessage.Type type12 = SystemMessageFormats.SystemMessage.Type.SUPERVISE;
                            SystemMessageFormats.SystemMessage.Type type13 = type;
                            if (!(type12 != null ? !((Object)((Object)type12)).equals((Object)type13) : type13 != null)) {
                                create = Supervise$.MODULE$.apply(this.deserializeActorRef(sysmsg.getSuperviseData().getChild()), sysmsg.getSuperviseData().getAsync());
                            } else {
                                SystemMessageFormats.SystemMessage.Type type14 = SystemMessageFormats.SystemMessage.Type.WATCH;
                                SystemMessageFormats.SystemMessage.Type type15 = type;
                                if (!(type14 != null ? !((Object)((Object)type14)).equals((Object)type15) : type15 != null)) {
                                    create = Watch$.MODULE$.apply((InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatchee()), (InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatcher()));
                                } else {
                                    SystemMessageFormats.SystemMessage.Type type16 = SystemMessageFormats.SystemMessage.Type.UNWATCH;
                                    SystemMessageFormats.SystemMessage.Type type17 = type;
                                    if (!(type16 != null ? !((Object)((Object)type16)).equals((Object)type17) : type17 != null)) {
                                        create = Unwatch$.MODULE$.apply((ActorRef)((InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatchee())), (ActorRef)((InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatcher())));
                                    } else {
                                        SystemMessageFormats.SystemMessage.Type type18 = SystemMessageFormats.SystemMessage.Type.FAILED;
                                        SystemMessageFormats.SystemMessage.Type type19 = type;
                                        if (!(type18 != null ? !((Object)((Object)type18)).equals((Object)type19) : type19 != null)) {
                                            create = Failed$.MODULE$.apply(this.deserializeActorRef(sysmsg.getFailedData().getChild()), this.getCauseThrowable(sysmsg), (int)sysmsg.getFailedData().getUid());
                                        } else {
                                            SystemMessageFormats.SystemMessage.Type type20 = SystemMessageFormats.SystemMessage.Type.DEATHWATCH_NOTIFICATION;
                                            SystemMessageFormats.SystemMessage.Type type21 = type;
                                            if (!(type20 != null ? !((Object)((Object)type20)).equals((Object)type21) : type21 != null)) {
                                                create = DeathWatchNotification$.MODULE$.apply(this.deserializeActorRef(sysmsg.getDwNotificationData().getActor()), sysmsg.getDwNotificationData().getExistenceConfirmed(), sysmsg.getDwNotificationData().getAddressTerminated());
                                            } else {
                                                throw new MatchError((Object)type);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return (SystemMessage)create;
    }

    private ContainerFormats.Payload.Builder serializeThrowable(Throwable throwable) {
        return this.payloadSupport.payloadBuilder(throwable);
    }

    private Throwable getCauseThrowable(SystemMessageFormats.SystemMessage msg) {
        return (Throwable)this.payloadSupport.deserializePayload(msg.getCauseData());
    }

    private ContainerFormats.ActorRef.Builder serializeActorRef(ActorRef actorRef) {
        return ContainerFormats.ActorRef.newBuilder().setPath(Serialization$.MODULE$.serializedActorPath(actorRef));
    }

    private ActorRef deserializeActorRef(ContainerFormats.ActorRef serializedRef) {
        return this.serialization().system().provider().resolveActorRef(serializedRef.getPath());
    }
}

