/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Props;
import org.apache.pekko.pattern.AskableActorSelection$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.Remoting;
import org.apache.pekko.remote.Remoting$RegisterTransportActor$;
import org.apache.pekko.remote.transport.AbstractTransportAdapter;
import org.apache.pekko.remote.transport.ActorTransportAdapter$;
import org.apache.pekko.remote.transport.ActorTransportAdapter$AssociateUnderlying$;
import org.apache.pekko.remote.transport.ActorTransportAdapter$DisassociateUnderlying$;
import org.apache.pekko.remote.transport.ActorTransportAdapter$ListenUnderlying$;
import org.apache.pekko.remote.transport.ActorTransportAdapter$ListenerRegistered$;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.Transport;
import org.apache.pekko.remote.transport.Transport$ActorAssociationEventListener$;
import org.apache.pekko.util.Timeout;
import scala.Function1;
import scala.Product;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class ActorTransportAdapter
extends AbstractTransportAdapter {
    private final Transport wrappedTransport;
    private final ActorSystem system;
    private volatile ActorRef manager;

    public static Timeout AskTimeout() {
        return ActorTransportAdapter$.MODULE$.AskTimeout();
    }

    public ActorTransportAdapter(Transport wrappedTransport, ActorSystem system) {
        this.wrappedTransport = wrappedTransport;
        this.system = system;
        super(wrappedTransport, (ExecutionContext)system.dispatchers().internalDispatcher());
    }

    public abstract String managerName();

    public abstract Props managerProps();

    public ActorRef manager() {
        return this.manager;
    }

    public void manager_$eq(ActorRef x$1) {
        this.manager = x$1;
    }

    private Future<ActorRef> registerManager() {
        ActorSelection actorSelection = package$.MODULE$.ask(this.system.actorSelection("/system/transports"));
        Remoting.RegisterTransportActor registerTransportActor = Remoting$RegisterTransportActor$.MODULE$.apply(this.managerProps(), this.managerName());
        return AskableActorSelection$.MODULE$.$qmark$extension(actorSelection, (Object)registerTransportActor, ActorTransportAdapter$.MODULE$.AskTimeout(), AskableActorSelection$.MODULE$.$qmark$default$3$extension(actorSelection, (Object)registerTransportActor)).mapTo(ClassTag$.MODULE$.apply(ActorRef.class));
    }

    @Override
    public Future<Transport.AssociationEventListener> interceptListen(Address listenAddress, Future<Transport.AssociationEventListener> listenerPromise) {
        return this.registerManager().map((Function1 & Serializable)mgr -> {
            this.manager_$eq((ActorRef)mgr);
            ActorRef actorRef = this.manager();
            ListenUnderlying listenUnderlying = ActorTransportAdapter$ListenUnderlying$.MODULE$.apply(listenAddress, listenerPromise);
            actorRef.$bang((Object)listenUnderlying, actorRef.$bang$default$2((Object)listenUnderlying));
            return Transport$ActorAssociationEventListener$.MODULE$.apply(this.manager());
        }, this.ec());
    }

    @Override
    public void interceptAssociate(Address remoteAddress, Promise<AssociationHandle> statusPromise) {
        ActorRef actorRef = this.manager();
        AssociateUnderlying associateUnderlying = ActorTransportAdapter$AssociateUnderlying$.MODULE$.apply(remoteAddress, statusPromise);
        actorRef.$bang((Object)associateUnderlying, actorRef.$bang$default$2((Object)associateUnderlying));
    }

    @Override
    public Future<Object> shutdown() {
        return package$.MODULE$.gracefulStop(this.manager(), ((RARP)RARP$.MODULE$.apply(this.system)).provider().remoteSettings().FlushWait(), package$.MODULE$.gracefulStop$default$3()).flatMap((Function1 & Serializable)stopResult -> this.shutdown$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)stopResult)), this.ec());
    }

    private static final /* synthetic */ boolean shutdown$$anonfun$1$$anonfun$1(boolean stopResult$1, boolean wrappedStopResult) {
        return stopResult$1 && wrappedStopResult;
    }

    private final /* synthetic */ Future shutdown$$anonfun$1(boolean stopResult) {
        return this.wrappedTransport.shutdown().map((Function1 & Serializable)wrappedStopResult -> ActorTransportAdapter.shutdown$$anonfun$1$$anonfun$1(stopResult, BoxesRunTime.unboxToBoolean((Object)wrappedStopResult)), this.ec());
    }

    public static final class AssociateUnderlying
    implements TransportOperation,
    Product,
    Serializable {
        private final Address remoteAddress;
        private final Promise statusPromise;

        public static AssociateUnderlying apply(Address address, Promise<AssociationHandle> promise) {
            return ActorTransportAdapter$AssociateUnderlying$.MODULE$.apply(address, promise);
        }

        public static AssociateUnderlying fromProduct(Product product) {
            return ActorTransportAdapter$AssociateUnderlying$.MODULE$.fromProduct(product);
        }

        public static AssociateUnderlying unapply(AssociateUnderlying associateUnderlying) {
            return ActorTransportAdapter$AssociateUnderlying$.MODULE$.unapply(associateUnderlying);
        }

        public AssociateUnderlying(Address remoteAddress, Promise<AssociationHandle> statusPromise) {
            this.remoteAddress = remoteAddress;
            this.statusPromise = statusPromise;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AssociateUnderlying)) return false;
            AssociateUnderlying associateUnderlying = (AssociateUnderlying)object;
            Address address = this.remoteAddress();
            Address address2 = associateUnderlying.remoteAddress();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!address.equals(address2)) return false;
            Promise<AssociationHandle> promise = this.statusPromise();
            Promise<AssociationHandle> promise2 = associateUnderlying.statusPromise();
            if (promise == null) {
                if (promise2 == null) return true;
                return false;
            } else {
                if (!promise.equals(promise2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AssociateUnderlying;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AssociateUnderlying";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "remoteAddress";
            }
            if (1 == n2) {
                return "statusPromise";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address remoteAddress() {
            return this.remoteAddress;
        }

        public Promise<AssociationHandle> statusPromise() {
            return this.statusPromise;
        }

        public AssociateUnderlying copy(Address remoteAddress, Promise<AssociationHandle> statusPromise) {
            return new AssociateUnderlying(remoteAddress, statusPromise);
        }

        public Address copy$default$1() {
            return this.remoteAddress();
        }

        public Promise<AssociationHandle> copy$default$2() {
            return this.statusPromise();
        }

        public Address _1() {
            return this.remoteAddress();
        }

        public Promise<AssociationHandle> _2() {
            return this.statusPromise();
        }
    }

    public static final class DisassociateUnderlying
    implements TransportOperation,
    DeadLetterSuppression,
    Product,
    Serializable {
        private final AssociationHandle.DisassociateInfo info;

        public static DisassociateUnderlying apply(AssociationHandle.DisassociateInfo disassociateInfo) {
            return ActorTransportAdapter$DisassociateUnderlying$.MODULE$.apply(disassociateInfo);
        }

        public static DisassociateUnderlying fromProduct(Product product) {
            return ActorTransportAdapter$DisassociateUnderlying$.MODULE$.fromProduct(product);
        }

        public static DisassociateUnderlying unapply(DisassociateUnderlying disassociateUnderlying) {
            return ActorTransportAdapter$DisassociateUnderlying$.MODULE$.unapply(disassociateUnderlying);
        }

        public static AssociationHandle.DisassociateInfo $lessinit$greater$default$1() {
            return ActorTransportAdapter$DisassociateUnderlying$.MODULE$.$lessinit$greater$default$1();
        }

        public DisassociateUnderlying(AssociationHandle.DisassociateInfo info) {
            this.info = info;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DisassociateUnderlying)) return false;
            DisassociateUnderlying disassociateUnderlying = (DisassociateUnderlying)object;
            AssociationHandle.DisassociateInfo disassociateInfo = this.info();
            AssociationHandle.DisassociateInfo disassociateInfo2 = disassociateUnderlying.info();
            if (disassociateInfo != null) {
                if (!disassociateInfo.equals(disassociateInfo2)) return false;
                return true;
            }
            if (disassociateInfo2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DisassociateUnderlying;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DisassociateUnderlying";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "info";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public AssociationHandle.DisassociateInfo info() {
            return this.info;
        }

        public DisassociateUnderlying copy(AssociationHandle.DisassociateInfo info) {
            return new DisassociateUnderlying(info);
        }

        public AssociationHandle.DisassociateInfo copy$default$1() {
            return this.info();
        }

        public AssociationHandle.DisassociateInfo _1() {
            return this.info();
        }
    }

    public static final class ListenUnderlying
    implements TransportOperation,
    Product,
    Serializable {
        private final Address listenAddress;
        private final Future upstreamListener;

        public static ListenUnderlying apply(Address address, Future<Transport.AssociationEventListener> future) {
            return ActorTransportAdapter$ListenUnderlying$.MODULE$.apply(address, future);
        }

        public static ListenUnderlying fromProduct(Product product) {
            return ActorTransportAdapter$ListenUnderlying$.MODULE$.fromProduct(product);
        }

        public static ListenUnderlying unapply(ListenUnderlying listenUnderlying) {
            return ActorTransportAdapter$ListenUnderlying$.MODULE$.unapply(listenUnderlying);
        }

        public ListenUnderlying(Address listenAddress, Future<Transport.AssociationEventListener> upstreamListener) {
            this.listenAddress = listenAddress;
            this.upstreamListener = upstreamListener;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ListenUnderlying)) return false;
            ListenUnderlying listenUnderlying = (ListenUnderlying)object;
            Address address = this.listenAddress();
            Address address2 = listenUnderlying.listenAddress();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!address.equals(address2)) return false;
            Future<Transport.AssociationEventListener> future = this.upstreamListener();
            Future<Transport.AssociationEventListener> future2 = listenUnderlying.upstreamListener();
            if (future == null) {
                if (future2 == null) return true;
                return false;
            } else {
                if (!future.equals(future2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ListenUnderlying;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ListenUnderlying";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "listenAddress";
            }
            if (1 == n2) {
                return "upstreamListener";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address listenAddress() {
            return this.listenAddress;
        }

        public Future<Transport.AssociationEventListener> upstreamListener() {
            return this.upstreamListener;
        }

        public ListenUnderlying copy(Address listenAddress, Future<Transport.AssociationEventListener> upstreamListener) {
            return new ListenUnderlying(listenAddress, upstreamListener);
        }

        public Address copy$default$1() {
            return this.listenAddress();
        }

        public Future<Transport.AssociationEventListener> copy$default$2() {
            return this.upstreamListener();
        }

        public Address _1() {
            return this.listenAddress();
        }

        public Future<Transport.AssociationEventListener> _2() {
            return this.upstreamListener();
        }
    }

    public static final class ListenerRegistered
    implements TransportOperation,
    Product,
    Serializable {
        private final Transport.AssociationEventListener listener;

        public static ListenerRegistered apply(Transport.AssociationEventListener associationEventListener) {
            return ActorTransportAdapter$ListenerRegistered$.MODULE$.apply(associationEventListener);
        }

        public static ListenerRegistered fromProduct(Product product) {
            return ActorTransportAdapter$ListenerRegistered$.MODULE$.fromProduct(product);
        }

        public static ListenerRegistered unapply(ListenerRegistered listenerRegistered) {
            return ActorTransportAdapter$ListenerRegistered$.MODULE$.unapply(listenerRegistered);
        }

        public ListenerRegistered(Transport.AssociationEventListener listener) {
            this.listener = listener;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ListenerRegistered)) return false;
            ListenerRegistered listenerRegistered = (ListenerRegistered)object;
            Transport.AssociationEventListener associationEventListener = this.listener();
            Transport.AssociationEventListener associationEventListener2 = listenerRegistered.listener();
            if (associationEventListener != null) {
                if (!associationEventListener.equals(associationEventListener2)) return false;
                return true;
            }
            if (associationEventListener2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ListenerRegistered;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ListenerRegistered";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "listener";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Transport.AssociationEventListener listener() {
            return this.listener;
        }

        public ListenerRegistered copy(Transport.AssociationEventListener listener) {
            return new ListenerRegistered(listener);
        }

        public Transport.AssociationEventListener copy$default$1() {
            return this.listener();
        }

        public Transport.AssociationEventListener _1() {
            return this.listener();
        }
    }

    public static interface TransportOperation
    extends NoSerializationVerificationNeeded {
    }
}

