/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport;

import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.RemoteSettings;
import org.apache.pekko.remote.transport.TransportAdapterProvider;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ClassTag$;

public class TransportAdapters
implements Extension {
    private final ExtendedActorSystem system;
    private final RemoteSettings settings;
    private final Map<String, TransportAdapterProvider> adaptersTable;

    public TransportAdapters(ExtendedActorSystem system) {
        this.system = system;
        this.settings = ((RARP)RARP$.MODULE$.apply((ActorSystem)system)).provider().remoteSettings();
        this.adaptersTable = (Map)this.settings().Adapters().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                String fqn = (String)tuple2._2();
                return true;
            }
            return false;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                String fqn = (String)tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, system.dynamicAccess().createInstanceFor(fqn, (Seq)Seq$.MODULE$.empty(), ClassTag$.MODULE$.apply(TransportAdapterProvider.class)).recover((PartialFunction)new Serializable(fqn){
                    private final String fqn$1;
                    {
                        this.fqn$1 = fqn$2;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable;
                        Throwable e = throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable;
                        Throwable e = throwable = x;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Cannot instantiate transport adapter [").append(this.fqn$1).append("]").toString(), e);
                    }
                }).get());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public RemoteSettings settings() {
        return this.settings;
    }

    public TransportAdapterProvider getAdapterProvider(String name) {
        Option option = this.adaptersTable.get((Object)name);
        if (option instanceof Some) {
            TransportAdapterProvider provider = (TransportAdapterProvider)((Some)option).value();
            return provider;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(63).append("There is no registered transport adapter provider with name: [").append(name).append("]").toString());
        }
        throw new MatchError((Object)option);
    }
}

