/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import com.typesafe.config.Config;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelMatchers;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.dispatch.Dispatchers;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.Transport;
import org.apache.pekko.remote.transport.netty.ClientHandler;
import org.apache.pekko.remote.transport.netty.NettyFutureBridge$;
import org.apache.pekko.remote.transport.netty.NettySSLSupport$;
import org.apache.pekko.remote.transport.netty.NettyTransport$;
import org.apache.pekko.remote.transport.netty.NettyTransportException;
import org.apache.pekko.remote.transport.netty.NettyTransportExceptionNoStack;
import org.apache.pekko.remote.transport.netty.NettyTransportSettings;
import org.apache.pekko.remote.transport.netty.SSLEngineProvider;
import org.apache.pekko.remote.transport.netty.TcpClientHandler;
import org.apache.pekko.remote.transport.netty.TcpServerHandler;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public class NettyTransport
implements Transport {
    private final NettyTransportSettings settings;
    private final ExtendedActorSystem system;
    private final ExecutionContext executionContext;
    private final String schemeIdentifier;
    private volatile Address boundTo;
    private volatile Channel serverChannel;
    private final MarkerLoggingAdapter log;
    private final DefaultChannelGroup channelGroup;
    private final NioEventLoopGroup clientEventLoopGroup;
    private final NioEventLoopGroup serverEventLoopParentGroup;
    private final NioEventLoopGroup serverEventLoopChildGroup;
    private final Promise<Transport.AssociationEventListener> associationListenerPromise;
    private final SSLEngineProvider sslEngineProvider;
    private final ServerBootstrap inboundBootstrap;

    public static int FrameLengthFieldLength() {
        return NettyTransport$.MODULE$.FrameLengthFieldLength();
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option);
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option, Option<Object> option2) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option, option2);
    }

    public static void gracefulClose(Channel channel, ExecutionContext executionContext) {
        NettyTransport$.MODULE$.gracefulClose(channel, executionContext);
    }

    public static AtomicInteger uniqueIdCounter() {
        return NettyTransport$.MODULE$.uniqueIdCounter();
    }

    public NettyTransport(NettyTransportSettings settings, ExtendedActorSystem system) {
        SSLEngineProvider sSLEngineProvider;
        this.settings = settings;
        this.system = system;
        Dispatchers dispatchers = system.dispatchers();
        this.executionContext = (ExecutionContext)settings.UseDispatcherForIo().orElse(() -> NettyTransport.$init$$$anonfun$3(system)).map((Function1 & Serializable)id -> dispatchers.lookup(id)).getOrElse(() -> NettyTransport.$init$$$anonfun$5(system));
        this.schemeIdentifier = new StringBuilder(3).append(settings.EnableSsl() ? "ssl." : "").append("tcp").toString();
        this.log = Logging$.MODULE$.withMarker((ActorSystem)system, NettyTransport.class, LogSource$.MODULE$.fromAnyClass());
        this.channelGroup = new DefaultChannelGroup(new StringBuilder(42).append("pekko-netty-transport-driver-channelgroup-").append(NettyTransport$.MODULE$.uniqueIdCounter().getAndIncrement()).toString(), (EventExecutor)GlobalEventExecutor.INSTANCE);
        this.clientEventLoopGroup = this.createEventLoopGroup(settings.ClientSocketWorkerPoolSize() + 1);
        this.serverEventLoopParentGroup = this.createEventLoopGroup(0);
        this.serverEventLoopChildGroup = this.createEventLoopGroup(settings.ServerSocketWorkerPoolSize());
        this.associationListenerPromise = Promise$.MODULE$.apply();
        if (settings.EnableSsl()) {
            sSLEngineProvider = (SSLEngineProvider)OptionVal.Some$.MODULE$.apply(system.dynamicAccess().createInstanceFor(settings.SSLEngineProviderClassName(), (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply(ActorSystem.class, (Object)system)})), ClassTag$.MODULE$.apply(SSLEngineProvider.class)).recover((PartialFunction)new Serializable(this){
                private final /* synthetic */ NettyTransport $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    throw new ConfigurationException(new StringBuilder(37).append("Could not create SSLEngineProvider [").append(this.$outer.settings().SSLEngineProviderClassName()).append("]").toString(), e);
                }
            }).get());
        } else {
            OptionVal$.MODULE$.None();
            sSLEngineProvider = null;
        }
        this.sslEngineProvider = sSLEngineProvider;
        ChannelInitializer<SocketChannel> serverPipelineInitializer = new ChannelInitializer<SocketChannel>(settings, this){
            private final NettyTransportSettings settings$2;
            private final /* synthetic */ NettyTransport $outer;
            {
                this.settings$2 = settings$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final void initChannel(SocketChannel ch) {
                this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$_$_$$lessinit$greater$$anonfun$6(this.settings$2, ch);
            }
        };
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group((EventLoopGroup)this.serverEventLoopParentGroup, (EventLoopGroup)this.serverEventLoopChildGroup);
        bootstrap.channel(NioServerSocketChannel.class);
        bootstrap.childHandler((ChannelHandler)serverPipelineInitializer);
        bootstrap.option(ChannelOption.AUTO_READ, (Object)Predef$.MODULE$.boolean2Boolean(false));
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)Predef$.MODULE$.int2Integer(settings.Backlog()));
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)Predef$.MODULE$.boolean2Boolean(settings.TcpReuseAddr()));
        bootstrap.childOption(ChannelOption.AUTO_READ, (Object)Predef$.MODULE$.boolean2Boolean(false));
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)Predef$.MODULE$.boolean2Boolean(settings.TcpNodelay()));
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)Predef$.MODULE$.boolean2Boolean(settings.TcpKeepalive()));
        settings.ReceiveBufferSize().foreach((Function1 & Serializable)sz -> bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        settings.SendBufferSize().foreach((Function1 & Serializable)sz -> bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        settings.WriteBufferHighWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable)_$4 -> _$4 > 0).foreach((Function1 & Serializable)sz -> bootstrap.childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        settings.WriteBufferLowWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable)_$5 -> _$5 > 0).foreach((Function1 & Serializable)sz -> bootstrap.childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        this.inboundBootstrap = bootstrap;
    }

    public NettyTransportSettings settings() {
        return this.settings;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public NettyTransport(ExtendedActorSystem system, Config conf) {
        this(new NettyTransportSettings(conf), system);
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String schemeIdentifier() {
        return this.schemeIdentifier;
    }

    @Override
    public int maximumPayloadBytes() {
        return this.settings().MaxFrameSize();
    }

    private NioEventLoopGroup createEventLoopGroup(int nThreadCount) {
        Dispatchers dispatchers = this.system().dispatchers();
        return (NioEventLoopGroup)this.settings().UseDispatcherForIo().map((Function1 & Serializable)id -> dispatchers.lookup(id)).map((Function1 & Serializable)executor -> new NioEventLoopGroup(0, (Executor)executor)).getOrElse(() -> this.createEventLoopGroup$$anonfun$3(nThreadCount));
    }

    public DefaultChannelGroup channelGroup() {
        return this.channelGroup;
    }

    private ChannelPipeline newPipeline(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addFirst("FlushConsolidationHandler", (ChannelHandler)new FlushConsolidationHandler(256, true));
        pipeline.addLast("FrameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.maximumPayloadBytes(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), true));
        pipeline.addLast("FrameEncoder", (ChannelHandler)new LengthFieldPrepender(NettyTransport$.MODULE$.FrameLengthFieldLength()));
        return pipeline;
    }

    private SslHandler sslHandler(boolean isClient) {
        SSLEngineProvider sSLEngineProvider = this.sslEngineProvider;
        SSLEngineProvider sSLEngineProvider2 = (SSLEngineProvider)OptionVal.Some$.MODULE$.unapply((Object)sSLEngineProvider);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)sSLEngineProvider2)) {
            SSLEngineProvider sSLEngineProvider3;
            SSLEngineProvider sslProvider = sSLEngineProvider3 = (SSLEngineProvider)OptionVal$.MODULE$.get$extension((Object)sSLEngineProvider2);
            return NettySSLSupport$.MODULE$.apply(sslProvider, isClient);
        }
        throw new IllegalStateException("Expected enable-ssl=on");
    }

    private ChannelInitializer<SocketChannel> clientPipelineInitializer(Address remoteAddress) {
        return new ChannelInitializer<SocketChannel>(remoteAddress, this){
            private final Address remoteAddress$3;
            private final /* synthetic */ NettyTransport $outer;
            {
                this.remoteAddress$3 = remoteAddress$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final void initChannel(SocketChannel ch) {
                this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$_$clientPipelineInitializer$$anonfun$1(this.remoteAddress$3, ch);
            }
        };
    }

    private Bootstrap outboundBootstrap(Address remoteAddress) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)this.clientEventLoopGroup);
        bootstrap.handler(this.clientPipelineInitializer(remoteAddress));
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.AUTO_READ, (Object)Predef$.MODULE$.boolean2Boolean(false));
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Predef$.MODULE$.int2Integer((int)this.settings().ConnectionTimeout().toMillis()));
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)Predef$.MODULE$.boolean2Boolean(this.settings().TcpNodelay()));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)Predef$.MODULE$.boolean2Boolean(this.settings().TcpKeepalive()));
        this.settings().ReceiveBufferSize().foreach((Function1 & Serializable)sz -> NettyTransport.outboundBootstrap$$anonfun$1(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        this.settings().SendBufferSize().foreach((Function1 & Serializable)sz -> NettyTransport.outboundBootstrap$$anonfun$2(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        this.settings().WriteBufferHighWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable)_$6 -> _$6 > 0).foreach((Function1 & Serializable)sz -> NettyTransport.outboundBootstrap$$anonfun$4(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        this.settings().WriteBufferLowWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable)_$7 -> _$7 > 0).foreach((Function1 & Serializable)sz -> NettyTransport.outboundBootstrap$$anonfun$6(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        return bootstrap;
    }

    @Override
    public boolean isResponsibleFor(Address address) {
        return true;
    }

    public Future<InetSocketAddress> addressToSocketAddress(Address addr) {
        Address address = addr;
        if (address != null) {
            Address address2 = Address$.MODULE$.unapply(address);
            String string = address2._1();
            String string2 = address2._2();
            Option option = address2._3();
            Option option2 = address2._4();
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return Future$.MODULE$.apply(() -> NettyTransport.addressToSocketAddress$$anonfun$1(host, port), this.executionContext());
                }
            }
        }
        return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(55).append("Address [").append(addr).append("] must contain both host and port information.").toString()));
    }

    @Override
    public Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> listen() {
        int bindPort = this.settings().BindPortSelector();
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply(() -> this.listen$$anonfun$1(bindPort)));
    }

    public Address boundAddress() {
        return this.boundTo;
    }

    private Tuple2<String, Object> extractHostAndPort(Address addr) {
        Address address = addr;
        if (address != null) {
            Address address2 = Address$.MODULE$.unapply(address);
            String string = address2._1();
            String string2 = address2._2();
            Option option = address2._3();
            Option option2 = address2._4();
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return Tuple2$.MODULE$.apply((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
                }
            }
        }
        throw new IllegalArgumentException(new StringBuilder(55).append("Address [").append(addr).append("] must contain both host and port information.").toString());
    }

    @Override
    public Future<AssociationHandle> associate(Address remoteAddress) {
        if (!this.serverChannel.isActive()) {
            return Future$.MODULE$.failed((Throwable)new NettyTransportException("Transport is not bound"));
        }
        Bootstrap bootstrap = this.outboundBootstrap(remoteAddress);
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply(() -> this.associate$$anonfun$1(remoteAddress))).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String host = (String)tuple2._1();
                int port = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return true;
            }
            return false;
        }, this.executionContext()).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String host = (String)tuple2._1();
                int port = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return NettyFutureBridge$.MODULE$.apply(bootstrap.connect(host, port)).flatMap((Function1 & Serializable)channel -> (this.settings().EnableSsl() ? NettyFutureBridge$.MODULE$.apply(((SslHandler)channel.pipeline().get(SslHandler.class)).handshakeFuture()) : Future$.MODULE$.successful(channel)).flatMap((Function1 & Serializable)readyChannel -> ((ClientHandler)readyChannel.pipeline().get(ClientHandler.class)).statusFuture().map((Function1 & Serializable)handle -> handle, this.executionContext()), this.executionContext()), this.executionContext());
            }
            throw new MatchError((Object)tuple2);
        }, this.executionContext()).recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof CancellationException) {
                    return true;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable t = throwable2 = (Throwable)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof CancellationException) {
                    throw new NettyTransportExceptionNoStack("Connection was cancelled");
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2 = (Throwable)option.get();
                    Throwable t = throwable2;
                    String msg = t.getCause() == null ? t.getMessage() : (t.getCause().getCause() == null ? new StringBuilder(13).append(t.getMessage()).append(", caused by: ").append(t.getCause()).toString() : new StringBuilder(26).append(t.getMessage()).append(", caused by: ").append(t.getCause()).append(", caused by: ").append(t.getCause().getCause()).toString());
                    throw new NettyTransportExceptionNoStack(new StringBuilder(2).append(t.getClass().getName()).append(": ").append(msg).toString(), t.getCause());
                }
                return function1.apply((Object)x);
            }
        }, this.executionContext());
    }

    @Override
    public Future<Object> shutdown() {
        return this.always$1(this.channelGroup().close(ChannelMatchers.isServerChannel())).flatMap((Function1 & Serializable)unbindStatus -> this.shutdown$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)unbindStatus)), this.executionContext());
    }

    private static final Option $init$$$anonfun$3(ExtendedActorSystem system$1) {
        String string = ((RARP)RARP$.MODULE$.apply((ActorSystem)system$1)).provider().remoteSettings().Dispatcher();
        if ("".equals(string)) {
            return None$.MODULE$;
        }
        String dispatcherName = string;
        return Some$.MODULE$.apply((Object)dispatcherName);
    }

    private static final ExecutionContextExecutor $init$$$anonfun$5(ExtendedActorSystem system$2) {
        return system$2.dispatcher();
    }

    public final /* synthetic */ void org$apache$pekko$remote$transport$netty$NettyTransport$$_$_$$lessinit$greater$$anonfun$6(NettyTransportSettings settings$1, SocketChannel ch) {
        ChannelPipeline pipeline = this.newPipeline((Channel)ch);
        if (settings$1.EnableSsl()) {
            pipeline.addFirst("SslHandler", (ChannelHandler)this.sslHandler(false));
        }
        TcpServerHandler handler = new TcpServerHandler(this, (Future<Transport.AssociationEventListener>)this.associationListenerPromise.future(), (LoggingAdapter)this.log);
        pipeline.addLast("ServerHandler", (ChannelHandler)handler);
    }

    private final NioEventLoopGroup createEventLoopGroup$$anonfun$3(int nThreadCount$1) {
        return new NioEventLoopGroup(nThreadCount$1, this.system().threadFactory());
    }

    public final /* synthetic */ void org$apache$pekko$remote$transport$netty$NettyTransport$$_$clientPipelineInitializer$$anonfun$1(Address remoteAddress$1, SocketChannel ch) {
        ChannelPipeline pipeline = this.newPipeline((Channel)ch);
        if (this.settings().EnableSsl()) {
            pipeline.addFirst("SslHandler", (ChannelHandler)this.sslHandler(true));
        }
        TcpClientHandler handler = new TcpClientHandler(this, remoteAddress$1, (LoggingAdapter)this.log);
        pipeline.addLast("clienthandler", (ChannelHandler)handler);
    }

    private static final /* synthetic */ Bootstrap outboundBootstrap$$anonfun$1(Bootstrap bootstrap$5, int sz) {
        return (Bootstrap)bootstrap$5.option(ChannelOption.SO_RCVBUF, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    private static final /* synthetic */ Bootstrap outboundBootstrap$$anonfun$2(Bootstrap bootstrap$6, int sz) {
        return (Bootstrap)bootstrap$6.option(ChannelOption.SO_SNDBUF, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    private static final /* synthetic */ Bootstrap outboundBootstrap$$anonfun$4(Bootstrap bootstrap$7, int sz) {
        return (Bootstrap)bootstrap$7.option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    private static final /* synthetic */ Bootstrap outboundBootstrap$$anonfun$6(Bootstrap bootstrap$8, int sz) {
        return (Bootstrap)bootstrap$8.option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    private static final InetSocketAddress addressToSocketAddress$$anonfun$1$$anonfun$1(String host$2, int port$2) {
        return new InetSocketAddress(InetAddress.getByName(host$2), port$2);
    }

    private static final InetSocketAddress addressToSocketAddress$$anonfun$1(String host$1, int port$1) {
        return (InetSocketAddress)scala.concurrent.package$.MODULE$.blocking(() -> NettyTransport.addressToSocketAddress$$anonfun$1$$anonfun$1(host$1, port$1));
    }

    private final Tuple2 listen$$anonfun$1(int bindPort$1) {
        Tuple2 tuple2;
        try {
            Address address;
            Channel newServerChannel = this.inboundBootstrap.bind(this.settings().BindHostname(), bindPort$1).sync().channel();
            newServerChannel.config().setAutoRead(false);
            this.channelGroup().add(newServerChannel);
            this.serverChannel = newServerChannel;
            None$ port = this.settings().PortSelector() == 0 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.settings().PortSelector()));
            Option<Address> option = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.localAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)Some$.MODULE$.apply((Object)this.settings().Hostname()), (Option<Object>)port);
            if (option instanceof Some) {
                Address address2;
                address = (Address)((Some)option).value();
                Option<Address> option2 = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.localAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                if (!(option2 instanceof Some)) {
                    if (None$.MODULE$.equals(option2)) {
                        throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.localAddress().getClass().getName()).append("]").toString());
                    }
                    throw new MatchError(option2);
                }
                this.boundTo = address2 = (Address)((Some)option2).value();
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.localAddress().getClass().getName()).append("]").toString());
                }
                throw new MatchError(option);
            }
            this.associationListenerPromise.future().foreach((Function1 & Serializable)_$8 -> newServerChannel.config().setAutoRead(true), this.executionContext());
            tuple2 = Tuple2$.MODULE$.apply((Object)address, this.associationListenerPromise);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.log.error("failed to bind to host:{} port:{}, shutting down Netty transport", (Object)this.settings().BindHostname(), (Object)BoxesRunTime.boxToInteger((int)bindPort$1));
                try {
                    boxedUnit = this.shutdown();
                }
                catch (Throwable throwable4) {
                    Option option3;
                    Throwable throwable5 = throwable4;
                    if (throwable5 == null || (option3 = NonFatal$.MODULE$.unapply(throwable5)).isEmpty()) {
                        throw throwable4;
                    }
                    Throwable throwable6 = (Throwable)option3.get();
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw e;
            }
            throw throwable;
        }
        return tuple2;
    }

    private final Tuple2 associate$$anonfun$1(Address remoteAddress$2) {
        return this.extractHostAndPort(remoteAddress$2);
    }

    private final Future always$1(ChannelGroupFuture c) {
        return NettyFutureBridge$.MODULE$.apply(c).map((Function1 & Serializable)_$9 -> true, this.executionContext()).recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return BoxesRunTime.boxToBoolean((boolean)false);
            }
        }, this.executionContext());
    }

    private final /* synthetic */ boolean shutdown$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(boolean lastWriteStatus$2, boolean unbindStatus$2, boolean disconnectStatus$1, boolean closeStatus) {
        this.clientEventLoopGroup.shutdownGracefully();
        this.serverEventLoopParentGroup.shutdownGracefully();
        this.serverEventLoopChildGroup.shutdownGracefully();
        return lastWriteStatus$2 && unbindStatus$2 && disconnectStatus$1 && closeStatus;
    }

    private final /* synthetic */ Future shutdown$$anonfun$1$$anonfun$1$$anonfun$1(boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus) {
        return this.always$1(this.channelGroup().close()).map((Function1 & Serializable)closeStatus -> this.shutdown$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(lastWriteStatus$1, unbindStatus$1, disconnectStatus, BoxesRunTime.unboxToBoolean((Object)closeStatus)), this.executionContext());
    }

    private final /* synthetic */ Future shutdown$$anonfun$1$$anonfun$1(boolean unbindStatus$3, boolean lastWriteStatus) {
        return this.always$1(this.channelGroup().disconnect()).flatMap((Function1 & Serializable)disconnectStatus -> this.shutdown$$anonfun$1$$anonfun$1$$anonfun$1(lastWriteStatus, unbindStatus$3, BoxesRunTime.unboxToBoolean((Object)disconnectStatus)), this.executionContext());
    }

    private final /* synthetic */ Future shutdown$$anonfun$1(boolean unbindStatus) {
        return this.always$1(this.channelGroup().writeAndFlush((Object)Unpooled.EMPTY_BUFFER)).flatMap((Function1 & Serializable)lastWriteStatus -> this.shutdown$$anonfun$1$$anonfun$1(unbindStatus, BoxesRunTime.unboxToBoolean((Object)lastWriteStatus)), this.executionContext());
    }
}

