/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import org.apache.pekko.actor.Address;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.AssociationHandle$Disassociated$;
import org.apache.pekko.remote.transport.AssociationHandle$InboundPayload$;
import org.apache.pekko.remote.transport.AssociationHandle$Unknown$;
import org.apache.pekko.remote.transport.netty.CommonHandlers;
import org.apache.pekko.remote.transport.netty.TcpAssociationHandle;
import org.apache.pekko.remote.transport.netty.TcpHandlers$;
import org.apache.pekko.util.ByteString$;

public interface TcpHandlers
extends CommonHandlers {
    public LoggingAdapter log();

    public static void registerListener$(TcpHandlers $this, Channel channel, AssociationHandle.HandleEventListener listener, InetSocketAddress remoteSocketAddress) {
        $this.registerListener(channel, listener, remoteSocketAddress);
    }

    @Override
    default public void registerListener(Channel channel, AssociationHandle.HandleEventListener listener, InetSocketAddress remoteSocketAddress) {
        channel.attr(TcpHandlers$.org$apache$pekko$remote$transport$netty$TcpHandlers$$$LISTENER).set((Object)listener);
    }

    public static AssociationHandle createHandle$(TcpHandlers $this, Channel channel, Address localAddress, Address remoteAddress) {
        return $this.createHandle(channel, localAddress, remoteAddress);
    }

    @Override
    default public AssociationHandle createHandle(Channel channel, Address localAddress, Address remoteAddress) {
        return new TcpAssociationHandle(localAddress, remoteAddress, this.transport(), channel);
    }

    public static void onDisconnect$(TcpHandlers $this, ChannelHandlerContext ctx) {
        $this.onDisconnect(ctx);
    }

    @Override
    default public void onDisconnect(ChannelHandlerContext ctx) {
        this.notifyListener(ctx.channel(), AssociationHandle$Disassociated$.MODULE$.apply(AssociationHandle$Unknown$.MODULE$));
        this.log().debug("Remote connection to [{}] was disconnected.", (Object)ctx.channel().remoteAddress());
    }

    public static void onMessage$(TcpHandlers $this, ChannelHandlerContext ctx, ByteBuf msg) {
        $this.onMessage(ctx, msg);
    }

    @Override
    default public void onMessage(ChannelHandlerContext ctx, ByteBuf msg) {
        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)msg);
        if (bytes.length > 0) {
            this.notifyListener(ctx.channel(), AssociationHandle$InboundPayload$.MODULE$.apply(ByteString$.MODULE$.apply(bytes)));
            return;
        }
    }

    public static void onException$(TcpHandlers $this, ChannelHandlerContext ctx, Throwable e) {
        $this.onException(ctx, e);
    }

    @Override
    default public void onException(ChannelHandlerContext ctx, Throwable e) {
        this.notifyListener(ctx.channel(), AssociationHandle$Disassociated$.MODULE$.apply(AssociationHandle$Unknown$.MODULE$));
        this.log().warning("Remote connection to [{}] failed with {}", (Object)ctx.channel().remoteAddress(), (Object)e.getCause());
        ctx.channel().close();
    }

    private void notifyListener(Channel channel, AssociationHandle.HandleEvent event) {
        AssociationHandle.HandleEventListener listener = (AssociationHandle.HandleEventListener)channel.attr(TcpHandlers$.org$apache$pekko$remote$transport$netty$TcpHandlers$$$LISTENER).get();
        if (listener != null) {
            listener.notify(event);
            return;
        }
    }
}

