/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.AssociationErrorEvent$;
import org.apache.pekko.remote.AssociationEvent;
import org.apache.pekko.remote.DisassociatedEvent$;
import org.apache.pekko.remote.EventPublisher;
import org.apache.pekko.remote.RemoteSettings;
import org.apache.pekko.remote.transport.PekkoPduCodec;
import org.apache.pekko.remote.transport.Transport;
import scala.Option;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

public abstract class EndpointActor
implements Actor,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private final Address localAddress;
    private final Address remoteAddress;
    private final Transport transport;
    private final RemoteSettings settings;
    private final PekkoPduCodec codec;
    private final EventPublisher eventPublisher;

    public EndpointActor(Address localAddress, Address remoteAddress, Transport transport, RemoteSettings settings, PekkoPduCodec codec) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.transport = transport;
        this.settings = settings;
        this.codec = codec;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.eventPublisher = new EventPublisher(this.context().system(), this.log(), settings.RemoteLifecycleEventsLogLevel());
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public Address localAddress() {
        return this.localAddress;
    }

    public Address remoteAddress() {
        return this.remoteAddress;
    }

    public Transport transport() {
        return this.transport;
    }

    public RemoteSettings settings() {
        return this.settings;
    }

    public PekkoPduCodec codec() {
        return this.codec;
    }

    public abstract boolean inbound();

    public EventPublisher eventPublisher() {
        return this.eventPublisher;
    }

    public void publishError(Throwable reason, int logLevel) {
        this.tryPublish(AssociationErrorEvent$.MODULE$.apply(reason, this.localAddress(), this.remoteAddress(), this.inbound(), logLevel));
    }

    public void publishDisassociated() {
        this.tryPublish(DisassociatedEvent$.MODULE$.apply(this.localAddress(), this.remoteAddress(), this.inbound()));
    }

    private void tryPublish(AssociationEvent ev) {
        try {
            this.eventPublisher().notifyListeners(ev);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.log().error(e, "Unable to publish error event to EventStream.");
            }
            throw throwable;
        }
    }
}

