/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorInitializationException;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.OneForOneStrategy$;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.compat.Future$;
import org.apache.pekko.dispatch.RequiresMessageQueue;
import org.apache.pekko.dispatch.UnboundedMessageQueueSemantics;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.AckedReceiveBuffer;
import org.apache.pekko.remote.AddressUrlEncoder$;
import org.apache.pekko.remote.AssociatedEvent$;
import org.apache.pekko.remote.EndpointAssociationException;
import org.apache.pekko.remote.EndpointDisassociatedException;
import org.apache.pekko.remote.EndpointManager$;
import org.apache.pekko.remote.EndpointManager$Gated$;
import org.apache.pekko.remote.EndpointManager$Link$;
import org.apache.pekko.remote.EndpointManager$Listen$;
import org.apache.pekko.remote.EndpointManager$ListensFailure$;
import org.apache.pekko.remote.EndpointManager$ListensResult$;
import org.apache.pekko.remote.EndpointManager$ManagementCommand$;
import org.apache.pekko.remote.EndpointManager$ManagementCommandAck$;
import org.apache.pekko.remote.EndpointManager$Pass$;
import org.apache.pekko.remote.EndpointManager$Prune$;
import org.apache.pekko.remote.EndpointManager$Quarantine$;
import org.apache.pekko.remote.EndpointManager$Quarantined$;
import org.apache.pekko.remote.EndpointManager$ResendState$;
import org.apache.pekko.remote.EndpointManager$Send$;
import org.apache.pekko.remote.EndpointManager$ShutdownAndFlush$;
import org.apache.pekko.remote.EndpointManager$StartupFinished$;
import org.apache.pekko.remote.EndpointWriter;
import org.apache.pekko.remote.EndpointWriter$;
import org.apache.pekko.remote.EndpointWriter$FlushAndStop$;
import org.apache.pekko.remote.EndpointWriter$StopReading$;
import org.apache.pekko.remote.EndpointWriter$StoppedReading$;
import org.apache.pekko.remote.EndpointWriter$TakeOver$;
import org.apache.pekko.remote.EndpointWriter$TookOver$;
import org.apache.pekko.remote.EventPublisher;
import org.apache.pekko.remote.HasSequenceNumber;
import org.apache.pekko.remote.HopelessAssociation;
import org.apache.pekko.remote.HopelessAssociation$;
import org.apache.pekko.remote.InvalidAssociation;
import org.apache.pekko.remote.InvalidAssociation$;
import org.apache.pekko.remote.QuarantinedEvent$;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.ReliableDeliverySupervisor;
import org.apache.pekko.remote.ReliableDeliverySupervisor$;
import org.apache.pekko.remote.ReliableDeliverySupervisor$GotUid$;
import org.apache.pekko.remote.ReliableDeliverySupervisor$Idle$;
import org.apache.pekko.remote.ReliableDeliverySupervisor$IsIdle$;
import org.apache.pekko.remote.ReliableDeliverySupervisor$Ungate$;
import org.apache.pekko.remote.RemoteActorRef;
import org.apache.pekko.remote.RemoteSettings;
import org.apache.pekko.remote.RemoteTransportException;
import org.apache.pekko.remote.SeqNo;
import org.apache.pekko.remote.ShutDownAssociation;
import org.apache.pekko.remote.ShutDownAssociation$;
import org.apache.pekko.remote.ThisActorSystemQuarantinedEvent$;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.AssociationHandle$Quarantined$;
import org.apache.pekko.remote.transport.AssociationHandle$Shutdown$;
import org.apache.pekko.remote.transport.PekkoPduCodec;
import org.apache.pekko.remote.transport.PekkoPduProtobufCodec$;
import org.apache.pekko.remote.transport.PekkoProtocolHandle;
import org.apache.pekko.remote.transport.PekkoProtocolSettings;
import org.apache.pekko.remote.transport.PekkoProtocolTransport;
import org.apache.pekko.remote.transport.Transport;
import org.apache.pekko.remote.transport.Transport$ActorAssociationEventListener$;
import org.apache.pekko.remote.transport.Transport$InboundAssociation$;
import org.apache.pekko.remote.transport.TransportAdapters;
import org.apache.pekko.remote.transport.TransportAdaptersExtension$;
import org.apache.pekko.util.OptionVal;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public class EndpointManager
implements Actor,
RequiresMessageQueue<UnboundedMessageQueueSemantics> {
    private ActorContext context;
    private ActorRef self;
    private final Config conf;
    public final LoggingAdapter org$apache$pekko$remote$EndpointManager$$log;
    private final RemoteSettings settings;
    private final ExtendedActorSystem extendedSystem;
    private final Iterator endpointId;
    private final EventPublisher eventPublisher;
    private final EndpointRegistry endpoints;
    private Map transportMapping;
    private final FiniteDuration pruneInterval;
    private final Cancellable pruneTimerCancellable;
    private Map pendingReadHandoffs;
    private Map stashedInbound;
    private final SupervisorStrategy supervisorStrategy;
    private final ConcurrentHashMap receiveBuffers;
    private final PartialFunction accepting;
    public boolean org$apache$pekko$remote$EndpointManager$$normalShutdown;

    public EndpointManager(Config conf, LoggingAdapter log) {
        this.conf = conf;
        this.org$apache$pekko$remote$EndpointManager$$log = log;
        Actor.$init$((Actor)this);
        this.settings = new RemoteSettings(conf);
        this.extendedSystem = (ExtendedActorSystem)this.context().system();
        this.endpointId = scala.package$.MODULE$.Iterator().from(0);
        this.eventPublisher = new EventPublisher(this.context().system(), log, this.settings().RemoteLifecycleEventsLogLevel());
        this.endpoints = new EndpointRegistry();
        this.transportMapping = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.pruneInterval = this.settings().RetryGateClosedFor().$times(2L).max(new package.DurationInt(package$.MODULE$.DurationInt(1)).second()).min(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        this.pruneTimerCancellable = this.context().system().scheduler().scheduleWithFixedDelay(this.pruneInterval(), this.pruneInterval(), this.self(), (Object)EndpointManager$Prune$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.pendingReadHandoffs = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.stashedInbound = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.supervisorStrategy = OneForOneStrategy$.MODULE$.apply(OneForOneStrategy$.MODULE$.$lessinit$greater$default$1(), OneForOneStrategy$.MODULE$.$lessinit$greater$default$2(), false, (PartialFunction)new Serializable(log, this){
            private final LoggingAdapter log$4;
            private final /* synthetic */ EndpointManager $outer;
            {
                this.log$4 = log$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option option;
                ActorInitializationException e;
                Throwable throwable = x;
                if (throwable instanceof InvalidAssociation) {
                    InvalidAssociation invalidAssociation = InvalidAssociation$.MODULE$.unapply((InvalidAssociation)((Object)throwable));
                    Address address = invalidAssociation._1();
                    Address address2 = invalidAssociation._2();
                    Throwable throwable2 = invalidAssociation._3();
                    Option<AssociationHandle.DisassociateInfo> option2 = invalidAssociation._4();
                    Address localAddress = address;
                    Address remoteAddress = address2;
                    Throwable reason = throwable2;
                    Option<AssociationHandle.DisassociateInfo> disassociationInfo = option2;
                    return true;
                }
                if (throwable instanceof ShutDownAssociation) {
                    ShutDownAssociation shutDownAssociation = ShutDownAssociation$.MODULE$.unapply((ShutDownAssociation)((Object)throwable));
                    Address address = shutDownAssociation._1();
                    Address address3 = shutDownAssociation._2();
                    Throwable throwable3 = shutDownAssociation._3();
                    Address remoteAddress = address3;
                    return true;
                }
                if (throwable instanceof HopelessAssociation) {
                    HopelessAssociation e2 = (HopelessAssociation)((Object)throwable);
                    return true;
                }
                if (throwable instanceof ActorInitializationException && (e = (ActorInitializationException)throwable).getCause() instanceof HopelessAssociation) {
                    return true;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable4;
                    Throwable e3 = throwable4 = (Throwable)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option option;
                ActorInitializationException e;
                Throwable throwable = x;
                if (throwable instanceof InvalidAssociation) {
                    InvalidAssociation invalidAssociation = InvalidAssociation$.MODULE$.unapply((InvalidAssociation)((Object)throwable));
                    Address address = invalidAssociation._1();
                    Address address2 = invalidAssociation._2();
                    Throwable throwable2 = invalidAssociation._3();
                    Option<AssociationHandle.DisassociateInfo> option2 = invalidAssociation._4();
                    Address localAddress = address;
                    Address remoteAddress = address2;
                    Throwable reason = throwable2;
                    Option<AssociationHandle.DisassociateInfo> disassociationInfo = option2;
                    this.$outer.keepQuarantinedOr(remoteAddress, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                        this.applyOrElse$$anonfun$1(reason, remoteAddress);
                        return BoxedUnit.UNIT;
                    });
                    disassociationInfo.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                        AssociationHandle.DisassociateInfo disassociateInfo = x$1;
                        if (AssociationHandle$Quarantined$.MODULE$.equals(disassociateInfo)) {
                            this.$outer.context().system().eventStream().publish((Object)ThisActorSystemQuarantinedEvent$.MODULE$.apply(localAddress, remoteAddress));
                            return;
                        }
                    });
                    return SupervisorStrategy.Stop$.MODULE$;
                }
                if (throwable instanceof ShutDownAssociation) {
                    ShutDownAssociation shutDownAssociation = ShutDownAssociation$.MODULE$.unapply((ShutDownAssociation)((Object)throwable));
                    Address address = shutDownAssociation._1();
                    Address address3 = shutDownAssociation._2();
                    Throwable throwable3 = shutDownAssociation._3();
                    Address remoteAddress = address3;
                    this.$outer.keepQuarantinedOr(remoteAddress, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                        this.applyOrElse$$anonfun$3(remoteAddress);
                        return BoxedUnit.UNIT;
                    });
                    return SupervisorStrategy.Stop$.MODULE$;
                }
                if (throwable instanceof HopelessAssociation) {
                    HopelessAssociation e2 = (HopelessAssociation)((Object)throwable);
                    return this.$outer.org$apache$pekko$remote$EndpointManager$$_$hopeless$1(this.log$4, e2);
                }
                if (throwable instanceof ActorInitializationException && (e = (ActorInitializationException)throwable).getCause() instanceof HopelessAssociation) {
                    return this.$outer.org$apache$pekko$remote$EndpointManager$$_$hopeless$1(this.log$4, (HopelessAssociation)((Object)e.getCause()));
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable4 = (Throwable)option.get();
                    Throwable e3 = throwable4;
                    Throwable throwable5 = e3;
                    if (!(throwable5 instanceof EndpointDisassociatedException) && !(throwable5 instanceof EndpointAssociationException)) {
                        this.$outer.org$apache$pekko$remote$EndpointManager$$log.error(e3, e3.getMessage());
                    }
                    this.$outer.endpoints().markAsFailed(this.$outer.sender(), Deadline$.MODULE$.now().$plus(this.$outer.settings().RetryGateClosedFor()));
                    return SupervisorStrategy.Stop$.MODULE$;
                }
                return function1.apply((Object)x);
            }

            private final void applyOrElse$$anonfun$1(Throwable reason$1, Address remoteAddress$2) {
                String causedBy = reason$1.getCause() == null ? "" : new StringBuilder(13).append("Caused by: [").append(reason$1.getCause().getMessage()).append("]").toString();
                this.$outer.org$apache$pekko$remote$EndpointManager$$log.warning("Tried to associate with unreachable remote address [{}]. Address is now gated for {} ms, all messages to this address will be delivered to dead letters. Reason: [{}] {}", (Object)remoteAddress$2, (Object)BoxesRunTime.boxToLong((long)this.$outer.settings().RetryGateClosedFor().toMillis()), (Object)reason$1.getMessage(), (Object)causedBy);
                this.$outer.endpoints().markAsFailed(this.$outer.sender(), Deadline$.MODULE$.now().$plus(this.$outer.settings().RetryGateClosedFor()));
            }

            private final void applyOrElse$$anonfun$3(Address remoteAddress$4) {
                this.$outer.org$apache$pekko$remote$EndpointManager$$log.debug("Remote system with address [{}] has shut down. Address is now gated for {} ms, all messages to this address will be delivered to dead letters.", (Object)remoteAddress$4, (Object)BoxesRunTime.boxToLong((long)this.$outer.settings().RetryGateClosedFor().toMillis()));
                this.$outer.endpoints().markAsFailed(this.$outer.sender(), Deadline$.MODULE$.now().$plus(this.$outer.settings().RetryGateClosedFor()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$adapted$1(java.lang.Throwable org.apache.pekko.actor.Address ), applyOrElse$$anonfun$2(org.apache.pekko.actor.Address org.apache.pekko.actor.Address org.apache.pekko.remote.transport.AssociationHandle$DisassociateInfo ), applyOrElse$$anonfun$adapted$2(org.apache.pekko.actor.Address )}, serializedLambda);
            }
        });
        this.receiveBuffers = new ConcurrentHashMap();
        this.accepting = new Serializable(this){
            private final /* synthetic */ EndpointManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Transport.InboundAssociation inboundAssociation;
                Transport.InboundAssociation inboundAssociation2;
                AssociationHandle associationHandle;
                Object object = x;
                if (object instanceof ManagementCommand) {
                    Object object2;
                    ManagementCommand managementCommand = EndpointManager$ManagementCommand$.MODULE$.unapply((ManagementCommand)object);
                    Object cmd = object2 = managementCommand._1();
                    return true;
                }
                if (object instanceof Quarantine) {
                    Quarantine quarantine = EndpointManager$Quarantine$.MODULE$.unapply((Quarantine)object);
                    Address address = quarantine._1();
                    Option<Object> option = quarantine._2();
                    Address address2 = address;
                    Option<Object> uidToQuarantineOption = option;
                    return true;
                }
                if (object instanceof Send) {
                    Send send = (Send)object;
                    Send send2 = EndpointManager$Send$.MODULE$.unapply(send);
                    Object object3 = send2._1();
                    ActorRef actorRef = send2._2();
                    RemoteActorRef remoteActorRef = send2._3();
                    Option<SeqNo> option = send2._4();
                    RemoteActorRef recipientRef = remoteActorRef;
                    Send s = send;
                    return true;
                }
                if (object instanceof Transport.InboundAssociation && (associationHandle = (inboundAssociation2 = Transport$InboundAssociation$.MODULE$.unapply(inboundAssociation = (Transport.InboundAssociation)object))._1()) instanceof PekkoProtocolHandle) {
                    Transport.InboundAssociation ia = inboundAssociation;
                    return true;
                }
                if (object instanceof EndpointWriter.StoppedReading) {
                    ActorRef actorRef;
                    EndpointWriter.StoppedReading stoppedReading = EndpointWriter$StoppedReading$.MODULE$.unapply((EndpointWriter.StoppedReading)object);
                    ActorRef endpoint = actorRef = stoppedReading._1();
                    return true;
                }
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef endpoint = actorRef = terminated._1();
                    return true;
                }
                if (object instanceof EndpointWriter.TookOver) {
                    EndpointWriter.TookOver tookOver = EndpointWriter$TookOver$.MODULE$.unapply((EndpointWriter.TookOver)object);
                    ActorRef actorRef = tookOver._1();
                    PekkoProtocolHandle pekkoProtocolHandle = tookOver._2();
                    ActorRef endpoint = actorRef;
                    PekkoProtocolHandle handle = pekkoProtocolHandle;
                    return true;
                }
                if (object instanceof ReliableDeliverySupervisor.GotUid) {
                    ReliableDeliverySupervisor.GotUid gotUid = ReliableDeliverySupervisor$GotUid$.MODULE$.unapply((ReliableDeliverySupervisor.GotUid)object);
                    int n = gotUid._1();
                    Address address = gotUid._2();
                    int uid = n;
                    Address remoteAddress = address;
                    return true;
                }
                if (ReliableDeliverySupervisor$Idle$.MODULE$.equals(object)) {
                    return true;
                }
                if (EndpointManager$Prune$.MODULE$.equals(object)) {
                    return true;
                }
                return EndpointManager$ShutdownAndFlush$.MODULE$.equals(object);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(Object x, Function1 function1) {
                Transport.InboundAssociation inboundAssociation;
                Transport.InboundAssociation inboundAssociation2;
                AssociationHandle associationHandle;
                Object object;
                block30: {
                    Option<Object> uidToQuarantineOption;
                    Address address;
                    block31: {
                        Option option;
                        block32: {
                            int quarantineUid;
                            EndpointPolicy endpointPolicy;
                            block33: {
                                Option<Object> option2;
                                ActorRef actorRef;
                                block34: {
                                    object = x;
                                    if (object instanceof ManagementCommand) {
                                        Object object2;
                                        ManagementCommand managementCommand = EndpointManager$ManagementCommand$.MODULE$.unapply((ManagementCommand)object);
                                        Object cmd = object2 = managementCommand._1();
                                        Seq allStatuses = (Seq)this.$outer.transportMapping().values().iterator().map(arg_0 -> EndpointManager.org$apache$pekko$remote$EndpointManager$$anon$5$$_$_$$anonfun$5(cmd, arg_0)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$));
                                        org.apache.pekko.pattern.package$.MODULE$.pipe(Future$.MODULE$.fold((scala.collection.immutable.Iterable)allStatuses, (Object)BoxesRunTime.boxToBoolean((boolean)true), EndpointManager::org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$adapted$3, (ExecutionContext)this.$outer.context().dispatcher()).map(EndpointManager::org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$adapted$4, (ExecutionContext)this.$outer.context().dispatcher()), (ExecutionContext)this.$outer.context().dispatcher()).pipeTo(this.$outer.sender(), this.$outer.self());
                                        return BoxedUnit.UNIT;
                                    }
                                    if (!(object instanceof Quarantine)) break block30;
                                    Quarantine quarantine = EndpointManager$Quarantine$.MODULE$.unapply((Quarantine)object);
                                    Address address2 = quarantine._1();
                                    Option<Object> option3 = quarantine._2();
                                    address = address2;
                                    uidToQuarantineOption = option3;
                                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.$outer.endpoints().writableEndpointWithPolicyFor(address), uidToQuarantineOption);
                                    if (tuple2 == null) break block31;
                                    Option option4 = (Option)tuple2._1();
                                    option = (Option)tuple2._2();
                                    if (!(option4 instanceof Some)) break block32;
                                    endpointPolicy = (EndpointPolicy)((Some)option4).value();
                                    if (!(endpointPolicy instanceof Pass)) break block33;
                                    Pass pass = EndpointManager$Pass$.MODULE$.unapply((Pass)endpointPolicy);
                                    actorRef = pass._1();
                                    option2 = pass._2();
                                    ActorRef endpoint = actorRef;
                                    if (!None$.MODULE$.equals(option)) break block34;
                                    this.$outer.context().stop(endpoint);
                                    this.$outer.org$apache$pekko$remote$EndpointManager$$log.warning("Association to [{}] with unknown UID is reported as quarantined, but address cannot be quarantined without knowing the UID, gating instead for {} ms.", (Object)address, (Object)BoxesRunTime.boxToLong((long)this.$outer.settings().RetryGateClosedFor().toMillis()));
                                    this.$outer.endpoints().markAsFailed(endpoint, Deadline$.MODULE$.now().$plus(this.$outer.settings().RetryGateClosedFor()));
                                    break block31;
                                }
                                ActorRef endpoint = actorRef;
                                Option<Object> uidOption = option2;
                                if (!(option instanceof Some)) break block33;
                                int quarantineUid2 = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                                Option<Object> option5 = uidOption;
                                if (option5 instanceof Some && quarantineUid2 == BoxesRunTime.unboxToInt((Object)((Some)option5).value())) {
                                    this.$outer.endpoints().markAsQuarantined(address, quarantineUid2, Deadline$.MODULE$.now().$plus(this.$outer.settings().QuarantineDuration()));
                                    this.$outer.eventPublisher().notifyListeners(QuarantinedEvent$.MODULE$.apply(address, (long)quarantineUid2));
                                    this.$outer.context().stop(endpoint);
                                    break block31;
                                } else if (None$.MODULE$.equals(option5) && !this.$outer.endpoints().refuseUid(address).contains((Object)BoxesRunTime.boxToInteger((int)quarantineUid2))) {
                                    this.$outer.endpoints().registerWritableEndpointRefuseUid(address, quarantineUid2, Deadline$.MODULE$.now().$plus(this.$outer.settings().QuarantineDuration()));
                                }
                                break block31;
                            }
                            if (!(endpointPolicy instanceof Quarantined)) break block32;
                            Quarantined quarantined = EndpointManager$Quarantined$.MODULE$.unapply((Quarantined)endpointPolicy);
                            int n = quarantined._1();
                            Deadline deadline = quarantined._2();
                            int uid = n;
                            if (option instanceof Some && uid == (quarantineUid = BoxesRunTime.unboxToInt((Object)((Some)option).value()))) break block31;
                        }
                        if (option instanceof Some) {
                            int quarantineUid = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                            this.$outer.endpoints().markAsQuarantined(address, quarantineUid, Deadline$.MODULE$.now().$plus(this.$outer.settings().QuarantineDuration()));
                            this.$outer.eventPublisher().notifyListeners(QuarantinedEvent$.MODULE$.apply(address, (long)quarantineUid));
                        }
                    }
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.$outer.endpoints().readOnlyEndpointFor(address), uidToQuarantineOption);
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        Option option = (Option)tuple2._1();
                        Option option6 = (Option)tuple2._2();
                        if (option instanceof Some && (tuple22 = (Tuple2)((Some)option).value()) != null) {
                            ActorRef actorRef;
                            ActorRef endpoint = actorRef = (ActorRef)tuple22._1();
                            if (None$.MODULE$.equals(option6)) {
                                this.$outer.context().stop(endpoint);
                            } else {
                                int quarantineUid;
                                ActorRef endpoint2 = actorRef;
                                int currentUid = BoxesRunTime.unboxToInt((Object)tuple22._2());
                                if (option6 instanceof Some && currentUid == (quarantineUid = BoxesRunTime.unboxToInt((Object)((Some)option6).value()))) {
                                    this.$outer.context().stop(endpoint2);
                                }
                            }
                        }
                    }
                    this.$outer.pendingReadHandoffs_$eq((Map<ActorRef, PekkoProtocolHandle>)((Map)this.$outer.pendingReadHandoffs().filter((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            ActorRef pendingActor = (ActorRef)tuple2._1();
                            PekkoProtocolHandle pendingHandle = (PekkoProtocolHandle)tuple2._2();
                            boolean drop = EndpointManager.org$apache$pekko$remote$EndpointManager$$anon$5$$_$matchesQuarantine$1(address, uidToQuarantineOption, pendingHandle);
                            if (drop) {
                                pendingHandle.disassociate("the pending handle was quarantined", this.$outer.org$apache$pekko$remote$EndpointManager$$log);
                                this.$outer.context().stop(pendingActor);
                            }
                            return !drop;
                        }
                        throw new MatchError((Object)tuple2);
                    })));
                    this.$outer.stashedInbound_$eq((Map<ActorRef, Vector<Transport.InboundAssociation>>)((Map)this.$outer.stashedInbound().map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            ActorRef writer = (ActorRef)tuple2._1();
                            Vector associations = (Vector)tuple2._2();
                            ActorRef actorRef = (ActorRef)Predef$.MODULE$.ArrowAssoc((Object)writer);
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)actorRef, associations.filter((Function1 & Serializable)assoc -> {
                                PekkoProtocolHandle handle = (PekkoProtocolHandle)assoc.association();
                                boolean drop = EndpointManager.org$apache$pekko$remote$EndpointManager$$anon$5$$_$matchesQuarantine$1(address, uidToQuarantineOption, handle);
                                if (drop) {
                                    handle.disassociate("the stashed inbound handle was quarantined", this.$outer.org$apache$pekko$remote$EndpointManager$$log);
                                }
                                return !drop;
                            }));
                        }
                        throw new MatchError((Object)tuple2);
                    })));
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Send) {
                    Send send = (Send)object;
                    Send send2 = EndpointManager$Send$.MODULE$.unapply(send);
                    Object object3 = send2._1();
                    ActorRef actorRef = send2._2();
                    RemoteActorRef remoteActorRef = send2._3();
                    Option<SeqNo> option = send2._4();
                    RemoteActorRef recipientRef = remoteActorRef;
                    Send s = send;
                    Address recipientAddress = recipientRef.path().address();
                    Option<EndpointPolicy> option7 = this.$outer.endpoints().writableEndpointWithPolicyFor(recipientAddress);
                    if (option7 instanceof Some) {
                        EndpointPolicy endpointPolicy = (EndpointPolicy)((Some)option7).value();
                        if (endpointPolicy instanceof Pass) {
                            Pass pass = EndpointManager$Pass$.MODULE$.unapply((Pass)endpointPolicy);
                            ActorRef actorRef2 = pass._1();
                            Option<Object> option8 = pass._2();
                            ActorRef endpoint = actorRef2;
                            endpoint.$bang((Object)s, this.$outer.self());
                            return BoxedUnit.UNIT;
                        }
                        if (endpointPolicy instanceof Gated) {
                            Gated gated = EndpointManager$Gated$.MODULE$.unapply((Gated)endpointPolicy);
                            Deadline deadline = gated._1();
                            Deadline timeOfRelease = deadline;
                            if (timeOfRelease.isOverdue()) {
                                this.createAndRegisterWritingEndpoint$1(recipientAddress, recipientRef).$bang((Object)s, this.$outer.self());
                                return BoxedUnit.UNIT;
                            }
                            this.$outer.extendedSystem().deadLetters().$bang((Object)s, this.$outer.self());
                            return BoxedUnit.UNIT;
                        }
                        if (endpointPolicy instanceof Quarantined) {
                            Quarantined quarantined = EndpointManager$Quarantined$.MODULE$.unapply((Quarantined)endpointPolicy);
                            int n = quarantined._1();
                            Deadline deadline = quarantined._2();
                            this.createAndRegisterWritingEndpoint$1(recipientAddress, recipientRef).$bang((Object)s, this.$outer.self());
                            return BoxedUnit.UNIT;
                        }
                    }
                    if (!None$.MODULE$.equals(option7)) throw new MatchError(option7);
                    this.createAndRegisterWritingEndpoint$1(recipientAddress, recipientRef).$bang((Object)s, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Transport.InboundAssociation && (associationHandle = (inboundAssociation2 = Transport$InboundAssociation$.MODULE$.unapply(inboundAssociation = (Transport.InboundAssociation)object))._1()) instanceof PekkoProtocolHandle) {
                    Transport.InboundAssociation ia = inboundAssociation;
                    this.$outer.handleInboundAssociation(ia, false);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof EndpointWriter.StoppedReading) {
                    ActorRef actorRef;
                    EndpointWriter.StoppedReading stoppedReading = EndpointWriter$StoppedReading$.MODULE$.unapply((EndpointWriter.StoppedReading)object);
                    ActorRef endpoint = actorRef = stoppedReading._1();
                    this.$outer.org$apache$pekko$remote$EndpointManager$$acceptPendingReader(endpoint);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef endpoint = actorRef = terminated._1();
                    this.$outer.org$apache$pekko$remote$EndpointManager$$acceptPendingReader(endpoint);
                    this.$outer.endpoints().unregisterEndpoint(endpoint);
                    this.$outer.handleStashedInbound(endpoint, false);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof EndpointWriter.TookOver) {
                    EndpointWriter.TookOver tookOver = EndpointWriter$TookOver$.MODULE$.unapply((EndpointWriter.TookOver)object);
                    ActorRef actorRef = tookOver._1();
                    PekkoProtocolHandle pekkoProtocolHandle = tookOver._2();
                    ActorRef endpoint = actorRef;
                    PekkoProtocolHandle handle = pekkoProtocolHandle;
                    this.$outer.org$apache$pekko$remote$EndpointManager$$removePendingReader(endpoint, handle);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ReliableDeliverySupervisor.GotUid) {
                    ReliableDeliverySupervisor.GotUid gotUid = ReliableDeliverySupervisor$GotUid$.MODULE$.unapply((ReliableDeliverySupervisor.GotUid)object);
                    int n = gotUid._1();
                    Address address = gotUid._2();
                    int uid = n;
                    Address remoteAddress = address;
                    Option<Object> refuseUidOption = this.$outer.endpoints().refuseUid(remoteAddress);
                    Option<EndpointPolicy> option = this.$outer.endpoints().writableEndpointWithPolicyFor(remoteAddress);
                    if (!(option instanceof Some)) return BoxedUnit.UNIT;
                    EndpointPolicy endpointPolicy = (EndpointPolicy)((Some)option).value();
                    if (!(endpointPolicy instanceof Pass)) return BoxedUnit.UNIT;
                    Pass pass = EndpointManager$Pass$.MODULE$.unapply((Pass)endpointPolicy);
                    ActorRef actorRef = pass._1();
                    Option<Object> option9 = pass._2();
                    ActorRef endpoint = actorRef;
                    if (refuseUidOption.contains((Object)BoxesRunTime.boxToInteger((int)uid))) {
                        this.$outer.endpoints().markAsQuarantined(remoteAddress, uid, Deadline$.MODULE$.now().$plus(this.$outer.settings().QuarantineDuration()));
                        this.$outer.eventPublisher().notifyListeners(QuarantinedEvent$.MODULE$.apply(remoteAddress, (long)uid));
                        this.$outer.context().stop(endpoint);
                    } else {
                        this.$outer.endpoints().registerWritableEndpointUid(remoteAddress, uid);
                    }
                    this.$outer.handleStashedInbound(this.$outer.sender(), false);
                    return BoxedUnit.UNIT;
                }
                if (ReliableDeliverySupervisor$Idle$.MODULE$.equals(object)) {
                    this.$outer.handleStashedInbound(this.$outer.sender(), true);
                    return BoxedUnit.UNIT;
                }
                if (EndpointManager$Prune$.MODULE$.equals(object)) {
                    this.$outer.endpoints().prune();
                    return BoxedUnit.UNIT;
                }
                if (!EndpointManager$ShutdownAndFlush$.MODULE$.equals(object)) return function1.apply(x);
                org.apache.pekko.pattern.package$.MODULE$.pipe(this.shutdownAll$1((IterableOnce)this.$outer.endpoints().allEndpoints(), (Function1 & Serializable)_$13 -> org.apache.pekko.pattern.package$.MODULE$.gracefulStop(_$13, this.$outer.settings().FlushWait(), (Object)EndpointWriter$FlushAndStop$.MODULE$)).flatMap((Function1 & Serializable)flushStatus -> this.applyOrElse$$anonfun$9(BoxesRunTime.unboxToBoolean((Object)flushStatus)), (ExecutionContext)this.$outer.context().dispatcher()), (ExecutionContext)this.$outer.context().dispatcher()).pipeTo(this.$outer.sender(), this.$outer.self());
                this.$outer.pendingReadHandoffs().valuesIterator().foreach((Function1)((JProcedure1 & Serializable)EndpointManager::org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$10));
                this.$outer.org$apache$pekko$remote$EndpointManager$$normalShutdown = true;
                this.$outer.context().become(this.$outer.flushing());
                return BoxedUnit.UNIT;
            }

            private final ActorRef createAndRegisterWritingEndpoint$1(Address recipientAddress$1, RemoteActorRef recipientRef$1) {
                return this.$outer.endpoints().registerWritableEndpoint(recipientAddress$1, (Option<Object>)None$.MODULE$, this.$outer.org$apache$pekko$remote$EndpointManager$$createEndpoint(recipientAddress$1, recipientRef$1.localAddressToUse(), (PekkoProtocolTransport)this.$outer.transportMapping().apply((Object)recipientRef$1.localAddressToUse()), this.$outer.settings(), (Option<PekkoProtocolHandle>)None$.MODULE$, true));
            }

            private final Future shutdownAll$1(IterableOnce resources, Function1 shutdown) {
                IterableOnce iterableOnce = IterableOnce$.MODULE$.iterableOnceExtensionMethods(resources);
                return scala.concurrent.Future$.MODULE$.sequence((IterableOnce)IterableOnceExtensionMethods$.MODULE$.toList$extension(iterableOnce).map(shutdown), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.$outer.context().dispatcher()).map(EndpointManager::org$apache$pekko$remote$EndpointManager$$anon$5$$_$shutdownAll$1$$anonfun$1, (ExecutionContext)this.$outer.context().dispatcher()).recover((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Throwable x) {
                        Option option;
                        Throwable throwable = x;
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable throwable2 = (Throwable)option.get();
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Option option;
                        Throwable throwable = x;
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable throwable2 = (Throwable)option.get();
                            return BoxesRunTime.boxToBoolean((boolean)false);
                        }
                        return function1.apply((Object)x);
                    }
                }, (ExecutionContext)this.$outer.context().dispatcher());
            }

            private final /* synthetic */ Future applyOrElse$$anonfun$9(boolean flushStatus) {
                return this.shutdownAll$1((IterableOnce)this.$outer.transportMapping().values(), EndpointManager::org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$9$$anonfun$1).map(arg_0 -> EndpointManager.org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$9$$anonfun$adapted$1(flushStatus, arg_0), (ExecutionContext)this.$outer.context().dispatcher());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$remote$EndpointManager$$anon$5$$_$_$$anonfun$5(java.lang.Object org.apache.pekko.remote.transport.PekkoProtocolTransport ), org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$adapted$3(java.lang.Object java.lang.Object ), org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$adapted$4(java.lang.Object ), applyOrElse$$anonfun$6(org.apache.pekko.actor.Address scala.Option scala.Tuple2 ), applyOrElse$$anonfun$7(org.apache.pekko.actor.Address scala.Option scala.Tuple2 ), applyOrElse$$anonfun$8(org.apache.pekko.actor.ActorRef ), applyOrElse$$anonfun$adapted$5(java.lang.Object ), org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$10(org.apache.pekko.remote.transport.PekkoProtocolHandle ), applyOrElse$$anonfun$7$$anonfun$1(org.apache.pekko.actor.Address scala.Option org.apache.pekko.remote.transport.Transport$InboundAssociation ), org$apache$pekko$remote$EndpointManager$$anon$5$$_$shutdownAll$1$$anonfun$1(scala.collection.immutable.List ), org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$9$$anonfun$1(org.apache.pekko.remote.transport.PekkoProtocolTransport ), org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$9$$anonfun$adapted$1(boolean java.lang.Object )}, serializedLambda);
            }
        };
        this.org$apache$pekko$remote$EndpointManager$$normalShutdown = false;
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public RemoteSettings settings() {
        return this.settings;
    }

    public ExtendedActorSystem extendedSystem() {
        return this.extendedSystem;
    }

    public Iterator<Object> endpointId() {
        return this.endpointId;
    }

    public EventPublisher eventPublisher() {
        return this.eventPublisher;
    }

    public EndpointRegistry endpoints() {
        return this.endpoints;
    }

    public Map<Address, PekkoProtocolTransport> transportMapping() {
        return this.transportMapping;
    }

    public void transportMapping_$eq(Map<Address, PekkoProtocolTransport> x$1) {
        this.transportMapping = x$1;
    }

    public FiniteDuration pruneInterval() {
        return this.pruneInterval;
    }

    public Cancellable pruneTimerCancellable() {
        return this.pruneTimerCancellable;
    }

    public Map<ActorRef, PekkoProtocolHandle> pendingReadHandoffs() {
        return this.pendingReadHandoffs;
    }

    public void pendingReadHandoffs_$eq(Map<ActorRef, PekkoProtocolHandle> x$1) {
        this.pendingReadHandoffs = x$1;
    }

    public Map<ActorRef, Vector<Transport.InboundAssociation>> stashedInbound() {
        return this.stashedInbound;
    }

    public void stashedInbound_$eq(Map<ActorRef, Vector<Transport.InboundAssociation>> x$1) {
        this.stashedInbound = x$1;
    }

    public void handleStashedInbound(ActorRef endpoint, boolean writerIsIdle) {
        Vector stashed = (Vector)this.stashedInbound().getOrElse((Object)endpoint, EndpointManager::$anonfun$6);
        this.stashedInbound_$eq((Map<ActorRef, Vector<Transport.InboundAssociation>>)((Map)this.stashedInbound().$minus((Object)endpoint)));
        stashed.foreach((Function1)(JProcedure1 & Serializable)_$7 -> this.handleInboundAssociation((Transport.InboundAssociation)_$7, writerIsIdle));
    }

    public void keepQuarantinedOr(Address remoteAddress, Function0<BoxedUnit> body) {
        Option<Object> option = this.endpoints().refuseUid(remoteAddress);
        if (option instanceof Some) {
            int uid = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            this.org$apache$pekko$remote$EndpointManager$$log.info("Quarantined address [{}] is still unreachable or has not been restarted. Keeping it quarantined.", (Object)remoteAddress);
            this.endpoints().markAsQuarantined(remoteAddress, uid, Deadline$.MODULE$.now().$plus(this.settings().QuarantineDuration()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            body.apply$mcV$sp();
            return;
        }
        throw new MatchError(option);
    }

    public SupervisorStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    public ConcurrentHashMap<Link, ResendState> receiveBuffers() {
        return this.receiveBuffers;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ EndpointManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Listen) {
                    Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise;
                    Listen listen = EndpointManager$Listen$.MODULE$.unapply((Listen)object);
                    Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise = promise = listen._1();
                    return true;
                }
                if (object instanceof ListensResult) {
                    ListensResult listensResult = EndpointManager$ListensResult$.MODULE$.unapply((ListensResult)object);
                    Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise = listensResult._1();
                    Seq<Tuple3<PekkoProtocolTransport, Address, Promise<Transport.AssociationEventListener>>> seq = listensResult._2();
                    Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise = promise;
                    Seq<Tuple3<PekkoProtocolTransport, Address, Promise<Transport.AssociationEventListener>>> results = seq;
                    return true;
                }
                if (object instanceof ListensFailure) {
                    ListensFailure listensFailure = EndpointManager$ListensFailure$.MODULE$.unapply((ListensFailure)object);
                    Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise = listensFailure._1();
                    Throwable throwable = listensFailure._2();
                    Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise = promise;
                    Throwable cause = throwable;
                    return true;
                }
                if (object instanceof Transport.InboundAssociation) {
                    Transport.InboundAssociation ia = (Transport.InboundAssociation)object;
                    return true;
                }
                if (object instanceof ManagementCommand) {
                    ManagementCommand managementCommand = EndpointManager$ManagementCommand$.MODULE$.unapply((ManagementCommand)object);
                    Object object2 = managementCommand._1();
                    return true;
                }
                if (EndpointManager$StartupFinished$.MODULE$.equals(object)) {
                    return true;
                }
                return EndpointManager$ShutdownAndFlush$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Listen) {
                    Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise;
                    Listen listen = EndpointManager$Listen$.MODULE$.unapply((Listen)object);
                    Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise = promise = listen._1();
                    org.apache.pekko.pattern.package$.MODULE$.pipe(this.$outer.org$apache$pekko$remote$EndpointManager$$listens().map(arg_0 -> EndpointManager.org$apache$pekko$remote$EndpointManager$$anon$7$$_$applyOrElse$$anonfun$11(addressesPromise, arg_0), (ExecutionContext)this.$outer.context().dispatcher()).recover((PartialFunction)new Serializable(addressesPromise){
                        private final Promise addressesPromise$2;
                        {
                            this.addressesPromise$2 = addressesPromise$3;
                        }

                        public final boolean isDefinedAt(Throwable x) {
                            Option option;
                            Throwable throwable = x;
                            if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                                Throwable throwable2;
                                Throwable e = throwable2 = (Throwable)option.get();
                                return true;
                            }
                            return false;
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Option option;
                            Throwable throwable = x;
                            if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                                Throwable throwable2;
                                Throwable e = throwable2 = (Throwable)option.get();
                                return EndpointManager$ListensFailure$.MODULE$.apply((Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>>)this.addressesPromise$2, e);
                            }
                            return function1.apply((Object)x);
                        }
                    }, (ExecutionContext)this.$outer.context().dispatcher()), (ExecutionContext)this.$outer.context().dispatcher()).pipeTo(this.$outer.self(), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ListensResult) {
                    ListensResult listensResult = EndpointManager$ListensResult$.MODULE$.unapply((ListensResult)object);
                    Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise = listensResult._1();
                    Seq<Tuple3<PekkoProtocolTransport, Address, Promise<Transport.AssociationEventListener>>> seq = listensResult._2();
                    Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise = promise;
                    Seq<Tuple3<PekkoProtocolTransport, Address, Promise<Transport.AssociationEventListener>>> results = seq;
                    this.$outer.transportMapping_$eq((Map<Address, PekkoProtocolTransport>)((Map)results.groupBy(EndpointManager::org$apache$pekko$remote$EndpointManager$$anon$7$$_$applyOrElse$$anonfun$12).map(EndpointManager::org$apache$pekko$remote$EndpointManager$$anon$7$$_$applyOrElse$$anonfun$13)));
                    Seq transportsAndAddresses = (Seq)results.map((Function1 & Serializable)x$1 -> {
                        Tuple3 tuple3 = x$1;
                        if (tuple3 != null) {
                            PekkoProtocolTransport transport = (PekkoProtocolTransport)tuple3._1();
                            Address address = (Address)tuple3._2();
                            Promise promise = (Promise)tuple3._3();
                            promise.success((Object)Transport$ActorAssociationEventListener$.MODULE$.apply(this.$outer.self()));
                            PekkoProtocolTransport pekkoProtocolTransport = (PekkoProtocolTransport)Predef$.MODULE$.ArrowAssoc((Object)transport);
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)pekkoProtocolTransport, (Object)address);
                        }
                        throw new MatchError((Object)tuple3);
                    });
                    addressesPromise.success((Object)transportsAndAddresses);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ListensFailure) {
                    ListensFailure listensFailure = EndpointManager$ListensFailure$.MODULE$.unapply((ListensFailure)object);
                    Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise = listensFailure._1();
                    Throwable throwable = listensFailure._2();
                    Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise = promise;
                    Throwable cause = throwable;
                    addressesPromise.failure(cause);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Transport.InboundAssociation) {
                    Transport.InboundAssociation ia = (Transport.InboundAssociation)object;
                    this.$outer.context().system().scheduler().scheduleOnce(new package.DurationInt(package$.MODULE$.DurationInt(10)).milliseconds(), this.$outer.self(), (Object)ia, (ExecutionContext)this.$outer.context().dispatcher(), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ManagementCommand) {
                    ManagementCommand managementCommand = EndpointManager$ManagementCommand$.MODULE$.unapply((ManagementCommand)object);
                    Object object2 = managementCommand._1();
                    this.$outer.sender().$bang((Object)EndpointManager$ManagementCommandAck$.MODULE$.apply(false), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (EndpointManager$StartupFinished$.MODULE$.equals(object)) {
                    this.$outer.context().become(this.$outer.accepting());
                    return BoxedUnit.UNIT;
                }
                if (EndpointManager$ShutdownAndFlush$.MODULE$.equals(object)) {
                    this.$outer.sender().$bang((Object)BoxesRunTime.boxToBoolean((boolean)true), this.$outer.self());
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$remote$EndpointManager$$anon$7$$_$applyOrElse$$anonfun$11(scala.concurrent.Promise scala.collection.immutable.Seq ), org$apache$pekko$remote$EndpointManager$$anon$7$$_$applyOrElse$$anonfun$12(scala.Tuple3 ), org$apache$pekko$remote$EndpointManager$$anon$7$$_$applyOrElse$$anonfun$13(scala.Tuple2 ), $anonfun$7(scala.Tuple3 )}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> accepting() {
        return this.accepting;
    }

    public PartialFunction<Object, BoxedUnit> flushing() {
        return new Serializable(this){
            private final /* synthetic */ EndpointManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Transport.InboundAssociation inboundAssociation;
                AssociationHandle associationHandle;
                Object object = x;
                if (object instanceof Send) {
                    Send s = (Send)object;
                    return true;
                }
                if (object instanceof Transport.InboundAssociation && (associationHandle = (inboundAssociation = Transport$InboundAssociation$.MODULE$.unapply((Transport.InboundAssociation)object))._1()) instanceof PekkoProtocolHandle) {
                    PekkoProtocolHandle h = (PekkoProtocolHandle)associationHandle;
                    return true;
                }
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Transport.InboundAssociation inboundAssociation;
                AssociationHandle associationHandle;
                Object object = x;
                if (object instanceof Send) {
                    Send s = (Send)object;
                    this.$outer.extendedSystem().deadLetters().$bang((Object)s, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Transport.InboundAssociation && (associationHandle = (inboundAssociation = Transport$InboundAssociation$.MODULE$.unapply((Transport.InboundAssociation)object))._1()) instanceof PekkoProtocolHandle) {
                    PekkoProtocolHandle h = (PekkoProtocolHandle)associationHandle;
                    h.disassociate(AssociationHandle$Shutdown$.MODULE$);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public void handleInboundAssociation(Transport.InboundAssociation ia, boolean writerIsIdle) {
        Transport.InboundAssociation inboundAssociation;
        AssociationHandle associationHandle;
        Transport.InboundAssociation inboundAssociation2 = ia;
        if (inboundAssociation2 != null && (associationHandle = (inboundAssociation = Transport$InboundAssociation$.MODULE$.unapply(inboundAssociation2))._1()) instanceof PekkoProtocolHandle) {
            Tuple2 tuple2;
            PekkoProtocolHandle handle = (PekkoProtocolHandle)associationHandle;
            Transport.InboundAssociation ia2 = inboundAssociation2;
            Option<Tuple2<ActorRef, Object>> option = this.endpoints().readOnlyEndpointFor(handle.remoteAddress());
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                EndpointPolicy endpointPolicy;
                ActorRef endpoint = (ActorRef)tuple2._1();
                this.pendingReadHandoffs().get((Object)endpoint).foreach((Function1)(JProcedure1 & Serializable)_$16 -> _$16.disassociate("the existing readOnly association was replaced by a new incoming one", this.org$apache$pekko$remote$EndpointManager$$log));
                ActorRef actorRef = (ActorRef)Predef$.MODULE$.ArrowAssoc((Object)endpoint);
                this.pendingReadHandoffs_$eq((Map<ActorRef, PekkoProtocolHandle>)((Map)this.pendingReadHandoffs().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)actorRef, (Object)handle))));
                endpoint.$bang((Object)EndpointWriter$TakeOver$.MODULE$.apply(handle, this.self()), this.self());
                Option<EndpointPolicy> option2 = this.endpoints().writableEndpointWithPolicyFor(handle.remoteAddress());
                if (option2 instanceof Some && (endpointPolicy = (EndpointPolicy)((Some)option2).value()) instanceof Pass) {
                    Pass pass = EndpointManager$Pass$.MODULE$.unapply((Pass)endpointPolicy);
                    ActorRef actorRef2 = pass._1();
                    Option<Object> option3 = pass._2();
                    ActorRef ep = actorRef2;
                    ep.$bang((Object)ReliableDeliverySupervisor$Ungate$.MODULE$, this.self());
                    return;
                }
                return;
            }
            if (None$.MODULE$.equals(option)) {
                EndpointPolicy endpointPolicy;
                if (this.endpoints().isQuarantined(handle.remoteAddress(), handle.handshakeInfo().uid())) {
                    handle.disassociate(AssociationHandle$Quarantined$.MODULE$);
                    return;
                }
                Option<EndpointPolicy> option4 = this.endpoints().writableEndpointWithPolicyFor(handle.remoteAddress());
                if (option4 instanceof Some && (endpointPolicy = (EndpointPolicy)((Some)option4).value()) instanceof Pass) {
                    Pass pass = EndpointManager$Pass$.MODULE$.unapply((Pass)endpointPolicy);
                    ActorRef actorRef = pass._1();
                    Option<Object> option5 = pass._2();
                    ActorRef ep = actorRef;
                    if (None$.MODULE$.equals(option5)) {
                        if (!writerIsIdle) {
                            ep.$bang((Object)ReliableDeliverySupervisor$IsIdle$.MODULE$, this.self());
                            ActorRef actorRef3 = (ActorRef)Predef$.MODULE$.ArrowAssoc((Object)ep);
                            this.stashedInbound_$eq((Map<ActorRef, Vector<Transport.InboundAssociation>>)((Map)this.stashedInbound().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)actorRef3, ((SeqOps)this.stashedInbound().getOrElse((Object)ep, EndpointManager::handleInboundAssociation$$anonfun$2)).$colon$plus((Object)ia2)))));
                            return;
                        }
                        this.createAndRegisterEndpoint(handle);
                        return;
                    }
                    ActorRef ep2 = actorRef;
                    if (option5 instanceof Some) {
                        int uid = BoxesRunTime.unboxToInt((Object)((Some)option5).value());
                        if (handle.handshakeInfo().uid() == uid) {
                            this.pendingReadHandoffs().get((Object)ep2).foreach((Function1)(JProcedure1 & Serializable)_$17 -> _$17.disassociate("the existing writable association was replaced by a new incoming one", this.org$apache$pekko$remote$EndpointManager$$log));
                            ActorRef actorRef4 = (ActorRef)Predef$.MODULE$.ArrowAssoc((Object)ep2);
                            this.pendingReadHandoffs_$eq((Map<ActorRef, PekkoProtocolHandle>)((Map)this.pendingReadHandoffs().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)actorRef4, (Object)handle))));
                            ep2.$bang((Object)EndpointWriter$StopReading$.MODULE$.apply(ep2, this.self()), this.self());
                            ep2.$bang((Object)ReliableDeliverySupervisor$Ungate$.MODULE$, this.self());
                            return;
                        }
                        this.context().stop(ep2);
                        this.endpoints().unregisterEndpoint(ep2);
                        this.pendingReadHandoffs_$eq((Map<ActorRef, PekkoProtocolHandle>)((Map)this.pendingReadHandoffs().$minus((Object)ep2)));
                        this.endpoints().markAsQuarantined(handle.remoteAddress(), uid, Deadline$.MODULE$.now().$plus(this.settings().QuarantineDuration()));
                        this.createAndRegisterEndpoint(handle);
                        return;
                    }
                }
                this.createAndRegisterEndpoint(handle);
                return;
            }
            throw new MatchError(option);
        }
    }

    private void createAndRegisterEndpoint(PekkoProtocolHandle handle) {
        boolean writing = this.settings().UsePassiveConnections() && !this.endpoints().hasWritableEndpointFor(handle.remoteAddress());
        this.eventPublisher().notifyListeners(AssociatedEvent$.MODULE$.apply(handle.localAddress(), handle.remoteAddress(), true));
        ActorRef endpoint = this.org$apache$pekko$remote$EndpointManager$$createEndpoint(handle.remoteAddress(), handle.localAddress(), (PekkoProtocolTransport)this.transportMapping().apply((Object)handle.localAddress()), this.settings(), (Option<PekkoProtocolHandle>)Some$.MODULE$.apply((Object)handle), writing);
        if (writing) {
            this.endpoints().registerWritableEndpoint(handle.remoteAddress(), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)handle.handshakeInfo().uid())), endpoint);
            return;
        }
        this.endpoints().registerReadOnlyEndpoint(handle.remoteAddress(), endpoint, handle.handshakeInfo().uid());
        if (!this.endpoints().hasWritableEndpointFor(handle.remoteAddress())) {
            this.endpoints().removePolicy(handle.remoteAddress());
            return;
        }
    }

    public Future<Seq<Tuple3<PekkoProtocolTransport, Address, Promise<Transport.AssociationEventListener>>>> org$apache$pekko$remote$EndpointManager$$listens() {
        Seq transports = (Seq)this.settings().Transports().withFilter((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                String fqn = (String)tuple3._1();
                Seq adapters = (Seq)tuple3._2();
                Config config = (Config)tuple3._3();
                return true;
            }
            return false;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                String fqn = (String)tuple3._1();
                Seq adapters = (Seq)tuple3._2();
                Config config = (Config)tuple3._3();
                Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class);
                Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(Config.class);
                Seq args = (Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)this.context().system()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)config), (List)Nil$.MODULE$)));
                Transport driver = (Transport)this.extendedSystem().dynamicAccess().createInstanceFor(fqn, args, ClassTag$.MODULE$.apply(Transport.class)).recover((PartialFunction)new Serializable(fqn){
                    private final String fqn$1;
                    {
                        this.fqn$1 = fqn$2;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable;
                        Throwable exception = throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable;
                        Throwable exception = throwable = x;
                        throw new IllegalArgumentException(new StringBuilder(213).append("Cannot instantiate transport [").append(this.fqn$1).append("]. ").append("Make sure it extends [org.apache.pekko.remote.transport.Transport] and has constructor with ").append("[org.apache.pekko.actor.ExtendedActorSystem] and [com.typesafe.config.Config] parameters").toString(), exception);
                    }
                }).get();
                TransportAdapters transportAdapters = TransportAdaptersExtension$.MODULE$.get(this.context().system());
                Transport wrappedTransport = (Transport)((IterableOnceOps)adapters.map((Function1 & Serializable)name -> transportAdapters.getAdapterProvider((String)name))).foldLeft((Object)driver, (Function2 & Serializable)(t, provider) -> provider.create((Transport)t, (ExtendedActorSystem)this.context().system()));
                return new PekkoProtocolTransport(wrappedTransport, this.context().system(), new PekkoProtocolSettings(this.conf), PekkoPduProtobufCodec$.MODULE$);
            }
            throw new MatchError((Object)tuple3);
        });
        return scala.concurrent.Future$.MODULE$.sequence((IterableOnce)transports.map((Function1 & Serializable)transport -> transport.listen().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Address address = (Address)tuple2._1();
                Promise listenerPromise = (Promise)tuple2._2();
                return Tuple3$.MODULE$.apply(transport, (Object)address, (Object)listenerPromise);
            }
            throw new MatchError((Object)tuple2);
        }, (ExecutionContext)this.context().dispatcher())), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.context().dispatcher());
    }

    public void org$apache$pekko$remote$EndpointManager$$acceptPendingReader(ActorRef takingOverFrom) {
        if (this.pendingReadHandoffs().contains((Object)takingOverFrom)) {
            PekkoProtocolHandle handle = (PekkoProtocolHandle)this.pendingReadHandoffs().apply((Object)takingOverFrom);
            this.pendingReadHandoffs_$eq((Map<ActorRef, PekkoProtocolHandle>)((Map)this.pendingReadHandoffs().$minus((Object)takingOverFrom)));
            this.eventPublisher().notifyListeners(AssociatedEvent$.MODULE$.apply(handle.localAddress(), handle.remoteAddress(), true));
            ActorRef endpoint = this.org$apache$pekko$remote$EndpointManager$$createEndpoint(handle.remoteAddress(), handle.localAddress(), (PekkoProtocolTransport)this.transportMapping().apply((Object)handle.localAddress()), this.settings(), (Option<PekkoProtocolHandle>)Some$.MODULE$.apply((Object)handle), false);
            this.endpoints().registerReadOnlyEndpoint(handle.remoteAddress(), endpoint, handle.handshakeInfo().uid());
            return;
        }
    }

    public void org$apache$pekko$remote$EndpointManager$$removePendingReader(ActorRef takingOverFrom, PekkoProtocolHandle withHandle) {
        if (this.pendingReadHandoffs().get((Object)takingOverFrom).exists((Function1 & Serializable)handle -> {
            PekkoProtocolHandle pekkoProtocolHandle = handle;
            PekkoProtocolHandle pekkoProtocolHandle2 = withHandle;
            return !(pekkoProtocolHandle != null ? !pekkoProtocolHandle.equals(pekkoProtocolHandle2) : pekkoProtocolHandle2 != null);
        })) {
            this.pendingReadHandoffs_$eq((Map<ActorRef, PekkoProtocolHandle>)((Map)this.pendingReadHandoffs().$minus((Object)takingOverFrom)));
            return;
        }
    }

    public ActorRef org$apache$pekko$remote$EndpointManager$$createEndpoint(Address remoteAddress, Address localAddress, PekkoProtocolTransport transport, RemoteSettings endpointSettings, Option<PekkoProtocolHandle> handleOption, boolean writing) {
        Predef$.MODULE$.require(this.transportMapping().contains((Object)localAddress), EndpointManager::createEndpoint$$anonfun$1);
        Option<Object> refuseUid = this.endpoints().refuseUid(remoteAddress);
        if (writing) {
            return this.context().watch(this.context().actorOf(((RARP)RARP$.MODULE$.apply((ActorSystem)this.extendedSystem())).configureDispatcher(ReliableDeliverySupervisor$.MODULE$.props(handleOption, localAddress, remoteAddress, refuseUid, transport, endpointSettings, PekkoPduProtobufCodec$.MODULE$, this.receiveBuffers())).withDeploy(Deploy$.MODULE$.local()), new StringBuilder(24).append("reliableEndpointWriter-").append(AddressUrlEncoder$.MODULE$.apply(remoteAddress)).append("-").append(this.endpointId().next()).toString()));
        }
        return this.context().watch(this.context().actorOf(((RARP)RARP$.MODULE$.apply((ActorSystem)this.extendedSystem())).configureDispatcher(EndpointWriter$.MODULE$.props(handleOption, localAddress, remoteAddress, refuseUid, transport, endpointSettings, PekkoPduProtobufCodec$.MODULE$, this.receiveBuffers(), (Option<ActorRef>)None$.MODULE$)).withDeploy(Deploy$.MODULE$.local()), new StringBuilder(16).append("endpointWriter-").append(AddressUrlEncoder$.MODULE$.apply(remoteAddress)).append("-").append(this.endpointId().next()).toString()));
    }

    public void postStop() {
        this.pruneTimerCancellable().cancel();
        this.pendingReadHandoffs().valuesIterator().foreach((Function1)(JProcedure1 & Serializable)_$18 -> _$18.disassociate(AssociationHandle$Shutdown$.MODULE$));
        if (!this.org$apache$pekko$remote$EndpointManager$$normalShutdown) {
            this.org$apache$pekko$remote$EndpointManager$$log.error("Remoting system has been terminated abrubtly. Attempting to shut down transports");
            this.transportMapping().values().map((Function1 & Serializable)_$19 -> _$19.shutdown());
            return;
        }
    }

    private final void hopeless$1$$anonfun$1(LoggingAdapter log$2, Address remoteAddress$1) {
        log$2.warning("Association to [{}] with unknown UID is irrecoverably failed. Address cannot be quarantined without knowing the UID, gating instead for {} ms.", (Object)remoteAddress$1, (Object)BoxesRunTime.boxToLong((long)this.settings().RetryGateClosedFor().toMillis()));
        this.endpoints().markAsFailed(this.sender(), Deadline$.MODULE$.now().$plus(this.settings().RetryGateClosedFor()));
    }

    public final SupervisorStrategy.Directive org$apache$pekko$remote$EndpointManager$$_$hopeless$1(LoggingAdapter log$1, HopelessAssociation e) {
        HopelessAssociation hopelessAssociation = e;
        if (hopelessAssociation != null) {
            HopelessAssociation hopelessAssociation2 = HopelessAssociation$.MODULE$.unapply(hopelessAssociation);
            Address address = hopelessAssociation2._1();
            Address address2 = hopelessAssociation2._2();
            Option<Object> option = hopelessAssociation2._3();
            Throwable throwable = hopelessAssociation2._4();
            Address remoteAddress = address2;
            if (option instanceof Some) {
                int uid = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                Throwable reason = throwable;
                log$1.error(reason, "Association to [{}] with UID [{}] irrecoverably failed. Quarantining address.", (Object)remoteAddress, (Object)BoxesRunTime.boxToInteger((int)uid));
                FiniteDuration finiteDuration = this.settings().QuarantineDuration();
                if (finiteDuration != null) {
                    FiniteDuration d = finiteDuration;
                    this.endpoints().markAsQuarantined(remoteAddress, uid, Deadline$.MODULE$.now().$plus(d));
                    this.eventPublisher().notifyListeners(QuarantinedEvent$.MODULE$.apply(remoteAddress, (long)uid));
                } else if (finiteDuration != null) {
                    throw new MatchError((Object)finiteDuration);
                }
                return SupervisorStrategy.Stop$.MODULE$;
            }
            Address remoteAddress2 = address2;
            if (None$.MODULE$.equals(option)) {
                this.keepQuarantinedOr(remoteAddress2, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                    this.hopeless$1$$anonfun$1(log$1, remoteAddress2);
                    return BoxedUnit.UNIT;
                });
                return SupervisorStrategy.Stop$.MODULE$;
            }
        }
        throw new MatchError((Object)hopelessAssociation);
    }

    public static final /* synthetic */ Future org$apache$pekko$remote$EndpointManager$$anon$5$$_$_$$anonfun$5(Object cmd$1, PekkoProtocolTransport transport) {
        return transport.managementCommand(cmd$1);
    }

    private static final /* synthetic */ boolean applyOrElse$$anonfun$4(boolean _$9, boolean _$10) {
        return _$9 && _$10;
    }

    public static /* bridge */ /* synthetic */ boolean org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$adapted$3(Object _$9, Object _$10) {
        return EndpointManager.applyOrElse$$anonfun$4(BoxesRunTime.unboxToBoolean((Object)_$9), BoxesRunTime.unboxToBoolean((Object)_$10));
    }

    public static /* bridge */ /* synthetic */ ManagementCommandAck org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$adapted$4(Object status) {
        return EndpointManager$ManagementCommandAck$.MODULE$.apply(BoxesRunTime.unboxToBoolean((Object)status));
    }

    public static final boolean org$apache$pekko$remote$EndpointManager$$anon$5$$_$matchesQuarantine$1(Address address$1, Option uidToQuarantineOption$1, PekkoProtocolHandle handle) {
        Address address = handle.remoteAddress();
        Address address2 = address$1;
        return !(address != null ? !address.equals(address2) : address2 != null) && uidToQuarantineOption$1.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$11 -> _$11 == handle.handshakeInfo().uid());
    }

    private static final /* synthetic */ boolean shutdownAll$1$$anonfun$1$$anonfun$1(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ boolean org$apache$pekko$remote$EndpointManager$$anon$5$$_$shutdownAll$1$$anonfun$1(List _$12) {
        return _$12.forall((Function1 & Serializable)x -> EndpointManager.shutdownAll$1$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)x)));
    }

    public static final /* synthetic */ Future org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$9$$anonfun$1(PekkoProtocolTransport _$14) {
        return _$14.shutdown();
    }

    private static final /* synthetic */ boolean applyOrElse$$anonfun$9$$anonfun$2(boolean flushStatus$1, boolean shutdownStatus) {
        return flushStatus$1 && shutdownStatus;
    }

    public static /* bridge */ /* synthetic */ boolean org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$9$$anonfun$adapted$1(boolean flushStatus$2, Object shutdownStatus) {
        return EndpointManager.applyOrElse$$anonfun$9$$anonfun$2(flushStatus$2, BoxesRunTime.unboxToBoolean((Object)shutdownStatus));
    }

    public static final /* synthetic */ void org$apache$pekko$remote$EndpointManager$$anon$5$$_$applyOrElse$$anonfun$10(PekkoProtocolHandle _$15) {
        _$15.disassociate(AssociationHandle$Shutdown$.MODULE$);
    }

    private static final Vector $anonfun$6() {
        return scala.package$.MODULE$.Vector().empty();
    }

    public static final /* synthetic */ ListensResult org$apache$pekko$remote$EndpointManager$$anon$7$$_$applyOrElse$$anonfun$11(Promise addressesPromise$1, Seq _$8) {
        return EndpointManager$ListensResult$.MODULE$.apply((Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>>)addressesPromise$1, (Seq<Tuple3<PekkoProtocolTransport, Address, Promise<Transport.AssociationEventListener>>>)_$8);
    }

    public static final /* synthetic */ Address org$apache$pekko$remote$EndpointManager$$anon$7$$_$applyOrElse$$anonfun$12(Tuple3 x$1) {
        Tuple3 tuple3 = x$1;
        if (tuple3 != null) {
            Address transportAddress = (Address)tuple3._2();
            return transportAddress;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ Tuple2 org$apache$pekko$remote$EndpointManager$$anon$7$$_$applyOrElse$$anonfun$13(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Address address = (Address)tuple2._1();
            Seq seq = (Seq)tuple2._2();
            Address a = address;
            Seq t = seq;
            if (t.size() > 1) {
                throw new RemoteTransportException(new StringBuilder(64).append("There are more than one transports listening on local address [").append(a).append("]").toString(), null);
            }
            Address a2 = address;
            Seq t2 = seq;
            Address address2 = (Address)Predef$.MODULE$.ArrowAssoc((Object)a2);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)address2, ((Tuple3)t2.head())._1());
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Vector handleInboundAssociation$$anonfun$2() {
        return scala.package$.MODULE$.Vector().empty();
    }

    private static final Object createEndpoint$$anonfun$1() {
        return "Transport mapping is not defined for the address";
    }

    public static interface EndpointPolicy {
        public boolean isTombstone();
    }

    public static class EndpointRegistry {
        private HashMap<Address, Tuple2<Object, Deadline>> addressToRefuseUid = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        private HashMap<Address, EndpointPolicy> addressToWritable = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        private HashMap<ActorRef, Address> writableToAddress = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        private HashMap<Address, Tuple2<ActorRef, Object>> addressToReadonly = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        private HashMap<ActorRef, Address> readonlyToAddress = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));

        public ActorRef registerWritableEndpoint(Address address, Option<Object> uid, ActorRef endpoint) {
            EndpointPolicy endpointPolicy;
            Option option = this.addressToWritable.get((Object)address);
            if (option instanceof Some && (endpointPolicy = (EndpointPolicy)((Some)option).value()) instanceof Pass) {
                Pass pass = EndpointManager$Pass$.MODULE$.unapply((Pass)endpointPolicy);
                ActorRef actorRef = pass._1();
                Option<Object> option2 = pass._2();
                ActorRef e = actorRef;
                throw new IllegalArgumentException(new StringBuilder(52).append("Attempting to overwrite existing endpoint [").append(e).append("] with [").append(endpoint).append("]").toString());
            }
            Address address2 = (Address)Predef$.MODULE$.ArrowAssoc((Object)address);
            this.addressToWritable = (HashMap)this.addressToWritable.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)address2, (Object)EndpointManager$Pass$.MODULE$.apply(endpoint, uid)));
            ActorRef actorRef = (ActorRef)Predef$.MODULE$.ArrowAssoc((Object)endpoint);
            this.writableToAddress = (HashMap)this.writableToAddress.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)actorRef, (Object)address));
            return endpoint;
        }

        public void registerWritableEndpointUid(Address remoteAddress, int uid) {
            EndpointPolicy endpointPolicy;
            Option option = this.addressToWritable.get((Object)remoteAddress);
            if (option instanceof Some && (endpointPolicy = (EndpointPolicy)((Some)option).value()) instanceof Pass) {
                Pass pass = EndpointManager$Pass$.MODULE$.unapply((Pass)endpointPolicy);
                ActorRef actorRef = pass._1();
                Option<Object> option2 = pass._2();
                ActorRef ep = actorRef;
                Address address = (Address)Predef$.MODULE$.ArrowAssoc((Object)remoteAddress);
                this.addressToWritable = (HashMap)this.addressToWritable.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)address, (Object)EndpointManager$Pass$.MODULE$.apply(ep, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)uid)))));
                return;
            }
        }

        public void registerWritableEndpointRefuseUid(Address remoteAddress, int refuseUid, Deadline timeOfRelease) {
            this.addressToRefuseUid = this.addressToRefuseUid.updated((Object)remoteAddress, (Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)refuseUid), (Object)timeOfRelease));
        }

        public ActorRef registerReadOnlyEndpoint(Address address, ActorRef endpoint, int uid) {
            Address address2 = (Address)Predef$.MODULE$.ArrowAssoc((Object)address);
            this.addressToReadonly = (HashMap)this.addressToReadonly.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)address2, (Object)Tuple2$.MODULE$.apply((Object)endpoint, (Object)BoxesRunTime.boxToInteger((int)uid))));
            ActorRef actorRef = (ActorRef)Predef$.MODULE$.ArrowAssoc((Object)endpoint);
            this.readonlyToAddress = (HashMap)this.readonlyToAddress.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)actorRef, (Object)address));
            return endpoint;
        }

        public void unregisterEndpoint(ActorRef endpoint) {
            if (this.isWritable(endpoint)) {
                EndpointPolicy policy;
                Address address = (Address)this.writableToAddress.apply((Object)endpoint);
                Option option = this.addressToWritable.get((Object)address);
                if (!(option instanceof Some) || !(policy = (EndpointPolicy)((Some)option).value()).isTombstone()) {
                    this.addressToWritable = (HashMap)this.addressToWritable.$minus((Object)address);
                }
                this.writableToAddress = (HashMap)this.writableToAddress.$minus((Object)endpoint);
                return;
            }
            if (this.isReadOnly(endpoint)) {
                this.addressToReadonly = (HashMap)this.addressToReadonly.$minus(this.readonlyToAddress.apply((Object)endpoint));
                this.readonlyToAddress = (HashMap)this.readonlyToAddress.$minus((Object)endpoint);
                return;
            }
        }

        public Option<Address> addressForWriter(ActorRef writer) {
            return this.writableToAddress.get((Object)writer);
        }

        public Option<EndpointPolicy> writableEndpointWithPolicyFor(Address address) {
            return this.addressToWritable.get((Object)address);
        }

        public boolean hasWritableEndpointFor(Address address) {
            Option<EndpointPolicy> option = this.writableEndpointWithPolicyFor(address);
            return option instanceof Some && ((Some)option).value() instanceof Pass;
        }

        public Option<Tuple2<ActorRef, Object>> readOnlyEndpointFor(Address address) {
            return this.addressToReadonly.get((Object)address);
        }

        public boolean isWritable(ActorRef endpoint) {
            return this.writableToAddress.contains((Object)endpoint);
        }

        public boolean isReadOnly(ActorRef endpoint) {
            return this.readonlyToAddress.contains((Object)endpoint);
        }

        public boolean isQuarantined(Address address, int uid) {
            EndpointPolicy endpointPolicy;
            Option<EndpointPolicy> option = this.writableEndpointWithPolicyFor(address);
            if (option instanceof Some && (endpointPolicy = (EndpointPolicy)((Some)option).value()) instanceof Quarantined) {
                Quarantined quarantined = EndpointManager$Quarantined$.MODULE$.unapply((Quarantined)endpointPolicy);
                int n = quarantined._1();
                Deadline deadline = quarantined._2();
                if (uid == n) {
                    return true;
                }
            }
            return this.addressToRefuseUid.get((Object)address).exists(arg_0 -> EndpointManager$.org$apache$pekko$remote$EndpointManager$EndpointRegistry$$_$isQuarantined$$anonfun$1(uid, arg_0));
        }

        public Option<Object> refuseUid(Address address) {
            EndpointPolicy endpointPolicy;
            Option<EndpointPolicy> option = this.writableEndpointWithPolicyFor(address);
            if (option instanceof Some && (endpointPolicy = (EndpointPolicy)((Some)option).value()) instanceof Quarantined) {
                Quarantined quarantined = EndpointManager$Quarantined$.MODULE$.unapply((Quarantined)endpointPolicy);
                int n = quarantined._1();
                Deadline deadline = quarantined._2();
                int uid = n;
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)uid));
            }
            return this.addressToRefuseUid.get((Object)address).map(EndpointManager$::org$apache$pekko$remote$EndpointManager$EndpointRegistry$$_$refuseUid$$anonfun$1);
        }

        public void markAsFailed(ActorRef endpoint, Deadline timeOfRelease) {
            if (this.isWritable(endpoint)) {
                Address address = (Address)this.writableToAddress.apply((Object)endpoint);
                Option option = this.addressToWritable.get((Object)address);
                if (option instanceof Some) {
                    EndpointPolicy endpointPolicy = (EndpointPolicy)((Some)option).value();
                    if (endpointPolicy instanceof Quarantined) {
                        Quarantined quarantined = EndpointManager$Quarantined$.MODULE$.unapply((Quarantined)endpointPolicy);
                        int n = quarantined._1();
                        Deadline deadline = quarantined._2();
                        return;
                    }
                    if (endpointPolicy instanceof Pass) {
                        Pass pass = EndpointManager$Pass$.MODULE$.unapply((Pass)endpointPolicy);
                        ActorRef actorRef = pass._1();
                        Option<Object> option2 = pass._2();
                        Address address2 = (Address)Predef$.MODULE$.ArrowAssoc((Object)address);
                        this.addressToWritable = (HashMap)this.addressToWritable.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)address2, (Object)EndpointManager$Gated$.MODULE$.apply(timeOfRelease)));
                        this.writableToAddress = (HashMap)this.writableToAddress.$minus((Object)endpoint);
                        return;
                    }
                    if (endpointPolicy instanceof Gated) {
                        Gated gated = EndpointManager$Gated$.MODULE$.unapply((Gated)endpointPolicy);
                        Deadline deadline = gated._1();
                        return;
                    }
                }
                if (None$.MODULE$.equals(option)) {
                    Address address3 = (Address)Predef$.MODULE$.ArrowAssoc((Object)address);
                    this.addressToWritable = (HashMap)this.addressToWritable.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)address3, (Object)EndpointManager$Gated$.MODULE$.apply(timeOfRelease)));
                    this.writableToAddress = (HashMap)this.writableToAddress.$minus((Object)endpoint);
                    return;
                }
                throw new MatchError((Object)option);
            }
            if (this.isReadOnly(endpoint)) {
                this.addressToReadonly = (HashMap)this.addressToReadonly.$minus(this.readonlyToAddress.apply((Object)endpoint));
                this.readonlyToAddress = (HashMap)this.readonlyToAddress.$minus((Object)endpoint);
                return;
            }
        }

        public void markAsQuarantined(Address address, int uid, Deadline timeOfRelease) {
            Address address2 = (Address)Predef$.MODULE$.ArrowAssoc((Object)address);
            this.addressToWritable = (HashMap)this.addressToWritable.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)address2, (Object)EndpointManager$Quarantined$.MODULE$.apply(uid, timeOfRelease)));
            this.addressToRefuseUid = this.addressToRefuseUid.updated((Object)address, (Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)uid), (Object)timeOfRelease));
        }

        public void removePolicy(Address address) {
            this.addressToWritable = (HashMap)this.addressToWritable.$minus((Object)address);
        }

        public Iterable<ActorRef> allEndpoints() {
            return (Iterable)this.writableToAddress.keys().$plus$plus((IterableOnce)this.readonlyToAddress.keys());
        }

        public void prune() {
            this.addressToWritable = (HashMap)this.addressToWritable.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Tuple2 x) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        EndpointPolicy endpointPolicy = (EndpointPolicy)tuple2._2();
                        if (endpointPolicy instanceof Gated) {
                            Deadline deadline;
                            Gated gated = EndpointManager$Gated$.MODULE$.unapply((Gated)endpointPolicy);
                            Deadline timeOfRelease = deadline = gated._1();
                            Tuple2 entry = tuple2;
                            if (timeOfRelease.hasTimeLeft()) {
                                return true;
                            }
                        }
                        if (endpointPolicy instanceof Quarantined) {
                            Deadline deadline;
                            Quarantined quarantined = EndpointManager$Quarantined$.MODULE$.unapply((Quarantined)endpointPolicy);
                            int n = quarantined._1();
                            Deadline timeOfRelease = deadline = quarantined._2();
                            Tuple2 entry = tuple2;
                            if (timeOfRelease.hasTimeLeft()) {
                                return true;
                            }
                        }
                        if (endpointPolicy instanceof Pass) {
                            Tuple2 entry = tuple2;
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        EndpointPolicy endpointPolicy = (EndpointPolicy)tuple2._2();
                        if (endpointPolicy instanceof Gated) {
                            Deadline deadline;
                            Gated gated = EndpointManager$Gated$.MODULE$.unapply((Gated)endpointPolicy);
                            Deadline timeOfRelease = deadline = gated._1();
                            Tuple2 entry = tuple2;
                            if (timeOfRelease.hasTimeLeft()) {
                                return entry;
                            }
                        }
                        if (endpointPolicy instanceof Quarantined) {
                            Deadline deadline;
                            Quarantined quarantined = EndpointManager$Quarantined$.MODULE$.unapply((Quarantined)endpointPolicy);
                            int n = quarantined._1();
                            Deadline timeOfRelease = deadline = quarantined._2();
                            Tuple2 entry = tuple2;
                            if (timeOfRelease.hasTimeLeft()) {
                                return entry;
                            }
                        }
                        if (endpointPolicy instanceof Pass) {
                            Tuple2 entry = tuple2;
                            return entry;
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
            this.addressToRefuseUid = (HashMap)this.addressToRefuseUid.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Tuple2 x) {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = x;
                    if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                        Deadline timeOfRelease = (Deadline)tuple2._2();
                        Tuple2 entry = tuple22;
                        if (timeOfRelease.hasTimeLeft()) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = x;
                    if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                        Deadline timeOfRelease = (Deadline)tuple2._2();
                        Tuple2 entry = tuple22;
                        if (timeOfRelease.hasTimeLeft()) {
                            return entry;
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
        }
    }

    public static final class Gated
    implements EndpointPolicy,
    Product,
    Serializable {
        private final Deadline timeOfRelease;

        public static Gated apply(Deadline deadline) {
            return EndpointManager$Gated$.MODULE$.apply(deadline);
        }

        public static Gated fromProduct(Product product) {
            return EndpointManager$Gated$.MODULE$.fromProduct(product);
        }

        public static Gated unapply(Gated gated) {
            return EndpointManager$Gated$.MODULE$.unapply(gated);
        }

        public Gated(Deadline timeOfRelease) {
            this.timeOfRelease = timeOfRelease;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Gated)) return false;
            Gated gated = (Gated)object;
            Deadline deadline = this.timeOfRelease();
            Deadline deadline2 = gated.timeOfRelease();
            if (deadline != null) {
                if (!deadline.equals(deadline2)) return false;
                return true;
            }
            if (deadline2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Gated;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Gated";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "timeOfRelease";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Deadline timeOfRelease() {
            return this.timeOfRelease;
        }

        @Override
        public boolean isTombstone() {
            return true;
        }

        public Gated copy(Deadline timeOfRelease) {
            return new Gated(timeOfRelease);
        }

        public Deadline copy$default$1() {
            return this.timeOfRelease();
        }

        public Deadline _1() {
            return this.timeOfRelease();
        }
    }

    public static final class Link
    implements Product,
    Serializable {
        private final Address localAddress;
        private final Address remoteAddress;

        public static Link apply(Address address, Address address2) {
            return EndpointManager$Link$.MODULE$.apply(address, address2);
        }

        public static Link fromProduct(Product product) {
            return EndpointManager$Link$.MODULE$.fromProduct(product);
        }

        public static Link unapply(Link link) {
            return EndpointManager$Link$.MODULE$.unapply(link);
        }

        public Link(Address localAddress, Address remoteAddress) {
            this.localAddress = localAddress;
            this.remoteAddress = remoteAddress;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Link)) return false;
            Link link = (Link)object;
            Address address = this.localAddress();
            Address address2 = link.localAddress();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!address.equals(address2)) return false;
            Address address3 = this.remoteAddress();
            Address address4 = link.remoteAddress();
            if (address3 == null) {
                if (address4 == null) return true;
                return false;
            } else {
                if (!address3.equals(address4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Link;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Link";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "localAddress";
            }
            if (1 == n2) {
                return "remoteAddress";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address localAddress() {
            return this.localAddress;
        }

        public Address remoteAddress() {
            return this.remoteAddress;
        }

        public Link copy(Address localAddress, Address remoteAddress) {
            return new Link(localAddress, remoteAddress);
        }

        public Address copy$default$1() {
            return this.localAddress();
        }

        public Address copy$default$2() {
            return this.remoteAddress();
        }

        public Address _1() {
            return this.localAddress();
        }

        public Address _2() {
            return this.remoteAddress();
        }
    }

    public static final class Listen
    implements RemotingCommand,
    Product,
    Serializable {
        private final Promise addressesPromise;

        public static Listen apply(Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise) {
            return EndpointManager$Listen$.MODULE$.apply(promise);
        }

        public static Listen fromProduct(Product product) {
            return EndpointManager$Listen$.MODULE$.fromProduct(product);
        }

        public static Listen unapply(Listen listen) {
            return EndpointManager$Listen$.MODULE$.unapply(listen);
        }

        public Listen(Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise) {
            this.addressesPromise = addressesPromise;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Listen)) return false;
            Listen listen = (Listen)object;
            Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise = this.addressesPromise();
            Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise2 = listen.addressesPromise();
            if (promise != null) {
                if (!promise.equals(promise2)) return false;
                return true;
            }
            if (promise2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Listen;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Listen";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "addressesPromise";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise() {
            return this.addressesPromise;
        }

        public Listen copy(Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise) {
            return new Listen(addressesPromise);
        }

        public Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> copy$default$1() {
            return this.addressesPromise();
        }

        public Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> _1() {
            return this.addressesPromise();
        }
    }

    public static final class ListensFailure
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final Promise addressesPromise;
        private final Throwable cause;

        public static ListensFailure apply(Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise, Throwable throwable) {
            return EndpointManager$ListensFailure$.MODULE$.apply(promise, throwable);
        }

        public static ListensFailure fromProduct(Product product) {
            return EndpointManager$ListensFailure$.MODULE$.fromProduct(product);
        }

        public static ListensFailure unapply(ListensFailure listensFailure) {
            return EndpointManager$ListensFailure$.MODULE$.unapply(listensFailure);
        }

        public ListensFailure(Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise, Throwable cause) {
            this.addressesPromise = addressesPromise;
            this.cause = cause;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ListensFailure)) return false;
            ListensFailure listensFailure = (ListensFailure)object;
            Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise = this.addressesPromise();
            Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise2 = listensFailure.addressesPromise();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            Throwable throwable = this.cause();
            Throwable throwable2 = listensFailure.cause();
            if (throwable == null) {
                if (throwable2 == null) return true;
                return false;
            } else {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ListensFailure;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ListensFailure";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "addressesPromise";
            }
            if (1 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise() {
            return this.addressesPromise;
        }

        public Throwable cause() {
            return this.cause;
        }

        public ListensFailure copy(Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise, Throwable cause) {
            return new ListensFailure(addressesPromise, cause);
        }

        public Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> copy$default$1() {
            return this.addressesPromise();
        }

        public Throwable copy$default$2() {
            return this.cause();
        }

        public Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> _1() {
            return this.addressesPromise();
        }

        public Throwable _2() {
            return this.cause();
        }
    }

    public static final class ListensResult
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final Promise addressesPromise;
        private final Seq results;

        public static ListensResult apply(Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise, Seq<Tuple3<PekkoProtocolTransport, Address, Promise<Transport.AssociationEventListener>>> seq) {
            return EndpointManager$ListensResult$.MODULE$.apply(promise, seq);
        }

        public static ListensResult fromProduct(Product product) {
            return EndpointManager$ListensResult$.MODULE$.fromProduct(product);
        }

        public static ListensResult unapply(ListensResult listensResult) {
            return EndpointManager$ListensResult$.MODULE$.unapply(listensResult);
        }

        public ListensResult(Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise, Seq<Tuple3<PekkoProtocolTransport, Address, Promise<Transport.AssociationEventListener>>> results) {
            this.addressesPromise = addressesPromise;
            this.results = results;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ListensResult)) return false;
            ListensResult listensResult = (ListensResult)object;
            Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise = this.addressesPromise();
            Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> promise2 = listensResult.addressesPromise();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            Seq<Tuple3<PekkoProtocolTransport, Address, Promise<Transport.AssociationEventListener>>> seq = this.results();
            Seq<Tuple3<PekkoProtocolTransport, Address, Promise<Transport.AssociationEventListener>>> seq2 = listensResult.results();
            if (seq == null) {
                if (seq2 == null) return true;
                return false;
            } else {
                if (!seq.equals(seq2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ListensResult;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ListensResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "addressesPromise";
            }
            if (1 == n2) {
                return "results";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise() {
            return this.addressesPromise;
        }

        public Seq<Tuple3<PekkoProtocolTransport, Address, Promise<Transport.AssociationEventListener>>> results() {
            return this.results;
        }

        public ListensResult copy(Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> addressesPromise, Seq<Tuple3<PekkoProtocolTransport, Address, Promise<Transport.AssociationEventListener>>> results) {
            return new ListensResult(addressesPromise, results);
        }

        public Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> copy$default$1() {
            return this.addressesPromise();
        }

        public Seq<Tuple3<PekkoProtocolTransport, Address, Promise<Transport.AssociationEventListener>>> copy$default$2() {
            return this.results();
        }

        public Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>> _1() {
            return this.addressesPromise();
        }

        public Seq<Tuple3<PekkoProtocolTransport, Address, Promise<Transport.AssociationEventListener>>> _2() {
            return this.results();
        }
    }

    public static final class ManagementCommand
    implements RemotingCommand,
    Product,
    Serializable {
        private final Object cmd;

        public static ManagementCommand apply(Object object) {
            return EndpointManager$ManagementCommand$.MODULE$.apply(object);
        }

        public static ManagementCommand fromProduct(Product product) {
            return EndpointManager$ManagementCommand$.MODULE$.fromProduct(product);
        }

        public static ManagementCommand unapply(ManagementCommand managementCommand) {
            return EndpointManager$ManagementCommand$.MODULE$.unapply(managementCommand);
        }

        public ManagementCommand(Object cmd) {
            this.cmd = cmd;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ManagementCommand)) return false;
            ManagementCommand managementCommand = (ManagementCommand)object;
            if (!BoxesRunTime.equals((Object)this.cmd(), (Object)managementCommand.cmd())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ManagementCommand;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ManagementCommand";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cmd";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Object cmd() {
            return this.cmd;
        }

        public ManagementCommand copy(Object cmd) {
            return new ManagementCommand(cmd);
        }

        public Object copy$default$1() {
            return this.cmd();
        }

        public Object _1() {
            return this.cmd();
        }
    }

    public static final class ManagementCommandAck
    implements Product,
    Serializable {
        private final boolean status;

        public static ManagementCommandAck apply(boolean bl) {
            return EndpointManager$ManagementCommandAck$.MODULE$.apply(bl);
        }

        public static ManagementCommandAck fromProduct(Product product) {
            return EndpointManager$ManagementCommandAck$.MODULE$.fromProduct(product);
        }

        public static ManagementCommandAck unapply(ManagementCommandAck managementCommandAck) {
            return EndpointManager$ManagementCommandAck$.MODULE$.unapply(managementCommandAck);
        }

        public ManagementCommandAck(boolean status) {
            this.status = status;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.status() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ManagementCommandAck)) return false;
            ManagementCommandAck managementCommandAck = (ManagementCommandAck)object;
            if (this.status() != managementCommandAck.status()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ManagementCommandAck;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ManagementCommandAck";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToBoolean((boolean)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "status";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean status() {
            return this.status;
        }

        public ManagementCommandAck copy(boolean status) {
            return new ManagementCommandAck(status);
        }

        public boolean copy$default$1() {
            return this.status();
        }

        public boolean _1() {
            return this.status();
        }
    }

    public static final class Pass
    implements EndpointPolicy,
    Product,
    Serializable {
        private final ActorRef endpoint;
        private final Option uid;

        public static Pass apply(ActorRef actorRef, Option<Object> option) {
            return EndpointManager$Pass$.MODULE$.apply(actorRef, option);
        }

        public static Pass fromProduct(Product product) {
            return EndpointManager$Pass$.MODULE$.fromProduct(product);
        }

        public static Pass unapply(Pass pass) {
            return EndpointManager$Pass$.MODULE$.unapply(pass);
        }

        public Pass(ActorRef endpoint, Option<Object> uid) {
            this.endpoint = endpoint;
            this.uid = uid;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Pass)) return false;
            Pass pass = (Pass)object;
            ActorRef actorRef = this.endpoint();
            ActorRef actorRef2 = pass.endpoint();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            Option<Object> option = this.uid();
            Option<Object> option2 = pass.uid();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Pass;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Pass";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "endpoint";
            }
            if (1 == n2) {
                return "uid";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef endpoint() {
            return this.endpoint;
        }

        public Option<Object> uid() {
            return this.uid;
        }

        @Override
        public boolean isTombstone() {
            return false;
        }

        public Pass copy(ActorRef endpoint, Option<Object> uid) {
            return new Pass(endpoint, uid);
        }

        public ActorRef copy$default$1() {
            return this.endpoint();
        }

        public Option<Object> copy$default$2() {
            return this.uid();
        }

        public ActorRef _1() {
            return this.endpoint();
        }

        public Option<Object> _2() {
            return this.uid();
        }
    }

    public static final class Quarantine
    implements RemotingCommand,
    Product,
    Serializable {
        private final Address remoteAddress;
        private final Option uid;

        public static Quarantine apply(Address address, Option<Object> option) {
            return EndpointManager$Quarantine$.MODULE$.apply(address, option);
        }

        public static Quarantine fromProduct(Product product) {
            return EndpointManager$Quarantine$.MODULE$.fromProduct(product);
        }

        public static Quarantine unapply(Quarantine quarantine) {
            return EndpointManager$Quarantine$.MODULE$.unapply(quarantine);
        }

        public Quarantine(Address remoteAddress, Option<Object> uid) {
            this.remoteAddress = remoteAddress;
            this.uid = uid;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Quarantine)) return false;
            Quarantine quarantine = (Quarantine)object;
            Address address = this.remoteAddress();
            Address address2 = quarantine.remoteAddress();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!address.equals(address2)) return false;
            Option<Object> option = this.uid();
            Option<Object> option2 = quarantine.uid();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Quarantine;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Quarantine";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "remoteAddress";
            }
            if (1 == n2) {
                return "uid";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address remoteAddress() {
            return this.remoteAddress;
        }

        public Option<Object> uid() {
            return this.uid;
        }

        public Quarantine copy(Address remoteAddress, Option<Object> uid) {
            return new Quarantine(remoteAddress, uid);
        }

        public Address copy$default$1() {
            return this.remoteAddress();
        }

        public Option<Object> copy$default$2() {
            return this.uid();
        }

        public Address _1() {
            return this.remoteAddress();
        }

        public Option<Object> _2() {
            return this.uid();
        }
    }

    public static final class Quarantined
    implements EndpointPolicy,
    Product,
    Serializable {
        private final int uid;
        private final Deadline timeOfRelease;

        public static Quarantined apply(int n, Deadline deadline) {
            return EndpointManager$Quarantined$.MODULE$.apply(n, deadline);
        }

        public static Quarantined fromProduct(Product product) {
            return EndpointManager$Quarantined$.MODULE$.fromProduct(product);
        }

        public static Quarantined unapply(Quarantined quarantined) {
            return EndpointManager$Quarantined$.MODULE$.unapply(quarantined);
        }

        public Quarantined(int uid, Deadline timeOfRelease) {
            this.uid = uid;
            this.timeOfRelease = timeOfRelease;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.uid());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.timeOfRelease()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Quarantined)) return false;
            Quarantined quarantined = (Quarantined)object;
            if (this.uid() != quarantined.uid()) return false;
            Deadline deadline = this.timeOfRelease();
            Deadline deadline2 = quarantined.timeOfRelease();
            if (deadline != null) {
                if (!deadline.equals(deadline2)) return false;
                return true;
            }
            if (deadline2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Quarantined;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Quarantined";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "uid";
            }
            if (1 == n2) {
                return "timeOfRelease";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int uid() {
            return this.uid;
        }

        public Deadline timeOfRelease() {
            return this.timeOfRelease;
        }

        @Override
        public boolean isTombstone() {
            return true;
        }

        public Quarantined copy(int uid, Deadline timeOfRelease) {
            return new Quarantined(uid, timeOfRelease);
        }

        public int copy$default$1() {
            return this.uid();
        }

        public Deadline copy$default$2() {
            return this.timeOfRelease();
        }

        public int _1() {
            return this.uid();
        }

        public Deadline _2() {
            return this.timeOfRelease();
        }
    }

    public static interface RemotingCommand
    extends NoSerializationVerificationNeeded {
    }

    public static final class ResendState
    implements Product,
    Serializable {
        private final int uid;
        private final AckedReceiveBuffer buffer;

        public static ResendState apply(int n, AckedReceiveBuffer<PekkoPduCodec.Message> ackedReceiveBuffer) {
            return EndpointManager$ResendState$.MODULE$.apply(n, ackedReceiveBuffer);
        }

        public static ResendState fromProduct(Product product) {
            return EndpointManager$ResendState$.MODULE$.fromProduct(product);
        }

        public static ResendState unapply(ResendState resendState) {
            return EndpointManager$ResendState$.MODULE$.unapply(resendState);
        }

        public ResendState(int uid, AckedReceiveBuffer<PekkoPduCodec.Message> buffer) {
            this.uid = uid;
            this.buffer = buffer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.uid());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.buffer()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResendState)) return false;
            ResendState resendState = (ResendState)object;
            if (this.uid() != resendState.uid()) return false;
            AckedReceiveBuffer<PekkoPduCodec.Message> ackedReceiveBuffer = this.buffer();
            AckedReceiveBuffer<PekkoPduCodec.Message> ackedReceiveBuffer2 = resendState.buffer();
            if (ackedReceiveBuffer != null) {
                if (!((Object)ackedReceiveBuffer).equals(ackedReceiveBuffer2)) return false;
                return true;
            }
            if (ackedReceiveBuffer2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ResendState;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ResendState";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "uid";
            }
            if (1 == n2) {
                return "buffer";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int uid() {
            return this.uid;
        }

        public AckedReceiveBuffer<PekkoPduCodec.Message> buffer() {
            return this.buffer;
        }

        public ResendState copy(int uid, AckedReceiveBuffer<PekkoPduCodec.Message> buffer) {
            return new ResendState(uid, buffer);
        }

        public int copy$default$1() {
            return this.uid();
        }

        public AckedReceiveBuffer<PekkoPduCodec.Message> copy$default$2() {
            return this.buffer();
        }

        public int _1() {
            return this.uid();
        }

        public AckedReceiveBuffer<PekkoPduCodec.Message> _2() {
            return this.buffer();
        }
    }

    @InternalStableApi
    public static final class Send
    implements RemotingCommand,
    HasSequenceNumber,
    Product,
    Serializable {
        private final Object message;
        private final ActorRef senderOption;
        private final RemoteActorRef recipient;
        private final Option seqOpt;

        public static Send apply(Object object, ActorRef actorRef, RemoteActorRef remoteActorRef, Option<SeqNo> option) {
            return EndpointManager$Send$.MODULE$.apply(object, actorRef, remoteActorRef, option);
        }

        public static Send fromProduct(Product product) {
            return EndpointManager$Send$.MODULE$.fromProduct(product);
        }

        public static Send unapply(Send send) {
            return EndpointManager$Send$.MODULE$.unapply(send);
        }

        public static Option<SeqNo> $lessinit$greater$default$4() {
            return EndpointManager$Send$.MODULE$.$lessinit$greater$default$4();
        }

        public Send(Object message, ActorRef senderOption, RemoteActorRef recipient, Option<SeqNo> seqOpt) {
            this.message = message;
            this.senderOption = senderOption;
            this.recipient = recipient;
            this.seqOpt = seqOpt;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Send)) return false;
            Send send = (Send)object;
            if (!BoxesRunTime.equals((Object)this.message(), (Object)send.message())) return false;
            ActorRef actorRef = this.senderOption();
            ActorRef actorRef2 = send.senderOption();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            RemoteActorRef remoteActorRef = this.recipient();
            RemoteActorRef remoteActorRef2 = send.recipient();
            if (remoteActorRef == null) {
                if (remoteActorRef2 != null) {
                    return false;
                }
            } else if (!remoteActorRef.equals(remoteActorRef2)) return false;
            Option<SeqNo> option = this.seqOpt();
            Option<SeqNo> option2 = send.seqOpt();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Send;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Send";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return new OptionVal((Object)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "message";
                }
                case 1: {
                    return "senderOption";
                }
                case 2: {
                    return "recipient";
                }
                case 3: {
                    return "seqOpt";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Object message() {
            return this.message;
        }

        public ActorRef senderOption() {
            return this.senderOption;
        }

        public RemoteActorRef recipient() {
            return this.recipient;
        }

        public Option<SeqNo> seqOpt() {
            return this.seqOpt;
        }

        public String toString() {
            return new StringBuilder(19).append("Remote message ").append(new OptionVal((Object)this.senderOption())).append(" -> ").append(this.recipient()).toString();
        }

        @Override
        public SeqNo seq() {
            return (SeqNo)this.seqOpt().get();
        }

        public Send copy(Object message, ActorRef senderOption, RemoteActorRef recipient, Option<SeqNo> seqOpt) {
            return new Send(message, senderOption, recipient, seqOpt);
        }

        public Object copy$default$1() {
            return this.message();
        }

        public ActorRef copy$default$2() {
            return this.senderOption();
        }

        public RemoteActorRef copy$default$3() {
            return this.recipient();
        }

        public Option<SeqNo> copy$default$4() {
            return this.seqOpt();
        }

        public Object _1() {
            return this.message();
        }

        public ActorRef _2() {
            return this.senderOption();
        }

        public RemoteActorRef _3() {
            return this.recipient();
        }

        public Option<SeqNo> _4() {
            return this.seqOpt();
        }
    }
}

