/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.remote.Ack;
import org.apache.pekko.remote.AckedReceiveBuffer;
import org.apache.pekko.remote.AckedReceiveBuffer$;
import org.apache.pekko.remote.EndpointActor;
import org.apache.pekko.remote.EndpointException;
import org.apache.pekko.remote.EndpointManager;
import org.apache.pekko.remote.EndpointManager$Link$;
import org.apache.pekko.remote.EndpointManager$ResendState$;
import org.apache.pekko.remote.EndpointReader$;
import org.apache.pekko.remote.EndpointWriter;
import org.apache.pekko.remote.EndpointWriter$OutboundAck$;
import org.apache.pekko.remote.EndpointWriter$StopReading$;
import org.apache.pekko.remote.EndpointWriter$StoppedReading$;
import org.apache.pekko.remote.HasSequenceNumber$;
import org.apache.pekko.remote.InboundMessageDispatcher;
import org.apache.pekko.remote.InvalidAssociation$;
import org.apache.pekko.remote.OversizedPayloadException;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.RemoteSettings;
import org.apache.pekko.remote.ShutDownAssociation$;
import org.apache.pekko.remote.WireFormats;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.AssociationHandle$Disassociated$;
import org.apache.pekko.remote.transport.AssociationHandle$InboundPayload$;
import org.apache.pekko.remote.transport.AssociationHandle$Quarantined$;
import org.apache.pekko.remote.transport.AssociationHandle$Shutdown$;
import org.apache.pekko.remote.transport.AssociationHandle$Unknown$;
import org.apache.pekko.remote.transport.PekkoPduCodec;
import org.apache.pekko.remote.transport.Transport;
import org.apache.pekko.remote.transport.Transport$InvalidAssociationException$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public class EndpointReader
extends EndpointActor {
    public final InboundMessageDispatcher org$apache$pekko$remote$EndpointReader$$msgDispatch;
    private final boolean inbound;
    private final int uid;
    private final Option reliableDeliverySupervisor;
    private final ConcurrentHashMap receiveBuffers;
    private final RemoteActorRefProvider provider;
    private AckedReceiveBuffer ackedReceiveBuffer;

    public static Props props(Address address, Address address2, Transport transport, RemoteSettings remoteSettings, PekkoPduCodec pekkoPduCodec, InboundMessageDispatcher inboundMessageDispatcher, boolean bl, int n, Option<ActorRef> option, ConcurrentHashMap<EndpointManager.Link, EndpointManager.ResendState> concurrentHashMap) {
        return EndpointReader$.MODULE$.props(address, address2, transport, remoteSettings, pekkoPduCodec, inboundMessageDispatcher, bl, n, option, concurrentHashMap);
    }

    public EndpointReader(Address localAddress, Address remoteAddress, Transport transport, RemoteSettings settings, PekkoPduCodec codec, InboundMessageDispatcher msgDispatch, boolean inbound, int uid, Option<ActorRef> reliableDeliverySupervisor, ConcurrentHashMap<EndpointManager.Link, EndpointManager.ResendState> receiveBuffers) {
        this.org$apache$pekko$remote$EndpointReader$$msgDispatch = msgDispatch;
        this.inbound = inbound;
        this.uid = uid;
        this.reliableDeliverySupervisor = reliableDeliverySupervisor;
        this.receiveBuffers = receiveBuffers;
        super(localAddress, remoteAddress, transport, settings, codec);
        this.provider = ((RARP)RARP$.MODULE$.apply(this.context().system())).provider();
        this.ackedReceiveBuffer = new AckedReceiveBuffer(AckedReceiveBuffer$.MODULE$.$lessinit$greater$default$1(), AckedReceiveBuffer$.MODULE$.$lessinit$greater$default$2(), AckedReceiveBuffer$.MODULE$.$lessinit$greater$default$3(), HasSequenceNumber$.MODULE$.seqOrdering());
    }

    private Address localAddress$accessor() {
        return super.localAddress();
    }

    public Address org$apache$pekko$remote$EndpointReader$$remoteAddress$accessor() {
        return super.remoteAddress();
    }

    public Transport org$apache$pekko$remote$EndpointReader$$transport$accessor() {
        return super.transport();
    }

    private RemoteSettings settings$accessor() {
        return super.settings();
    }

    private PekkoPduCodec codec$accessor() {
        return super.codec();
    }

    @Override
    public boolean inbound() {
        return this.inbound;
    }

    public int uid() {
        return this.uid;
    }

    public Option<ActorRef> reliableDeliverySupervisor() {
        return this.reliableDeliverySupervisor;
    }

    public ConcurrentHashMap<EndpointManager.Link, EndpointManager.ResendState> receiveBuffers() {
        return this.receiveBuffers;
    }

    public RemoteActorRefProvider provider() {
        return this.provider;
    }

    public AckedReceiveBuffer<PekkoPduCodec.Message> ackedReceiveBuffer() {
        return this.ackedReceiveBuffer;
    }

    public void ackedReceiveBuffer_$eq(AckedReceiveBuffer<PekkoPduCodec.Message> x$1) {
        this.ackedReceiveBuffer = x$1;
    }

    @Override
    public void preStart() {
        EndpointManager.ResendState resendState = this.receiveBuffers().get(EndpointManager$Link$.MODULE$.apply(this.localAddress$accessor(), this.org$apache$pekko$remote$EndpointReader$$remoteAddress$accessor()));
        if (resendState == null) {
            return;
        }
        if (resendState != null) {
            EndpointManager.ResendState resendState2 = EndpointManager$ResendState$.MODULE$.unapply(resendState);
            int n = resendState2._1();
            AckedReceiveBuffer<PekkoPduCodec.Message> ackedReceiveBuffer = resendState2._2();
            if (this.uid() == n) {
                AckedReceiveBuffer<PekkoPduCodec.Message> buffer = ackedReceiveBuffer;
                this.ackedReceiveBuffer_$eq(buffer);
                this.org$apache$pekko$remote$EndpointReader$$deliverAndAck();
                return;
            }
        }
    }

    @Override
    public void postStop() {
        this.saveState();
    }

    public void saveState() {
        EndpointManager.Link key = EndpointManager$Link$.MODULE$.apply(this.localAddress$accessor(), this.org$apache$pekko$remote$EndpointReader$$remoteAddress$accessor());
        this.updateSavedState$1(key, this.receiveBuffers().get(key));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ EndpointReader $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof AssociationHandle.Disassociated) {
                    AssociationHandle.DisassociateInfo disassociateInfo;
                    AssociationHandle.Disassociated disassociated = AssociationHandle$Disassociated$.MODULE$.unapply((AssociationHandle.Disassociated)object);
                    AssociationHandle.DisassociateInfo info = disassociateInfo = disassociated._1();
                    return true;
                }
                if (object instanceof AssociationHandle.InboundPayload) {
                    AssociationHandle.InboundPayload inboundPayload = AssociationHandle$InboundPayload$.MODULE$.unapply((AssociationHandle.InboundPayload)object);
                    ByteString byteString = inboundPayload._1();
                    ByteString p = byteString;
                    if (p.length() <= this.$outer.org$apache$pekko$remote$EndpointReader$$transport$accessor().maximumPayloadBytes()) {
                        return true;
                    }
                    ByteString oversized = byteString;
                    return true;
                }
                if (object instanceof EndpointWriter.StopReading) {
                    EndpointWriter.StopReading stopReading = EndpointWriter$StopReading$.MODULE$.unapply((EndpointWriter.StopReading)object);
                    ActorRef actorRef = stopReading._1();
                    ActorRef actorRef2 = stopReading._2();
                    ActorRef writer = actorRef;
                    ActorRef replyTo = actorRef2;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof AssociationHandle.Disassociated) {
                    AssociationHandle.DisassociateInfo disassociateInfo;
                    AssociationHandle.Disassociated disassociated = AssociationHandle$Disassociated$.MODULE$.unapply((AssociationHandle.Disassociated)object);
                    AssociationHandle.DisassociateInfo info = disassociateInfo = disassociated._1();
                    this.$outer.org$apache$pekko$remote$EndpointReader$$handleDisassociated(info);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof AssociationHandle.InboundPayload) {
                    AssociationHandle.InboundPayload inboundPayload = AssociationHandle$InboundPayload$.MODULE$.unapply((AssociationHandle.InboundPayload)object);
                    ByteString byteString = inboundPayload._1();
                    ByteString p = byteString;
                    if (p.length() <= this.$outer.org$apache$pekko$remote$EndpointReader$$transport$accessor().maximumPayloadBytes()) {
                        Tuple2<Option<Ack>, Option<PekkoPduCodec.Message>> tuple2 = this.$outer.org$apache$pekko$remote$EndpointReader$$tryDecodeMessageAndAck(p);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Option ackOption = (Option)tuple2._1();
                        Option msgOption = (Option)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)ackOption, (Object)msgOption);
                        Option ackOption2 = (Option)tuple22._1();
                        Option msgOption2 = (Option)tuple22._2();
                        ackOption2.foreach((Function1)(JProcedure1 & Serializable)ack -> this.$outer.reliableDeliverySupervisor().foreach((Function1)(JProcedure1 & Serializable)reliableDelivery -> reliableDelivery.$bang(ack, this.$outer.self())));
                        Option option = msgOption2;
                        if (option instanceof Some) {
                            PekkoPduCodec.Message msg = (PekkoPduCodec.Message)((Some)option).value();
                            if (msg.reliableDeliveryEnabled()) {
                                this.$outer.ackedReceiveBuffer_$eq(this.$outer.ackedReceiveBuffer().receive(msg));
                                this.$outer.org$apache$pekko$remote$EndpointReader$$deliverAndAck();
                            } else {
                                try {
                                    this.$outer.org$apache$pekko$remote$EndpointReader$$msgDispatch.dispatch(msg.recipient(), msg.recipientAddress(), msg.serializedMessage(), msg.senderOption());
                                }
                                catch (NotSerializableException e) {
                                    this.$outer.org$apache$pekko$remote$EndpointReader$$logTransientSerializationError(msg, e);
                                }
                                catch (IllegalArgumentException e) {
                                    this.$outer.org$apache$pekko$remote$EndpointReader$$logTransientSerializationError(msg, e);
                                }
                            }
                        } else if (!None$.MODULE$.equals(option)) {
                            throw new MatchError((Object)option);
                        }
                        return BoxedUnit.UNIT;
                    }
                    ByteString oversized = byteString;
                    this.$outer.log().error((Throwable)((Object)new OversizedPayloadException(new StringBuilder(39).append("Discarding oversized payload received: ").append(new StringBuilder(48).append("max allowed size [").append(this.$outer.org$apache$pekko$remote$EndpointReader$$transport$accessor().maximumPayloadBytes()).append("] bytes, actual size [").append(oversized.size()).append("] bytes.").toString()).toString())), "Transient error while reading from association (association remains live)");
                    return BoxedUnit.UNIT;
                }
                if (object instanceof EndpointWriter.StopReading) {
                    EndpointWriter.StopReading stopReading = EndpointWriter$StopReading$.MODULE$.unapply((EndpointWriter.StopReading)object);
                    ActorRef actorRef = stopReading._1();
                    ActorRef actorRef2 = stopReading._2();
                    ActorRef writer = actorRef;
                    ActorRef replyTo = actorRef2;
                    this.$outer.saveState();
                    this.$outer.context().become(this.$outer.notReading());
                    replyTo.$bang((Object)EndpointWriter$StoppedReading$.MODULE$.apply(writer), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$3(org.apache.pekko.remote.Ack ), applyOrElse$$anonfun$3$$anonfun$1(org.apache.pekko.remote.Ack org.apache.pekko.actor.ActorRef )}, serializedLambda);
            }
        };
    }

    public void org$apache$pekko$remote$EndpointReader$$logTransientSerializationError(PekkoPduCodec.Message msg, Exception error) {
        WireFormats.SerializedMessage sm = msg.serializedMessage();
        this.log().warning("Serializer not defined for message with serializer id [{}] and manifest [{}]. Transient association error (association remains live). {}", (Object)BoxesRunTime.boxToInteger((int)sm.getSerializerId()), (Object)(sm.hasMessageManifest() ? sm.getMessageManifest().toStringUtf8() : ""), (Object)error.getMessage());
    }

    public PartialFunction<Object, BoxedUnit> notReading() {
        return new Serializable(this){
            private final /* synthetic */ EndpointReader $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof AssociationHandle.Disassociated) {
                    AssociationHandle.DisassociateInfo disassociateInfo;
                    AssociationHandle.Disassociated disassociated = AssociationHandle$Disassociated$.MODULE$.unapply((AssociationHandle.Disassociated)object);
                    AssociationHandle.DisassociateInfo info = disassociateInfo = disassociated._1();
                    return true;
                }
                if (object instanceof EndpointWriter.StopReading) {
                    EndpointWriter.StopReading stopReading = EndpointWriter$StopReading$.MODULE$.unapply((EndpointWriter.StopReading)object);
                    ActorRef actorRef = stopReading._1();
                    ActorRef actorRef2 = stopReading._2();
                    ActorRef writer = actorRef;
                    ActorRef replyTo = actorRef2;
                    return true;
                }
                if (object instanceof AssociationHandle.InboundPayload) {
                    AssociationHandle.InboundPayload inboundPayload = AssociationHandle$InboundPayload$.MODULE$.unapply((AssociationHandle.InboundPayload)object);
                    ByteString byteString = inboundPayload._1();
                    ByteString p = byteString;
                    if (p.length() <= this.$outer.org$apache$pekko$remote$EndpointReader$$transport$accessor().maximumPayloadBytes()) {
                        return true;
                    }
                    ByteString oversized = byteString;
                    return true;
                }
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                block2: {
                    ByteString byteString;
                    block4: {
                        Object object;
                        block3: {
                            block1: {
                                AssociationHandle.DisassociateInfo disassociateInfo;
                                object = x;
                                if (!(object instanceof AssociationHandle.Disassociated)) break block1;
                                AssociationHandle.Disassociated disassociated = AssociationHandle$Disassociated$.MODULE$.unapply((AssociationHandle.Disassociated)object);
                                AssociationHandle.DisassociateInfo info = disassociateInfo = disassociated._1();
                                this.$outer.org$apache$pekko$remote$EndpointReader$$handleDisassociated(info);
                                break block2;
                            }
                            if (!(object instanceof EndpointWriter.StopReading)) break block3;
                            EndpointWriter.StopReading stopReading = EndpointWriter$StopReading$.MODULE$.unapply((EndpointWriter.StopReading)object);
                            ActorRef actorRef = stopReading._1();
                            ActorRef actorRef2 = stopReading._2();
                            ActorRef writer = actorRef;
                            ActorRef replyTo = actorRef2;
                            replyTo.$bang((Object)EndpointWriter$StoppedReading$.MODULE$.apply(writer), this.$outer.self());
                            break block2;
                        }
                        if (!(object instanceof AssociationHandle.InboundPayload)) break block2;
                        AssociationHandle.InboundPayload inboundPayload = AssociationHandle$InboundPayload$.MODULE$.unapply((AssociationHandle.InboundPayload)object);
                        byteString = inboundPayload._1();
                        ByteString p = byteString;
                        if (p.length() > this.$outer.org$apache$pekko$remote$EndpointReader$$transport$accessor().maximumPayloadBytes()) break block4;
                        Tuple2<Option<Ack>, Option<PekkoPduCodec.Message>> tuple2 = this.$outer.org$apache$pekko$remote$EndpointReader$$tryDecodeMessageAndAck(p);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Option ackOption = (Option)tuple2._1();
                        Option msgOption = (Option)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)ackOption, (Object)msgOption);
                        Option ackOption2 = (Option)tuple22._1();
                        Option msgOption2 = (Option)tuple22._2();
                        ackOption2.foreach((Function1)(JProcedure1 & Serializable)ack -> this.$outer.reliableDeliverySupervisor().foreach((Function1)(JProcedure1 & Serializable)reliableDelivery -> reliableDelivery.$bang(ack, this.$outer.self())));
                        if (!this.$outer.log().isWarningEnabled()) break block2;
                        this.$outer.log().warning("Discarding inbound message to [{}] in read-only association to [{}]. If this happens often you may consider using pekko.remote.use-passive-connections=off or use Artery TCP.", msgOption2.map(EndpointReader::org$apache$pekko$remote$EndpointReader$$anon$12$$_$applyOrElse$$anonfun$5).getOrElse(EndpointReader::org$apache$pekko$remote$EndpointReader$$anon$12$$_$applyOrElse$$anonfun$6), (Object)this.$outer.org$apache$pekko$remote$EndpointReader$$remoteAddress$accessor());
                        break block2;
                    }
                    ByteString oversized = byteString;
                    this.$outer.log().error((Throwable)((Object)new OversizedPayloadException(new StringBuilder(64).append("Discarding oversized payload received in read-only association: ").append(new StringBuilder(48).append("max allowed size [").append(this.$outer.org$apache$pekko$remote$EndpointReader$$transport$accessor().maximumPayloadBytes()).append("] bytes, actual size [").append(oversized.size()).append("] bytes.").toString()).toString())), "Transient error while reading from association (association remains live)");
                }
                return BoxedUnit.UNIT;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$4(org.apache.pekko.remote.Ack ), org$apache$pekko$remote$EndpointReader$$anon$12$$_$applyOrElse$$anonfun$5(org.apache.pekko.remote.transport.PekkoPduCodec$Message ), org$apache$pekko$remote$EndpointReader$$anon$12$$_$applyOrElse$$anonfun$6(), applyOrElse$$anonfun$4$$anonfun$1(org.apache.pekko.remote.Ack org.apache.pekko.actor.ActorRef )}, serializedLambda);
            }
        };
    }

    public void org$apache$pekko$remote$EndpointReader$$handleDisassociated(AssociationHandle.DisassociateInfo info) {
        AssociationHandle.DisassociateInfo disassociateInfo = info;
        if (AssociationHandle$Unknown$.MODULE$.equals(disassociateInfo)) {
            this.context().stop(this.self());
            return;
        }
        if (AssociationHandle$Shutdown$.MODULE$.equals(disassociateInfo)) {
            throw ShutDownAssociation$.MODULE$.apply(this.localAddress$accessor(), this.org$apache$pekko$remote$EndpointReader$$remoteAddress$accessor(), (Throwable)((Object)Transport$InvalidAssociationException$.MODULE$.apply("The remote system terminated the association because it is shutting down.", Transport$InvalidAssociationException$.MODULE$.$lessinit$greater$default$2())));
        }
        if (AssociationHandle$Quarantined$.MODULE$.equals(disassociateInfo)) {
            throw InvalidAssociation$.MODULE$.apply(this.localAddress$accessor(), this.org$apache$pekko$remote$EndpointReader$$remoteAddress$accessor(), (Throwable)((Object)Transport$InvalidAssociationException$.MODULE$.apply("The remote system has quarantined this system. No further associations to the remote system are possible until this system is restarted.", Transport$InvalidAssociationException$.MODULE$.$lessinit$greater$default$2())), (Option<AssociationHandle.DisassociateInfo>)Some$.MODULE$.apply((Object)AssociationHandle$Quarantined$.MODULE$));
        }
        throw new MatchError((Object)disassociateInfo);
    }

    public void org$apache$pekko$remote$EndpointReader$$deliverAndAck() {
        Tuple3<AckedReceiveBuffer<PekkoPduCodec.Message>, Seq<PekkoPduCodec.Message>, Ack> tuple3 = this.ackedReceiveBuffer().extractDeliverable();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        AckedReceiveBuffer updatedBuffer = (AckedReceiveBuffer)tuple3._1();
        Seq deliver = (Seq)tuple3._2();
        Ack ack = (Ack)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)updatedBuffer, (Object)deliver, (Object)ack);
        AckedReceiveBuffer updatedBuffer2 = (AckedReceiveBuffer)tuple32._1();
        Seq deliver2 = (Seq)tuple32._2();
        Ack ack2 = (Ack)tuple32._3();
        this.ackedReceiveBuffer_$eq(updatedBuffer2);
        this.context().parent().$bang((Object)EndpointWriter$OutboundAck$.MODULE$.apply(ack2), this.self());
        deliver2.foreach((Function1)(JProcedure1 & Serializable)m -> this.org$apache$pekko$remote$EndpointReader$$msgDispatch.dispatch(m.recipient(), m.recipientAddress(), m.serializedMessage(), m.senderOption()));
    }

    public Tuple2<Option<Ack>, Option<PekkoPduCodec.Message>> org$apache$pekko$remote$EndpointReader$$tryDecodeMessageAndAck(ByteString pdu) {
        Tuple2<Option<Ack>, Option<PekkoPduCodec.Message>> tuple2;
        try {
            tuple2 = this.codec$accessor().decodeMessage(pdu, this.provider(), this.localAddress$accessor());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                throw new EndpointException("Error while decoding incoming Pekko PDU", e);
            }
            throw throwable;
        }
        return tuple2;
    }

    private final EndpointManager.ResendState merge$1(EndpointManager.ResendState currentState, EndpointManager.ResendState oldState) {
        if (currentState.uid() == oldState.uid()) {
            return EndpointManager$ResendState$.MODULE$.apply(this.uid(), oldState.buffer().mergeFrom(currentState.buffer()));
        }
        return currentState;
    }

    private final void updateSavedState$1(EndpointManager.Link key, EndpointManager.ResendState expectedState) {
        while (true) {
            if (expectedState == null) {
                if (this.receiveBuffers().putIfAbsent(key, EndpointManager$ResendState$.MODULE$.apply(this.uid(), this.ackedReceiveBuffer())) != null) {
                    expectedState = this.receiveBuffers().get(key);
                    continue;
                }
                return;
            }
            if (this.receiveBuffers().replace(key, expectedState, this.merge$1(EndpointManager$ResendState$.MODULE$.apply(this.uid(), this.ackedReceiveBuffer()), expectedState))) break;
            expectedState = this.receiveBuffers().get(key);
        }
    }

    public static final /* synthetic */ InternalActorRef org$apache$pekko$remote$EndpointReader$$anon$12$$_$applyOrElse$$anonfun$5(PekkoPduCodec.Message _$14) {
        return _$14.recipient();
    }

    public static final Serializable org$apache$pekko$remote$EndpointReader$$anon$12$$_$applyOrElse$$anonfun$6() {
        return "unknown";
    }
}

