/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.AddressTerminated$;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.RootActorPath$;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.RequiresMessageQueue;
import org.apache.pekko.dispatch.UnboundedMessageQueueSemantics;
import org.apache.pekko.dispatch.sysmsg.DeathWatchNotification$;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.dispatch.sysmsg.Watch$;
import org.apache.pekko.event.AddressTerminatedTopic;
import org.apache.pekko.event.AddressTerminatedTopic$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.AddressUidExtension;
import org.apache.pekko.remote.AddressUidExtension$;
import org.apache.pekko.remote.FailureDetectorRegistry;
import org.apache.pekko.remote.HeartbeatMessage;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.RemoteSettings;
import org.apache.pekko.remote.RemoteTransport;
import org.apache.pekko.remote.RemoteWatcher$;
import org.apache.pekko.remote.RemoteWatcher$ArteryHeartbeat$;
import org.apache.pekko.remote.RemoteWatcher$ArteryHeartbeatRsp$;
import org.apache.pekko.remote.RemoteWatcher$ExpectedFirstHeartbeat$;
import org.apache.pekko.remote.RemoteWatcher$Heartbeat$;
import org.apache.pekko.remote.RemoteWatcher$HeartbeatRsp$;
import org.apache.pekko.remote.RemoteWatcher$HeartbeatTick$;
import org.apache.pekko.remote.RemoteWatcher$ReapUnreachableTick$;
import org.apache.pekko.remote.RemoteWatcher$Stats$;
import org.apache.pekko.remote.RemoteWatcher$UnwatchRemote$;
import org.apache.pekko.remote.RemoteWatcher$WatchRemote$;
import org.apache.pekko.remote.artery.ArteryMessage;
import org.apache.pekko.remote.artery.ArteryTransport;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.MultiMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public class RemoteWatcher
implements Actor,
ActorLogging,
RequiresMessageQueue<UnboundedMessageQueueSemantics> {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private final FailureDetectorRegistry<Address> failureDetector;
    private final FiniteDuration heartbeatExpectedResponseAfter;
    private final RemoteActorRefProvider remoteProvider;
    private final boolean artery;
    private final HeartbeatMessage heartBeatMsg;
    private final HeartbeatMessage selfHeartbeatRspMsg;
    private final HashMap watching;
    private final HashMap watcheeByNodes;
    private scala.collection.immutable.Set unreachable;
    private Map addressUids;
    private final Cancellable heartbeatTask;
    private final Cancellable failureDetectorReaperTask;

    public static Props props(RemoteSettings remoteSettings, FailureDetectorRegistry<Address> failureDetectorRegistry) {
        return RemoteWatcher$.MODULE$.props(remoteSettings, failureDetectorRegistry);
    }

    public RemoteWatcher(FailureDetectorRegistry<Address> failureDetector, FiniteDuration heartbeatInterval, FiniteDuration unreachableReaperInterval, FiniteDuration heartbeatExpectedResponseAfter) {
        Tuple2 tuple2;
        this.failureDetector = failureDetector;
        this.heartbeatExpectedResponseAfter = heartbeatExpectedResponseAfter;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.remoteProvider = ((RARP)RARP$.MODULE$.apply(this.context().system())).provider();
        this.artery = this.remoteProvider().remoteSettings().Artery().Enabled();
        if (this.artery()) {
            tuple2 = Tuple2$.MODULE$.apply((Object)RemoteWatcher$ArteryHeartbeat$.MODULE$, (Object)RemoteWatcher$ArteryHeartbeatRsp$.MODULE$.apply(((AddressUidExtension)AddressUidExtension$.MODULE$.apply(this.context().system())).longAddressUid()));
        } else {
            int addressUid = ((AddressUidExtension)AddressUidExtension$.MODULE$.apply(this.context().system())).addressUid();
            tuple2 = Tuple2$.MODULE$.apply((Object)RemoteWatcher$Heartbeat$.MODULE$, (Object)RemoteWatcher$HeartbeatRsp$.MODULE$.apply(addressUid));
        }
        Tuple2 tuple22 = tuple2;
        this.heartBeatMsg = (HeartbeatMessage)tuple22._1();
        this.selfHeartbeatRspMsg = (HeartbeatMessage)tuple22._2();
        this.watching = new MultiMap<InternalActorRef, InternalActorRef>(){
            {
                MultiMap.$init$((MultiMap)this);
            }
        };
        this.watcheeByNodes = new MultiMap<Address, InternalActorRef>(){
            {
                MultiMap.$init$((MultiMap)this);
            }
        };
        this.unreachable = Predef$.MODULE$.Set().empty();
        this.addressUids = Predef$.MODULE$.Map().empty();
        this.heartbeatTask = this.scheduler().scheduleWithFixedDelay(heartbeatInterval, heartbeatInterval, this.self(), (Object)RemoteWatcher$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.failureDetectorReaperTask = this.scheduler().scheduleWithFixedDelay(unreachableReaperInterval, unreachableReaperInterval, this.self(), (Object)RemoteWatcher$ReapUnreachableTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public Scheduler scheduler() {
        return this.context().system().scheduler();
    }

    public RemoteActorRefProvider remoteProvider() {
        return this.remoteProvider;
    }

    public boolean artery() {
        return this.artery;
    }

    public HeartbeatMessage heartBeatMsg() {
        return this.heartBeatMsg;
    }

    public HeartbeatMessage selfHeartbeatRspMsg() {
        return this.selfHeartbeatRspMsg;
    }

    public HashMap<InternalActorRef, scala.collection.mutable.Set<InternalActorRef>> watching() {
        return this.watching;
    }

    public HashMap<Address, scala.collection.mutable.Set<InternalActorRef>> watcheeByNodes() {
        return this.watcheeByNodes;
    }

    public Set<Address> watchingNodes() {
        return this.watcheeByNodes().keySet();
    }

    public scala.collection.immutable.Set<Address> unreachable() {
        return this.unreachable;
    }

    public void unreachable_$eq(scala.collection.immutable.Set<Address> x$1) {
        this.unreachable = x$1;
    }

    public Map<Address, Object> addressUids() {
        return this.addressUids;
    }

    public void addressUids_$eq(Map<Address, Object> x$1) {
        this.addressUids = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    public Cancellable failureDetectorReaperTask() {
        return this.failureDetectorReaperTask;
    }

    public void postStop() {
        Actor.postStop$((Actor)this);
        this.heartbeatTask().cancel();
        this.failureDetectorReaperTask().cancel();
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ RemoteWatcher $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Terminated terminated;
                Terminated terminated2;
                ActorRef actorRef;
                Object object = x;
                if (RemoteWatcher$HeartbeatTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (RemoteWatcher$Heartbeat$.MODULE$.equals(object) || RemoteWatcher$ArteryHeartbeat$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof HeartbeatRsp) {
                    int n;
                    HeartbeatRsp heartbeatRsp = RemoteWatcher$HeartbeatRsp$.MODULE$.unapply((HeartbeatRsp)object);
                    int uid = n = heartbeatRsp._1();
                    return true;
                }
                if (object instanceof ArteryHeartbeatRsp) {
                    long l;
                    ArteryHeartbeatRsp arteryHeartbeatRsp = RemoteWatcher$ArteryHeartbeatRsp$.MODULE$.unapply((ArteryHeartbeatRsp)object);
                    long uid = l = arteryHeartbeatRsp._1();
                    return true;
                }
                if (RemoteWatcher$ReapUnreachableTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ExpectedFirstHeartbeat) {
                    Address address;
                    ExpectedFirstHeartbeat expectedFirstHeartbeat = RemoteWatcher$ExpectedFirstHeartbeat$.MODULE$.unapply((ExpectedFirstHeartbeat)object);
                    Address from = address = expectedFirstHeartbeat._1();
                    return true;
                }
                if (object instanceof WatchRemote) {
                    WatchRemote watchRemote = RemoteWatcher$WatchRemote$.MODULE$.unapply((WatchRemote)object);
                    InternalActorRef internalActorRef = watchRemote._1();
                    InternalActorRef internalActorRef2 = watchRemote._2();
                    InternalActorRef watchee = internalActorRef;
                    InternalActorRef watcher = internalActorRef2;
                    return true;
                }
                if (object instanceof UnwatchRemote) {
                    UnwatchRemote unwatchRemote = RemoteWatcher$UnwatchRemote$.MODULE$.unapply((UnwatchRemote)object);
                    InternalActorRef internalActorRef = unwatchRemote._1();
                    InternalActorRef internalActorRef3 = unwatchRemote._2();
                    InternalActorRef watchee = internalActorRef;
                    InternalActorRef watcher = internalActorRef3;
                    return true;
                }
                if (object instanceof Terminated && (actorRef = (terminated2 = Terminated$.MODULE$.unapply(terminated = (Terminated)object))._1()) instanceof InternalActorRef) {
                    InternalActorRef watchee = (InternalActorRef)actorRef;
                    Terminated t = terminated;
                    return true;
                }
                return RemoteWatcher$Stats$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Terminated terminated;
                Terminated terminated2;
                ActorRef actorRef;
                Object object = x;
                if (RemoteWatcher$HeartbeatTick$.MODULE$.equals(object)) {
                    this.$outer.sendHeartbeat();
                    return BoxedUnit.UNIT;
                }
                if (RemoteWatcher$Heartbeat$.MODULE$.equals(object) || RemoteWatcher$ArteryHeartbeat$.MODULE$.equals(object)) {
                    this.$outer.receiveHeartbeat();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof HeartbeatRsp) {
                    int n;
                    HeartbeatRsp heartbeatRsp = RemoteWatcher$HeartbeatRsp$.MODULE$.unapply((HeartbeatRsp)object);
                    int uid = n = heartbeatRsp._1();
                    this.$outer.receiveHeartbeatRsp(uid);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ArteryHeartbeatRsp) {
                    long l;
                    ArteryHeartbeatRsp arteryHeartbeatRsp = RemoteWatcher$ArteryHeartbeatRsp$.MODULE$.unapply((ArteryHeartbeatRsp)object);
                    long uid = l = arteryHeartbeatRsp._1();
                    this.$outer.receiveHeartbeatRsp(uid);
                    return BoxedUnit.UNIT;
                }
                if (RemoteWatcher$ReapUnreachableTick$.MODULE$.equals(object)) {
                    this.$outer.reapUnreachable();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ExpectedFirstHeartbeat) {
                    Address address;
                    ExpectedFirstHeartbeat expectedFirstHeartbeat = RemoteWatcher$ExpectedFirstHeartbeat$.MODULE$.unapply((ExpectedFirstHeartbeat)object);
                    Address from = address = expectedFirstHeartbeat._1();
                    this.$outer.triggerFirstHeartbeat(from);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof WatchRemote) {
                    WatchRemote watchRemote = RemoteWatcher$WatchRemote$.MODULE$.unapply((WatchRemote)object);
                    InternalActorRef internalActorRef = watchRemote._1();
                    InternalActorRef internalActorRef2 = watchRemote._2();
                    InternalActorRef watchee = internalActorRef;
                    InternalActorRef watcher = internalActorRef2;
                    this.$outer.addWatch(watchee, watcher);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof UnwatchRemote) {
                    UnwatchRemote unwatchRemote = RemoteWatcher$UnwatchRemote$.MODULE$.unapply((UnwatchRemote)object);
                    InternalActorRef internalActorRef = unwatchRemote._1();
                    InternalActorRef internalActorRef3 = unwatchRemote._2();
                    InternalActorRef watchee = internalActorRef;
                    InternalActorRef watcher = internalActorRef3;
                    this.$outer.removeWatch(watchee, watcher);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Terminated && (actorRef = (terminated2 = Terminated$.MODULE$.unapply(terminated = (Terminated)object))._1()) instanceof InternalActorRef) {
                    InternalActorRef watchee = (InternalActorRef)actorRef;
                    Terminated t = terminated;
                    this.$outer.terminated(watchee, t.existenceConfirmed(), t.addressTerminated());
                    return BoxedUnit.UNIT;
                }
                if (RemoteWatcher$Stats$.MODULE$.equals(object)) {
                    scala.collection.immutable.Set watchSet = this.$outer.watching().iterator().flatMap(RemoteWatcher::org$apache$pekko$remote$RemoteWatcher$$anon$3$$_$_$$anonfun$1).toSet();
                    this.$outer.sender().$bang((Object)RemoteWatcher$Stats$.MODULE$.apply(watchSet.size(), this.$outer.watchingNodes().size(), (scala.collection.immutable.Set<Tuple2<ActorRef, ActorRef>>)watchSet, (scala.collection.immutable.Set<Address>)this.$outer.watchingNodes().toSet()), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$remote$RemoteWatcher$$anon$3$$_$_$$anonfun$1(scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public void receiveHeartbeat() {
        this.sender().$bang((Object)this.selfHeartbeatRspMsg(), this.self());
    }

    public void receiveHeartbeatRsp(long uid) {
        Address from = this.sender().path().address();
        if (this.failureDetector.isMonitoring(from)) {
            this.log().debug("Received heartbeat rsp from [{}]", (Object)from);
        } else {
            this.log().debug("Received first heartbeat rsp from [{}]", (Object)from);
        }
        if (this.watcheeByNodes().contains((Object)from) && !this.unreachable().apply((Object)from)) {
            if (!this.addressUids().contains((Object)from) || BoxesRunTime.unboxToLong((Object)this.addressUids().apply((Object)from)) != uid) {
                this.reWatch(from);
            }
            Address address = (Address)Predef$.MODULE$.ArrowAssoc((Object)from);
            this.addressUids_$eq((Map<Address, Object>)((Map)this.addressUids().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)address, (Object)BoxesRunTime.boxToLong((long)uid)))));
            this.failureDetector.heartbeat(from);
            return;
        }
    }

    public void reapUnreachable() {
        this.watchingNodes().foreach((Function1)(JProcedure1 & Serializable)a -> {
            if (!this.unreachable().apply(a) && !this.failureDetector.isAvailable((Address)a)) {
                this.log().warning("Detected unreachable: [{}]", a);
                this.quarantine((Address)a, (Option<Object>)this.addressUids().get(a), "Deemed unreachable by remote failure detector", false);
                this.publishAddressTerminated((Address)a);
                this.unreachable_$eq((scala.collection.immutable.Set<Address>)((scala.collection.immutable.Set)this.unreachable().$plus(a)));
                return;
            }
        });
    }

    public void publishAddressTerminated(Address address) {
        this.log().debug("Publish AddressTerminated [{}]", (Object)address);
        ((AddressTerminatedTopic)AddressTerminatedTopic$.MODULE$.apply(this.context().system())).publish(AddressTerminated$.MODULE$.apply(address));
    }

    public void quarantine(Address address, Option<Object> uid, String reason, boolean harmless) {
        RemoteTransport remoteTransport = this.remoteProvider().transport();
        if (remoteTransport instanceof ArteryTransport) {
            ArteryTransport t = (ArteryTransport)remoteTransport;
            if (harmless) {
                t.quarantine(address, uid, reason, harmless);
                return;
            }
        }
        this.remoteProvider().quarantine(address, uid, reason);
    }

    public boolean shouldWatch(InternalActorRef watchee) {
        return this.remoteProvider().remoteSettings().UseUnsafeRemoteFeaturesWithoutCluster();
    }

    public void addWatch(InternalActorRef watchee, InternalActorRef watcher) {
        InternalActorRef internalActorRef = watcher;
        ActorRef actorRef = this.self();
        if (!(internalActorRef != null ? !internalActorRef.equals(actorRef) : actorRef != null)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.log().debug("Watching: [{} -> {}]", (Object)watcher, (Object)watchee);
        if (this.shouldWatch(watchee)) {
            ((MultiMap)this.watching()).addBinding((Object)watchee, (Object)watcher);
            this.watchNode(watchee);
            this.context().watch((ActorRef)watchee);
            return;
        }
        this.remoteProvider().warnIfUnsafeDeathwatchWithoutCluster((ActorRef)watchee, (ActorRef)watcher, "Watch");
    }

    public void watchNode(InternalActorRef watchee) {
        Address watcheeAddress = watchee.path().address();
        if (!this.watcheeByNodes().contains((Object)watcheeAddress) && this.unreachable().apply((Object)watcheeAddress)) {
            this.unreachable_$eq((scala.collection.immutable.Set<Address>)((scala.collection.immutable.Set)this.unreachable().$minus((Object)watcheeAddress)));
            this.failureDetector.remove(watcheeAddress);
        }
        ((MultiMap)this.watcheeByNodes()).addBinding((Object)watcheeAddress, (Object)watchee);
    }

    public void removeWatch(InternalActorRef watchee, InternalActorRef watcher) {
        InternalActorRef internalActorRef = watcher;
        ActorRef actorRef = this.self();
        if (!(internalActorRef != null ? !internalActorRef.equals(actorRef) : actorRef != null)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (this.shouldWatch(watchee)) {
            Option option = this.watching().get((Object)watchee);
            if (option instanceof Some) {
                scala.collection.mutable.Set watchers = (scala.collection.mutable.Set)((Some)option).value();
                watchers.$minus$eq((Object)watcher);
                if (watchers.isEmpty()) {
                    this.log().debug("Unwatching: [{} -> {}]", (Object)watcher, (Object)watchee);
                    this.log().debug("Cleanup self watch of [{}]", (Object)watchee.path());
                    this.context().unwatch((ActorRef)watchee);
                    this.removeWatchee(watchee);
                    return;
                }
                return;
            }
            if (None$.MODULE$.equals(option)) {
                return;
            }
            throw new MatchError((Object)option);
        }
        this.remoteProvider().warnIfUnsafeDeathwatchWithoutCluster((ActorRef)watchee, (ActorRef)watcher, "Unwatch");
    }

    public void removeWatchee(InternalActorRef watchee) {
        Address watcheeAddress = watchee.path().address();
        this.watching().$minus$eq((Object)watchee);
        Option option = this.watcheeByNodes().get((Object)watcheeAddress);
        if (option instanceof Some) {
            scala.collection.mutable.Set watchees = (scala.collection.mutable.Set)((Some)option).value();
            watchees.$minus$eq((Object)watchee);
            if (watchees.isEmpty()) {
                this.log().debug("Unwatched last watchee of node: [{}]", (Object)watcheeAddress);
                this.unwatchNode(watcheeAddress);
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    public void unwatchNode(Address watcheeAddress) {
        this.watcheeByNodes().$minus$eq((Object)watcheeAddress);
        this.addressUids_$eq((Map<Address, Object>)((Map)this.addressUids().$minus((Object)watcheeAddress)));
        this.failureDetector.remove(watcheeAddress);
    }

    public void terminated(InternalActorRef watchee, boolean existenceConfirmed, boolean addressTerminated) {
        this.log().debug("Watchee terminated: [{}]", (Object)watchee.path());
        if (!addressTerminated) {
            this.watching().get((Object)watchee).foreach((Function1)(JProcedure1 & Serializable)watchers -> watchers.foreach((Function1)(JProcedure1 & Serializable)watcher -> watcher.sendSystemMessage((SystemMessage)DeathWatchNotification$.MODULE$.apply((ActorRef)watchee, existenceConfirmed, addressTerminated))));
        }
        this.removeWatchee(watchee);
    }

    public void sendHeartbeat() {
        this.watchingNodes().foreach((Function1)(JProcedure1 & Serializable)a -> {
            if (!this.unreachable().apply(a)) {
                BoxedUnit boxedUnit;
                if (this.failureDetector.isMonitoring((Address)a)) {
                    this.log().debug("Sending Heartbeat to [{}]", a);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.log().debug("Sending first Heartbeat to [{}]", a);
                    boxedUnit = this.scheduler().scheduleOnce(this.heartbeatExpectedResponseAfter, this.self(), (Object)RemoteWatcher$ExpectedFirstHeartbeat$.MODULE$.apply((Address)a), (ExecutionContext)this.context().dispatcher(), this.self());
                }
                ActorSelection$.MODULE$.toScala(this.context().actorSelection(RootActorPath$.MODULE$.apply(a, RootActorPath$.MODULE$.$lessinit$greater$default$2()).$div((Iterable)this.self().path().elements()))).$bang((Object)this.heartBeatMsg(), this.self());
                return;
            }
        });
    }

    public void triggerFirstHeartbeat(Address address) {
        if (this.watcheeByNodes().contains((Object)address) && !this.failureDetector.isMonitoring(address)) {
            this.log().debug("Trigger extra expected heartbeat from [{}]", (Object)address);
            this.failureDetector.heartbeat(address);
            return;
        }
    }

    public void reWatch(Address address) {
        this.watcheeByNodes().get((Object)address).foreach((Function1)(JProcedure1 & Serializable)watchees -> watchees.foreach((Function1)(JProcedure1 & Serializable)watchee -> {
            InternalActorRef watcher = (InternalActorRef)this.self();
            this.log().debug("Re-watch [{} -> {}]", (Object)watcher.path(), (Object)watchee.path());
            watchee.sendSystemMessage((SystemMessage)Watch$.MODULE$.apply(watchee, watcher));
        }));
    }

    public static final /* synthetic */ IterableOnce org$apache$pekko$remote$RemoteWatcher$$anon$3$$_$_$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            InternalActorRef wee = (InternalActorRef)tuple2._1();
            scala.collection.mutable.Set wers = (scala.collection.mutable.Set)tuple2._2();
            return (scala.collection.mutable.Set)wers.map((Function1 & Serializable)wer -> {
                InternalActorRef internalActorRef = (InternalActorRef)Predef$.MODULE$.ArrowAssoc((Object)wee);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)internalActorRef, wer);
            });
        }
        throw new MatchError((Object)tuple2);
    }

    public static final class ArteryHeartbeatRsp
    implements HeartbeatMessage,
    ArteryMessage,
    Product {
        private final long uid;

        public static ArteryHeartbeatRsp apply(long l) {
            return RemoteWatcher$ArteryHeartbeatRsp$.MODULE$.apply(l);
        }

        public static ArteryHeartbeatRsp fromProduct(Product product) {
            return RemoteWatcher$ArteryHeartbeatRsp$.MODULE$.fromProduct(product);
        }

        public static ArteryHeartbeatRsp unapply(ArteryHeartbeatRsp arteryHeartbeatRsp) {
            return RemoteWatcher$ArteryHeartbeatRsp$.MODULE$.unapply(arteryHeartbeatRsp);
        }

        public ArteryHeartbeatRsp(long uid) {
            this.uid = uid;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.uid()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ArteryHeartbeatRsp)) return false;
            ArteryHeartbeatRsp arteryHeartbeatRsp = (ArteryHeartbeatRsp)object;
            if (this.uid() != arteryHeartbeatRsp.uid()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ArteryHeartbeatRsp;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ArteryHeartbeatRsp";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "uid";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long uid() {
            return this.uid;
        }

        public ArteryHeartbeatRsp copy(long uid) {
            return new ArteryHeartbeatRsp(uid);
        }

        public long copy$default$1() {
            return this.uid();
        }

        public long _1() {
            return this.uid();
        }
    }

    public static final class ExpectedFirstHeartbeat
    implements Product,
    Serializable {
        private final Address from;

        public static ExpectedFirstHeartbeat apply(Address address) {
            return RemoteWatcher$ExpectedFirstHeartbeat$.MODULE$.apply(address);
        }

        public static ExpectedFirstHeartbeat fromProduct(Product product) {
            return RemoteWatcher$ExpectedFirstHeartbeat$.MODULE$.fromProduct(product);
        }

        public static ExpectedFirstHeartbeat unapply(ExpectedFirstHeartbeat expectedFirstHeartbeat) {
            return RemoteWatcher$ExpectedFirstHeartbeat$.MODULE$.unapply(expectedFirstHeartbeat);
        }

        public ExpectedFirstHeartbeat(Address from) {
            this.from = from;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ExpectedFirstHeartbeat)) return false;
            ExpectedFirstHeartbeat expectedFirstHeartbeat = (ExpectedFirstHeartbeat)object;
            Address address = this.from();
            Address address2 = expectedFirstHeartbeat.from();
            if (address != null) {
                if (!address.equals(address2)) return false;
                return true;
            }
            if (address2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ExpectedFirstHeartbeat;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ExpectedFirstHeartbeat";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "from";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address from() {
            return this.from;
        }

        public ExpectedFirstHeartbeat copy(Address from) {
            return new ExpectedFirstHeartbeat(from);
        }

        public Address copy$default$1() {
            return this.from();
        }

        public Address _1() {
            return this.from();
        }
    }

    public static final class HeartbeatRsp
    implements HeartbeatMessage,
    Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int addressUid;

        public static HeartbeatRsp apply(int n) {
            return RemoteWatcher$HeartbeatRsp$.MODULE$.apply(n);
        }

        public static HeartbeatRsp fromProduct(Product product) {
            return RemoteWatcher$HeartbeatRsp$.MODULE$.fromProduct(product);
        }

        public static HeartbeatRsp unapply(HeartbeatRsp heartbeatRsp) {
            return RemoteWatcher$HeartbeatRsp$.MODULE$.unapply(heartbeatRsp);
        }

        public HeartbeatRsp(int addressUid) {
            this.addressUid = addressUid;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.addressUid());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HeartbeatRsp)) return false;
            HeartbeatRsp heartbeatRsp = (HeartbeatRsp)object;
            if (this.addressUid() != heartbeatRsp.addressUid()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof HeartbeatRsp;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "HeartbeatRsp";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "addressUid";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int addressUid() {
            return this.addressUid;
        }

        public HeartbeatRsp copy(int addressUid) {
            return new HeartbeatRsp(addressUid);
        }

        public int copy$default$1() {
            return this.addressUid();
        }

        public int _1() {
            return this.addressUid();
        }
    }

    public static final class Stats
    implements Product,
    Serializable {
        private final int watching;
        private final int watchingNodes;
        private final scala.collection.immutable.Set watchingRefs;
        private final scala.collection.immutable.Set watchingAddresses;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RemoteWatcher$Stats$.class.getDeclaredField("empty$lzy1"));

        public static Stats apply(int n, int n2, scala.collection.immutable.Set<Tuple2<ActorRef, ActorRef>> set, scala.collection.immutable.Set<Address> set2) {
            return RemoteWatcher$Stats$.MODULE$.apply(n, n2, set, set2);
        }

        public static Stats counts(int n, int n2) {
            return RemoteWatcher$Stats$.MODULE$.counts(n, n2);
        }

        public static Stats empty() {
            return RemoteWatcher$Stats$.MODULE$.empty();
        }

        public static Stats unapply(Stats stats) {
            return RemoteWatcher$Stats$.MODULE$.unapply(stats);
        }

        public Stats(int watching, int watchingNodes, scala.collection.immutable.Set<Tuple2<ActorRef, ActorRef>> watchingRefs, scala.collection.immutable.Set<Address> watchingAddresses) {
            this.watching = watching;
            this.watchingNodes = watchingNodes;
            this.watchingRefs = watchingRefs;
            this.watchingAddresses = watchingAddresses;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.watching());
            n = Statics.mix((int)n, (int)this.watchingNodes());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Stats)) return false;
            Stats stats = (Stats)object;
            if (this.watching() != stats.watching()) return false;
            if (this.watchingNodes() != stats.watchingNodes()) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Stats;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Stats";
        }

        public Object productElement(int n) {
            int n2;
            int n3 = n;
            if (0 == n3) {
                n2 = this._1();
            } else if (1 == n3) {
                n2 = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)n2);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "watching";
            }
            if (1 == n2) {
                return "watchingNodes";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int watching() {
            return this.watching;
        }

        public int watchingNodes() {
            return this.watchingNodes;
        }

        public scala.collection.immutable.Set<Tuple2<ActorRef, ActorRef>> watchingRefs() {
            return this.watchingRefs;
        }

        public scala.collection.immutable.Set<Address> watchingAddresses() {
            return this.watchingAddresses;
        }

        public String toString() {
            return new StringBuilder(67).append("Stats(watching=").append(this.watching()).append(", watchingNodes=").append(this.watchingNodes()).append(", watchingRefs=").append(this.formatWatchingRefs$1()).append(", watchingAddresses=").append(this.formatWatchingAddresses$1()).append(")").toString();
        }

        public Stats copy(int watching, int watchingNodes, scala.collection.immutable.Set<Tuple2<ActorRef, ActorRef>> watchingRefs, scala.collection.immutable.Set<Address> watchingAddresses) {
            return new Stats(watching, watchingNodes, watchingRefs, watchingAddresses);
        }

        public int copy$default$1() {
            return this.watching();
        }

        public int copy$default$2() {
            return this.watchingNodes();
        }

        public int _1() {
            return this.watching();
        }

        public int _2() {
            return this.watchingNodes();
        }

        private final String formatWatchingRefs$1() {
            return ((IterableOnceOps)this.watchingRefs().map(RemoteWatcher$::org$apache$pekko$remote$RemoteWatcher$Stats$$_$formatWatchingRefs$1$$anonfun$1)).mkString("[", ", ", "]");
        }

        private final String formatWatchingAddresses$1() {
            return this.watchingAddresses().mkString("[", ", ", "]");
        }
    }

    public static final class UnwatchRemote
    implements Product,
    Serializable {
        private final InternalActorRef watchee;
        private final InternalActorRef watcher;

        public static UnwatchRemote apply(InternalActorRef internalActorRef, InternalActorRef internalActorRef2) {
            return RemoteWatcher$UnwatchRemote$.MODULE$.apply(internalActorRef, internalActorRef2);
        }

        public static UnwatchRemote fromProduct(Product product) {
            return RemoteWatcher$UnwatchRemote$.MODULE$.fromProduct(product);
        }

        public static UnwatchRemote unapply(UnwatchRemote unwatchRemote) {
            return RemoteWatcher$UnwatchRemote$.MODULE$.unapply(unwatchRemote);
        }

        public UnwatchRemote(InternalActorRef watchee, InternalActorRef watcher) {
            this.watchee = watchee;
            this.watcher = watcher;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnwatchRemote)) return false;
            UnwatchRemote unwatchRemote = (UnwatchRemote)object;
            InternalActorRef internalActorRef = this.watchee();
            InternalActorRef internalActorRef2 = unwatchRemote.watchee();
            if (internalActorRef == null) {
                if (internalActorRef2 != null) {
                    return false;
                }
            } else if (!internalActorRef.equals(internalActorRef2)) return false;
            InternalActorRef internalActorRef3 = this.watcher();
            InternalActorRef internalActorRef4 = unwatchRemote.watcher();
            if (internalActorRef3 == null) {
                if (internalActorRef4 == null) return true;
                return false;
            } else {
                if (!internalActorRef3.equals(internalActorRef4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UnwatchRemote;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "UnwatchRemote";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "watchee";
            }
            if (1 == n2) {
                return "watcher";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public InternalActorRef watchee() {
            return this.watchee;
        }

        public InternalActorRef watcher() {
            return this.watcher;
        }

        public UnwatchRemote copy(InternalActorRef watchee, InternalActorRef watcher) {
            return new UnwatchRemote(watchee, watcher);
        }

        public InternalActorRef copy$default$1() {
            return this.watchee();
        }

        public InternalActorRef copy$default$2() {
            return this.watcher();
        }

        public InternalActorRef _1() {
            return this.watchee();
        }

        public InternalActorRef _2() {
            return this.watcher();
        }
    }

    public static final class WatchRemote
    implements Product,
    Serializable {
        private final InternalActorRef watchee;
        private final InternalActorRef watcher;

        public static WatchRemote apply(InternalActorRef internalActorRef, InternalActorRef internalActorRef2) {
            return RemoteWatcher$WatchRemote$.MODULE$.apply(internalActorRef, internalActorRef2);
        }

        public static WatchRemote fromProduct(Product product) {
            return RemoteWatcher$WatchRemote$.MODULE$.fromProduct(product);
        }

        public static WatchRemote unapply(WatchRemote watchRemote) {
            return RemoteWatcher$WatchRemote$.MODULE$.unapply(watchRemote);
        }

        public WatchRemote(InternalActorRef watchee, InternalActorRef watcher) {
            this.watchee = watchee;
            this.watcher = watcher;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WatchRemote)) return false;
            WatchRemote watchRemote = (WatchRemote)object;
            InternalActorRef internalActorRef = this.watchee();
            InternalActorRef internalActorRef2 = watchRemote.watchee();
            if (internalActorRef == null) {
                if (internalActorRef2 != null) {
                    return false;
                }
            } else if (!internalActorRef.equals(internalActorRef2)) return false;
            InternalActorRef internalActorRef3 = this.watcher();
            InternalActorRef internalActorRef4 = watchRemote.watcher();
            if (internalActorRef3 == null) {
                if (internalActorRef4 == null) return true;
                return false;
            } else {
                if (!internalActorRef3.equals(internalActorRef4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WatchRemote;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "WatchRemote";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "watchee";
            }
            if (1 == n2) {
                return "watcher";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public InternalActorRef watchee() {
            return this.watchee;
        }

        public InternalActorRef watcher() {
            return this.watcher;
        }

        public WatchRemote copy(InternalActorRef watchee, InternalActorRef watcher) {
            return new WatchRemote(watchee, watcher);
        }

        public InternalActorRef copy$default$1() {
            return this.watchee();
        }

        public InternalActorRef copy$default$2() {
            return this.watcher();
        }

        public InternalActorRef _1() {
            return this.watchee();
        }

        public InternalActorRef _2() {
            return this.watcher();
        }
    }
}

