/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.Actor$;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.OneForOneStrategy$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.dispatch.RequiresMessageQueue;
import org.apache.pekko.dispatch.UnboundedMessageQueueSemantics;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.LoggingBus;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.remote.EndpointManager;
import org.apache.pekko.remote.EndpointManager$Listen$;
import org.apache.pekko.remote.EndpointManager$ManagementCommand$;
import org.apache.pekko.remote.EndpointManager$ManagementCommandAck$;
import org.apache.pekko.remote.EndpointManager$Quarantine$;
import org.apache.pekko.remote.EndpointManager$Send$;
import org.apache.pekko.remote.EndpointManager$ShutdownAndFlush$;
import org.apache.pekko.remote.EndpointManager$StartupFinished$;
import org.apache.pekko.remote.EventPublisher;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.RemoteActorRef;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.RemoteTransport;
import org.apache.pekko.remote.RemoteTransportException;
import org.apache.pekko.remote.RemoteTransportExceptionNoStackTrace;
import org.apache.pekko.remote.Remoting$;
import org.apache.pekko.remote.Remoting$RegisterTransportActor$;
import org.apache.pekko.remote.RemotingErrorEvent$;
import org.apache.pekko.remote.RemotingListenEvent$;
import org.apache.pekko.remote.RemotingShutdownEvent$;
import org.apache.pekko.remote.transport.PekkoProtocolTransport;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.Timeout;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class Remoting
extends RemoteTransport {
    private volatile Option<ActorRef> endpointManager = None$.MODULE$;
    private volatile Map<String, Set<Tuple2<PekkoProtocolTransport, Address>>> transportMapping;
    private volatile Set addresses;
    private volatile Address defaultAddress;
    private final MessageDispatcher ec = this.system().dispatchers().lookup(this.provider().remoteSettings().Dispatcher());
    private final ActorRef transportSupervisor = this.system().systemActorOf(this.provider().remoteSettings().configureDispatcher(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(TransportSupervisor.class))), "transports");
    private final LoggingAdapter log = Logging$.MODULE$.apply((LoggingBus)this.system().eventStream(), Remoting.class, LogSource$.MODULE$.fromAnyClass());
    private final EventPublisher eventPublisher = new EventPublisher((ActorSystem)this.system(), this.log(), this.provider().remoteSettings().RemoteLifecycleEventsLogLevel());

    public static String EndpointManagerName() {
        return Remoting$.MODULE$.EndpointManagerName();
    }

    public Remoting(ExtendedActorSystem _system, RemoteActorRefProvider _provider) {
        super(_system, _provider);
    }

    @Override
    public Set<Address> addresses() {
        return this.addresses;
    }

    public void addresses_$eq(Set<Address> x$1) {
        this.addresses = x$1;
    }

    @Override
    public Address defaultAddress() {
        return this.defaultAddress;
    }

    public void defaultAddress_$eq(Address x$1) {
        this.defaultAddress = x$1;
    }

    public ActorRef transportSupervisor() {
        return this.transportSupervisor;
    }

    @Override
    public Address localAddressForRemote(Address remote) {
        return Remoting$.MODULE$.localAddressForRemote(this.transportMapping, remote);
    }

    @Override
    public LoggingAdapter log() {
        return this.log;
    }

    public EventPublisher eventPublisher() {
        return this.eventPublisher;
    }

    public void org$apache$pekko$remote$Remoting$$notifyError(String msg, Throwable cause) {
        this.eventPublisher().notifyListeners(RemotingErrorEvent$.MODULE$.apply((Throwable)((Object)new RemoteTransportException(msg, cause))));
    }

    @Override
    public Future<Done> shutdown() {
        Option<ActorRef> option = this.endpointManager;
        if (option instanceof Some) {
            ActorRef manager = (ActorRef)((Some)option).value();
            Timeout timeout = this.provider().remoteSettings().ShutdownTimeout();
            ActorRef actorRef = package$.MODULE$.ask(manager);
            return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)EndpointManager$ShutdownAndFlush$.MODULE$, timeout, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)EndpointManager$ShutdownAndFlush$.MODULE$)).mapTo(ClassTag$.MODULE$.apply(Boolean.TYPE)).andThen((PartialFunction)new Serializable(this){
                private final /* synthetic */ Remoting $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Try x) {
                    Try try_ = x;
                    if (try_ instanceof Success) {
                        boolean flushSuccessful = BoxesRunTime.unboxToBoolean((Object)((Success)try_).value());
                        return true;
                    }
                    if (try_ instanceof Failure) {
                        Throwable e = ((Failure)try_).exception();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Try try_ = x;
                    if (try_ instanceof Success) {
                        boolean flushSuccessful = BoxesRunTime.unboxToBoolean((Object)((Success)try_).value());
                        if (!flushSuccessful) {
                            this.$outer.log().warning("Shutdown finished, but flushing might not have been successful and some messages might have been dropped. Increase pekko.remote.flush-wait-on-shutdown to a larger value to avoid this.");
                        }
                        this.$outer.org$apache$pekko$remote$Remoting$$_$finalize$1();
                        return BoxedUnit.UNIT;
                    }
                    if (try_ instanceof Failure) {
                        Throwable e = ((Failure)try_).exception();
                        this.$outer.org$apache$pekko$remote$Remoting$$notifyError("Failure during shutdown of remoting.", e);
                        this.$outer.org$apache$pekko$remote$Remoting$$_$finalize$1();
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply((Object)x);
                }
            }, (ExecutionContext)this.ec).map((Function1 & Serializable)_$4 -> Remoting.shutdown$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)_$4)), (ExecutionContext)this.ec);
        }
        if (None$.MODULE$.equals(option)) {
            this.log().warning("Remoting is not running. Ignoring shutdown attempt.");
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        throw new MatchError(option);
    }

    @Override
    public void start() {
        Option<ActorRef> option = this.endpointManager;
        if (None$.MODULE$.equals(option)) {
            this.log().info("Starting remoting");
            ActorRef manager = this.system().systemActorOf(this.provider().remoteSettings().configureDispatcher(Props$.MODULE$.apply(EndpointManager.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.provider().remoteSettings().config(), this.log()}))).withDeploy(Deploy$.MODULE$.local()), "endpointManager");
            this.endpointManager = Some$.MODULE$.apply((Object)manager);
            try {
                Promise addressesPromise = Promise$.MODULE$.apply();
                EndpointManager.Listen listen = EndpointManager$Listen$.MODULE$.apply((Promise<Seq<Tuple2<PekkoProtocolTransport, Address>>>)addressesPromise);
                manager.$bang((Object)listen, manager.$bang$default$2((Object)listen));
                Seq transports = (Seq)Await$.MODULE$.result((Awaitable)addressesPromise.future(), (Duration)this.provider().remoteSettings().StartupTimeout().duration());
                if (transports.isEmpty()) {
                    throw new RemoteTransportException("No transport drivers were loaded.", null);
                }
                Map mapping = (Map)transports.groupBy((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        PekkoProtocolTransport transport = (PekkoProtocolTransport)tuple2._1();
                        return transport.schemeIdentifier();
                    }
                    throw new MatchError((Object)tuple2);
                }).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Seq v = (Seq)tuple2._2();
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v.toSet());
                    }
                    throw new MatchError((Object)tuple2);
                });
                this.transportMapping = this.addProtocolsToMap((Map<String, Set<Tuple2<PekkoProtocolTransport, Address>>>)mapping);
                this.defaultAddress_$eq((Address)((Tuple2)transports.head())._2());
                this.addresses_$eq((Set<Address>)((IterableOnceOps)transports.map((Function1 & Serializable)_$5 -> (Address)_$5._2())).toSet());
                this.log().info(new StringBuilder(42).append("Remoting started; listening on addresses :").append(this.addresses().mkString("[", ", ", "]")).toString());
                manager.$bang((Object)EndpointManager$StartupFinished$.MODULE$, manager.$bang$default$2((Object)EndpointManager$StartupFinished$.MODULE$));
                this.eventPublisher().notifyListeners(RemotingListenEvent$.MODULE$.apply(this.addresses()));
            }
            catch (TimeoutException e) {
                this.org$apache$pekko$remote$Remoting$$notifyError("Startup timed out. This is usually related to actor system host setting or host name resolution misconfiguration.", e);
                throw e;
            }
            catch (Throwable throwable) {
                Option option2;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option2.get();
                    this.org$apache$pekko$remote$Remoting$$notifyError("Startup failed", e);
                    throw e;
                }
                throw throwable;
            }
            return;
        }
        if (option instanceof Some) {
            this.log().warning("Remoting was already started. Ignoring start attempt.");
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void send(Object message, ActorRef senderOption, RemoteActorRef recipient) {
        Option<ActorRef> option = this.endpointManager;
        if (option instanceof Some) {
            ActorRef manager = (ActorRef)((Some)option).value();
            manager.tell((Object)EndpointManager$Send$.MODULE$.apply(message, senderOption, recipient, EndpointManager$Send$.MODULE$.$lessinit$greater$default$4()), (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)senderOption, (Object)Actor$.MODULE$.noSender()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new RemoteTransportExceptionNoStackTrace("Attempted to send remote message but Remoting is not running.", null);
        }
        throw new MatchError(option);
    }

    @Override
    public Future<Object> managementCommand(Object cmd) {
        Option<ActorRef> option = this.endpointManager;
        if (option instanceof Some) {
            ActorRef manager = (ActorRef)((Some)option).value();
            Timeout timeout = this.provider().remoteSettings().CommandAckTimeout();
            ActorRef actorRef = package$.MODULE$.ask(manager);
            EndpointManager.ManagementCommand managementCommand = EndpointManager$ManagementCommand$.MODULE$.apply(cmd);
            return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)managementCommand, timeout, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)managementCommand)).map((Function1 & Serializable)x$1 -> {
                Object object = x$1;
                if (object instanceof EndpointManager.ManagementCommandAck) {
                    boolean bl;
                    EndpointManager.ManagementCommandAck managementCommandAck = EndpointManager$ManagementCommandAck$.MODULE$.unapply((EndpointManager.ManagementCommandAck)object);
                    boolean status = bl = managementCommandAck._1();
                    return status;
                }
                Object unexpected = object;
                throw new IllegalArgumentException(new StringBuilder(26).append("Unexpected response type: ").append(unexpected.getClass()).toString());
            }, (ExecutionContext)this.ec);
        }
        if (None$.MODULE$.equals(option)) {
            throw new RemoteTransportExceptionNoStackTrace("Attempted to send management command but Remoting is not running.", null);
        }
        throw new MatchError(option);
    }

    @Override
    public void quarantine(Address remoteAddress, Option<Object> uid, String reason) {
        Option<ActorRef> option = this.endpointManager;
        if (option instanceof Some) {
            ActorRef manager = (ActorRef)((Some)option).value();
            EndpointManager.Quarantine quarantine = EndpointManager$Quarantine$.MODULE$.apply(remoteAddress, (Option<Object>)uid.map((Function1)(JFunction1.mcIJ.sp & Serializable)_$6 -> (int)_$6));
            manager.$bang((Object)quarantine, manager.$bang$default$2((Object)quarantine));
            return;
        }
        throw new RemoteTransportExceptionNoStackTrace(new StringBuilder(74).append("Attempted to quarantine address [").append(remoteAddress).append("] with UID [").append(uid).append("] but Remoting is not running").toString(), null);
    }

    public Map<String, Set<Address>> boundAddresses() {
        return (Map)this.transportMapping.map((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                String scheme = (String)tuple2._1();
                Set transports = (Set)tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)scheme);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, transports.flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        PekkoProtocolTransport t = (PekkoProtocolTransport)tuple2._1();
                        return Option$.MODULE$.apply((Object)t.boundAddress());
                    }
                    throw new MatchError((Object)tuple2);
                }));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Map<String, Set<Tuple2<PekkoProtocolTransport, Address>>> addProtocolsToMap(Map<String, Set<Tuple2<PekkoProtocolTransport, Address>>> map) {
        if (this.provider().remoteSettings().AcceptProtocolNames().size() > 1) {
            return (Map)map.flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String protocol = (String)tuple2._1();
                    Set transports = (Set)tuple2._2();
                    boolean tcpProtocol = protocol.endsWith(".tcp");
                    return (Set)this.provider().remoteSettings().AcceptProtocolNames().map((Function1 & Serializable)newProtocol -> {
                        if (tcpProtocol) {
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(4).append((String)newProtocol).append(".tcp").toString());
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)transports);
                        }
                        String string = (String)Predef$.MODULE$.ArrowAssoc(newProtocol);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)transports);
                    });
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return map;
    }

    public final void org$apache$pekko$remote$Remoting$$_$finalize$1() {
        this.eventPublisher().notifyListeners(RemotingShutdownEvent$.MODULE$);
        this.endpointManager = None$.MODULE$;
    }

    private static final /* synthetic */ Done$ shutdown$$anonfun$1(boolean _$4) {
        return Done$.MODULE$;
    }

    public static final class RegisterTransportActor
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final Props props;
        private final String name;

        public static RegisterTransportActor apply(Props props, String string) {
            return Remoting$RegisterTransportActor$.MODULE$.apply(props, string);
        }

        public static RegisterTransportActor fromProduct(Product product) {
            return Remoting$RegisterTransportActor$.MODULE$.fromProduct(product);
        }

        public static RegisterTransportActor unapply(RegisterTransportActor registerTransportActor) {
            return Remoting$RegisterTransportActor$.MODULE$.unapply(registerTransportActor);
        }

        public RegisterTransportActor(Props props, String name) {
            this.props = props;
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RegisterTransportActor)) return false;
            RegisterTransportActor registerTransportActor = (RegisterTransportActor)object;
            Props props = this.props();
            Props props2 = registerTransportActor.props();
            if (props == null) {
                if (props2 != null) {
                    return false;
                }
            } else if (!props.equals(props2)) return false;
            String string = this.name();
            String string2 = registerTransportActor.name();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RegisterTransportActor;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RegisterTransportActor";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "props";
            }
            if (1 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Props props() {
            return this.props;
        }

        public String name() {
            return this.name;
        }

        public RegisterTransportActor copy(Props props, String name) {
            return new RegisterTransportActor(props, name);
        }

        public Props copy$default$1() {
            return this.props();
        }

        public String copy$default$2() {
            return this.name();
        }

        public Props _1() {
            return this.props();
        }

        public String _2() {
            return this.name();
        }
    }

    public static class TransportSupervisor
    implements Actor,
    RequiresMessageQueue<UnboundedMessageQueueSemantics> {
        private ActorContext context;
        private ActorRef self;

        public TransportSupervisor() {
            Actor.$init$((Actor)this);
            Statics.releaseFence();
        }

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
            this.context = x$0;
        }

        public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
            this.self = x$0;
        }

        public SupervisorStrategy supervisorStrategy() {
            return OneForOneStrategy$.MODULE$.apply(OneForOneStrategy$.MODULE$.$lessinit$greater$default$1(), OneForOneStrategy$.MODULE$.$lessinit$greater$default$2(), OneForOneStrategy$.MODULE$.$lessinit$greater$default$3(), (PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Option option;
                    Throwable throwable = x;
                    if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                        Throwable throwable2 = (Throwable)option.get();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Option option;
                    Throwable throwable = x;
                    if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                        Throwable throwable2 = (Throwable)option.get();
                        return SupervisorStrategy.Restart$.MODULE$;
                    }
                    return function1.apply((Object)x);
                }
            });
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                private final /* synthetic */ TransportSupervisor $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Object x) {
                    Object object = x;
                    if (object instanceof RegisterTransportActor) {
                        RegisterTransportActor registerTransportActor = Remoting$RegisterTransportActor$.MODULE$.unapply((RegisterTransportActor)object);
                        Props props = registerTransportActor._1();
                        String string = registerTransportActor._2();
                        Props props2 = props;
                        String name = string;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Object object = x;
                    if (object instanceof RegisterTransportActor) {
                        RegisterTransportActor registerTransportActor = Remoting$RegisterTransportActor$.MODULE$.unapply((RegisterTransportActor)object);
                        Props props = registerTransportActor._1();
                        String string = registerTransportActor._2();
                        Props props2 = props;
                        String name = string;
                        this.$outer.sender().$bang((Object)this.$outer.context().actorOf(((RARP)RARP$.MODULE$.apply(this.$outer.context().system())).configureDispatcher(props2.withDeploy(Deploy$.MODULE$.local())), name), this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply(x);
                }
            };
        }
    }
}

