/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.NotUsed;
import org.apache.pekko.NotUsed$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRef$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.actor.Dropped$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.AddressUidExtension;
import org.apache.pekko.remote.AddressUidExtension$;
import org.apache.pekko.remote.RemoteActorRef;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.RemoteTransport;
import org.apache.pekko.remote.UniqueAddress;
import org.apache.pekko.remote.UniqueAddress$;
import org.apache.pekko.remote.artery.ActorSystemTerminating;
import org.apache.pekko.remote.artery.ActorSystemTerminating$;
import org.apache.pekko.remote.artery.ActorSystemTerminatingAck$;
import org.apache.pekko.remote.artery.ArterySettings;
import org.apache.pekko.remote.artery.ArteryTransport$;
import org.apache.pekko.remote.artery.ArteryTransport$InboundStreamMatValues$;
import org.apache.pekko.remote.artery.ArteryTransport$ShutdownSignal$;
import org.apache.pekko.remote.artery.ArteryTransport$ShuttingDown$;
import org.apache.pekko.remote.artery.Association;
import org.apache.pekko.remote.artery.AssociationRegistry;
import org.apache.pekko.remote.artery.ControlMessage;
import org.apache.pekko.remote.artery.Decoder;
import org.apache.pekko.remote.artery.Deserializer;
import org.apache.pekko.remote.artery.Encoder;
import org.apache.pekko.remote.artery.EnvelopeBuffer;
import org.apache.pekko.remote.artery.EnvelopeBufferPool;
import org.apache.pekko.remote.artery.Flush$;
import org.apache.pekko.remote.artery.FlushAck$;
import org.apache.pekko.remote.artery.FlushOnShutdown$;
import org.apache.pekko.remote.artery.InboundContext;
import org.apache.pekko.remote.artery.InboundControlJunction;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.InboundHandshake;
import org.apache.pekko.remote.artery.InboundQuarantineCheck;
import org.apache.pekko.remote.artery.InboundTestStage;
import org.apache.pekko.remote.artery.MessageDispatcher;
import org.apache.pekko.remote.artery.ObjectPool;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.OutboundControlJunction;
import org.apache.pekko.remote.artery.OutboundEnvelope;
import org.apache.pekko.remote.artery.OutboundHandshake;
import org.apache.pekko.remote.artery.OutboundTestStage;
import org.apache.pekko.remote.artery.Quarantined;
import org.apache.pekko.remote.artery.Quarantined$;
import org.apache.pekko.remote.artery.RemotingFlightRecorder;
import org.apache.pekko.remote.artery.RemotingFlightRecorder$;
import org.apache.pekko.remote.artery.RestartCounter;
import org.apache.pekko.remote.artery.ReusableInboundEnvelope;
import org.apache.pekko.remote.artery.ReusableInboundEnvelope$;
import org.apache.pekko.remote.artery.ReusableOutboundEnvelope;
import org.apache.pekko.remote.artery.ReusableOutboundEnvelope$;
import org.apache.pekko.remote.artery.SharedTestState;
import org.apache.pekko.remote.artery.SystemMessageAcker;
import org.apache.pekko.remote.artery.SystemMessageDelivery;
import org.apache.pekko.remote.artery.TestManagementCommands;
import org.apache.pekko.remote.artery.TestManagementCommands$FailInboundStreamOnce$;
import org.apache.pekko.remote.artery.ThisActorSystemQuarantinedEvent;
import org.apache.pekko.remote.artery.ThisActorSystemQuarantinedEvent$;
import org.apache.pekko.remote.artery.compress.CompressionProtocol;
import org.apache.pekko.remote.artery.compress.CompressionProtocol$ActorRefCompressionAdvertisement$;
import org.apache.pekko.remote.artery.compress.CompressionProtocol$ActorRefCompressionAdvertisementAck$;
import org.apache.pekko.remote.artery.compress.CompressionProtocol$ClassManifestCompressionAdvertisement$;
import org.apache.pekko.remote.artery.compress.CompressionProtocol$ClassManifestCompressionAdvertisementAck$;
import org.apache.pekko.remote.artery.compress.CompressionProtocol$Events$ReceivedActorRefCompressionTable$;
import org.apache.pekko.remote.artery.compress.CompressionProtocol$Events$ReceivedClassManifestCompressionTable$;
import org.apache.pekko.remote.artery.compress.CompressionTable;
import org.apache.pekko.remote.artery.compress.InboundCompressions;
import org.apache.pekko.remote.artery.compress.InboundCompressionsImpl;
import org.apache.pekko.remote.artery.compress.NoInboundCompressions$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$Blackhole$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$SetThrottle$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$Unthrottled$;
import org.apache.pekko.stream.AbruptTerminationException;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.KillSwitches$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.SharedKillSwitch;
import org.apache.pekko.stream.SystemMaterializer;
import org.apache.pekko.stream.SystemMaterializer$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Sink;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.WildcardIndex;
import org.apache.pekko.util.WildcardIndex$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.Try$;

public abstract class ArteryTransport
extends RemoteTransport
implements InboundContext {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ArteryTransport.class.getDeclaredField("shutdownHook$lzy1"));
    private volatile UniqueAddress _localAddress;
    private volatile UniqueAddress _bindAddress;
    private volatile Set<Address> _addresses;
    private volatile Materializer materializer;
    private volatile Materializer controlMaterializer;
    private volatile InboundControlJunction.ControlMessageSubject controlSubject;
    private volatile MessageDispatcher messageDispatcher;
    private final MarkerLoggingAdapter log = Logging$.MODULE$.withMarker((ActorSystem)this.system(), ArteryTransport.class, LogSource$.MODULE$.fromAnyClass());
    private final RemotingFlightRecorder flightRecorder = (RemotingFlightRecorder)RemotingFlightRecorder$.MODULE$.apply((ActorSystem)this.system());
    private final InboundCompressions _inboundCompressions;
    private volatile Decoder.InboundCompressionAccess _inboundCompressionAccess;
    private final SharedKillSwitch killSwitch;
    private final AtomicReference streamMatValues;
    public final AtomicBoolean org$apache$pekko$remote$artery$ArteryTransport$$hasBeenShutdown;
    private final SharedTestState testState;
    private final int inboundLanes;
    private final boolean largeMessageChannelEnabled;
    private final WildcardIndex<NotUsed> priorityMessageDestinations;
    private final RestartCounter restartCounter;
    private final EnvelopeBufferPool envelopeBufferPool;
    private final EnvelopeBufferPool largeEnvelopeBufferPool;
    private final ObjectPool<ReusableInboundEnvelope> inboundEnvelopePool;
    private final ObjectPool<ReusableOutboundEnvelope> outboundEnvelopePool;
    private final AssociationRegistry associationRegistry;
    private final Function1 inboundLanePartitioner;
    private volatile Object shutdownHook$lzy1;
    private final Sink messageDispatcherSink;

    public static int ControlStreamId() {
        return ArteryTransport$.MODULE$.ControlStreamId();
    }

    public static byte HighestVersion() {
        return ArteryTransport$.MODULE$.HighestVersion();
    }

    public static int LargeStreamId() {
        return ArteryTransport$.MODULE$.LargeStreamId();
    }

    public static int OrdinaryStreamId() {
        return ArteryTransport$.MODULE$.OrdinaryStreamId();
    }

    public static String streamName(int n) {
        return ArteryTransport$.MODULE$.streamName(n);
    }

    public ArteryTransport(ExtendedActorSystem _system, RemoteActorRefProvider _provider) {
        super(_system, _provider);
        this.log().debug("Using flight recorder {}", (Object)this.flightRecorder());
        this._inboundCompressions = this.settings().Advanced().Compression().Enabled() ? new InboundCompressionsImpl((ActorSystem)this.system(), this, this.settings().Advanced().Compression(), this.flightRecorder()) : NoInboundCompressions$.MODULE$;
        OptionVal$.MODULE$.None();
        this._inboundCompressionAccess = null;
        this.killSwitch = KillSwitches$.MODULE$.shared("transportKillSwitch");
        this.streamMatValues = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        this.org$apache$pekko$remote$artery$ArteryTransport$$hasBeenShutdown = new AtomicBoolean(false);
        this.testState = new SharedTestState();
        this.inboundLanes = this.settings().Advanced().InboundLanes();
        this.largeMessageChannelEnabled = !this.settings().LargeMessageDestinations().wildcardTree().isEmpty() || !this.settings().LargeMessageDestinations().doubleWildcardTree().isEmpty();
        this.priorityMessageDestinations = WildcardIndex$.MODULE$.apply(WildcardIndex$.MODULE$.$lessinit$greater$default$1(), WildcardIndex$.MODULE$.$lessinit$greater$default$2()).insert(new String[]{"system", "remote-watcher"}, (Object)NotUsed$.MODULE$).insert(new String[]{"system", "cluster", "core", "daemon", "heartbeatSender"}, (Object)NotUsed$.MODULE$).insert(new String[]{"system", "cluster", "core", "daemon", "crossDcHeartbeatSender"}, (Object)NotUsed$.MODULE$).insert(new String[]{"system", "cluster", "heartbeatReceiver"}, (Object)NotUsed$.MODULE$);
        this.restartCounter = new RestartCounter(this.settings().Advanced().InboundMaxRestarts(), this.settings().Advanced().InboundRestartTimeout());
        this.envelopeBufferPool = new EnvelopeBufferPool(this.settings().Advanced().MaximumFrameSize(), this.settings().Advanced().BufferPoolSize());
        this.largeEnvelopeBufferPool = this.largeMessageChannelEnabled() ? new EnvelopeBufferPool(this.settings().Advanced().MaximumLargeFrameSize(), this.settings().Advanced().LargeBufferPoolSize()) : new EnvelopeBufferPool(0, 2);
        this.inboundEnvelopePool = ReusableInboundEnvelope$.MODULE$.createObjectPool(16);
        this.outboundEnvelopePool = ReusableOutboundEnvelope$.MODULE$.createObjectPool(this.settings().Advanced().OutboundMessageQueueSize() * this.settings().Advanced().OutboundLanes() * 3);
        this.associationRegistry = new AssociationRegistry((Function1<Address, Association>)(Function1 & Serializable)remoteAddress -> new Association(this, this.materializer(), this.controlMaterializer(), (Address)remoteAddress, this.controlSubject, this.settings().LargeMessageDestinations(), this.priorityMessageDestinations, this.outboundEnvelopePool));
        this.inboundLanePartitioner = (Function1 & Serializable)env -> {
            InternalActorRef internalActorRef = env.recipient();
            InternalActorRef internalActorRef2 = (InternalActorRef)OptionVal.Some$.MODULE$.unapply((Object)internalActorRef);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)internalActorRef2)) {
                InternalActorRef internalActorRef3;
                InternalActorRef r = internalActorRef3 = (InternalActorRef)OptionVal$.MODULE$.get$extension((Object)internalActorRef2);
                int a = r.path().uid();
                long b = env.originUid();
                int hashA = 23 + a;
                int hash = 23 * hashA + Long.hashCode(b);
                return package$.MODULE$.abs(hash % this.inboundLanes());
            }
            return env.lane();
        };
        this.messageDispatcherSink = Sink$.MODULE$.foreach((Function1)(JProcedure1 & Serializable)m -> {
            this.messageDispatcher.dispatch((InboundEnvelope)m);
            InboundEnvelope inboundEnvelope = m;
            if (inboundEnvelope instanceof ReusableInboundEnvelope) {
                ReusableInboundEnvelope r = (ReusableInboundEnvelope)inboundEnvelope;
                this.inboundEnvelopePool.release(r);
                return;
            }
        });
    }

    public Materializer materializer() {
        return this.materializer;
    }

    public void materializer_$eq(Materializer x$1) {
        this.materializer = x$1;
    }

    public Materializer controlMaterializer() {
        return this.controlMaterializer;
    }

    public void controlMaterializer_$eq(Materializer x$1) {
        this.controlMaterializer = x$1;
    }

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    public RemotingFlightRecorder flightRecorder() {
        return this.flightRecorder;
    }

    public InboundCompressions _inboundCompressions() {
        return this._inboundCompressions;
    }

    public Decoder.InboundCompressionAccess inboundCompressionAccess() {
        return this._inboundCompressionAccess;
    }

    public void setInboundCompressionAccess(Decoder.InboundCompressionAccess a) {
        this._inboundCompressionAccess = (Decoder.InboundCompressionAccess)OptionVal$.MODULE$.apply((Object)a);
    }

    public UniqueAddress bindAddress() {
        return this._bindAddress;
    }

    @Override
    public UniqueAddress localAddress() {
        return this._localAddress;
    }

    @Override
    public Address defaultAddress() {
        if (this._localAddress == null) {
            return null;
        }
        return this.localAddress().address();
    }

    @Override
    public Set<Address> addresses() {
        return this._addresses;
    }

    @Override
    public Address localAddressForRemote(Address remote) {
        return this.defaultAddress();
    }

    public SharedKillSwitch killSwitch() {
        return this.killSwitch;
    }

    public AtomicReference<Map<Object, InboundStreamMatValues<Object>>> streamMatValues() {
        return this.streamMatValues;
    }

    public int inboundLanes() {
        return this.inboundLanes;
    }

    public boolean largeMessageChannelEnabled() {
        return this.largeMessageChannelEnabled;
    }

    public EnvelopeBufferPool envelopeBufferPool() {
        return this.envelopeBufferPool;
    }

    public EnvelopeBufferPool largeEnvelopeBufferPool() {
        return this.largeEnvelopeBufferPool;
    }

    public Set<Address> remoteAddresses() {
        return (Set)this.associationRegistry.allAssociations().map((Function1 & Serializable)_$10 -> _$10.remoteAddress());
    }

    @Override
    public ArterySettings settings() {
        return this.provider().remoteSettings().Artery();
    }

    @Override
    public void start() {
        if (this.system().settings().JvmShutdownHooks()) {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook());
        }
        this.startTransport();
        this.flightRecorder().transportStarted();
        SystemMaterializer systemMaterializer = (SystemMaterializer)SystemMaterializer$.MODULE$.apply((ActorSystem)this.system());
        this.materializer_$eq(systemMaterializer.createAdditionalLegacySystemMaterializer("remote", this.settings().Advanced().MaterializerSettings()));
        this.controlMaterializer_$eq(systemMaterializer.createAdditionalLegacySystemMaterializer("remoteControl", this.settings().Advanced().ControlStreamMaterializerSettings()));
        this.messageDispatcher = new MessageDispatcher(this.system(), this.provider());
        this.flightRecorder().transportMaterializerStarted();
        Tuple2<Object, Object> tuple2 = this.bindInboundStreams();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int port = tuple2._1$mcI$sp();
        int boundPort = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(port, boundPort);
        int port2 = sp2._1$mcI$sp();
        int boundPort2 = sp2._2$mcI$sp();
        this._localAddress = UniqueAddress$.MODULE$.apply(Address$.MODULE$.apply(this.provider().remoteSettings().ProtocolName(), this.system().name(), this.settings().Canonical().Hostname(), port2), ((AddressUidExtension)AddressUidExtension$.MODULE$.apply((ActorSystem)this.system())).longAddressUid());
        this._addresses = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Address[]{this._localAddress.address()}));
        this._bindAddress = UniqueAddress$.MODULE$.apply(Address$.MODULE$.apply(this.provider().remoteSettings().ProtocolName(), this.system().name(), this.settings().Bind().Hostname(), boundPort2), ((AddressUidExtension)AddressUidExtension$.MODULE$.apply((ActorSystem)this.system())).longAddressUid());
        this.flightRecorder().transportUniqueAddressSet(this._localAddress);
        this.runInboundStreams(port2, boundPort2);
        this.flightRecorder().transportStartupFinished();
        this.startRemoveQuarantinedAssociationTask();
        Address address = this.localAddress().address();
        Address address2 = this.bindAddress().address();
        if (!(address != null ? !address.equals(address2) : address2 != null)) {
            this.log().info("Remoting started with transport [Artery {}]; listening on address [{}] with UID [{}]", (Object)this.settings().Transport(), (Object)this.bindAddress().address(), (Object)BoxesRunTime.boxToLong((long)this.bindAddress().uid()));
            return;
        }
        this.log().info("Remoting started with transport [Artery {}]; listening on address [{}] and bound to [{}] with UID [{}]", (Object)this.settings().Transport(), (Object)this.localAddress().address(), (Object)this.bindAddress().address(), (Object)BoxesRunTime.boxToLong((long)this.localAddress().uid()));
    }

    public abstract void startTransport();

    public abstract Tuple2<Object, Object> bindInboundStreams();

    public abstract void runInboundStreams(int var1, int var2);

    private void startRemoveQuarantinedAssociationTask() {
        FiniteDuration removeAfter = this.settings().Advanced().RemoveQuarantinedAssociationAfter();
        FiniteDuration interval = removeAfter.$div(2L);
        this.system().scheduler().scheduleWithFixedDelay(removeAfter, interval, () -> {
            if (!this.isShutdown()) {
                this.associationRegistry.removeUnusedQuarantined(removeAfter);
                return;
            }
        }, (ExecutionContext)this.system().dispatchers().internalDispatcher());
    }

    public Function1<InboundEnvelope, Object> inboundLanePartitioner() {
        return this.inboundLanePartitioner;
    }

    private Thread shutdownHook() {
        Object object = this.shutdownHook$lzy1;
        if (object instanceof Thread) {
            return (Thread)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Thread)this.shutdownHook$lzyINIT1();
    }

    private Object shutdownHook$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.shutdownHook$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Thread thread = null;
                    try {
                        thread = new Thread(this){
                            private final /* synthetic */ ArteryTransport $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public void run() {
                                if (!this.$outer.org$apache$pekko$remote$artery$ArteryTransport$$hasBeenShutdown.get()) {
                                    CoordinatedShutdown coord = (CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply((ActorSystem)this.$outer.system());
                                    FiniteDuration totalTimeout = coord.totalTimeout().max(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds());
                                    if (!coord.jvmHooksLatch().await(totalTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                                        this.$outer.log().warning("CoordinatedShutdown took longer than [{}]. Shutting down [{}] via shutdownHook", (Object)totalTimeout, (Object)this.$outer.localAddress());
                                    } else {
                                        this.$outer.log().debug("Shutting down [{}] via shutdownHook", (Object)this.$outer.localAddress());
                                    }
                                    if (this.$outer.org$apache$pekko$remote$artery$ArteryTransport$$hasBeenShutdown.compareAndSet(false, true)) {
                                        Await$.MODULE$.result(this.$outer.org$apache$pekko$remote$artery$ArteryTransport$$internalShutdown(), (Duration)this.$outer.settings().Advanced().Aeron().DriverTimeout().$plus(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds()));
                                        return;
                                    }
                                    return;
                                }
                            }
                        };
                        object2 = thread == null ? LazyVals.NullValue$.MODULE$ : thread;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.shutdownHook$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return thread;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void attachControlMessageObserver(InboundControlJunction.ControlMessageSubject ctrl) {
        this.controlSubject = ctrl;
        this.controlSubject.attach(new InboundControlJunction.ControlMessageObserver(this){
            private final /* synthetic */ ArteryTransport $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void notify(InboundEnvelope inboundEnvelope) {
                try {
                    Object object = inboundEnvelope.message();
                    if (object instanceof CompressionProtocol.CompressionMessage) {
                        CompressionProtocol.CompressionMessage m = (CompressionProtocol.CompressionMessage)object;
                        CompressionProtocol.CompressionMessage compressionMessage = m;
                        if (compressionMessage instanceof CompressionProtocol.ActorRefCompressionAdvertisement) {
                            CompressionProtocol.ActorRefCompressionAdvertisement actorRefCompressionAdvertisement = CompressionProtocol$ActorRefCompressionAdvertisement$.MODULE$.unapply((CompressionProtocol.ActorRefCompressionAdvertisement)compressionMessage);
                            UniqueAddress uniqueAddress = actorRefCompressionAdvertisement._1();
                            CompressionTable<ActorRef> compressionTable = actorRefCompressionAdvertisement._2();
                            UniqueAddress from = uniqueAddress;
                            CompressionTable<ActorRef> table = compressionTable;
                            if (table.originUid() == this.$outer.localAddress().uid()) {
                                this.$outer.log().debug("Incoming ActorRef compression advertisement from [{}], table: [{}]", (Object)from, table);
                                Association a = this.$outer.association(from.address());
                                if (!a.associationState().uniqueRemoteAddress().contains((Object)from)) return;
                                a.changeActorRefCompression(table).foreach((Function1)(JProcedure1 & Serializable)_$11 -> {
                                    a.sendControl(CompressionProtocol$ActorRefCompressionAdvertisementAck$.MODULE$.apply(this.$outer.localAddress(), table.version()));
                                    this.$outer.system().eventStream().publish((Object)CompressionProtocol$Events$ReceivedActorRefCompressionTable$.MODULE$.apply(from, table));
                                }, (ExecutionContext)this.$outer.system().dispatchers().internalDispatcher());
                                return;
                            } else {
                                this.$outer.log().debug("Discarding incoming ActorRef compression advertisement from [{}] that was prepared for another incarnation with uid [{}] than current uid [{}], table: [{}]", (Object)from, (Object)BoxesRunTime.boxToLong((long)table.originUid()), (Object)BoxesRunTime.boxToLong((long)this.$outer.localAddress().uid()), table);
                            }
                            return;
                        } else if (compressionMessage instanceof CompressionProtocol.ActorRefCompressionAdvertisementAck) {
                            CompressionProtocol.ActorRefCompressionAdvertisementAck ack = (CompressionProtocol.ActorRefCompressionAdvertisementAck)compressionMessage;
                            Decoder.InboundCompressionAccess inboundCompressionAccess = this.$outer.inboundCompressionAccess();
                            Decoder.InboundCompressionAccess inboundCompressionAccess2 = (Decoder.InboundCompressionAccess)OptionVal.Some$.MODULE$.unapply((Object)inboundCompressionAccess);
                            if (!OptionVal$.MODULE$.isEmpty$extension((Object)inboundCompressionAccess2)) {
                                Decoder.InboundCompressionAccess inboundCompressionAccess3;
                                Decoder.InboundCompressionAccess access = inboundCompressionAccess3 = (Decoder.InboundCompressionAccess)OptionVal$.MODULE$.get$extension((Object)inboundCompressionAccess2);
                                access.confirmActorRefCompressionAdvertisementAck(ack);
                                return;
                            } else {
                                this.$outer.log().debug(new StringBuilder(159).append("Received {} version: [{}] however no inbound compression access was present. ").append("ACK will not take effect, however it will be redelivered and likely to apply then.").toString(), (Object)Logging$.MODULE$.simpleName((Object)ack), (Object)BoxesRunTime.boxToByte((byte)ack.tableVersion()));
                            }
                            return;
                        } else if (compressionMessage instanceof CompressionProtocol.ClassManifestCompressionAdvertisement) {
                            CompressionProtocol.ClassManifestCompressionAdvertisement classManifestCompressionAdvertisement = CompressionProtocol$ClassManifestCompressionAdvertisement$.MODULE$.unapply((CompressionProtocol.ClassManifestCompressionAdvertisement)compressionMessage);
                            UniqueAddress uniqueAddress = classManifestCompressionAdvertisement._1();
                            CompressionTable<String> compressionTable = classManifestCompressionAdvertisement._2();
                            UniqueAddress from = uniqueAddress;
                            CompressionTable<String> table = compressionTable;
                            if (table.originUid() == this.$outer.localAddress().uid()) {
                                this.$outer.log().debug("Incoming Class Manifest compression advertisement from [{}], table: [{}]", (Object)from, table);
                                Association a = this.$outer.association(from.address());
                                if (!a.associationState().uniqueRemoteAddress().contains((Object)from)) return;
                                a.changeClassManifestCompression(table).foreach((Function1)(JProcedure1 & Serializable)_$12 -> {
                                    a.sendControl(CompressionProtocol$ClassManifestCompressionAdvertisementAck$.MODULE$.apply(this.$outer.localAddress(), table.version()));
                                    this.$outer.system().eventStream().publish((Object)CompressionProtocol$Events$ReceivedClassManifestCompressionTable$.MODULE$.apply(from, table));
                                }, (ExecutionContext)this.$outer.system().dispatchers().internalDispatcher());
                                return;
                            } else {
                                this.$outer.log().debug("Discarding incoming Class Manifest compression advertisement from [{}] that was prepared for another incarnation with uid [{}] than current uid [{}], table: [{}]", (Object)from, (Object)BoxesRunTime.boxToLong((long)table.originUid()), (Object)BoxesRunTime.boxToLong((long)this.$outer.localAddress().uid()), table);
                            }
                            return;
                        } else {
                            if (!(compressionMessage instanceof CompressionProtocol.ClassManifestCompressionAdvertisementAck)) throw new MatchError((Object)compressionMessage);
                            CompressionProtocol.ClassManifestCompressionAdvertisementAck ack = (CompressionProtocol.ClassManifestCompressionAdvertisementAck)compressionMessage;
                            Decoder.InboundCompressionAccess inboundCompressionAccess = this.$outer.inboundCompressionAccess();
                            Decoder.InboundCompressionAccess inboundCompressionAccess4 = (Decoder.InboundCompressionAccess)OptionVal.Some$.MODULE$.unapply((Object)inboundCompressionAccess);
                            if (!OptionVal$.MODULE$.isEmpty$extension((Object)inboundCompressionAccess4)) {
                                Decoder.InboundCompressionAccess inboundCompressionAccess5;
                                Decoder.InboundCompressionAccess access = inboundCompressionAccess5 = (Decoder.InboundCompressionAccess)OptionVal$.MODULE$.get$extension((Object)inboundCompressionAccess4);
                                access.confirmClassManifestCompressionAdvertisementAck(ack);
                                return;
                            } else {
                                this.$outer.log().debug(new StringBuilder(159).append("Received {} version: [{}] however no inbound compression access was present. ").append("ACK will not take effect, however it will be redelivered and likely to apply then.").toString(), (Object)Logging$.MODULE$.simpleName((Object)ack), (Object)BoxesRunTime.boxToByte((byte)ack.tableVersion()));
                            }
                        }
                        return;
                    } else {
                        UniqueAddress to;
                        if (!(object instanceof Quarantined)) return;
                        Quarantined quarantined = Quarantined$.MODULE$.unapply((Quarantined)object);
                        UniqueAddress uniqueAddress = quarantined._1();
                        UniqueAddress uniqueAddress2 = quarantined._2();
                        UniqueAddress from = uniqueAddress;
                        UniqueAddress uniqueAddress3 = to = uniqueAddress2;
                        UniqueAddress uniqueAddress4 = this.$outer.localAddress();
                        if (uniqueAddress3 != null ? !((Object)uniqueAddress3).equals(uniqueAddress4) : uniqueAddress4 != null) return;
                        this.$outer.log().warning("Other node [{}#{}] quarantined this node.", (Object)from.address(), (Object)BoxesRunTime.boxToLong((long)from.uid()));
                        ThisActorSystemQuarantinedEvent lifecycleEvent = ThisActorSystemQuarantinedEvent$.MODULE$.apply(this.$outer.localAddress(), from);
                        this.$outer.system().eventStream().publish((Object)lifecycleEvent);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (ArteryTransport$ShuttingDown$.MODULE$.equals(throwable2)) return;
                    throw throwable;
                }
            }

            public void controlSubjectCompleted(Try signal) {
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{notify$$anonfun$1(org.apache.pekko.remote.artery.Association org.apache.pekko.remote.artery.compress.CompressionTable org.apache.pekko.remote.UniqueAddress org.apache.pekko.Done ), notify$$anonfun$2(org.apache.pekko.remote.artery.Association org.apache.pekko.remote.artery.compress.CompressionTable org.apache.pekko.remote.UniqueAddress org.apache.pekko.Done )}, serializedLambda);
            }
        });
    }

    public void attachInboundStreamRestart(String streamName, Future<Done> streamCompleted, Function0<BoxedUnit> restart) {
        ExecutionContextExecutor ec = this.materializer().executionContext();
        streamCompleted.failed().foreach((Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (ArteryTransport$ShutdownSignal$.MODULE$.equals(throwable)) {
                return BoxedUnit.UNIT;
            }
            if (throwable instanceof AeronTerminated) {
                return BoxedUnit.UNIT;
            }
            Throwable cause = throwable;
            if (this.isShutdown()) {
                this.log().warning("{} failed after shutdown. {}: {}", (Object)streamName, (Object)cause.getClass().getName(), (Object)cause.getMessage());
                return BoxedUnit.UNIT;
            }
            if (throwable instanceof AbruptTerminationException) {
                return BoxedUnit.UNIT;
            }
            Throwable cause2 = throwable;
            if (this.restartCounter.restart()) {
                this.log().warning("{} failed. Restarting it. {}: {}", (Object)streamName, (Object)cause2.getClass().getName(), (Object)cause2.getMessage());
                this.flightRecorder().transportRestartInbound(this.localAddress(), streamName);
                restart.apply$mcV$sp();
                return BoxedUnit.UNIT;
            }
            this.log().error(cause2, "{} failed and restarted {} times within {} seconds. Terminating system. {}", (Object)streamName, (Object)BoxesRunTime.boxToInteger((int)this.settings().Advanced().InboundMaxRestarts()), (Object)BoxesRunTime.boxToLong((long)this.settings().Advanced().InboundRestartTimeout().toSeconds()), (Object)cause2.getMessage());
            return this.system().terminate();
        }, (ExecutionContext)ec);
    }

    @Override
    public Future<Done> shutdown() {
        if (this.org$apache$pekko$remote$artery$ArteryTransport$$hasBeenShutdown.compareAndSet(false, true)) {
            Future future;
            Set<Association> allAssociations;
            this.log().debug("Shutting down [{}]", (Object)this.localAddress());
            if (this.system().settings().JvmShutdownHooks()) {
                Try$.MODULE$.apply(this::shutdown$$anonfun$1);
            }
            if ((allAssociations = this.associationRegistry.allAssociations()).isEmpty()) {
                future = Future$.MODULE$.successful((Object)Done$.MODULE$);
            } else {
                Promise flushingPromise = Promise$.MODULE$.apply();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("Flushing associations [{}]", (Object)((IterableOnceOps)allAssociations.map((Function1 & Serializable)_$13 -> _$13.remoteAddress())).mkString(", "));
                }
                this.system().systemActorOf(FlushOnShutdown$.MODULE$.props((Promise<Done>)flushingPromise, this.settings().Advanced().ShutdownFlushTimeout(), allAssociations).withDispatcher("pekko.actor.internal-dispatcher"), "remoteFlushOnShutdown");
                future = flushingPromise.future();
            }
            Future flushing = future;
            org.apache.pekko.dispatch.MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
            return flushing.recover((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    return Done$.MODULE$;
                }
            }, (ExecutionContext)ec).flatMap((Function1 & Serializable)_$14 -> this.org$apache$pekko$remote$artery$ArteryTransport$$internalShutdown(), (ExecutionContext)ec);
        }
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    public Future<Done> org$apache$pekko$remote$artery$ArteryTransport$$internalShutdown() {
        org.apache.pekko.dispatch.MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
        this.killSwitch().abort((Throwable)ArteryTransport$ShutdownSignal$.MODULE$);
        this.flightRecorder().transportKillSwitchPulled();
        return this.streamsCompleted().recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return Done$.MODULE$;
            }
        }, (ExecutionContext)ec).flatMap((Function1 & Serializable)x$12 -> {
            Done done = x$12;
            return this.shutdownTransport().recover((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    return Done$.MODULE$;
                }
            }, (ExecutionContext)ec).map((Function1 & Serializable)x$1 -> {
                Done done = x$1;
                OptionVal$.MODULE$.None();
                this._inboundCompressionAccess = null;
                return Done$.MODULE$;
            }, (ExecutionContext)ec);
        }, (ExecutionContext)ec);
    }

    public abstract Future<Done> shutdownTransport();

    public final void updateStreamMatValues(int streamId, InboundStreamMatValues<Object> values) {
        Integer n;
        Map<Object, InboundStreamMatValues<Object>> prev;
        do {
            prev = this.streamMatValues().get();
            n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)streamId));
        } while (!this.streamMatValues().compareAndSet(prev, (Map<Object, InboundStreamMatValues<Object>>)prev.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, values))));
    }

    private Future<Done> streamsCompleted() {
        org.apache.pekko.dispatch.MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
        return Future$.MODULE$.traverse(this.associationRegistry.allAssociations(), (Function1 & Serializable)_$15 -> _$15.streamsCompleted(), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)ec).flatMap((Function1 & Serializable)x$12 -> {
            Set set = x$12;
            return Future$.MODULE$.sequence((IterableOnce)((MapOps)this.streamMatValues().get()).valuesIterator().map((Function1 & Serializable)x$1 -> {
                InboundStreamMatValues inboundStreamMatValues = x$1;
                if (inboundStreamMatValues != null) {
                    Future<Done> future;
                    InboundStreamMatValues inboundStreamMatValues2 = ArteryTransport$InboundStreamMatValues$.MODULE$.unapply(inboundStreamMatValues);
                    Object LifeCycle = inboundStreamMatValues2._1();
                    Future<Done> done = future = inboundStreamMatValues2._2();
                    return done;
                }
                throw new MatchError((Object)inboundStreamMatValues);
            }), BuildFrom$.MODULE$.buildFromIterator(), (ExecutionContext)ec).map((Function1 & Serializable)x$1 -> {
                Iterator iterator = x$1;
                return Done$.MODULE$;
            }, (ExecutionContext)ec);
        }, (ExecutionContext)ec);
    }

    public boolean isShutdown() {
        return this.org$apache$pekko$remote$artery$ArteryTransport$$hasBeenShutdown.get();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Future<Object> managementCommand(Object cmd) {
        Throwable throwable;
        Object object = cmd;
        if (object instanceof ThrottlerTransportAdapter.SetThrottle) {
            ThrottlerTransportAdapter.SetThrottle setThrottle = ThrottlerTransportAdapter$SetThrottle$.MODULE$.unapply((ThrottlerTransportAdapter.SetThrottle)object);
            Address address = setThrottle._1();
            ThrottlerTransportAdapter.Direction direction = setThrottle._2();
            ThrottlerTransportAdapter.ThrottleMode throttleMode = setThrottle._3();
            Address address2 = address;
            ThrottlerTransportAdapter.Direction direction2 = direction;
            if (ThrottlerTransportAdapter$Blackhole$.MODULE$.equals(throttleMode)) {
                this.testState.blackhole(this.localAddress().address(), address2, direction2);
                return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            Address address3 = address;
            ThrottlerTransportAdapter.Direction direction3 = direction;
            if (ThrottlerTransportAdapter$Unthrottled$.MODULE$.equals(throttleMode)) {
                this.testState.passThrough(this.localAddress().address(), address3, direction3);
                return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
        }
        if (!(object instanceof TestManagementCommands.FailInboundStreamOnce)) throw new MatchError(object);
        TestManagementCommands.FailInboundStreamOnce failInboundStreamOnce = TestManagementCommands$FailInboundStreamOnce$.MODULE$.unapply((TestManagementCommands.FailInboundStreamOnce)object);
        Throwable ex = throwable = failInboundStreamOnce._1();
        this.testState.failInboundStreamOnce(ex);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    @Override
    public void sendControl(Address to, ControlMessage message) {
        block2: {
            try {
                this.association(to).sendControl(message);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (ArteryTransport$ShuttingDown$.MODULE$.equals(throwable2)) break block2;
                throw throwable;
            }
        }
    }

    @Override
    public void send(Object message, ActorRef sender, RemoteActorRef recipient) {
        block4: {
            try {
                Association association;
                Association cached = recipient.cachedAssociation();
                if (cached != null) {
                    association = cached;
                } else {
                    Association a2 = this.association(recipient.path().address());
                    recipient.cachedAssociation_$eq(a2);
                    association = a2;
                }
                Association a = association;
                a.send(message, sender, (RemoteActorRef)OptionVal.Some$.MODULE$.apply((Object)recipient));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (ArteryTransport$ShuttingDown$.MODULE$.equals(throwable2)) break block4;
                throw throwable;
            }
        }
    }

    @Override
    public Association association(Address remoteAddress) {
        Address address = remoteAddress;
        Address address2 = this.localAddress().address();
        Predef$.MODULE$.require(address == null ? address2 != null : !address.equals(address2), ArteryTransport::association$$anonfun$1);
        return this.associationRegistry.association(remoteAddress);
    }

    @Override
    public Association association(long uid) {
        return this.associationRegistry.association(uid);
    }

    @Override
    public Future<Done> completeHandshake(UniqueAddress peer) {
        Future future;
        try {
            future = this.associationRegistry.setUID(peer).completeHandshake(peer);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (ArteryTransport$ShuttingDown$.MODULE$.equals(throwable2)) {
                future = Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
            throw throwable;
        }
        return future;
    }

    @Override
    @InternalStableApi
    public void quarantine(Address remoteAddress, Option<Object> uid, String reason) {
        this.quarantine(remoteAddress, uid, reason, false);
    }

    public void quarantine(Address remoteAddress, Option<Object> uid, String reason, boolean harmless) {
        block2: {
            try {
                this.association(remoteAddress).quarantine(reason, uid, harmless);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (ArteryTransport$ShuttingDown$.MODULE$.equals(throwable2)) break block2;
                throw throwable;
            }
        }
    }

    public Sink<OutboundEnvelope, Future<Done>> outboundLarge(OutboundContext outboundContext) {
        return this.createOutboundSink(ArteryTransport$.MODULE$.LargeStreamId(), outboundContext, this.largeEnvelopeBufferPool()).mapMaterializedValue((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Future d = (Future)tuple2._2();
                return d;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Sink<OutboundEnvelope, Tuple2<Encoder.OutboundCompressionAccess, Future<Done>>> outbound(OutboundContext outboundContext) {
        return this.createOutboundSink(ArteryTransport$.MODULE$.OrdinaryStreamId(), outboundContext, this.envelopeBufferPool());
    }

    private Sink<OutboundEnvelope, Tuple2<Encoder.OutboundCompressionAccess, Future<Done>>> createOutboundSink(int streamId, OutboundContext outboundContext, EnvelopeBufferPool bufferPool) {
        return this.outboundLane(outboundContext, bufferPool, streamId).toMat(this.outboundTransportSink(outboundContext, streamId, bufferPool), Keep$.MODULE$.both());
    }

    public Sink<EnvelopeBuffer, Future<Done>> outboundTransportSink(OutboundContext outboundContext) {
        return this.outboundTransportSink(outboundContext, ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool());
    }

    public abstract Sink<EnvelopeBuffer, Future<Done>> outboundTransportSink(OutboundContext var1, int var2, EnvelopeBufferPool var3);

    public Flow<OutboundEnvelope, EnvelopeBuffer, Encoder.OutboundCompressionAccess> outboundLane(OutboundContext outboundContext) {
        return this.outboundLane(outboundContext, this.envelopeBufferPool(), ArteryTransport$.MODULE$.OrdinaryStreamId());
    }

    private Flow<OutboundEnvelope, EnvelopeBuffer, Encoder.OutboundCompressionAccess> outboundLane(OutboundContext outboundContext, EnvelopeBufferPool bufferPool, int streamId) {
        return Flow$.MODULE$.fromGraph(this.killSwitch().flow()).via((Graph)new OutboundHandshake((ActorSystem)this.system(), outboundContext, this.outboundEnvelopePool, this.settings().Advanced().HandshakeTimeout(), this.settings().Advanced().HandshakeRetryInterval(), this.settings().Advanced().InjectHandshakeInterval(), (Duration)Duration$.MODULE$.Undefined())).viaMat(this.createEncoder(bufferPool, streamId), Keep$.MODULE$.right());
    }

    public Sink<OutboundEnvelope, Tuple2<OutboundControlJunction.OutboundControlIngress, Future<Done>>> outboundControl(OutboundContext outboundContext) {
        FiniteDuration livenessProbeInterval = this.settings().Advanced().QuarantineIdleOutboundAfter().$div(10L).max(this.settings().Advanced().HandshakeRetryInterval());
        return Flow$.MODULE$.fromGraph(this.killSwitch().flow()).via((Graph)new OutboundHandshake((ActorSystem)this.system(), outboundContext, this.outboundEnvelopePool, this.settings().Advanced().HandshakeTimeout(), this.settings().Advanced().HandshakeRetryInterval(), this.settings().Advanced().InjectHandshakeInterval(), (Duration)livenessProbeInterval)).via((Graph)new SystemMessageDelivery(outboundContext, this.system().deadLetters(), this.settings().Advanced().SystemMessageResendInterval(), this.settings().Advanced().SysMsgBufferSize())).viaMat((Graph)new OutboundControlJunction(outboundContext, this.outboundEnvelopePool), Keep$.MODULE$.right()).via(this.outboundTestFlow(outboundContext)).via(this.createEncoder(this.envelopeBufferPool(), ArteryTransport$.MODULE$.ControlStreamId())).toMat(this.outboundTransportSink(outboundContext, ArteryTransport$.MODULE$.ControlStreamId(), this.envelopeBufferPool()), Keep$.MODULE$.both());
    }

    public Flow<OutboundEnvelope, EnvelopeBuffer, Encoder.OutboundCompressionAccess> createEncoder(EnvelopeBufferPool pool, int streamId) {
        return Flow$.MODULE$.fromGraph((Graph)new Encoder(this.localAddress(), this.system(), this.outboundEnvelopePool, pool, streamId, this.settings().LogSend(), this.settings().Version()));
    }

    public Flow<EnvelopeBuffer, InboundEnvelope, Decoder.InboundCompressionAccess> createDecoder(ArterySettings settings, InboundCompressions compressions) {
        return Flow$.MODULE$.fromGraph((Graph)new Decoder(this, this.system(), this.localAddress(), settings, compressions, this.inboundEnvelopePool));
    }

    public Flow<InboundEnvelope, InboundEnvelope, NotUsed> createDeserializer(EnvelopeBufferPool bufferPool) {
        return Flow$.MODULE$.fromGraph((Graph)new Deserializer(this, this.system(), bufferPool));
    }

    public Sink<InboundEnvelope, Future<Done>> messageDispatcherSink() {
        return this.messageDispatcherSink;
    }

    public Flow<InboundEnvelope, InboundEnvelope, NotUsed> terminationHintReplier(boolean inControlStream) {
        return (Flow)Flow$.MODULE$.apply().filter((Function1 & Serializable)envelope -> {
            Object object = envelope.message();
            if (object instanceof ActorSystemTerminating) {
                UniqueAddress uniqueAddress;
                ActorSystemTerminating actorSystemTerminating = ActorSystemTerminating$.MODULE$.unapply((ActorSystemTerminating)object);
                UniqueAddress from = uniqueAddress = actorSystemTerminating._1();
                ActorRef actorRef = envelope.sender();
                ActorRef actorRef2 = (ActorRef)OptionVal.Some$.MODULE$.unapply((Object)actorRef);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)actorRef2)) {
                    ActorRef actorRef3;
                    ActorRef snd = actorRef3 = (ActorRef)OptionVal$.MODULE$.get$extension((Object)actorRef2);
                    snd.tell((Object)ActorSystemTerminatingAck$.MODULE$.apply(this.localAddress()), ActorRef$.MODULE$.noSender());
                    if (inControlStream) {
                        this.system().scheduler().scheduleOnce(this.settings().Advanced().ShutdownFlushTimeout(), (Function0 & Serializable)() -> {
                            this.terminationHintReplier$$anonfun$1$$anonfun$1(from);
                            return BoxedUnit.UNIT;
                        }, (ExecutionContext)this.materializer().executionContext());
                    }
                } else {
                    this.log().error("Expected sender for ActorSystemTerminating message from [{}]", (Object)from);
                }
                return false;
            }
            return true;
        });
    }

    public Flow<InboundEnvelope, InboundEnvelope, NotUsed> flushReplier(int expectedAcks) {
        return (Flow)Flow$.MODULE$.apply().filter((Function1 & Serializable)envelope -> {
            Object object = envelope.message();
            if (Flush$.MODULE$.equals(object)) {
                ActorRef actorRef = envelope.sender();
                ActorRef actorRef2 = (ActorRef)OptionVal.Some$.MODULE$.unapply((Object)actorRef);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)actorRef2)) {
                    ActorRef actorRef3;
                    ActorRef snd = actorRef3 = (ActorRef)OptionVal$.MODULE$.get$extension((Object)actorRef2);
                    snd.tell((Object)FlushAck$.MODULE$.apply(expectedAcks), ActorRef$.MODULE$.noSender());
                } else {
                    this.log().error("Expected sender for Flush message from [{}]", (Object)new OptionVal((Object)envelope.association()));
                }
                return false;
            }
            return true;
        });
    }

    public Sink<InboundEnvelope, Future<Done>> inboundSink(EnvelopeBufferPool bufferPool) {
        return Flow$.MODULE$.apply().via(this.createDeserializer(bufferPool)).via((Graph)(this.settings().Advanced().TestMode() ? new InboundTestStage(this, this.testState) : Flow$.MODULE$.apply())).via(this.flushReplier(this.settings().Advanced().InboundLanes())).via(this.terminationHintReplier(false)).via((Graph)new InboundHandshake(this, false)).via((Graph)new InboundQuarantineCheck(this)).toMat(this.messageDispatcherSink(), Keep$.MODULE$.right());
    }

    public Flow<EnvelopeBuffer, InboundEnvelope, Decoder.InboundCompressionAccess> inboundFlow(ArterySettings settings, InboundCompressions compressions) {
        return Flow$.MODULE$.apply().via(this.killSwitch().flow()).viaMat(this.createDecoder(settings, compressions), Keep$.MODULE$.right());
    }

    public Flow<EnvelopeBuffer, InboundEnvelope, Object> inboundLargeFlow(ArterySettings settings) {
        return this.inboundFlow(settings, NoInboundCompressions$.MODULE$);
    }

    public Sink<InboundEnvelope, Tuple2<InboundControlJunction.ControlMessageSubject, Future<Done>>> inboundControlSink() {
        return Flow$.MODULE$.apply().via(this.createDeserializer(this.envelopeBufferPool())).via((Graph)(this.settings().Advanced().TestMode() ? new InboundTestStage(this, this.testState) : Flow$.MODULE$.apply())).via(this.flushReplier(1)).via(this.terminationHintReplier(true)).via((Graph)new InboundHandshake(this, true)).via((Graph)new InboundQuarantineCheck(this)).viaMat((Graph)new InboundControlJunction(), Keep$.MODULE$.right()).via((Graph)new SystemMessageAcker(this)).toMat(this.messageDispatcherSink(), Keep$.MODULE$.both());
    }

    public Flow<OutboundEnvelope, OutboundEnvelope, NotUsed> outboundTestFlow(OutboundContext outboundContext) {
        if (this.settings().Advanced().TestMode()) {
            return Flow$.MODULE$.fromGraph((Graph)new OutboundTestStage(outboundContext, this.testState));
        }
        return Flow$.MODULE$.apply();
    }

    public void triggerCompressionAdvertisements(boolean actorRef, boolean manifest) {
        Decoder.InboundCompressionAccess inboundCompressionAccess = this.inboundCompressionAccess();
        Decoder.InboundCompressionAccess inboundCompressionAccess2 = (Decoder.InboundCompressionAccess)OptionVal.Some$.MODULE$.unapply((Object)inboundCompressionAccess);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)inboundCompressionAccess2)) {
            Decoder.InboundCompressionAccess inboundCompressionAccess3;
            Decoder.InboundCompressionAccess c = inboundCompressionAccess3 = (Decoder.InboundCompressionAccess)OptionVal$.MODULE$.get$extension((Object)inboundCompressionAccess2);
            if (actorRef || manifest) {
                this.log().info("Triggering compression table advertisement for {}", (Object)c);
                if (actorRef) {
                    c.runNextActorRefAdvertisement();
                }
                if (manifest) {
                    c.runNextClassManifestAdvertisement();
                    return;
                }
                return;
            }
        }
    }

    @Override
    public void publishDropped(InboundEnvelope env, String reason) {
        InternalActorRef internalActorRef = env.recipient();
        this.system().eventStream().publish((Object)Dropped$.MODULE$.apply(env.message(), reason, (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)internalActorRef, (Object)this.system().deadLetters())));
    }

    private final boolean shutdown$$anonfun$1() {
        return Runtime.getRuntime().removeShutdownHook(this.shutdownHook());
    }

    private static final Object association$$anonfun$1() {
        return "Attempted association with self address!";
    }

    private final void terminationHintReplier$$anonfun$1$$anonfun$1(UniqueAddress from$3) {
        if (!this.isShutdown()) {
            this.quarantine(from$3.address(), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)from$3.uid())), "ActorSystem terminated", true);
            return;
        }
    }

    public static class AeronTerminated
    extends RuntimeException {
        public AeronTerminated(Throwable e) {
            super(e);
        }
    }

    public static final class InboundStreamMatValues<LifeCycle>
    implements Product,
    Serializable {
        private final Object lifeCycle;
        private final Future completed;

        public static <LifeCycle> InboundStreamMatValues<LifeCycle> apply(LifeCycle LifeCycle, Future<Done> future) {
            return ArteryTransport$InboundStreamMatValues$.MODULE$.apply(LifeCycle, future);
        }

        public static InboundStreamMatValues<?> fromProduct(Product product) {
            return ArteryTransport$InboundStreamMatValues$.MODULE$.fromProduct(product);
        }

        public static <LifeCycle> InboundStreamMatValues<LifeCycle> unapply(InboundStreamMatValues<LifeCycle> inboundStreamMatValues) {
            return ArteryTransport$InboundStreamMatValues$.MODULE$.unapply(inboundStreamMatValues);
        }

        public InboundStreamMatValues(LifeCycle lifeCycle, Future<Done> completed) {
            this.lifeCycle = lifeCycle;
            this.completed = completed;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InboundStreamMatValues)) return false;
            InboundStreamMatValues inboundStreamMatValues = (InboundStreamMatValues)object;
            if (!BoxesRunTime.equals(this.lifeCycle(), inboundStreamMatValues.lifeCycle())) return false;
            Future<Done> future = this.completed();
            Future<Done> future2 = inboundStreamMatValues.completed();
            if (future != null) {
                if (!future.equals(future2)) return false;
                return true;
            }
            if (future2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof InboundStreamMatValues;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "InboundStreamMatValues";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "lifeCycle";
            }
            if (1 == n2) {
                return "completed";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LifeCycle lifeCycle() {
            return (LifeCycle)this.lifeCycle;
        }

        public Future<Done> completed() {
            return this.completed;
        }

        public <LifeCycle> InboundStreamMatValues<LifeCycle> copy(LifeCycle lifeCycle, Future<Done> completed) {
            return new InboundStreamMatValues<LifeCycle>(lifeCycle, completed);
        }

        public <LifeCycle> LifeCycle copy$default$1() {
            return this.lifeCycle();
        }

        public <LifeCycle> Future<Done> copy$default$2() {
            return this.completed();
        }

        public LifeCycle _1() {
            return this.lifeCycle();
        }

        public Future<Done> _2() {
            return this.completed();
        }
    }
}

