/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.WrappedMessage;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.artery.ArterySettings;
import org.apache.pekko.remote.artery.ArteryTransport;
import org.apache.pekko.remote.artery.RemoteInstrument;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

@InternalApi
public class LoggingRemoteInstrument
extends RemoteInstrument {
    private final int logFrameSizeExceeding;
    private final LoggingAdapter log;
    private final ConcurrentHashMap<Class<?>, Integer> maxPayloadBytes;

    public LoggingRemoteInstrument(ActorSystem system) {
        ArterySettings settings = ((ArteryTransport)((RemoteActorRefProvider)((ExtendedActorSystem)system).provider()).transport()).settings();
        this.logFrameSizeExceeding = BoxesRunTime.unboxToInt((Object)settings.LogFrameSizeExceeding().get());
        this.log = Logging$.MODULE$.apply(system, LoggingRemoteInstrument.class, LogSource$.MODULE$.fromAnyClass());
        this.maxPayloadBytes = new ConcurrentHashMap();
    }

    @Override
    public byte identifier() {
        return 1;
    }

    @Override
    public void remoteWriteMetadata(ActorRef recipient, Object message, ActorRef sender, ByteBuffer buffer) {
    }

    @Override
    public void remoteMessageSent(ActorRef recipient, Object message, ActorRef sender, int size, long time) {
        if (size >= this.logFrameSizeExceeding) {
            Class<?> clazz;
            Object object = message;
            if (object instanceof WrappedMessage) {
                WrappedMessage x = (WrappedMessage)object;
                clazz = x.message().getClass();
            } else {
                clazz = message.getClass();
            }
            Class<?> clazz2 = clazz;
            this.check$1(clazz2, size, recipient);
            return;
        }
    }

    @Override
    public void remoteReadMetadata(ActorRef recipient, Object message, ActorRef sender, ByteBuffer buffer) {
    }

    @Override
    public void remoteMessageReceived(ActorRef recipient, Object message, ActorRef sender, int size, long time) {
    }

    private static final int newMax$1(int size$1) {
        return (int)((double)size$1 * 1.1);
    }

    private final void check$1(Class clazz$1, int size$2, ActorRef recipient$1) {
        block2: {
            while (true) {
                Integer max;
                if ((max = this.maxPayloadBytes.get(clazz$1)) == null) {
                    if (this.maxPayloadBytes.putIfAbsent(clazz$1, Predef$.MODULE$.int2Integer(LoggingRemoteInstrument.newMax$1(size$2))) != null) continue;
                    this.log.info("Payload size for [{}] is [{}] bytes. Sent to {}", (Object)clazz$1.getName(), (Object)BoxesRunTime.boxToInteger((int)size$2), (Object)recipient$1);
                    return;
                }
                if (size$2 <= Predef$.MODULE$.Integer2int(max)) break block2;
                if (this.maxPayloadBytes.replace(clazz$1, max, Predef$.MODULE$.int2Integer(LoggingRemoteInstrument.newMax$1(size$2)))) break;
            }
            this.log.info("New maximum payload size for [{}] is [{}] bytes. Sent to {}.", (Object)clazz$1.getName(), (Object)BoxesRunTime.boxToInteger((int)size$2), (Object)recipient$1);
            return;
        }
    }
}

