/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.compress;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.InternalActorRef$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.artery.ArterySettings;
import org.apache.pekko.remote.artery.InboundContext;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.compress.CompressionProtocol$ActorRefCompressionAdvertisement$;
import org.apache.pekko.remote.artery.compress.CompressionTable;
import org.apache.pekko.remote.artery.compress.InboundCompression;
import org.apache.pekko.remote.artery.compress.TopHeavyHitters;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.function.JProcedure1;

public final class InboundActorRefCompression
extends InboundCompression<ActorRef> {
    private final InboundContext inboundContext;

    public InboundActorRefCompression(LoggingAdapter log, ArterySettings.Compression settings, long originUid, InboundContext inboundContext, TopHeavyHitters<ActorRef> heavyHitters) {
        this.inboundContext = inboundContext;
        super(log, settings, originUid, inboundContext, heavyHitters);
    }

    private LoggingAdapter log$accessor() {
        return super.log();
    }

    private ArterySettings.Compression settings$accessor() {
        return super.settings();
    }

    private long originUid$accessor() {
        return super.originUid();
    }

    private TopHeavyHitters<ActorRef> heavyHitters$accessor() {
        return super.heavyHitters();
    }

    @Override
    public void increment(Address remoteAddress, ActorRef value, long n) {
        if (!InternalActorRef$.MODULE$.isTemporaryRef(value)) {
            super.increment(remoteAddress, value, n);
            return;
        }
    }

    public ActorRef decompress(byte tableVersion, int idx) {
        return (ActorRef)super.decompressInternal(tableVersion, idx, 0);
    }

    @Override
    public void advertiseCompressionTable(OutboundContext outboundContext, CompressionTable<ActorRef> table) {
        this.log$accessor().debug("Advertise {} compression [{}] to [{}#{}]", (Object)Logging$.MODULE$.simpleName(this.getClass()), table, (Object)outboundContext.remoteAddress(), (Object)BoxesRunTime.boxToLong((long)this.originUid$accessor()));
        outboundContext.sendControl(CompressionProtocol$ActorRefCompressionAdvertisement$.MODULE$.apply(this.inboundContext.localAddress(), table));
    }

    @Override
    public Map<ActorRef, Object> buildTableForAdvertisement(Iterator<ActorRef> elements) {
        Builder mb = Predef$.MODULE$.Map().newBuilder();
        IntRef idx = IntRef.create((int)0);
        elements.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            ActorRef actorRef = x$1;
            if (actorRef instanceof InternalActorRef) {
                InternalActorRef ref = (InternalActorRef)actorRef;
                if (!InternalActorRef$.MODULE$.isTemporaryRef((ActorRef)ref)) {
                    InternalActorRef internalActorRef = (InternalActorRef)Predef$.MODULE$.ArrowAssoc((Object)ref);
                    mb.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)internalActorRef, (Object)BoxesRunTime.boxToInteger((int)idx$1.elem)));
                    ++idx$1.elem;
                    return;
                }
                return;
            }
        });
        return (Map)mb.result();
    }
}

