/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.tcp;

import com.typesafe.config.Config;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.artery.tcp.SSLEngineProvider;
import org.apache.pekko.remote.artery.tcp.SecureRandomFactory$;
import org.apache.pekko.remote.artery.tcp.SslTransportException;
import org.apache.pekko.remote.artery.tcp.ssl.SSLEngineConfig;
import org.apache.pekko.stream.Client$;
import org.apache.pekko.stream.Server$;
import org.apache.pekko.stream.TLSRole;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Try$;

public class ConfigSSLEngineProvider
implements SSLEngineProvider {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ConfigSSLEngineProvider.class.getDeclaredField("sslContext$lzy1"));
    private final Config config;
    private final MarkerLoggingAdapter log;
    private final String SSLKeyStore;
    private final String SSLTrustStore;
    private final String SSLKeyStorePassword;
    private final String SSLKeyPassword;
    private final String SSLTrustStorePassword;
    private final Set SSLEnabledAlgorithms;
    private final String SSLProtocol;
    private final String SSLRandomNumberGenerator;
    private final boolean SSLRequireMutualAuthentication;
    private final boolean HostnameVerification;
    private volatile Object sslContext$lzy1;

    public ConfigSSLEngineProvider(Config config, MarkerLoggingAdapter log) {
        this.config = config;
        this.log = log;
        SSLEngineConfig sslEngineConfig = new SSLEngineConfig(config);
        this.SSLKeyStore = config.getString("key-store");
        this.SSLTrustStore = config.getString("trust-store");
        this.SSLKeyStorePassword = config.getString("key-store-password");
        this.SSLKeyPassword = config.getString("key-password");
        this.SSLTrustStorePassword = config.getString("trust-store-password");
        this.SSLEnabledAlgorithms = sslEngineConfig.SSLEnabledAlgorithms();
        this.SSLProtocol = sslEngineConfig.SSLProtocol();
        this.SSLRandomNumberGenerator = sslEngineConfig.SSLRandomNumberGenerator();
        this.SSLRequireMutualAuthentication = sslEngineConfig.SSLRequireMutualAuthentication();
        this.HostnameVerification = sslEngineConfig.HostnameVerification();
    }

    public Config config() {
        return this.config;
    }

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    public ConfigSSLEngineProvider(ActorSystem system) {
        this(system.settings().config().getConfig("pekko.remote.artery.ssl.config-ssl-engine"), Logging$.MODULE$.withMarker(system, (Object)ConfigSSLEngineProvider.class.getName(), LogSource$.MODULE$.fromString()));
    }

    public String SSLKeyStore() {
        return this.SSLKeyStore;
    }

    public String SSLTrustStore() {
        return this.SSLTrustStore;
    }

    public String SSLKeyStorePassword() {
        return this.SSLKeyStorePassword;
    }

    public String SSLKeyPassword() {
        return this.SSLKeyPassword;
    }

    public String SSLTrustStorePassword() {
        return this.SSLTrustStorePassword;
    }

    public Set<String> SSLEnabledAlgorithms() {
        return this.SSLEnabledAlgorithms;
    }

    public String SSLProtocol() {
        return this.SSLProtocol;
    }

    public String SSLRandomNumberGenerator() {
        return this.SSLRandomNumberGenerator;
    }

    public boolean SSLRequireMutualAuthentication() {
        return this.SSLRequireMutualAuthentication;
    }

    public boolean HostnameVerification() {
        return this.HostnameVerification;
    }

    private SSLContext sslContext() {
        Object object = this.sslContext$lzy1;
        if (object instanceof SSLContext) {
            return (SSLContext)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SSLContext)this.sslContext$lzyINIT1();
    }

    private Object sslContext$lzyINIT1() {
        Object object;
        block10: {
            while (true) {
                if ((object = this.sslContext$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SSLContext sSLContext = null;
                    try {
                        if (this.HostnameVerification()) {
                            this.log().debug("TLS/SSL hostname verification is enabled.");
                        } else {
                            this.log().info(LogMarker$.MODULE$.Security(), "TLS/SSL hostname verification is disabled. See Pekko reference documentation for more information.");
                        }
                        sSLContext = this.constructContext();
                        object2 = sSLContext == null ? LazyVals.NullValue$.MODULE$ : sSLContext;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.sslContext$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return sSLContext;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private SSLContext constructContext() {
        void v0;
        try {
            void var2_2;
            SecureRandom rng = this.createSecureRandom();
            SSLContext ctx = SSLContext.getInstance(this.SSLProtocol());
            ctx.init(this.keyManagers(), this.trustManagers(), rng);
            v0 = var2_2;
        }
        catch (FileNotFoundException e) {
            throw new SslTransportException("Server SSL connection could not be established because key store could not be loaded", e);
        }
        catch (IOException e) {
            throw new SslTransportException(new StringBuilder(56).append("Server SSL connection could not be established because: ").append(e.getMessage()).toString(), e);
        }
        catch (GeneralSecurityException e) {
            throw new SslTransportException("Server SSL connection could not be established because SSL context could not be constructed", e);
        }
        return v0;
    }

    public KeyStore loadKeystore(String filename, String password) {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream fin = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
        try {
            keyStore.load(fin, password.toCharArray());
        }
        finally {
            Try$.MODULE$.apply((Function0 & Serializable)() -> {
                ConfigSSLEngineProvider.loadKeystore$$anonfun$1(fin);
                return BoxedUnit.UNIT;
            });
        }
        return keyStore;
    }

    public KeyManager[] keyManagers() {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(this.loadKeystore(this.SSLKeyStore(), this.SSLKeyStorePassword()), this.SSLKeyPassword().toCharArray());
        return factory.getKeyManagers();
    }

    public TrustManager[] trustManagers() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.loadKeystore(this.SSLTrustStore(), this.SSLTrustStorePassword()));
        return trustManagerFactory.getTrustManagers();
    }

    public SecureRandom createSecureRandom() {
        return SecureRandomFactory$.MODULE$.createSecureRandom(this.SSLRandomNumberGenerator(), this.log());
    }

    @Override
    public SSLEngine createServerSSLEngine(String hostname, int port) {
        return this.createSSLEngine((TLSRole)Server$.MODULE$, hostname, port);
    }

    @Override
    public SSLEngine createClientSSLEngine(String hostname, int port) {
        return this.createSSLEngine((TLSRole)Client$.MODULE$, hostname, port);
    }

    private SSLEngine createSSLEngine(TLSRole role, String hostname, int port) {
        return this.createSSLEngine(this.sslContext(), role, hostname, port);
    }

    private SSLEngine createSSLEngine(SSLContext sslContext, TLSRole role, String hostname, int port) {
        SSLEngine engine = sslContext.createSSLEngine(hostname, port);
        if (this.HostnameVerification()) {
            TLSRole tLSRole = role;
            Client$ client$ = Client$.MODULE$;
            if (!(tLSRole != null ? !tLSRole.equals(client$) : client$ != null)) {
                SSLParameters sslParams = sslContext.getDefaultSSLParameters();
                sslParams.setEndpointIdentificationAlgorithm("HTTPS");
                engine.setSSLParameters(sslParams);
            }
        }
        TLSRole tLSRole = role;
        Client$ client$ = Client$.MODULE$;
        engine.setUseClientMode(!(tLSRole != null ? !tLSRole.equals(client$) : client$ != null));
        engine.setEnabledCipherSuites((String[])this.SSLEnabledAlgorithms().toArray(ClassTag$.MODULE$.apply(String.class)));
        engine.setEnabledProtocols(new String[]{this.SSLProtocol()});
        TLSRole tLSRole2 = role;
        Client$ client$2 = Client$.MODULE$;
        if ((tLSRole2 == null ? client$2 != null : !tLSRole2.equals(client$2)) && this.SSLRequireMutualAuthentication()) {
            engine.setNeedClientAuth(true);
        }
        return engine;
    }

    @Override
    public Option<Throwable> verifyClientSession(String hostname, SSLSession session) {
        return None$.MODULE$;
    }

    @Override
    public Option<Throwable> verifyServerSession(String hostname, SSLSession session) {
        return None$.MODULE$;
    }

    private static final void loadKeystore$$anonfun$1(InputStream fin$1) {
        fin$1.close();
    }
}

