/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.tcp.ssl;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.pki.pem.DERPrivateKeyLoader$;
import org.apache.pekko.pki.pem.PEMDecoder$;
import scala.concurrent.package$;
import scala.runtime.ModuleSerializationProxy;

@InternalApi
public final class PemManagersProvider$
implements Serializable {
    private static final CertificateFactory certFactory;
    public static final PemManagersProvider$ MODULE$;

    private PemManagersProvider$() {
    }

    static {
        MODULE$ = new PemManagersProvider$();
        certFactory = CertificateFactory.getInstance("X.509");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PemManagersProvider$.class);
    }

    @InternalApi
    public KeyManager[] buildKeyManagers(PrivateKey privateKey, X509Certificate cert, Certificate cacert) {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null);
        keyStore.setCertificateEntry("cert", cert);
        keyStore.setCertificateEntry("cacert", cacert);
        keyStore.setKeyEntry("private-key", privateKey, "changeit".toCharArray(), new Certificate[]{cert, cacert});
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, "changeit".toCharArray());
        KeyManager[] keyManagers = kmf.getKeyManagers();
        return keyManagers;
    }

    @InternalApi
    public TrustManager[] buildTrustManagers(Certificate cacert) {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null);
        trustStore.setCertificateEntry("cacert", cacert);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        return tmf.getTrustManagers();
    }

    @InternalApi
    public PrivateKey loadPrivateKey(String filename) {
        return (PrivateKey)package$.MODULE$.blocking(() -> PemManagersProvider$.loadPrivateKey$$anonfun$1(filename));
    }

    @InternalApi
    public Certificate loadCertificate(String filename) {
        return (Certificate)package$.MODULE$.blocking(() -> PemManagersProvider$.loadCertificate$$anonfun$1(filename));
    }

    private static final PrivateKey loadPrivateKey$$anonfun$1(String filename$1) {
        byte[] bytes = Files.readAllBytes(new File(filename$1).toPath());
        String pemData = new String(bytes, StandardCharsets.UTF_8);
        return DERPrivateKeyLoader$.MODULE$.load(PEMDecoder$.MODULE$.decode(pemData));
    }

    private static final Certificate loadCertificate$$anonfun$1(String filename$2) {
        return certFactory.generateCertificate(Files.newInputStream(new File(filename$2).toPath(), new OpenOption[0]));
    }
}

