/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.tcp.ssl;

import com.typesafe.config.Config;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.artery.tcp.SSLEngineProvider;
import org.apache.pekko.remote.artery.tcp.SecureRandomFactory$;
import org.apache.pekko.remote.artery.tcp.SslTransportException;
import org.apache.pekko.remote.artery.tcp.ssl.PeerSubjectVerifier;
import org.apache.pekko.remote.artery.tcp.ssl.PemManagersProvider$;
import org.apache.pekko.remote.artery.tcp.ssl.RotatingKeysSSLEngineProvider$CachedContext$;
import org.apache.pekko.remote.artery.tcp.ssl.RotatingKeysSSLEngineProvider$ConfiguredContext$;
import org.apache.pekko.remote.artery.tcp.ssl.SSLEngineConfig;
import org.apache.pekko.remote.artery.tcp.ssl.SessionVerifier;
import org.apache.pekko.stream.Client$;
import org.apache.pekko.stream.Server$;
import org.apache.pekko.stream.TLSRole;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.concurrent.duration.Deadline;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ApiMayChange
public final class RotatingKeysSSLEngineProvider
implements SSLEngineProvider {
    private final Config config;
    private final MarkerLoggingAdapter log;
    private final String SSLKeyFile;
    private final String SSLCertFile;
    private final String SSLCACertFile;
    private final SSLEngineConfig sslEngineConfig;
    private final SecureRandom rng;
    private volatile Option<CachedContext> cachedContext;

    public RotatingKeysSSLEngineProvider(Config config, MarkerLoggingAdapter log) {
        this.config = config;
        this.log = log;
        this.SSLKeyFile = config.getString("key-file");
        this.SSLCertFile = config.getString("cert-file");
        this.SSLCACertFile = config.getString("ca-cert-file");
        this.sslEngineConfig = new SSLEngineConfig(config);
        this.rng = SecureRandomFactory$.MODULE$.createSecureRandom(this.sslEngineConfig.SSLRandomNumberGenerator(), log);
        this.cachedContext = None$.MODULE$;
    }

    public Config config() {
        return this.config;
    }

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    public RotatingKeysSSLEngineProvider(ActorSystem system) {
        this(system.settings().config().getConfig("pekko.remote.artery.ssl.rotating-keys-engine"), Logging$.MODULE$.withMarker(system, (Object)RotatingKeysSSLEngineProvider.class.getName(), LogSource$.MODULE$.fromString()));
    }

    @InternalApi
    public SSLContext getSSLContext() {
        return this.getContext().context();
    }

    private ConfiguredContext getContext() {
        CachedContext cachedContext;
        Option<CachedContext> option = this.cachedContext;
        if (option instanceof Some && (cachedContext = (CachedContext)((Some)option).value()) != null) {
            CachedContext cachedContext2 = RotatingKeysSSLEngineProvider$CachedContext$.MODULE$.unapply(cachedContext);
            ConfiguredContext configuredContext = cachedContext2._1();
            Deadline deadline = cachedContext2._2();
            Deadline expired = deadline;
            if (expired.isOverdue()) {
                ConfiguredContext context = this.constructContext();
                this.cachedContext = Some$.MODULE$.apply((Object)RotatingKeysSSLEngineProvider$CachedContext$.MODULE$.apply(context, this.sslEngineConfig.SSLContextCacheTime().fromNow()));
                return context;
            }
            ConfiguredContext cached = configuredContext;
            return cached;
        }
        if (None$.MODULE$.equals(option)) {
            ConfiguredContext context = this.constructContext();
            this.cachedContext = Some$.MODULE$.apply((Object)RotatingKeysSSLEngineProvider$CachedContext$.MODULE$.apply(context, this.sslEngineConfig.SSLContextCacheTime().fromNow()));
            return context;
        }
        throw new MatchError(option);
    }

    private ConfiguredContext constructContext() {
        ConfiguredContext configuredContext;
        Tuple3<PrivateKey, X509Certificate, Certificate> tuple3 = this.readFiles();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        PrivateKey privateKey = (PrivateKey)tuple3._1();
        X509Certificate cert = (X509Certificate)tuple3._2();
        Certificate cacert = (Certificate)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)privateKey, (Object)cert, (Object)cacert);
        PrivateKey privateKey2 = (PrivateKey)tuple32._1();
        X509Certificate cert2 = (X509Certificate)tuple32._2();
        Certificate cacert2 = (Certificate)tuple32._3();
        try {
            KeyManager[] keyManagers = PemManagersProvider$.MODULE$.buildKeyManagers(privateKey2, cert2, cacert2);
            TrustManager[] trustManagers = PemManagersProvider$.MODULE$.buildTrustManagers(cacert2);
            PeerSubjectVerifier sessionVerifier = new PeerSubjectVerifier(cert2);
            SSLContext ctx = SSLContext.getInstance(this.sslEngineConfig.SSLProtocol());
            ctx.init(keyManagers, trustManagers, this.rng);
            configuredContext = RotatingKeysSSLEngineProvider$ConfiguredContext$.MODULE$.apply(ctx, sessionVerifier);
        }
        catch (GeneralSecurityException e) {
            throw new SslTransportException("Server SSL connection could not be established because SSL context could not be constructed", e);
        }
        catch (IllegalArgumentException e) {
            throw new SslTransportException(new StringBuilder(56).append("Server SSL connection could not be established because: ").append(e.getMessage()).toString(), e);
        }
        return configuredContext;
    }

    private Tuple3<PrivateKey, X509Certificate, Certificate> readFiles() {
        Tuple3 tuple3;
        try {
            Certificate cacert = PemManagersProvider$.MODULE$.loadCertificate(this.SSLCACertFile);
            X509Certificate cert = (X509Certificate)PemManagersProvider$.MODULE$.loadCertificate(this.SSLCertFile);
            PrivateKey privateKey = PemManagersProvider$.MODULE$.loadPrivateKey(this.SSLKeyFile);
            tuple3 = Tuple3$.MODULE$.apply((Object)privateKey, (Object)cert, (Object)cacert);
        }
        catch (FileNotFoundException e) {
            throw new SslTransportException("Server SSL connection could not be established because a key or cert could not be loaded", e);
        }
        catch (IOException e) {
            throw new SslTransportException(new StringBuilder(56).append("Server SSL connection could not be established because: ").append(e.getMessage()).toString(), e);
        }
        return tuple3;
    }

    @Override
    public SSLEngine createServerSSLEngine(String hostname, int port) {
        return this.createSSLEngine((TLSRole)Server$.MODULE$, hostname, port, this.getContext().context());
    }

    @Override
    public SSLEngine createClientSSLEngine(String hostname, int port) {
        return this.createSSLEngine((TLSRole)Client$.MODULE$, hostname, port, this.getContext().context());
    }

    private SSLEngine createSSLEngine(TLSRole role, String hostname, int port, SSLContext sslContext) {
        SSLEngine engine = sslContext.createSSLEngine(hostname, port);
        TLSRole tLSRole = role;
        Client$ client$ = Client$.MODULE$;
        engine.setUseClientMode(!(tLSRole != null ? !tLSRole.equals(client$) : client$ != null));
        engine.setEnabledCipherSuites((String[])this.sslEngineConfig.SSLEnabledAlgorithms().toArray(ClassTag$.MODULE$.apply(String.class)));
        engine.setEnabledProtocols(new String[]{this.sslEngineConfig.SSLProtocol()});
        TLSRole tLSRole2 = role;
        Client$ client$2 = Client$.MODULE$;
        if (tLSRole2 == null ? client$2 != null : !tLSRole2.equals(client$2)) {
            engine.setNeedClientAuth(true);
        }
        return engine;
    }

    @Override
    public Option<Throwable> verifyClientSession(String hostname, SSLSession session) {
        return this.getContext().sessionVerifier().verifyClientSession(hostname, session);
    }

    @Override
    public Option<Throwable> verifyServerSession(String hostname, SSLSession session) {
        return this.getContext().sessionVerifier().verifyServerSession(hostname, session);
    }

    @InternalApi
    public static class CachedContext
    implements Product,
    Serializable {
        private final ConfiguredContext cached;
        private final Deadline expires;

        public static CachedContext apply(ConfiguredContext configuredContext, Deadline deadline) {
            return RotatingKeysSSLEngineProvider$CachedContext$.MODULE$.apply(configuredContext, deadline);
        }

        public static CachedContext fromProduct(Product product) {
            return RotatingKeysSSLEngineProvider$CachedContext$.MODULE$.fromProduct(product);
        }

        public static CachedContext unapply(CachedContext cachedContext) {
            return RotatingKeysSSLEngineProvider$CachedContext$.MODULE$.unapply(cachedContext);
        }

        public CachedContext(ConfiguredContext cached, Deadline expires) {
            this.cached = cached;
            this.expires = expires;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CachedContext)) return false;
            CachedContext cachedContext = (CachedContext)object;
            ConfiguredContext configuredContext = this.cached();
            ConfiguredContext configuredContext2 = cachedContext.cached();
            if (configuredContext == null) {
                if (configuredContext2 != null) {
                    return false;
                }
            } else if (!((Object)configuredContext).equals(configuredContext2)) return false;
            Deadline deadline = this.expires();
            Deadline deadline2 = cachedContext.expires();
            if (deadline == null) {
                if (deadline2 != null) {
                    return false;
                }
            } else if (!deadline.equals(deadline2)) return false;
            if (!cachedContext.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CachedContext;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CachedContext";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cached";
            }
            if (1 == n2) {
                return "expires";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ConfiguredContext cached() {
            return this.cached;
        }

        public Deadline expires() {
            return this.expires;
        }

        public CachedContext copy(ConfiguredContext cached, Deadline expires) {
            return new CachedContext(cached, expires);
        }

        public ConfiguredContext copy$default$1() {
            return this.cached();
        }

        public Deadline copy$default$2() {
            return this.expires();
        }

        public ConfiguredContext _1() {
            return this.cached();
        }

        public Deadline _2() {
            return this.expires();
        }
    }

    @InternalApi
    public static class ConfiguredContext
    implements Product,
    Serializable {
        private final SSLContext context;
        private final SessionVerifier sessionVerifier;

        public static ConfiguredContext apply(SSLContext sSLContext, SessionVerifier sessionVerifier) {
            return RotatingKeysSSLEngineProvider$ConfiguredContext$.MODULE$.apply(sSLContext, sessionVerifier);
        }

        public static ConfiguredContext fromProduct(Product product) {
            return RotatingKeysSSLEngineProvider$ConfiguredContext$.MODULE$.fromProduct(product);
        }

        public static ConfiguredContext unapply(ConfiguredContext configuredContext) {
            return RotatingKeysSSLEngineProvider$ConfiguredContext$.MODULE$.unapply(configuredContext);
        }

        public ConfiguredContext(SSLContext context, SessionVerifier sessionVerifier) {
            this.context = context;
            this.sessionVerifier = sessionVerifier;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConfiguredContext)) return false;
            ConfiguredContext configuredContext = (ConfiguredContext)object;
            SSLContext sSLContext = this.context();
            SSLContext sSLContext2 = configuredContext.context();
            if (sSLContext == null) {
                if (sSLContext2 != null) {
                    return false;
                }
            } else if (!sSLContext.equals(sSLContext2)) return false;
            SessionVerifier sessionVerifier = this.sessionVerifier();
            SessionVerifier sessionVerifier2 = configuredContext.sessionVerifier();
            if (sessionVerifier == null) {
                if (sessionVerifier2 != null) {
                    return false;
                }
            } else if (!sessionVerifier.equals(sessionVerifier2)) return false;
            if (!configuredContext.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ConfiguredContext;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ConfiguredContext";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "context";
            }
            if (1 == n2) {
                return "sessionVerifier";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SSLContext context() {
            return this.context;
        }

        public SessionVerifier sessionVerifier() {
            return this.sessionVerifier;
        }

        public ConfiguredContext copy(SSLContext context, SessionVerifier sessionVerifier) {
            return new ConfiguredContext(context, sessionVerifier);
        }

        public SSLContext copy$default$1() {
            return this.context();
        }

        public SessionVerifier copy$default$2() {
            return this.sessionVerifier();
        }

        public SSLContext _1() {
            return this.context();
        }

        public SessionVerifier _2() {
            return this.sessionVerifier();
        }
    }
}

