/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.routing;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Deploy;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Scope;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.remote.RemoteScope;
import org.apache.pekko.remote.RemoteScope$;
import org.apache.pekko.remote.routing.RemoteRouterConfig$;
import org.apache.pekko.routing.ActorRefRoutee$;
import org.apache.pekko.routing.Pool;
import org.apache.pekko.routing.Resizer;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.routing.Router;
import org.apache.pekko.routing.RouterActor;
import org.apache.pekko.routing.RouterConfig;
import org.apache.pekko.util.ccompat.package;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class RemoteRouterConfig
implements RouterConfig,
Pool,
Product {
    private static final long serialVersionUID = 1L;
    private final Pool local;
    private final Iterable nodes;
    private final transient Iterator<Address> nodeAddressIter;
    private final transient AtomicInteger childNameCounter;

    public static RemoteRouterConfig apply(Pool pool, Iterable<Address> iterable) {
        return RemoteRouterConfig$.MODULE$.apply(pool, iterable);
    }

    public static RemoteRouterConfig fromProduct(Product product) {
        return RemoteRouterConfig$.MODULE$.fromProduct(product);
    }

    public static RemoteRouterConfig unapply(RemoteRouterConfig remoteRouterConfig) {
        return RemoteRouterConfig$.MODULE$.unapply(remoteRouterConfig);
    }

    public RemoteRouterConfig(Pool local, Iterable<Address> nodes) {
        this.local = local;
        this.nodes = nodes;
        Predef$.MODULE$.require(nodes.nonEmpty(), RemoteRouterConfig::$init$$$anonfun$1);
        this.nodeAddressIter = ((LinearSeqOps)package$.MODULE$.Stream().continually(() -> RemoteRouterConfig.$init$$$anonfun$2(nodes)).flatten(Predef$.MODULE$.$conforms())).iterator();
        this.childNameCounter = new AtomicInteger();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof RemoteRouterConfig)) return false;
        RemoteRouterConfig remoteRouterConfig = (RemoteRouterConfig)object;
        Pool pool = this.local();
        Pool pool2 = remoteRouterConfig.local();
        if (pool == null) {
            if (pool2 != null) {
                return false;
            }
        } else if (!pool.equals(pool2)) return false;
        Iterable<Address> iterable = this.nodes();
        Iterable<Address> iterable2 = remoteRouterConfig.nodes();
        if (iterable == null) {
            if (iterable2 == null) return true;
            return false;
        } else {
            if (!iterable.equals(iterable2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof RemoteRouterConfig;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "RemoteRouterConfig";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "local";
        }
        if (1 == n2) {
            return "nodes";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Pool local() {
        return this.local;
    }

    public Iterable<Address> nodes() {
        return this.nodes;
    }

    public RemoteRouterConfig(Pool local, java.lang.Iterable<Address> nodes) {
        this(local, (Iterable<Address>)package.JavaConverters$.MODULE$.IterableHasAsScala(nodes).asScala().toSeq());
    }

    public RemoteRouterConfig(Pool local, Address[] nodes) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])nodes);
        this(local, (Iterable<Address>)ArrayOps$.MODULE$.toSeq$extension(object));
    }

    public Router createRouter(ActorSystem system) {
        return this.local().createRouter(system);
    }

    public int nrOfInstances(ActorSystem sys) {
        return this.local().nrOfInstances(sys);
    }

    public Routee newRoutee(Props routeeProps, ActorContext context) {
        String name = new StringBuilder(1).append("c").append(this.childNameCounter.incrementAndGet()).toString();
        Config config = ConfigFactory.empty();
        RouterConfig routerConfig = routeeProps.routerConfig();
        RemoteScope remoteScope = RemoteScope$.MODULE$.apply((Address)this.nodeAddressIter.next());
        String string = Deploy$.MODULE$.apply$default$1();
        String string2 = Deploy$.MODULE$.apply$default$5();
        String string3 = Deploy$.MODULE$.apply$default$6();
        Deploy deploy = Deploy$.MODULE$.apply(string, config, routerConfig, (Scope)remoteScope, string2, string3);
        ActorRef ref = ((ActorCell)context).attachChild(this.local().enrichWithPoolDispatcher(routeeProps, context).withDeploy(deploy), name, false);
        return ActorRefRoutee$.MODULE$.apply(ref);
    }

    public RouterActor createRouterActor() {
        return this.local().createRouterActor();
    }

    public SupervisorStrategy supervisorStrategy() {
        return this.local().supervisorStrategy();
    }

    public String routerDispatcher() {
        return this.local().routerDispatcher();
    }

    public Option<Resizer> resizer() {
        return this.local().resizer();
    }

    public RouterConfig withFallback(RouterConfig other) {
        RouterConfig routerConfig = other;
        if (routerConfig instanceof RemoteRouterConfig) {
            RemoteRouterConfig remoteRouterConfig = RemoteRouterConfig$.MODULE$.unapply((RemoteRouterConfig)routerConfig);
            Pool pool = remoteRouterConfig._1();
            Iterable<Address> iterable = remoteRouterConfig._2();
            if (pool instanceof RemoteRouterConfig) {
                throw new IllegalStateException("RemoteRouterConfig is not allowed to wrap a RemoteRouterConfig");
            }
            if (pool != null) {
                Pool local = pool;
                return this.copy((Pool)this.local().withFallback((RouterConfig)local), this.copy$default$2());
            }
        }
        return this.copy((Pool)this.local().withFallback(other), this.copy$default$2());
    }

    public RemoteRouterConfig copy(Pool local, Iterable<Address> nodes) {
        return new RemoteRouterConfig(local, nodes);
    }

    public Pool copy$default$1() {
        return this.local();
    }

    public Iterable<Address> copy$default$2() {
        return this.nodes();
    }

    public Pool _1() {
        return this.local();
    }

    public Iterable<Address> _2() {
        return this.nodes();
    }

    private static final Object $init$$$anonfun$1() {
        return "Must specify list of remote target.nodes";
    }

    private static final Iterable $init$$$anonfun$2(Iterable nodes$1) {
        return nodes$1;
    }
}

